package com.github.theholywaffle.teamspeak3.api;

public enum IPermissionType {

	I_CHANNEL_MIN_DEPTH("i_channel_min_depth", "Min channel creation depth in hierarchy", 82),
	I_CHANNEL_MAX_DEPTH("i_channel_max_depth", "Max channel creation depth in hierarchy", 83),
	I_CHANNEL_PERMISSION_MODIFY_POWER("i_channel_permission_modify_power", "Modify channel permission power", 85),
	I_CHANNEL_NEEDED_PERMISSION_MODIFY_POWER("i_channel_needed_permission_modify_power", "Needed modify channel permission power", 86),
	I_CHANNEL_CREATE_MODIFY_WITH_CODEC_MAXQUALITY("i_channel_create_modify_with_codec_maxquality", "Create channels with custom codec quality", 98),
	I_CHANNEL_CREATE_MODIFY_WITH_CODEC_LATENCY_FACTOR_MIN("i_channel_create_modify_with_codec_latency_factor_min", "Create channels with minimal custom codec latency factor", 99),
	I_CHANNEL_CREATE_MODIFY_WITH_TEMP_DELETE_DELAY("i_channel_create_modify_with_temp_delete_delay", "Max delete delay for temporary channels", 106),
	I_CHANNEL_MODIFY_POWER("i_channel_modify_power", "Channel modify power", 124),
	I_CHANNEL_NEEDED_MODIFY_POWER("i_channel_needed_modify_power", "Needed channel modify power", 125),
	I_CHANNEL_DELETE_POWER("i_channel_delete_power", "Delete channel power", 132),
	I_CHANNEL_NEEDED_DELETE_POWER("i_channel_needed_delete_power", "Needed delete channel power", 133),
	I_CHANNEL_JOIN_POWER("i_channel_join_power", "Channel join power", 139),
	I_CHANNEL_NEEDED_JOIN_POWER("i_channel_needed_join_power", "Needed channel join power", 140),
	I_CHANNEL_SUBSCRIBE_POWER("i_channel_subscribe_power", "Channel subscribe power", 141),
	I_CHANNEL_NEEDED_SUBSCRIBE_POWER("i_channel_needed_subscribe_power", "Needed channel subscribe power", 142),
	I_CHANNEL_DESCRIPTION_VIEW_POWER("i_channel_description_view_power", "Channel description view power", 143),
	I_CHANNEL_NEEDED_DESCRIPTION_VIEW_POWER("i_channel_needed_description_view_power", "Needed channel needed description view power", 144),
	I_ICON_ID("i_icon_id", "Group icon identifier", 145),
	I_MAX_ICON_FILESIZE("i_max_icon_filesize", "Max icon filesize in bytes", 146),
	I_GROUP_AUTO_UPDATE_TYPE("i_group_auto_update_type", "Group auto-update type", 149),
	I_GROUP_AUTO_UPDATE_MAX_VALUE("i_group_auto_update_max_value", "Group auto-update max value", 150),
	I_GROUP_SORT_ID("i_group_sort_id", "Group sort id", 151),
	I_GROUP_SHOW_NAME_IN_TREE("i_group_show_name_in_tree", "Show group name in tree depending on selected mode", 152),
	I_GROUP_MODIFY_POWER("i_group_modify_power", "Group modify power", 164),
	I_GROUP_NEEDED_MODIFY_POWER("i_group_needed_modify_power", "Needed group modify power", 165),
	I_GROUP_MEMBER_ADD_POWER("i_group_member_add_power", "Group member add power", 166),
	I_GROUP_NEEDED_MEMBER_ADD_POWER("i_group_needed_member_add_power", "Needed group member add power", 167),
	I_GROUP_MEMBER_REMOVE_POWER("i_group_member_remove_power", "Group member delete power", 168),
	I_GROUP_NEEDED_MEMBER_REMOVE_POWER("i_group_needed_member_remove_power", "Needed group member delete power", 169),
	I_PERMISSION_MODIFY_POWER("i_permission_modify_power", "Permission modify power", 170),
	I_CLIENT_PERMISSION_MODIFY_POWER("i_client_permission_modify_power", "Client permission modify power", 174),
	I_CLIENT_NEEDED_PERMISSION_MODIFY_POWER("i_client_needed_permission_modify_power", "Needed client permission modify power", 175),
	I_CLIENT_MAX_CLONES_UID("i_client_max_clones_uid", "Max additional connections per client identity", 176),
	I_CLIENT_MAX_IDLETIME("i_client_max_idletime", "Max idle time in seconds", 177),
	I_CLIENT_MAX_AVATAR_FILESIZE("i_client_max_avatar_filesize", "Max avatar filesize in bytes", 178),
	I_CLIENT_MAX_CHANNEL_SUBSCRIPTIONS("i_client_max_channel_subscriptions", "Max channel subscriptions", 179),
	I_CLIENT_SERVERQUERY_VIEW_POWER("i_client_serverquery_view_power", "ServerQuery view power", 195),
	I_CLIENT_NEEDED_SERVERQUERY_VIEW_POWER("i_client_needed_serverquery_view_power", "Needed ServerQuery view power", 196),
	I_CLIENT_KICK_FROM_SERVER_POWER("i_client_kick_from_server_power", "Client kick power from server", 198),
	I_CLIENT_NEEDED_KICK_FROM_SERVER_POWER("i_client_needed_kick_from_server_power", "Needed client kick power from server", 199),
	I_CLIENT_KICK_FROM_CHANNEL_POWER("i_client_kick_from_channel_power", "Client kick power from channel", 200),
	I_CLIENT_NEEDED_KICK_FROM_CHANNEL_POWER("i_client_needed_kick_from_channel_power", "Needed client kick power from channel", 201),
	I_CLIENT_BAN_POWER("i_client_ban_power", "Client ban power", 202),
	I_CLIENT_NEEDED_BAN_POWER("i_client_needed_ban_power", "Needed client ban power", 203),
	I_CLIENT_MOVE_POWER("i_client_move_power", "Client move power", 204),
	I_CLIENT_NEEDED_MOVE_POWER("i_client_needed_move_power", "Needed client move power", 205),
	I_CLIENT_COMPLAIN_POWER("i_client_complain_power", "Complain power", 206),
	I_CLIENT_NEEDED_COMPLAIN_POWER("i_client_needed_complain_power", "Needed complain power", 207),
	I_CLIENT_BAN_MAX_BANTIME("i_client_ban_max_bantime", "Max bantime", 215),
	I_CLIENT_PRIVATE_TEXTMESSAGE_POWER("i_client_private_textmessage_power", "Client private message power", 216),
	I_CLIENT_NEEDED_PRIVATE_TEXTMESSAGE_POWER("i_client_needed_private_textmessage_power", "Needed client private message power", 217),
	I_CLIENT_TALK_POWER("i_client_talk_power", "Client talk power", 221),
	I_CLIENT_NEEDED_TALK_POWER("i_client_needed_talk_power", "Needed client talk power", 222),
	I_CLIENT_POKE_POWER("i_client_poke_power", "Client poke power", 223),
	I_CLIENT_NEEDED_POKE_POWER("i_client_needed_poke_power", "Needed client poke power", 224),
	I_CLIENT_WHISPER_POWER("i_client_whisper_power", "Client whisper power", 226),
	I_CLIENT_NEEDED_WHISPER_POWER("i_client_needed_whisper_power", "Client needed whisper power", 227),
	I_FT_FILE_UPLOAD_POWER("i_ft_file_upload_power", "File upload power", 235),
	I_FT_NEEDED_FILE_UPLOAD_POWER("i_ft_needed_file_upload_power", "Needed file upload power", 236),
	I_FT_FILE_DOWNLOAD_POWER("i_ft_file_download_power", "File download power", 237),
	I_FT_NEEDED_FILE_DOWNLOAD_POWER("i_ft_needed_file_download_power", "Needed file download power", 238),
	I_FT_FILE_DELETE_POWER("i_ft_file_delete_power", "File delete power", 239),
	I_FT_NEEDED_FILE_DELETE_POWER("i_ft_needed_file_delete_power", "Needed file delete power", 240),
	I_FT_FILE_RENAME_POWER("i_ft_file_rename_power", "File rename power", 241),
	I_FT_NEEDED_FILE_RENAME_POWER("i_ft_needed_file_rename_power", "Needed file rename power", 242),
	I_FT_FILE_BROWSE_POWER("i_ft_file_browse_power", "File browse power", 243),
	I_FT_NEEDED_FILE_BROWSE_POWER("i_ft_needed_file_browse_power", "Needed file browse power", 244),
	I_FT_DIRECTORY_CREATE_POWER("i_ft_directory_create_power", "Create directory power", 245),
	I_FT_NEEDED_DIRECTORY_CREATE_POWER("i_ft_needed_directory_create_power", "Needed create directory power", 246),
	I_FT_QUOTA_MB_DOWNLOAD_PER_CLIENT("i_ft_quota_mb_download_per_client", "Download quota per client in MByte", 247),
	I_FT_QUOTA_MB_UPLOAD_PER_CLIENT("i_ft_quota_mb_upload_per_client", "Upload quota per client in MByte", 248),
	I_NEEDED_MODIFY_POWER_SERVERINSTANCE_HELP_VIEW("i_needed_modify_power_serverinstance_help_view", "", 32769),
	I_NEEDED_MODIFY_POWER_SERVERINSTANCE_INFO_VIEW("i_needed_modify_power_serverinstance_info_view", "", 32770),
	I_NEEDED_MODIFY_POWER_SERVERINSTANCE_VIRTUALSERVER_LIST("i_needed_modify_power_serverinstance_virtualserver_list", "", 32771),
	I_NEEDED_MODIFY_POWER_SERVERINSTANCE_BINDING_LIST("i_needed_modify_power_serverinstance_binding_list", "", 32772),
	I_NEEDED_MODIFY_POWER_SERVERINSTANCE_PERMISSION_LIST("i_needed_modify_power_serverinstance_permission_list", "", 32773),
	I_NEEDED_MODIFY_POWER_SERVERINSTANCE_PERMISSION_FIND("i_needed_modify_power_serverinstance_permission_find", "", 32774),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_CREATE("i_needed_modify_power_virtualserver_create", "", 32775),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_DELETE("i_needed_modify_power_virtualserver_delete", "", 32776),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_START_ANY("i_needed_modify_power_virtualserver_start_any", "", 32777),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_STOP_ANY("i_needed_modify_power_virtualserver_stop_any", "", 32778),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_CHANGE_MACHINE_ID("i_needed_modify_power_virtualserver_change_machine_id", "", 32779),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_CHANGE_TEMPLATE("i_needed_modify_power_virtualserver_change_template", "", 32780),
	I_NEEDED_MODIFY_POWER_SERVERQUERY_LOGIN("i_needed_modify_power_serverquery_login", "", 32781),
	I_NEEDED_MODIFY_POWER_SERVERQUERY_LOGIN_CREATE("i_needed_modify_power_serverquery_login_create", "", 32782),
	I_NEEDED_MODIFY_POWER_SERVERQUERY_LOGIN_DELETE("i_needed_modify_power_serverquery_login_delete", "", 32783),
	I_NEEDED_MODIFY_POWER_SERVERQUERY_LOGIN_LIST("i_needed_modify_power_serverquery_login_list", "", 32784),
	I_NEEDED_MODIFY_POWER_SERVERINSTANCE_TEXTMESSAGE_SEND("i_needed_modify_power_serverinstance_textmessage_send", "", 32785),
	I_NEEDED_MODIFY_POWER_SERVERINSTANCE_LOG_VIEW("i_needed_modify_power_serverinstance_log_view", "", 32786),
	I_NEEDED_MODIFY_POWER_SERVERINSTANCE_LOG_ADD("i_needed_modify_power_serverinstance_log_add", "", 32787),
	I_NEEDED_MODIFY_POWER_SERVERINSTANCE_STOP("i_needed_modify_power_serverinstance_stop", "", 32788),
	I_NEEDED_MODIFY_POWER_SERVERINSTANCE_MODIFY_SETTINGS("i_needed_modify_power_serverinstance_modify_settings", "", 32789),
	I_NEEDED_MODIFY_POWER_SERVERINSTANCE_MODIFY_QUERYGROUP("i_needed_modify_power_serverinstance_modify_querygroup", "", 32790),
	I_NEEDED_MODIFY_POWER_SERVERINSTANCE_MODIFY_TEMPLATES("i_needed_modify_power_serverinstance_modify_templates", "", 32791),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_SELECT("i_needed_modify_power_virtualserver_select", "", 32792),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_INFO_VIEW("i_needed_modify_power_virtualserver_info_view", "", 32793),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_CONNECTIONINFO_VIEW("i_needed_modify_power_virtualserver_connectioninfo_view", "", 32794),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_CHANNEL_LIST("i_needed_modify_power_virtualserver_channel_list", "", 32795),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_CHANNEL_SEARCH("i_needed_modify_power_virtualserver_channel_search", "", 32796),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_CLIENT_LIST("i_needed_modify_power_virtualserver_client_list", "", 32797),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_CLIENT_SEARCH("i_needed_modify_power_virtualserver_client_search", "", 32798),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_CLIENT_DBLIST("i_needed_modify_power_virtualserver_client_dblist", "", 32799),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_CLIENT_DBSEARCH("i_needed_modify_power_virtualserver_client_dbsearch", "", 32800),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_CLIENT_DBINFO("i_needed_modify_power_virtualserver_client_dbinfo", "", 32801),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_PERMISSION_FIND("i_needed_modify_power_virtualserver_permission_find", "", 32802),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_CUSTOM_SEARCH("i_needed_modify_power_virtualserver_custom_search", "", 32803),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_START("i_needed_modify_power_virtualserver_start", "", 32804),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_STOP("i_needed_modify_power_virtualserver_stop", "", 32805),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_TOKEN_LIST("i_needed_modify_power_virtualserver_token_list", "", 32806),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_TOKEN_ADD("i_needed_modify_power_virtualserver_token_add", "", 32807),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_TOKEN_USE("i_needed_modify_power_virtualserver_token_use", "", 32808),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_TOKEN_DELETE("i_needed_modify_power_virtualserver_token_delete", "", 32809),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_APIKEY_ADD("i_needed_modify_power_virtualserver_apikey_add", "", 32810),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_APIKEY_MANAGE("i_needed_modify_power_virtualserver_apikey_manage", "", 32811),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_LOG_VIEW("i_needed_modify_power_virtualserver_log_view", "", 32812),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_LOG_ADD("i_needed_modify_power_virtualserver_log_add", "", 32813),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_JOIN_IGNORE_PASSWORD("i_needed_modify_power_virtualserver_join_ignore_password", "", 32814),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_NOTIFY_REGISTER("i_needed_modify_power_virtualserver_notify_register", "", 32815),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_NOTIFY_UNREGISTER("i_needed_modify_power_virtualserver_notify_unregister", "", 32816),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_SNAPSHOT_CREATE("i_needed_modify_power_virtualserver_snapshot_create", "", 32817),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_SNAPSHOT_DEPLOY("i_needed_modify_power_virtualserver_snapshot_deploy", "", 32818),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_PERMISSION_RESET("i_needed_modify_power_virtualserver_permission_reset", "", 32819),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_NAME("i_needed_modify_power_virtualserver_modify_name", "", 32820),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_WELCOMEMESSAGE("i_needed_modify_power_virtualserver_modify_welcomemessage", "", 32821),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_MAXCLIENTS("i_needed_modify_power_virtualserver_modify_maxclients", "", 32822),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_RESERVED_SLOTS("i_needed_modify_power_virtualserver_modify_reserved_slots", "", 32823),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_PASSWORD("i_needed_modify_power_virtualserver_modify_password", "", 32824),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_DEFAULT_SERVERGROUP("i_needed_modify_power_virtualserver_modify_default_servergroup", "", 32825),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_DEFAULT_CHANNELGROUP("i_needed_modify_power_virtualserver_modify_default_channelgroup", "", 32826),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_DEFAULT_CHANNELADMINGROUP("i_needed_modify_power_virtualserver_modify_default_channeladmingroup", "", 32827),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_CHANNEL_FORCED_SILENCE("i_needed_modify_power_virtualserver_modify_channel_forced_silence", "", 32828),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_COMPLAIN("i_needed_modify_power_virtualserver_modify_complain", "", 32829),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_ANTIFLOOD("i_needed_modify_power_virtualserver_modify_antiflood", "", 32830),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_FT_SETTINGS("i_needed_modify_power_virtualserver_modify_ft_settings", "", 32831),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_FT_QUOTAS("i_needed_modify_power_virtualserver_modify_ft_quotas", "", 32832),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_HOSTMESSAGE("i_needed_modify_power_virtualserver_modify_hostmessage", "", 32833),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_HOSTBANNER("i_needed_modify_power_virtualserver_modify_hostbanner", "", 32834),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_HOSTBUTTON("i_needed_modify_power_virtualserver_modify_hostbutton", "", 32835),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_PORT("i_needed_modify_power_virtualserver_modify_port", "", 32836),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_AUTOSTART("i_needed_modify_power_virtualserver_modify_autostart", "", 32837),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_NEEDED_IDENTITY_SECURITY_LEVEL("i_needed_modify_power_virtualserver_modify_needed_identity_security_level", "", 32838),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_PRIORITY_SPEAKER_DIMM_MODIFICATOR("i_needed_modify_power_virtualserver_modify_priority_speaker_dimm_modificator", "", 32839),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_LOG_SETTINGS("i_needed_modify_power_virtualserver_modify_log_settings", "", 32840),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_MIN_CLIENT_VERSION("i_needed_modify_power_virtualserver_modify_min_client_version", "", 32841),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_ICON_ID("i_needed_modify_power_virtualserver_modify_icon_id", "", 32842),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_WEBLIST("i_needed_modify_power_virtualserver_modify_weblist", "", 32843),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_CODEC_ENCRYPTION_MODE("i_needed_modify_power_virtualserver_modify_codec_encryption_mode", "", 32844),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_TEMPORARY_PASSWORDS("i_needed_modify_power_virtualserver_modify_temporary_passwords", "", 32845),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_TEMPORARY_PASSWORDS_OWN("i_needed_modify_power_virtualserver_modify_temporary_passwords_own", "", 32846),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_CHANNEL_TEMP_DELETE_DELAY_DEFAULT("i_needed_modify_power_virtualserver_modify_channel_temp_delete_delay_default", "", 32847),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_NICKNAME("i_needed_modify_power_virtualserver_modify_nickname", "", 32848),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_MODIFY_INTEGRATIONS("i_needed_modify_power_virtualserver_modify_integrations", "", 32849),
	I_NEEDED_MODIFY_POWER_CHANNEL_MIN_DEPTH("i_needed_modify_power_channel_min_depth", "", 32850),
	I_NEEDED_MODIFY_POWER_CHANNEL_MAX_DEPTH("i_needed_modify_power_channel_max_depth", "", 32851),
	I_NEEDED_MODIFY_POWER_CHANNEL_GROUP_INHERITANCE_END("i_needed_modify_power_channel_group_inheritance_end", "", 32852),
	I_NEEDED_MODIFY_POWER_CHANNEL_PERMISSION_MODIFY_POWER("i_needed_modify_power_channel_permission_modify_power", "", 32853),
	I_NEEDED_MODIFY_POWER_CHANNEL_NEEDED_PERMISSION_MODIFY_POWER("i_needed_modify_power_channel_needed_permission_modify_power", "", 32854),
	I_NEEDED_MODIFY_POWER_CHANNEL_INFO_VIEW("i_needed_modify_power_channel_info_view", "", 32855),
	I_NEEDED_MODIFY_POWER_CHANNEL_CREATE_CHILD("i_needed_modify_power_channel_create_child", "", 32856),
	I_NEEDED_MODIFY_POWER_CHANNEL_CREATE_PERMANENT("i_needed_modify_power_channel_create_permanent", "", 32857),
	I_NEEDED_MODIFY_POWER_CHANNEL_CREATE_SEMI_PERMANENT("i_needed_modify_power_channel_create_semi_permanent", "", 32858),
	I_NEEDED_MODIFY_POWER_CHANNEL_CREATE_TEMPORARY("i_needed_modify_power_channel_create_temporary", "", 32859),
	I_NEEDED_MODIFY_POWER_CHANNEL_CREATE_WITH_TOPIC("i_needed_modify_power_channel_create_with_topic", "", 32860),
	I_NEEDED_MODIFY_POWER_CHANNEL_CREATE_WITH_DESCRIPTION("i_needed_modify_power_channel_create_with_description", "", 32861),
	I_NEEDED_MODIFY_POWER_CHANNEL_CREATE_WITH_PASSWORD("i_needed_modify_power_channel_create_with_password", "", 32862),
	I_NEEDED_MODIFY_POWER_CHANNEL_CREATE_WITH_BANNER("i_needed_modify_power_channel_create_with_banner", "", 32863),
	I_NEEDED_MODIFY_POWER_CHANNEL_CREATE_MODIFY_WITH_CODEC_OPUSVOICE("i_needed_modify_power_channel_create_modify_with_codec_opusvoice", "", 32864),
	I_NEEDED_MODIFY_POWER_CHANNEL_CREATE_MODIFY_WITH_CODEC_OPUSMUSIC("i_needed_modify_power_channel_create_modify_with_codec_opusmusic", "", 32865),
	I_NEEDED_MODIFY_POWER_CHANNEL_CREATE_MODIFY_WITH_CODEC_MAXQUALITY("i_needed_modify_power_channel_create_modify_with_codec_maxquality", "", 32866),
	I_NEEDED_MODIFY_POWER_CHANNEL_CREATE_MODIFY_WITH_CODEC_LATENCY_FACTOR_MIN("i_needed_modify_power_channel_create_modify_with_codec_latency_factor_min", "", 32867),
	I_NEEDED_MODIFY_POWER_CHANNEL_CREATE_WITH_MAXCLIENTS("i_needed_modify_power_channel_create_with_maxclients", "", 32868),
	I_NEEDED_MODIFY_POWER_CHANNEL_CREATE_WITH_MAXFAMILYCLIENTS("i_needed_modify_power_channel_create_with_maxfamilyclients", "", 32869),
	I_NEEDED_MODIFY_POWER_CHANNEL_CREATE_WITH_SORTORDER("i_needed_modify_power_channel_create_with_sortorder", "", 32870),
	I_NEEDED_MODIFY_POWER_CHANNEL_CREATE_WITH_DEFAULT("i_needed_modify_power_channel_create_with_default", "", 32871),
	I_NEEDED_MODIFY_POWER_CHANNEL_CREATE_WITH_NEEDED_TALK_POWER("i_needed_modify_power_channel_create_with_needed_talk_power", "", 32872),
	I_NEEDED_MODIFY_POWER_CHANNEL_CREATE_MODIFY_WITH_FORCE_PASSWORD("i_needed_modify_power_channel_create_modify_with_force_password", "", 32873),
	I_NEEDED_MODIFY_POWER_CHANNEL_CREATE_MODIFY_WITH_TEMP_DELETE_DELAY("i_needed_modify_power_channel_create_modify_with_temp_delete_delay", "", 32874),
	I_NEEDED_MODIFY_POWER_CHANNEL_MODIFY_PARENT("i_needed_modify_power_channel_modify_parent", "", 32875),
	I_NEEDED_MODIFY_POWER_CHANNEL_MODIFY_MAKE_DEFAULT("i_needed_modify_power_channel_modify_make_default", "", 32876),
	I_NEEDED_MODIFY_POWER_CHANNEL_MODIFY_MAKE_PERMANENT("i_needed_modify_power_channel_modify_make_permanent", "", 32877),
	I_NEEDED_MODIFY_POWER_CHANNEL_MODIFY_MAKE_SEMI_PERMANENT("i_needed_modify_power_channel_modify_make_semi_permanent", "", 32878),
	I_NEEDED_MODIFY_POWER_CHANNEL_MODIFY_MAKE_TEMPORARY("i_needed_modify_power_channel_modify_make_temporary", "", 32879),
	I_NEEDED_MODIFY_POWER_CHANNEL_MODIFY_NAME("i_needed_modify_power_channel_modify_name", "", 32880),
	I_NEEDED_MODIFY_POWER_CHANNEL_MODIFY_TOPIC("i_needed_modify_power_channel_modify_topic", "", 32881),
	I_NEEDED_MODIFY_POWER_CHANNEL_MODIFY_DESCRIPTION("i_needed_modify_power_channel_modify_description", "", 32882),
	I_NEEDED_MODIFY_POWER_CHANNEL_MODIFY_PASSWORD("i_needed_modify_power_channel_modify_password", "", 32883),
	I_NEEDED_MODIFY_POWER_CHANNEL_MODIFY_BANNER("i_needed_modify_power_channel_modify_banner", "", 32884),
	I_NEEDED_MODIFY_POWER_CHANNEL_MODIFY_CODEC("i_needed_modify_power_channel_modify_codec", "", 32885),
	I_NEEDED_MODIFY_POWER_CHANNEL_MODIFY_CODEC_QUALITY("i_needed_modify_power_channel_modify_codec_quality", "", 32886),
	I_NEEDED_MODIFY_POWER_CHANNEL_MODIFY_CODEC_LATENCY_FACTOR("i_needed_modify_power_channel_modify_codec_latency_factor", "", 32887),
	I_NEEDED_MODIFY_POWER_CHANNEL_MODIFY_MAXCLIENTS("i_needed_modify_power_channel_modify_maxclients", "", 32888),
	I_NEEDED_MODIFY_POWER_CHANNEL_MODIFY_MAXFAMILYCLIENTS("i_needed_modify_power_channel_modify_maxfamilyclients", "", 32889),
	I_NEEDED_MODIFY_POWER_CHANNEL_MODIFY_SORTORDER("i_needed_modify_power_channel_modify_sortorder", "", 32890),
	I_NEEDED_MODIFY_POWER_CHANNEL_MODIFY_NEEDED_TALK_POWER("i_needed_modify_power_channel_modify_needed_talk_power", "", 32891),
	I_NEEDED_MODIFY_POWER_CHANNEL_MODIFY_POWER("i_needed_modify_power_channel_modify_power", "", 32892),
	I_NEEDED_MODIFY_POWER_CHANNEL_NEEDED_MODIFY_POWER("i_needed_modify_power_channel_needed_modify_power", "", 32893),
	I_NEEDED_MODIFY_POWER_CHANNEL_MODIFY_MAKE_CODEC_ENCRYPTED("i_needed_modify_power_channel_modify_make_codec_encrypted", "", 32894),
	I_NEEDED_MODIFY_POWER_CHANNEL_MODIFY_TEMP_DELETE_DELAY("i_needed_modify_power_channel_modify_temp_delete_delay", "", 32895),
	I_NEEDED_MODIFY_POWER_CHANNEL_DELETE_PERMANENT("i_needed_modify_power_channel_delete_permanent", "", 32896),
	I_NEEDED_MODIFY_POWER_CHANNEL_DELETE_SEMI_PERMANENT("i_needed_modify_power_channel_delete_semi_permanent", "", 32897),
	I_NEEDED_MODIFY_POWER_CHANNEL_DELETE_TEMPORARY("i_needed_modify_power_channel_delete_temporary", "", 32898),
	I_NEEDED_MODIFY_POWER_CHANNEL_DELETE_FLAG_FORCE("i_needed_modify_power_channel_delete_flag_force", "", 32899),
	I_NEEDED_MODIFY_POWER_CHANNEL_DELETE_POWER("i_needed_modify_power_channel_delete_power", "", 32900),
	I_NEEDED_MODIFY_POWER_CHANNEL_NEEDED_DELETE_POWER("i_needed_modify_power_channel_needed_delete_power", "", 32901),
	I_NEEDED_MODIFY_POWER_CHANNEL_JOIN_PERMANENT("i_needed_modify_power_channel_join_permanent", "", 32902),
	I_NEEDED_MODIFY_POWER_CHANNEL_JOIN_SEMI_PERMANENT("i_needed_modify_power_channel_join_semi_permanent", "", 32903),
	I_NEEDED_MODIFY_POWER_CHANNEL_JOIN_TEMPORARY("i_needed_modify_power_channel_join_temporary", "", 32904),
	I_NEEDED_MODIFY_POWER_CHANNEL_JOIN_IGNORE_PASSWORD("i_needed_modify_power_channel_join_ignore_password", "", 32905),
	I_NEEDED_MODIFY_POWER_CHANNEL_JOIN_IGNORE_MAXCLIENTS("i_needed_modify_power_channel_join_ignore_maxclients", "", 32906),
	I_NEEDED_MODIFY_POWER_CHANNEL_JOIN_POWER("i_needed_modify_power_channel_join_power", "", 32907),
	I_NEEDED_MODIFY_POWER_CHANNEL_NEEDED_JOIN_POWER("i_needed_modify_power_channel_needed_join_power", "", 32908),
	I_NEEDED_MODIFY_POWER_CHANNEL_SUBSCRIBE_POWER("i_needed_modify_power_channel_subscribe_power", "", 32909),
	I_NEEDED_MODIFY_POWER_CHANNEL_NEEDED_SUBSCRIBE_POWER("i_needed_modify_power_channel_needed_subscribe_power", "", 32910),
	I_NEEDED_MODIFY_POWER_CHANNEL_DESCRIPTION_VIEW_POWER("i_needed_modify_power_channel_description_view_power", "", 32911),
	I_NEEDED_MODIFY_POWER_CHANNEL_NEEDED_DESCRIPTION_VIEW_POWER("i_needed_modify_power_channel_needed_description_view_power", "", 32912),
	I_NEEDED_MODIFY_POWER_ICON_ID("i_needed_modify_power_icon_id", "", 32913),
	I_NEEDED_MODIFY_POWER_MAX_ICON_FILESIZE("i_needed_modify_power_max_icon_filesize", "", 32914),
	I_NEEDED_MODIFY_POWER_ICON_MANAGE("i_needed_modify_power_icon_manage", "", 32915),
	I_NEEDED_MODIFY_POWER_GROUP_IS_PERMANENT("i_needed_modify_power_group_is_permanent", "", 32916),
	I_NEEDED_MODIFY_POWER_GROUP_AUTO_UPDATE_TYPE("i_needed_modify_power_group_auto_update_type", "", 32917),
	I_NEEDED_MODIFY_POWER_GROUP_AUTO_UPDATE_MAX_VALUE("i_needed_modify_power_group_auto_update_max_value", "", 32918),
	I_NEEDED_MODIFY_POWER_GROUP_SORT_ID("i_needed_modify_power_group_sort_id", "", 32919),
	I_NEEDED_MODIFY_POWER_GROUP_SHOW_NAME_IN_TREE("i_needed_modify_power_group_show_name_in_tree", "", 32920),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_SERVERGROUP_LIST("i_needed_modify_power_virtualserver_servergroup_list", "", 32921),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_SERVERGROUP_PERMISSION_LIST("i_needed_modify_power_virtualserver_servergroup_permission_list", "", 32922),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_SERVERGROUP_CLIENT_LIST("i_needed_modify_power_virtualserver_servergroup_client_list", "", 32923),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_CHANNELGROUP_LIST("i_needed_modify_power_virtualserver_channelgroup_list", "", 32924),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_CHANNELGROUP_PERMISSION_LIST("i_needed_modify_power_virtualserver_channelgroup_permission_list", "", 32925),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_CHANNELGROUP_CLIENT_LIST("i_needed_modify_power_virtualserver_channelgroup_client_list", "", 32926),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_CLIENT_PERMISSION_LIST("i_needed_modify_power_virtualserver_client_permission_list", "", 32927),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_CHANNEL_PERMISSION_LIST("i_needed_modify_power_virtualserver_channel_permission_list", "", 32928),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_CHANNELCLIENT_PERMISSION_LIST("i_needed_modify_power_virtualserver_channelclient_permission_list", "", 32929),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_SERVERGROUP_CREATE("i_needed_modify_power_virtualserver_servergroup_create", "", 32930),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_CHANNELGROUP_CREATE("i_needed_modify_power_virtualserver_channelgroup_create", "", 32931),
	I_NEEDED_MODIFY_POWER_GROUP_MODIFY_POWER("i_needed_modify_power_group_modify_power", "", 32932),
	I_NEEDED_MODIFY_POWER_GROUP_NEEDED_MODIFY_POWER("i_needed_modify_power_group_needed_modify_power", "", 32933),
	I_NEEDED_MODIFY_POWER_GROUP_MEMBER_ADD_POWER("i_needed_modify_power_group_member_add_power", "", 32934),
	I_NEEDED_MODIFY_POWER_GROUP_NEEDED_MEMBER_ADD_POWER("i_needed_modify_power_group_needed_member_add_power", "", 32935),
	I_NEEDED_MODIFY_POWER_GROUP_MEMBER_REMOVE_POWER("i_needed_modify_power_group_member_remove_power", "", 32936),
	I_NEEDED_MODIFY_POWER_GROUP_NEEDED_MEMBER_REMOVE_POWER("i_needed_modify_power_group_needed_member_remove_power", "", 32937),
	I_NEEDED_MODIFY_POWER_PERMISSION_MODIFY_POWER("i_needed_modify_power_permission_modify_power", "", 32938),
	I_NEEDED_MODIFY_POWER_PERMISSION_MODIFY_POWER_IGNORE("i_needed_modify_power_permission_modify_power_ignore", "", 32939),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_SERVERGROUP_DELETE("i_needed_modify_power_virtualserver_servergroup_delete", "", 32940),
	I_NEEDED_MODIFY_POWER_VIRTUALSERVER_CHANNELGROUP_DELETE("i_needed_modify_power_virtualserver_channelgroup_delete", "", 32941),
	I_NEEDED_MODIFY_POWER_CLIENT_PERMISSION_MODIFY_POWER("i_needed_modify_power_client_permission_modify_power", "", 32942),
	I_NEEDED_MODIFY_POWER_CLIENT_NEEDED_PERMISSION_MODIFY_POWER("i_needed_modify_power_client_needed_permission_modify_power", "", 32943),
	I_NEEDED_MODIFY_POWER_CLIENT_MAX_CLONES_UID("i_needed_modify_power_client_max_clones_uid", "", 32944),
	I_NEEDED_MODIFY_POWER_CLIENT_MAX_IDLETIME("i_needed_modify_power_client_max_idletime", "", 32945),
	I_NEEDED_MODIFY_POWER_CLIENT_MAX_AVATAR_FILESIZE("i_needed_modify_power_client_max_avatar_filesize", "", 32946),
	I_NEEDED_MODIFY_POWER_CLIENT_MAX_CHANNEL_SUBSCRIPTIONS("i_needed_modify_power_client_max_channel_subscriptions", "", 32947),
	I_NEEDED_MODIFY_POWER_CLIENT_IS_PRIORITY_SPEAKER("i_needed_modify_power_client_is_priority_speaker", "", 32948),
	I_NEEDED_MODIFY_POWER_CLIENT_SKIP_CHANNELGROUP_PERMISSIONS("i_needed_modify_power_client_skip_channelgroup_permissions", "", 32949),
	I_NEEDED_MODIFY_POWER_CLIENT_FORCE_PUSH_TO_TALK("i_needed_modify_power_client_force_push_to_talk", "", 32950),
	I_NEEDED_MODIFY_POWER_CLIENT_IGNORE_BANS("i_needed_modify_power_client_ignore_bans", "", 32951),
	I_NEEDED_MODIFY_POWER_CLIENT_IGNORE_ANTIFLOOD("i_needed_modify_power_client_ignore_antiflood", "", 32952),
	I_NEEDED_MODIFY_POWER_CLIENT_USE_RESERVED_SLOT("i_needed_modify_power_client_use_reserved_slot", "", 32953),
	I_NEEDED_MODIFY_POWER_CLIENT_USE_CHANNEL_COMMANDER("i_needed_modify_power_client_use_channel_commander", "", 32954),
	I_NEEDED_MODIFY_POWER_CLIENT_REQUEST_TALKER("i_needed_modify_power_client_request_talker", "", 32955),
	I_NEEDED_MODIFY_POWER_CLIENT_AVATAR_DELETE_OTHER("i_needed_modify_power_client_avatar_delete_other", "", 32956),
	I_NEEDED_MODIFY_POWER_CLIENT_IS_STICKY("i_needed_modify_power_client_is_sticky", "", 32957),
	I_NEEDED_MODIFY_POWER_CLIENT_IGNORE_STICKY("i_needed_modify_power_client_ignore_sticky", "", 32958),
	I_NEEDED_MODIFY_POWER_CLIENT_INFO_VIEW("i_needed_modify_power_client_info_view", "", 32959),
	I_NEEDED_MODIFY_POWER_CLIENT_PERMISSIONOVERVIEW_VIEW("i_needed_modify_power_client_permissionoverview_view", "", 32960),
	I_NEEDED_MODIFY_POWER_CLIENT_PERMISSIONOVERVIEW_OWN("i_needed_modify_power_client_permissionoverview_own", "", 32961),
	I_NEEDED_MODIFY_POWER_CLIENT_REMOTEADDRESS_VIEW("i_needed_modify_power_client_remoteaddress_view", "", 32962),
	I_NEEDED_MODIFY_POWER_CLIENT_SERVERQUERY_VIEW_POWER("i_needed_modify_power_client_serverquery_view_power", "", 32963),
	I_NEEDED_MODIFY_POWER_CLIENT_NEEDED_SERVERQUERY_VIEW_POWER("i_needed_modify_power_client_needed_serverquery_view_power", "", 32964),
	I_NEEDED_MODIFY_POWER_CLIENT_CUSTOM_INFO_VIEW("i_needed_modify_power_client_custom_info_view", "", 32965),
	I_NEEDED_MODIFY_POWER_CLIENT_KICK_FROM_SERVER_POWER("i_needed_modify_power_client_kick_from_server_power", "", 32966),
	I_NEEDED_MODIFY_POWER_CLIENT_NEEDED_KICK_FROM_SERVER_POWER("i_needed_modify_power_client_needed_kick_from_server_power", "", 32967),
	I_NEEDED_MODIFY_POWER_CLIENT_KICK_FROM_CHANNEL_POWER("i_needed_modify_power_client_kick_from_channel_power", "", 32968),
	I_NEEDED_MODIFY_POWER_CLIENT_NEEDED_KICK_FROM_CHANNEL_POWER("i_needed_modify_power_client_needed_kick_from_channel_power", "", 32969),
	I_NEEDED_MODIFY_POWER_CLIENT_BAN_POWER("i_needed_modify_power_client_ban_power", "", 32970),
	I_NEEDED_MODIFY_POWER_CLIENT_NEEDED_BAN_POWER("i_needed_modify_power_client_needed_ban_power", "", 32971),
	I_NEEDED_MODIFY_POWER_CLIENT_MOVE_POWER("i_needed_modify_power_client_move_power", "", 32972),
	I_NEEDED_MODIFY_POWER_CLIENT_NEEDED_MOVE_POWER("i_needed_modify_power_client_needed_move_power", "", 32973),
	I_NEEDED_MODIFY_POWER_CLIENT_COMPLAIN_POWER("i_needed_modify_power_client_complain_power", "", 32974),
	I_NEEDED_MODIFY_POWER_CLIENT_NEEDED_COMPLAIN_POWER("i_needed_modify_power_client_needed_complain_power", "", 32975),
	I_NEEDED_MODIFY_POWER_CLIENT_COMPLAIN_LIST("i_needed_modify_power_client_complain_list", "", 32976),
	I_NEEDED_MODIFY_POWER_CLIENT_COMPLAIN_DELETE_OWN("i_needed_modify_power_client_complain_delete_own", "", 32977),
	I_NEEDED_MODIFY_POWER_CLIENT_COMPLAIN_DELETE("i_needed_modify_power_client_complain_delete", "", 32978),
	I_NEEDED_MODIFY_POWER_CLIENT_BAN_LIST("i_needed_modify_power_client_ban_list", "", 32979),
	I_NEEDED_MODIFY_POWER_CLIENT_BAN_CREATE("i_needed_modify_power_client_ban_create", "", 32980),
	I_NEEDED_MODIFY_POWER_CLIENT_BAN_DELETE_OWN("i_needed_modify_power_client_ban_delete_own", "", 32981),
	I_NEEDED_MODIFY_POWER_CLIENT_BAN_DELETE("i_needed_modify_power_client_ban_delete", "", 32982),
	I_NEEDED_MODIFY_POWER_CLIENT_BAN_MAX_BANTIME("i_needed_modify_power_client_ban_max_bantime", "", 32983),
	I_NEEDED_MODIFY_POWER_CLIENT_PRIVATE_TEXTMESSAGE_POWER("i_needed_modify_power_client_private_textmessage_power", "", 32984),
	I_NEEDED_MODIFY_POWER_CLIENT_NEEDED_PRIVATE_TEXTMESSAGE_POWER("i_needed_modify_power_client_needed_private_textmessage_power", "", 32985),
	I_NEEDED_MODIFY_POWER_CLIENT_SERVER_TEXTMESSAGE_SEND("i_needed_modify_power_client_server_textmessage_send", "", 32986),
	I_NEEDED_MODIFY_POWER_CLIENT_CHANNEL_TEXTMESSAGE_SEND("i_needed_modify_power_client_channel_textmessage_send", "", 32987),
	I_NEEDED_MODIFY_POWER_CLIENT_OFFLINE_TEXTMESSAGE_SEND("i_needed_modify_power_client_offline_textmessage_send", "", 32988),
	I_NEEDED_MODIFY_POWER_CLIENT_TALK_POWER("i_needed_modify_power_client_talk_power", "", 32989),
	I_NEEDED_MODIFY_POWER_CLIENT_NEEDED_TALK_POWER("i_needed_modify_power_client_needed_talk_power", "", 32990),
	I_NEEDED_MODIFY_POWER_CLIENT_POKE_POWER("i_needed_modify_power_client_poke_power", "", 32991),
	I_NEEDED_MODIFY_POWER_CLIENT_NEEDED_POKE_POWER("i_needed_modify_power_client_needed_poke_power", "", 32992),
	I_NEEDED_MODIFY_POWER_CLIENT_SET_FLAG_TALKER("i_needed_modify_power_client_set_flag_talker", "", 32993),
	I_NEEDED_MODIFY_POWER_CLIENT_WHISPER_POWER("i_needed_modify_power_client_whisper_power", "", 32994),
	I_NEEDED_MODIFY_POWER_CLIENT_NEEDED_WHISPER_POWER("i_needed_modify_power_client_needed_whisper_power", "", 32995),
	I_NEEDED_MODIFY_POWER_CLIENT_MODIFY_DESCRIPTION("i_needed_modify_power_client_modify_description", "", 32996),
	I_NEEDED_MODIFY_POWER_CLIENT_MODIFY_OWN_DESCRIPTION("i_needed_modify_power_client_modify_own_description", "", 32997),
	I_NEEDED_MODIFY_POWER_CLIENT_MODIFY_DBPROPERTIES("i_needed_modify_power_client_modify_dbproperties", "", 32998),
	I_NEEDED_MODIFY_POWER_CLIENT_DELETE_DBPROPERTIES("i_needed_modify_power_client_delete_dbproperties", "", 32999),
	I_NEEDED_MODIFY_POWER_CLIENT_CREATE_MODIFY_SERVERQUERY_LOGIN("i_needed_modify_power_client_create_modify_serverquery_login", "", 33000),
	I_NEEDED_MODIFY_POWER_FT_IGNORE_PASSWORD("i_needed_modify_power_ft_ignore_password", "", 33001),
	I_NEEDED_MODIFY_POWER_FT_TRANSFER_LIST("i_needed_modify_power_ft_transfer_list", "", 33002),
	I_NEEDED_MODIFY_POWER_FT_FILE_UPLOAD_POWER("i_needed_modify_power_ft_file_upload_power", "", 33003),
	I_NEEDED_MODIFY_POWER_FT_NEEDED_FILE_UPLOAD_POWER("i_needed_modify_power_ft_needed_file_upload_power", "", 33004),
	I_NEEDED_MODIFY_POWER_FT_FILE_DOWNLOAD_POWER("i_needed_modify_power_ft_file_download_power", "", 33005),
	I_NEEDED_MODIFY_POWER_FT_NEEDED_FILE_DOWNLOAD_POWER("i_needed_modify_power_ft_needed_file_download_power", "", 33006),
	I_NEEDED_MODIFY_POWER_FT_FILE_DELETE_POWER("i_needed_modify_power_ft_file_delete_power", "", 33007),
	I_NEEDED_MODIFY_POWER_FT_NEEDED_FILE_DELETE_POWER("i_needed_modify_power_ft_needed_file_delete_power", "", 33008),
	I_NEEDED_MODIFY_POWER_FT_FILE_RENAME_POWER("i_needed_modify_power_ft_file_rename_power", "", 33009),
	I_NEEDED_MODIFY_POWER_FT_NEEDED_FILE_RENAME_POWER("i_needed_modify_power_ft_needed_file_rename_power", "", 33010),
	I_NEEDED_MODIFY_POWER_FT_FILE_BROWSE_POWER("i_needed_modify_power_ft_file_browse_power", "", 33011),
	I_NEEDED_MODIFY_POWER_FT_NEEDED_FILE_BROWSE_POWER("i_needed_modify_power_ft_needed_file_browse_power", "", 33012),
	I_NEEDED_MODIFY_POWER_FT_DIRECTORY_CREATE_POWER("i_needed_modify_power_ft_directory_create_power", "", 33013),
	I_NEEDED_MODIFY_POWER_FT_NEEDED_DIRECTORY_CREATE_POWER("i_needed_modify_power_ft_needed_directory_create_power", "", 33014),
	I_NEEDED_MODIFY_POWER_FT_QUOTA_MB_DOWNLOAD_PER_CLIENT("i_needed_modify_power_ft_quota_mb_download_per_client", "", 33015),
	I_NEEDED_MODIFY_POWER_FT_QUOTA_MB_UPLOAD_PER_CLIENT("i_needed_modify_power_ft_quota_mb_upload_per_client", "", 33016);

	private final String name;
	private final String description;
	private final int id;

	IPermissionType(String name, String description, int id) {
		this.name = name;
		this.description = description;
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public String getDescription() {
		return description;
	}

	public int getId() {
		return id;
	}
}
