/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.FileTransferHelper;
import com.github.theholywaffle.teamspeak3.TS3Query;
import com.github.theholywaffle.teamspeak3.api.ChannelProperty;
import com.github.theholywaffle.teamspeak3.api.ClientProperty;
import com.github.theholywaffle.teamspeak3.api.CommandFuture;
import com.github.theholywaffle.teamspeak3.api.PermissionGroupDatabaseType;
import com.github.theholywaffle.teamspeak3.api.PrivilegeKeyType;
import com.github.theholywaffle.teamspeak3.api.ReasonIdentifier;
import com.github.theholywaffle.teamspeak3.api.ServerGroupType;
import com.github.theholywaffle.teamspeak3.api.ServerInstanceProperty;
import com.github.theholywaffle.teamspeak3.api.Snapshot;
import com.github.theholywaffle.teamspeak3.api.TextMessageTargetMode;
import com.github.theholywaffle.teamspeak3.api.VirtualServerProperty;
import com.github.theholywaffle.teamspeak3.api.event.TS3EventType;
import com.github.theholywaffle.teamspeak3.api.event.TS3Listener;
import com.github.theholywaffle.teamspeak3.api.exception.TS3CommandFailedException;
import com.github.theholywaffle.teamspeak3.api.exception.TS3Exception;
import com.github.theholywaffle.teamspeak3.api.exception.TS3FileTransferFailedException;
import com.github.theholywaffle.teamspeak3.api.wrapper.Ban;
import com.github.theholywaffle.teamspeak3.api.wrapper.Binding;
import com.github.theholywaffle.teamspeak3.api.wrapper.Channel;
import com.github.theholywaffle.teamspeak3.api.wrapper.ChannelBase;
import com.github.theholywaffle.teamspeak3.api.wrapper.ChannelGroup;
import com.github.theholywaffle.teamspeak3.api.wrapper.ChannelGroupClient;
import com.github.theholywaffle.teamspeak3.api.wrapper.ChannelInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.Client;
import com.github.theholywaffle.teamspeak3.api.wrapper.ClientInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.Complaint;
import com.github.theholywaffle.teamspeak3.api.wrapper.ConnectionInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.CreatedVirtualServer;
import com.github.theholywaffle.teamspeak3.api.wrapper.CustomPropertyAssignment;
import com.github.theholywaffle.teamspeak3.api.wrapper.DatabaseClient;
import com.github.theholywaffle.teamspeak3.api.wrapper.DatabaseClientInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.FileInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.FileListEntry;
import com.github.theholywaffle.teamspeak3.api.wrapper.FileTransfer;
import com.github.theholywaffle.teamspeak3.api.wrapper.FileTransferParameters;
import com.github.theholywaffle.teamspeak3.api.wrapper.HostInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.IconFile;
import com.github.theholywaffle.teamspeak3.api.wrapper.InstanceInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.Message;
import com.github.theholywaffle.teamspeak3.api.wrapper.Permission;
import com.github.theholywaffle.teamspeak3.api.wrapper.PermissionAssignment;
import com.github.theholywaffle.teamspeak3.api.wrapper.PermissionInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.PrivilegeKey;
import com.github.theholywaffle.teamspeak3.api.wrapper.QueryError;
import com.github.theholywaffle.teamspeak3.api.wrapper.ServerGroup;
import com.github.theholywaffle.teamspeak3.api.wrapper.ServerGroupClient;
import com.github.theholywaffle.teamspeak3.api.wrapper.ServerQueryInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.Version;
import com.github.theholywaffle.teamspeak3.api.wrapper.VirtualServer;
import com.github.theholywaffle.teamspeak3.api.wrapper.VirtualServerInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.Wrapper;
import com.github.theholywaffle.teamspeak3.commands.BanCommands;
import com.github.theholywaffle.teamspeak3.commands.ChannelCommands;
import com.github.theholywaffle.teamspeak3.commands.ChannelGroupCommands;
import com.github.theholywaffle.teamspeak3.commands.ClientCommands;
import com.github.theholywaffle.teamspeak3.commands.Command;
import com.github.theholywaffle.teamspeak3.commands.ComplaintCommands;
import com.github.theholywaffle.teamspeak3.commands.CustomPropertyCommands;
import com.github.theholywaffle.teamspeak3.commands.DatabaseClientCommands;
import com.github.theholywaffle.teamspeak3.commands.FileCommands;
import com.github.theholywaffle.teamspeak3.commands.MessageCommands;
import com.github.theholywaffle.teamspeak3.commands.PermissionCommands;
import com.github.theholywaffle.teamspeak3.commands.PrivilegeKeyCommands;
import com.github.theholywaffle.teamspeak3.commands.QueryCommands;
import com.github.theholywaffle.teamspeak3.commands.ServerCommands;
import com.github.theholywaffle.teamspeak3.commands.ServerGroupCommands;
import com.github.theholywaffle.teamspeak3.commands.VirtualServerCommands;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TS3ApiAsync {
    private final TS3Query query;

    public TS3ApiAsync(TS3Query query) {
        this.query = query;
    }

    public CommandFuture<Integer> addBan(String ip, String name, String uid, long timeInSeconds, String reason) {
        return this.addBan(ip, name, uid, null, timeInSeconds, reason);
    }

    public CommandFuture<Integer> addBan(String ip, String name, String uid, String myTSId, long timeInSeconds, String reason) {
        Command cmd = BanCommands.banAdd(ip, name, uid, myTSId, timeInSeconds, reason);
        return this.executeAndReturnIntProperty(cmd, "banid");
    }

    public CommandFuture<Void> addChannelClientPermission(int channelId, int clientDBId, String permName, int permValue) {
        Command cmd = PermissionCommands.channelClientAddPerm(channelId, clientDBId, permName, permValue);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Integer> addChannelGroup(String name) {
        return this.addChannelGroup(name, null);
    }

    public CommandFuture<Integer> addChannelGroup(String name, PermissionGroupDatabaseType type) {
        Command cmd = ChannelGroupCommands.channelGroupAdd(name, type);
        return this.executeAndReturnIntProperty(cmd, "cgid");
    }

    public CommandFuture<Void> addChannelGroupPermission(int groupId, String permName, int permValue) {
        Command cmd = PermissionCommands.channelGroupAddPerm(groupId, permName, permValue);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> addChannelPermission(int channelId, String permName, int permValue) {
        Command cmd = PermissionCommands.channelAddPerm(channelId, permName, permValue);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> addClientPermission(int clientDBId, String permName, int value, boolean skipped) {
        Command cmd = PermissionCommands.clientAddPerm(clientDBId, permName, value, skipped);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> addClientToServerGroup(int groupId, int clientDatabaseId) {
        Command cmd = ServerGroupCommands.serverGroupAddClient(groupId, clientDatabaseId);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> addComplaint(int clientDBId, String message) {
        Command cmd = ComplaintCommands.complainAdd(clientDBId, message);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> addPermissionToAllServerGroups(ServerGroupType type, String permName, int value, boolean negated, boolean skipped) {
        Command cmd = PermissionCommands.serverGroupAutoAddPerm(type, permName, value, negated, skipped);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<String> addPrivilegeKey(PrivilegeKeyType type, int groupId, int channelId, String description) {
        Command cmd = PrivilegeKeyCommands.privilegeKeyAdd(type, groupId, channelId, description);
        return this.executeAndReturnStringProperty(cmd, "token");
    }

    public CommandFuture<String> addPrivilegeKeyChannelGroup(int channelGroupId, int channelId, String description) {
        return this.addPrivilegeKey(PrivilegeKeyType.CHANNEL_GROUP, channelGroupId, channelId, description);
    }

    public CommandFuture<String> addPrivilegeKeyServerGroup(int serverGroupId, String description) {
        return this.addPrivilegeKey(PrivilegeKeyType.SERVER_GROUP, serverGroupId, 0, description);
    }

    public CommandFuture<Integer> addServerGroup(String name) {
        return this.addServerGroup(name, PermissionGroupDatabaseType.REGULAR);
    }

    public CommandFuture<Integer> addServerGroup(String name, PermissionGroupDatabaseType type) {
        Command cmd = ServerGroupCommands.serverGroupAdd(name, type);
        return this.executeAndReturnIntProperty(cmd, "sgid");
    }

    public CommandFuture<Void> addServerGroupPermission(int groupId, String permName, int value, boolean negated, boolean skipped) {
        Command cmd = PermissionCommands.serverGroupAddPerm(groupId, permName, value, negated, skipped);
        return this.executeAndReturnError(cmd);
    }

    public void addTS3Listeners(TS3Listener ... listeners) {
        this.query.getEventManager().addListeners(listeners);
    }

    public CommandFuture<int[]> banClient(int clientId, long timeInSeconds) {
        return this.banClient(clientId, timeInSeconds, null);
    }

    public CommandFuture<int[]> banClient(int clientId, long timeInSeconds, String reason) {
        Command cmd = BanCommands.banClient(clientId, timeInSeconds, reason);
        return this.executeAndReturnIntArray(cmd, "banid");
    }

    public CommandFuture<int[]> banClient(int clientId, String reason) {
        return this.banClient(clientId, 0L, reason);
    }

    public CommandFuture<Void> broadcast(String message) {
        Command cmd = ServerCommands.gm(message);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> copyChannelGroup(int sourceGroupId, int targetGroupId, PermissionGroupDatabaseType type) {
        if (targetGroupId <= 0) {
            throw new IllegalArgumentException("To create a new channel group, use the method with a String argument");
        }
        Command cmd = ChannelGroupCommands.channelGroupCopy(sourceGroupId, targetGroupId, type);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Integer> copyChannelGroup(int sourceGroupId, String targetName, PermissionGroupDatabaseType type) {
        Command cmd = ChannelGroupCommands.channelGroupCopy(sourceGroupId, targetName, type);
        return this.executeAndReturnIntProperty(cmd, "cgid");
    }

    public CommandFuture<Integer> copyServerGroup(int sourceGroupId, int targetGroupId, PermissionGroupDatabaseType type) {
        if (targetGroupId <= 0) {
            throw new IllegalArgumentException("To create a new server group, use the method with a String argument");
        }
        Command cmd = ServerGroupCommands.serverGroupCopy(sourceGroupId, targetGroupId, type);
        return this.executeAndReturnIntProperty(cmd, "sgid");
    }

    public CommandFuture<Integer> copyServerGroup(int sourceGroupId, String targetName, PermissionGroupDatabaseType type) {
        Command cmd = ServerGroupCommands.serverGroupCopy(sourceGroupId, targetName, type);
        return this.executeAndReturnIntProperty(cmd, "sgid");
    }

    public CommandFuture<Integer> createChannel(String name, Map<ChannelProperty, String> options) {
        Command cmd = ChannelCommands.channelCreate(name, options);
        return this.executeAndReturnIntProperty(cmd, "cid");
    }

    public CommandFuture<Void> createFileDirectory(String directoryPath, int channelId) {
        return this.createFileDirectory(directoryPath, channelId, null);
    }

    public CommandFuture<Void> createFileDirectory(String directoryPath, int channelId, String channelPassword) {
        Command cmd = FileCommands.ftCreateDir(directoryPath, channelId, channelPassword);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<CreatedVirtualServer> createServer(String name, Map<VirtualServerProperty, String> options) {
        Command cmd = VirtualServerCommands.serverCreate(name, options);
        return this.executeAndTransformFirst(cmd, CreatedVirtualServer::new);
    }

    public CommandFuture<Snapshot> createServerSnapshot() {
        Command cmd = VirtualServerCommands.serverSnapshotCreate();
        CommandFuture<Snapshot> future = cmd.getFuture().map(result -> new Snapshot(result.getRawResponse()));
        this.query.doCommandAsync(cmd);
        return future;
    }

    public CommandFuture<Void> deleteAllBans() {
        Command cmd = BanCommands.banDelAll();
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteAllComplaints(int clientDBId) {
        Command cmd = ComplaintCommands.complainDelAll(clientDBId);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteBan(int banId) {
        Command cmd = BanCommands.banDel(banId);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteChannel(int channelId) {
        return this.deleteChannel(channelId, true);
    }

    public CommandFuture<Void> deleteChannel(int channelId, boolean force) {
        Command cmd = ChannelCommands.channelDelete(channelId, force);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteChannelClientPermission(int channelId, int clientDBId, String permName) {
        Command cmd = PermissionCommands.channelClientDelPerm(channelId, clientDBId, permName);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteChannelGroup(int groupId) {
        return this.deleteChannelGroup(groupId, true);
    }

    public CommandFuture<Void> deleteChannelGroup(int groupId, boolean force) {
        Command cmd = ChannelGroupCommands.channelGroupDel(groupId, force);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteChannelGroupPermission(int groupId, String permName) {
        Command cmd = PermissionCommands.channelGroupDelPerm(groupId, permName);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteChannelPermission(int channelId, String permName) {
        Command cmd = PermissionCommands.channelDelPerm(channelId, permName);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteClientPermission(int clientDBId, String permName) {
        Command cmd = PermissionCommands.clientDelPerm(clientDBId, permName);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteComplaint(int targetClientDBId, int fromClientDBId) {
        Command cmd = ComplaintCommands.complainDel(targetClientDBId, fromClientDBId);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteCustomClientProperty(int clientDBId, String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        Command cmd = CustomPropertyCommands.customDelete(clientDBId, key);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteDatabaseClientProperties(int clientDBId) {
        Command cmd = DatabaseClientCommands.clientDBDelete(clientDBId);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteFile(String filePath, int channelId) {
        return this.deleteFile(filePath, channelId, null);
    }

    public CommandFuture<Void> deleteFile(String filePath, int channelId, String channelPassword) {
        Command cmd = FileCommands.ftDeleteFile(channelId, channelPassword, filePath);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteFiles(String[] filePaths, int channelId) {
        return this.deleteFiles(filePaths, channelId, null);
    }

    public CommandFuture<Void> deleteFiles(String[] filePaths, int channelId, String channelPassword) {
        Command cmd = FileCommands.ftDeleteFile(channelId, channelPassword, filePaths);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteIcon(long iconId) {
        String iconPath = "/icon_" + iconId;
        return this.deleteFile(iconPath, 0);
    }

    public CommandFuture<Void> deleteIcons(long ... iconIds) {
        String[] iconPaths = new String[iconIds.length];
        for (int i = 0; i < iconIds.length; ++i) {
            iconPaths[i] = "/icon_" + iconIds[i];
        }
        return this.deleteFiles(iconPaths, 0);
    }

    public CommandFuture<Void> deleteOfflineMessage(int messageId) {
        Command cmd = MessageCommands.messageDel(messageId);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deletePermissionFromAllServerGroups(ServerGroupType type, String permName) {
        Command cmd = PermissionCommands.serverGroupAutoDelPerm(type, permName);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deletePrivilegeKey(String token) {
        Command cmd = PrivilegeKeyCommands.privilegeKeyDelete(token);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteServer(int serverId) {
        Command cmd = VirtualServerCommands.serverDelete(serverId);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteServerGroup(int groupId) {
        return this.deleteServerGroup(groupId, true);
    }

    public CommandFuture<Void> deleteServerGroup(int groupId, boolean force) {
        Command cmd = ServerGroupCommands.serverGroupDel(groupId, force);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteServerGroupPermission(int groupId, String permName) {
        Command cmd = PermissionCommands.serverGroupDelPerm(groupId, permName);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deployServerSnapshot(Snapshot snapshot) {
        return this.deployServerSnapshot(snapshot.get());
    }

    public CommandFuture<Void> deployServerSnapshot(String snapshot) {
        Command cmd = VirtualServerCommands.serverSnapshotDeploy(snapshot);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Long> downloadFile(OutputStream dataOut, String filePath, int channelId) {
        return this.downloadFile(dataOut, filePath, channelId, null);
    }

    public CommandFuture<Long> downloadFile(OutputStream dataOut, String filePath, int channelId, String channelPassword) {
        FileTransferHelper helper = this.query.getFileTransferHelper();
        int transferId = helper.getClientTransferId();
        Command cmd = FileCommands.ftInitDownload(transferId, filePath, channelId, channelPassword);
        CommandFuture<Long> future = new CommandFuture<Long>();
        this.executeAndTransformFirst(cmd, FileTransferParameters::new).onSuccess(params -> {
            QueryError error = params.getQueryError();
            if (!error.isSuccessful()) {
                future.fail(new TS3CommandFailedException(error, cmd.getName()));
                return;
            }
            try {
                this.query.getFileTransferHelper().downloadFile(dataOut, (FileTransferParameters)params);
            }
            catch (IOException e) {
                future.fail(new TS3FileTransferFailedException("Download failed", e));
                return;
            }
            future.set(params.getFileSize());
        }).forwardFailure(future);
        return future;
    }

    public CommandFuture<byte[]> downloadFileDirect(String filePath, int channelId) {
        return this.downloadFileDirect(filePath, channelId, null);
    }

    public CommandFuture<byte[]> downloadFileDirect(String filePath, int channelId, String channelPassword) {
        FileTransferHelper helper = this.query.getFileTransferHelper();
        int transferId = helper.getClientTransferId();
        Command cmd = FileCommands.ftInitDownload(transferId, filePath, channelId, channelPassword);
        CommandFuture<byte[]> future = new CommandFuture<byte[]>();
        this.executeAndTransformFirst(cmd, FileTransferParameters::new).onSuccess(params -> {
            QueryError error = params.getQueryError();
            if (!error.isSuccessful()) {
                future.fail(new TS3CommandFailedException(error, cmd.getName()));
                return;
            }
            long fileSize = params.getFileSize();
            if (fileSize > Integer.MAX_VALUE) {
                future.fail(new TS3FileTransferFailedException("File too big for byte array"));
                return;
            }
            ByteArrayOutputStream dataOut = new ByteArrayOutputStream((int)fileSize);
            try {
                this.query.getFileTransferHelper().downloadFile(dataOut, (FileTransferParameters)params);
            }
            catch (IOException e) {
                future.fail(new TS3FileTransferFailedException("Download failed", e));
                return;
            }
            future.set(dataOut.toByteArray());
        }).forwardFailure(future);
        return future;
    }

    public CommandFuture<Long> downloadIcon(OutputStream dataOut, long iconId) {
        String iconPath = "/icon_" + iconId;
        return this.downloadFile(dataOut, iconPath, 0);
    }

    public CommandFuture<byte[]> downloadIconDirect(long iconId) {
        String iconPath = "/icon_" + iconId;
        return this.downloadFileDirect(iconPath, 0);
    }

    public CommandFuture<Void> editChannel(int channelId, Map<ChannelProperty, String> options) {
        Command cmd = ChannelCommands.channelEdit(channelId, options);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> editChannel(int channelId, ChannelProperty property, String value) {
        return this.editChannel(channelId, Collections.singletonMap(property, value));
    }

    public CommandFuture<Void> editClient(int clientId, Map<ClientProperty, String> options) {
        Command cmd = ClientCommands.clientEdit(clientId, options);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> editClient(int clientId, ClientProperty property, String value) {
        return this.editClient(clientId, Collections.singletonMap(property, value));
    }

    public CommandFuture<Void> editDatabaseClient(int clientDBId, Map<ClientProperty, String> options) {
        Command cmd = DatabaseClientCommands.clientDBEdit(clientDBId, options);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> editInstance(ServerInstanceProperty property, String value) {
        Command cmd = ServerCommands.instanceEdit(Collections.singletonMap(property, value));
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> editServer(Map<VirtualServerProperty, String> options) {
        Command cmd = VirtualServerCommands.serverEdit(options);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<List<Ban>> getBans() {
        Command cmd = BanCommands.banList();
        return this.executeAndTransform(cmd, Ban::new);
    }

    public CommandFuture<List<Binding>> getBindings() {
        Command cmd = ServerCommands.bindingList();
        return this.executeAndTransform(cmd, Binding::new);
    }

    public CommandFuture<Channel> getChannelByNameExact(String name, boolean ignoreCase) {
        String caseName = ignoreCase ? name.toLowerCase(Locale.ROOT) : name;
        return this.getChannels().map(allChannels -> {
            for (Channel c : allChannels) {
                String channelName = ignoreCase ? c.getName().toLowerCase(Locale.ROOT) : c.getName();
                if (!caseName.equals(channelName)) continue;
                return c;
            }
            return null;
        });
    }

    public CommandFuture<List<Channel>> getChannelsByName(String name) {
        Command cmd = ChannelCommands.channelFind(name);
        CommandFuture<List<Channel>> future = new CommandFuture<List<Channel>>();
        CommandFuture channelIds = this.executeAndMap(cmd, response -> response.getInt("cid"));
        CommandFuture allChannels = this.getChannels();
        TS3ApiAsync.findByKey(channelIds, allChannels, Channel::getId).forwardSuccess(future).onFailure(TS3ApiAsync.transformError(future, 768, Collections.emptyList()));
        return future;
    }

    public CommandFuture<List<Permission>> getChannelClientPermissions(int channelId, int clientDBId) {
        Command cmd = PermissionCommands.channelClientPermList(channelId, clientDBId);
        return this.executeAndTransform(cmd, Permission::new);
    }

    public CommandFuture<List<ChannelGroupClient>> getChannelGroupClients(int channelId, int clientDBId, int groupId) {
        Command cmd = ChannelGroupCommands.channelGroupClientList(channelId, clientDBId, groupId);
        return this.executeAndTransform(cmd, ChannelGroupClient::new);
    }

    public CommandFuture<List<ChannelGroupClient>> getChannelGroupClientsByChannelGroupId(int groupId) {
        return this.getChannelGroupClients(-1, -1, groupId);
    }

    public CommandFuture<List<ChannelGroupClient>> getChannelGroupClientsByChannelId(int channelId) {
        return this.getChannelGroupClients(channelId, -1, -1);
    }

    public CommandFuture<List<ChannelGroupClient>> getChannelGroupClientsByClientDBId(int clientDBId) {
        return this.getChannelGroupClients(-1, clientDBId, -1);
    }

    public CommandFuture<List<Permission>> getChannelGroupPermissions(int groupId) {
        Command cmd = PermissionCommands.channelGroupPermList(groupId);
        return this.executeAndTransform(cmd, Permission::new);
    }

    public CommandFuture<List<ChannelGroup>> getChannelGroups() {
        Command cmd = ChannelGroupCommands.channelGroupList();
        return this.executeAndTransform(cmd, ChannelGroup::new);
    }

    public CommandFuture<ChannelInfo> getChannelInfo(int channelId) {
        Command cmd = ChannelCommands.channelInfo(channelId);
        return this.executeAndTransformFirst(cmd, map -> new ChannelInfo(channelId, (Map<String, String>)map));
    }

    public CommandFuture<List<Permission>> getChannelPermissions(int channelId) {
        Command cmd = PermissionCommands.channelPermList(channelId);
        return this.executeAndTransform(cmd, Permission::new);
    }

    public CommandFuture<List<Channel>> getChannels() {
        Command cmd = ChannelCommands.channelList();
        return this.executeAndTransform(cmd, Channel::new);
    }

    public CommandFuture<Client> getClientByNameExact(String name, boolean ignoreCase) {
        String caseName = ignoreCase ? name.toLowerCase(Locale.ROOT) : name;
        return this.getClients().map(allClients -> {
            for (Client c : allClients) {
                String clientName = ignoreCase ? c.getNickname().toLowerCase(Locale.ROOT) : c.getNickname();
                if (!caseName.equals(clientName)) continue;
                return c;
            }
            return null;
        });
    }

    public CommandFuture<List<Client>> getClientsByName(String name) {
        Command cmd = ClientCommands.clientFind(name);
        CommandFuture<List<Client>> future = new CommandFuture<List<Client>>();
        CommandFuture clientIds = this.executeAndMap(cmd, response -> response.getInt("clid"));
        CommandFuture allClients = this.getClients();
        TS3ApiAsync.findByKey(clientIds, allClients, Client::getId).forwardSuccess(future).onFailure(TS3ApiAsync.transformError(future, 512, Collections.emptyList()));
        return future;
    }

    public CommandFuture<ClientInfo> getClientByUId(String clientUId) {
        Command cmd = ClientCommands.clientGetIds(clientUId);
        return this.executeAndReturnIntProperty(cmd, "clid").then(this::getClientInfo);
    }

    public CommandFuture<ClientInfo> getClientInfo(int clientId) {
        Command cmd = ClientCommands.clientInfo(clientId);
        return this.executeAndTransformFirst(cmd, map -> new ClientInfo(clientId, (Map<String, String>)map));
    }

    public CommandFuture<List<Permission>> getClientPermissions(int clientDBId) {
        Command cmd = PermissionCommands.clientPermList(clientDBId);
        return this.executeAndTransform(cmd, Permission::new);
    }

    public CommandFuture<List<Client>> getClients() {
        Command cmd = ClientCommands.clientList();
        return this.executeAndTransform(cmd, Client::new);
    }

    public CommandFuture<List<Complaint>> getComplaints() {
        return this.getComplaints(-1);
    }

    public CommandFuture<List<Complaint>> getComplaints(int clientDBId) {
        Command cmd = ComplaintCommands.complainList(clientDBId);
        return this.executeAndTransform(cmd, Complaint::new);
    }

    public CommandFuture<ConnectionInfo> getConnectionInfo() {
        Command cmd = VirtualServerCommands.serverRequestConnectionInfo();
        return this.executeAndTransformFirst(cmd, ConnectionInfo::new);
    }

    public CommandFuture<Map<String, String>> getCustomClientProperties(int clientDBId) {
        Command cmd = CustomPropertyCommands.customInfo(clientDBId);
        CommandFuture<Map<String, String>> future = cmd.getFuture().map(result -> {
            List<Wrapper> response = result.getResponses();
            HashMap<String, String> properties = new HashMap<String, String>(response.size());
            for (Wrapper wrapper : response) {
                properties.put(wrapper.get("ident"), wrapper.get("value"));
            }
            return properties;
        });
        this.query.doCommandAsync(cmd);
        return future;
    }

    public CommandFuture<List<DatabaseClientInfo>> getDatabaseClientsByName(String name) {
        Command cmd = DatabaseClientCommands.clientDBFind(name, false);
        return this.executeAndMap(cmd, response -> response.getInt("cldbid")).then(dbClientIds -> {
            ArrayList infoFutures = new ArrayList(dbClientIds.size());
            Iterator iterator = dbClientIds.iterator();
            while (iterator.hasNext()) {
                int dbClientId = (Integer)iterator.next();
                infoFutures.add(this.getDatabaseClientInfo(dbClientId));
            }
            return CommandFuture.ofAll(infoFutures);
        });
    }

    public CommandFuture<DatabaseClientInfo> getDatabaseClientByUId(String clientUId) {
        Command cmd = DatabaseClientCommands.clientDBFind(clientUId, true);
        CommandFuture<DatabaseClientInfo> future = cmd.getFuture().then(result -> {
            if (result.getResponses().isEmpty()) {
                return null;
            }
            int databaseId = result.getFirstResponse().getInt("cldbid");
            return this.getDatabaseClientInfo(databaseId);
        });
        this.query.doCommandAsync(cmd);
        return future;
    }

    public CommandFuture<DatabaseClientInfo> getDatabaseClientInfo(int clientDBId) {
        Command cmd = DatabaseClientCommands.clientDBInfo(clientDBId);
        return this.executeAndTransformFirst(cmd, DatabaseClientInfo::new);
    }

    public CommandFuture<List<DatabaseClient>> getDatabaseClients() {
        Command cmd = DatabaseClientCommands.clientDBList(0, 1, true);
        return this.executeAndReturnIntProperty(cmd, "count").then(count -> {
            ArrayList futures = new ArrayList((count + 199) / 200);
            for (int i = 0; i < count; i += 200) {
                futures.add(this.getDatabaseClients(i, 200));
            }
            return CommandFuture.ofAll(futures);
        }).map(listOfLists -> listOfLists.stream().flatMap(Collection::stream).collect(Collectors.toList()));
    }

    public CommandFuture<List<DatabaseClient>> getDatabaseClients(int offset, int count) {
        Command cmd = DatabaseClientCommands.clientDBList(offset, count, false);
        return this.executeAndTransform(cmd, DatabaseClient::new);
    }

    public CommandFuture<FileInfo> getFileInfo(String filePath, int channelId) {
        return this.getFileInfo(filePath, channelId, null);
    }

    public CommandFuture<FileInfo> getFileInfo(String filePath, int channelId, String channelPassword) {
        Command cmd = FileCommands.ftGetFileInfo(channelId, channelPassword, filePath);
        return this.executeAndTransformFirst(cmd, FileInfo::new);
    }

    public CommandFuture<List<FileInfo>> getFileInfos(String[] filePaths, int channelId) {
        return this.getFileInfos(filePaths, channelId, null);
    }

    public CommandFuture<List<FileInfo>> getFileInfos(String[] filePaths, int channelId, String channelPassword) {
        Command cmd = FileCommands.ftGetFileInfo(channelId, channelPassword, filePaths);
        return this.executeAndTransform(cmd, FileInfo::new);
    }

    public CommandFuture<List<FileInfo>> getFileInfos(String[] filePaths, int[] channelIds, String[] channelPasswords) {
        Command cmd = FileCommands.ftGetFileInfo(channelIds, channelPasswords, filePaths);
        return this.executeAndTransform(cmd, FileInfo::new);
    }

    public CommandFuture<List<FileListEntry>> getFileList(String directoryPath, int channelId) {
        return this.getFileList(directoryPath, channelId, null);
    }

    public CommandFuture<List<FileListEntry>> getFileList(String directoryPath, int channelId, String channelPassword) {
        Command cmd = FileCommands.ftGetFileList(directoryPath, channelId, channelPassword);
        return this.executeAndTransform(cmd, FileListEntry::new);
    }

    public CommandFuture<List<FileTransfer>> getFileTransfers() {
        Command cmd = FileCommands.ftList();
        return this.executeAndTransform(cmd, FileTransfer::new);
    }

    public CommandFuture<HostInfo> getHostInfo() {
        Command cmd = ServerCommands.hostInfo();
        return this.executeAndTransformFirst(cmd, HostInfo::new);
    }

    public CommandFuture<List<IconFile>> getIconList() {
        return this.getFileList("/icons/", 0).map(result -> {
            ArrayList<IconFile> icons = new ArrayList<IconFile>(result.size());
            for (FileListEntry file : result) {
                if (file.isDirectory() || file.isStillUploading()) continue;
                icons.add(new IconFile(file.getMap()));
            }
            return icons;
        });
    }

    public CommandFuture<InstanceInfo> getInstanceInfo() {
        Command cmd = ServerCommands.instanceInfo();
        return this.executeAndTransformFirst(cmd, InstanceInfo::new);
    }

    public CommandFuture<List<String>> getInstanceLogEntries(int lines) {
        Command cmd = ServerCommands.logView(lines, true);
        return this.executeAndMap(cmd, response -> response.get("l"));
    }

    public CommandFuture<List<String>> getInstanceLogEntries() {
        return this.getInstanceLogEntries(100);
    }

    public CommandFuture<String> getOfflineMessage(int messageId) {
        Command cmd = MessageCommands.messageGet(messageId);
        return this.executeAndReturnStringProperty(cmd, "message");
    }

    public CommandFuture<String> getOfflineMessage(Message message) {
        return this.getOfflineMessage(message.getId());
    }

    public CommandFuture<List<Message>> getOfflineMessages() {
        Command cmd = MessageCommands.messageList();
        return this.executeAndTransform(cmd, Message::new);
    }

    public CommandFuture<List<PermissionAssignment>> getPermissionAssignments(String permName) {
        Command cmd = PermissionCommands.permFind(permName);
        CommandFuture<List<PermissionAssignment>> future = new CommandFuture<List<PermissionAssignment>>();
        this.executeAndTransform(cmd, PermissionAssignment::new).forwardSuccess(future).onFailure(TS3ApiAsync.transformError(future, 2562, Collections.emptyList()));
        return future;
    }

    public CommandFuture<Integer> getPermissionIdByName(String permName) {
        Command cmd = PermissionCommands.permIdGetByName(permName);
        return this.executeAndReturnIntProperty(cmd, "permid");
    }

    public CommandFuture<int[]> getPermissionIdsByName(String ... permNames) {
        Command cmd = PermissionCommands.permIdGetByName(permNames);
        return this.executeAndReturnIntArray(cmd, "permid");
    }

    public CommandFuture<List<PermissionAssignment>> getPermissionOverview(int channelId, int clientDBId) {
        Command cmd = PermissionCommands.permOverview(channelId, clientDBId);
        return this.executeAndTransform(cmd, PermissionAssignment::new);
    }

    public CommandFuture<List<PermissionInfo>> getPermissions() {
        Command cmd = PermissionCommands.permissionList();
        return this.executeAndTransform(cmd, PermissionInfo::new);
    }

    public CommandFuture<Integer> getPermissionValue(String permName) {
        Command cmd = PermissionCommands.permGet(permName);
        return this.executeAndReturnIntProperty(cmd, "permvalue");
    }

    public CommandFuture<int[]> getPermissionValues(String ... permNames) {
        Command cmd = PermissionCommands.permGet(permNames);
        return this.executeAndReturnIntArray(cmd, "permvalue");
    }

    public CommandFuture<List<PrivilegeKey>> getPrivilegeKeys() {
        Command cmd = PrivilegeKeyCommands.privilegeKeyList();
        return this.executeAndTransform(cmd, PrivilegeKey::new);
    }

    public CommandFuture<List<ServerGroupClient>> getServerGroupClients(int serverGroupId) {
        Command cmd = ServerGroupCommands.serverGroupClientList(serverGroupId);
        return this.executeAndTransform(cmd, ServerGroupClient::new);
    }

    public CommandFuture<List<ServerGroupClient>> getServerGroupClients(ServerGroup serverGroup) {
        return this.getServerGroupClients(serverGroup.getId());
    }

    public CommandFuture<List<Permission>> getServerGroupPermissions(int serverGroupId) {
        Command cmd = PermissionCommands.serverGroupPermList(serverGroupId);
        return this.executeAndTransform(cmd, Permission::new);
    }

    public CommandFuture<List<Permission>> getServerGroupPermissions(ServerGroup serverGroup) {
        return this.getServerGroupPermissions(serverGroup.getId());
    }

    public CommandFuture<List<ServerGroup>> getServerGroups() {
        Command cmd = ServerGroupCommands.serverGroupList();
        return this.executeAndTransform(cmd, ServerGroup::new);
    }

    public CommandFuture<List<ServerGroup>> getServerGroupsByClientId(int clientDatabaseId) {
        Command cmd = ServerGroupCommands.serverGroupsByClientId(clientDatabaseId);
        CommandFuture serverGroupIds = this.executeAndMap(cmd, response -> response.getInt("sgid"));
        CommandFuture allServerGroups = this.getServerGroups();
        return TS3ApiAsync.findByKey(serverGroupIds, allServerGroups, ServerGroup::getId);
    }

    public CommandFuture<List<ServerGroup>> getServerGroupsByClient(Client client) {
        return this.getServerGroupsByClientId(client.getDatabaseId());
    }

    public CommandFuture<Integer> getServerIdByPort(int port) {
        Command cmd = VirtualServerCommands.serverIdGetByPort(port);
        return this.executeAndReturnIntProperty(cmd, "server_id");
    }

    public CommandFuture<VirtualServerInfo> getServerInfo() {
        Command cmd = VirtualServerCommands.serverInfo();
        return this.executeAndTransformFirst(cmd, VirtualServerInfo::new);
    }

    public CommandFuture<Version> getVersion() {
        Command cmd = ServerCommands.version();
        return this.executeAndTransformFirst(cmd, Version::new);
    }

    public CommandFuture<List<VirtualServer>> getVirtualServers() {
        Command cmd = VirtualServerCommands.serverList();
        return this.executeAndTransform(cmd, VirtualServer::new);
    }

    public CommandFuture<List<String>> getVirtualServerLogEntries(int lines) {
        Command cmd = ServerCommands.logView(lines, false);
        return this.executeAndMap(cmd, response -> response.get("l"));
    }

    public CommandFuture<List<String>> getVirtualServerLogEntries() {
        return this.getVirtualServerLogEntries(100);
    }

    public CommandFuture<Boolean> isClientOnline(int clientId) {
        Command cmd = ClientCommands.clientInfo(clientId);
        CommandFuture<Boolean> future = new CommandFuture<Boolean>();
        cmd.getFuture().onSuccess(__ -> future.set(true)).onFailure(TS3ApiAsync.transformError(future, 512, false));
        this.query.doCommandAsync(cmd);
        return future;
    }

    public CommandFuture<Boolean> isClientOnline(String clientUId) {
        Command cmd = ClientCommands.clientGetIds(clientUId);
        CommandFuture<Boolean> future = cmd.getFuture().map(result -> !result.getResponses().isEmpty());
        this.query.doCommandAsync(cmd);
        return future;
    }

    public CommandFuture<Void> kickClientFromChannel(int ... clientIds) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_CHANNEL, null, clientIds);
    }

    public CommandFuture<Void> kickClientFromChannel(Client ... clients) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_CHANNEL, null, clients);
    }

    public CommandFuture<Void> kickClientFromChannel(String message, int ... clientIds) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_CHANNEL, message, clientIds);
    }

    public CommandFuture<Void> kickClientFromChannel(String message, Client ... clients) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_CHANNEL, message, clients);
    }

    public CommandFuture<Void> kickClientFromServer(int ... clientIds) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_SERVER, null, clientIds);
    }

    public CommandFuture<Void> kickClientFromServer(Client ... clients) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_SERVER, null, clients);
    }

    public CommandFuture<Void> kickClientFromServer(String message, int ... clientIds) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_SERVER, message, clientIds);
    }

    public CommandFuture<Void> kickClientFromServer(String message, Client ... clients) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_SERVER, message, clients);
    }

    private CommandFuture<Void> kickClients(ReasonIdentifier reason, String message, Client ... clients) {
        int[] clientIds = new int[clients.length];
        for (int i = 0; i < clients.length; ++i) {
            clientIds[i] = clients[i].getId();
        }
        return this.kickClients(reason, message, clientIds);
    }

    private CommandFuture<Void> kickClients(ReasonIdentifier reason, String message, int ... clientIds) {
        Command cmd = ClientCommands.clientKick(reason, message, clientIds);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> login(String username, String password) {
        Command cmd = QueryCommands.logIn(username, password);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> logout() {
        Command cmd = QueryCommands.logOut();
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> moveChannel(int channelId, int channelTargetId) {
        return this.moveChannel(channelId, channelTargetId, 0);
    }

    public CommandFuture<Void> moveChannel(int channelId, int channelTargetId, int order) {
        Command cmd = ChannelCommands.channelMove(channelId, channelTargetId, order);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> moveClient(int clientId, int channelId) {
        return this.moveClient(clientId, channelId, null);
    }

    public CommandFuture<Void> moveClients(int[] clientIds, int channelId) {
        return this.moveClients(clientIds, channelId, null);
    }

    public CommandFuture<Void> moveClient(Client client, ChannelBase channel) {
        return this.moveClient(client, channel, null);
    }

    public CommandFuture<Void> moveClients(Client[] clients, ChannelBase channel) {
        return this.moveClients(clients, channel, null);
    }

    public CommandFuture<Void> moveClient(int clientId, int channelId, String channelPassword) {
        Command cmd = ClientCommands.clientMove(clientId, channelId, channelPassword);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> moveClients(int[] clientIds, int channelId, String channelPassword) {
        if (clientIds == null) {
            throw new IllegalArgumentException("Client ID array was null");
        }
        if (clientIds.length == 0) {
            return CommandFuture.immediate(null);
        }
        Command cmd = ClientCommands.clientMove(clientIds, channelId, channelPassword);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> moveClient(Client client, ChannelBase channel, String channelPassword) {
        if (client == null) {
            throw new IllegalArgumentException("Client cannot be null");
        }
        if (channel == null) {
            throw new IllegalArgumentException("Channel cannot be null");
        }
        return this.moveClient(client.getId(), channel.getId(), channelPassword);
    }

    public CommandFuture<Void> moveClients(Client[] clients, ChannelBase channel, String channelPassword) {
        if (clients == null) {
            throw new IllegalArgumentException("Client array cannot be null");
        }
        if (channel == null) {
            throw new IllegalArgumentException("Channel cannot be null");
        }
        int[] clientIds = new int[clients.length];
        for (int i = 0; i < clients.length; ++i) {
            clientIds[i] = clients[i].getId();
        }
        return this.moveClients(clientIds, channel.getId(), channelPassword);
    }

    public CommandFuture<Void> moveFile(String oldPath, String newPath, int channelId) {
        return this.moveFile(oldPath, newPath, channelId, null);
    }

    public CommandFuture<Void> moveFile(String oldPath, String newPath, int oldChannelId, int newChannelId) {
        return this.moveFile(oldPath, newPath, oldChannelId, null, newChannelId, null);
    }

    public CommandFuture<Void> moveFile(String oldPath, String newPath, int channelId, String channelPassword) {
        Command cmd = FileCommands.ftRenameFile(oldPath, newPath, channelId, channelPassword);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> moveFile(String oldPath, String newPath, int oldChannelId, String oldPassword, int newChannelId, String newPassword) {
        Command cmd = FileCommands.ftRenameFile(oldPath, newPath, oldChannelId, oldPassword, newChannelId, newPassword);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> moveQuery(int channelId) {
        return this.moveClient(0, channelId, null);
    }

    public CommandFuture<Void> moveQuery(ChannelBase channel) {
        if (channel == null) {
            throw new IllegalArgumentException("Channel cannot be null");
        }
        return this.moveClient(0, channel.getId(), null);
    }

    public CommandFuture<Void> moveQuery(int channelId, String channelPassword) {
        return this.moveClient(0, channelId, channelPassword);
    }

    public CommandFuture<Void> moveQuery(ChannelBase channel, String channelPassword) {
        if (channel == null) {
            throw new IllegalArgumentException("Channel cannot be null");
        }
        return this.moveClient(0, channel.getId(), channelPassword);
    }

    public CommandFuture<Void> pokeClient(int clientId, String message) {
        Command cmd = ClientCommands.clientPoke(clientId, message);
        return this.executeAndReturnError(cmd);
    }

    CommandFuture<Void> quit() {
        Command cmd = QueryCommands.quit();
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> registerAllEvents() {
        List eventFutures = Arrays.asList(this.registerEvent(TS3EventType.SERVER), this.registerEvent(TS3EventType.TEXT_SERVER), this.registerEvent(TS3EventType.CHANNEL, 0), this.registerEvent(TS3EventType.TEXT_CHANNEL, 0), this.registerEvent(TS3EventType.TEXT_PRIVATE), this.registerEvent(TS3EventType.PRIVILEGE_KEY_USED));
        return CommandFuture.ofAll(eventFutures).map(__ -> null);
    }

    public CommandFuture<Void> registerEvent(TS3EventType eventType) {
        if (eventType == TS3EventType.CHANNEL || eventType == TS3EventType.TEXT_CHANNEL) {
            return this.registerEvent(eventType, 0);
        }
        return this.registerEvent(eventType, -1);
    }

    public CommandFuture<Void> registerEvent(TS3EventType eventType, int channelId) {
        Command cmd = QueryCommands.serverNotifyRegister(eventType, channelId);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> registerEvents(TS3EventType ... eventTypes) {
        if (eventTypes.length == 0) {
            return CommandFuture.immediate(null);
        }
        ArrayList registerFutures = new ArrayList(eventTypes.length);
        for (TS3EventType type : eventTypes) {
            registerFutures.add(this.registerEvent(type));
        }
        return CommandFuture.ofAll(registerFutures).map(__ -> null);
    }

    public CommandFuture<Void> removeClientFromServerGroup(int serverGroupId, int clientDatabaseId) {
        Command cmd = ServerGroupCommands.serverGroupDelClient(serverGroupId, clientDatabaseId);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> removeClientFromServerGroup(ServerGroup serverGroup, Client client) {
        return this.removeClientFromServerGroup(serverGroup.getId(), client.getDatabaseId());
    }

    public void removeTS3Listeners(TS3Listener ... listeners) {
        this.query.getEventManager().removeListeners(listeners);
    }

    public CommandFuture<Void> renameChannelGroup(int channelGroupId, String name) {
        Command cmd = ChannelGroupCommands.channelGroupRename(channelGroupId, name);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> renameChannelGroup(ChannelGroup channelGroup, String name) {
        return this.renameChannelGroup(channelGroup.getId(), name);
    }

    public CommandFuture<Void> renameServerGroup(int serverGroupId, String name) {
        Command cmd = ServerGroupCommands.serverGroupRename(serverGroupId, name);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> renameServerGroup(ServerGroup serverGroup, String name) {
        return this.renameChannelGroup(serverGroup.getId(), name);
    }

    public CommandFuture<String> resetPermissions() {
        Command cmd = PermissionCommands.permReset();
        return this.executeAndReturnStringProperty(cmd, "token");
    }

    public CommandFuture<List<CustomPropertyAssignment>> searchCustomClientProperty(String key) {
        return this.searchCustomClientProperty(key, "%");
    }

    public CommandFuture<List<CustomPropertyAssignment>> searchCustomClientProperty(String key, String valuePattern) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        Command cmd = CustomPropertyCommands.customSearch(key, valuePattern);
        return this.executeAndTransform(cmd, CustomPropertyAssignment::new);
    }

    public CommandFuture<Void> selectVirtualServerById(int id) {
        return this.selectVirtualServerById(id, null);
    }

    public CommandFuture<Void> selectVirtualServerById(int id, String nickname) {
        Command cmd = QueryCommands.useId(id, nickname);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> selectVirtualServerByPort(int port) {
        return this.selectVirtualServerByPort(port, null);
    }

    public CommandFuture<Void> selectVirtualServerByPort(int port, String nickname) {
        Command cmd = QueryCommands.usePort(port, nickname);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> selectVirtualServer(VirtualServer server) {
        return this.selectVirtualServerById(server.getId());
    }

    public CommandFuture<Void> selectVirtualServer(VirtualServer server, String nickname) {
        return this.selectVirtualServerById(server.getId(), nickname);
    }

    public CommandFuture<Void> sendOfflineMessage(String clientUId, String subject, String message) {
        Command cmd = MessageCommands.messageAdd(clientUId, subject, message);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> sendTextMessage(TextMessageTargetMode targetMode, int targetId, String message) {
        Command cmd = ClientCommands.sendTextMessage(targetMode.getIndex(), targetId, message);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> sendChannelMessage(int channelId, String message) {
        return this.moveQuery(channelId).then(__ -> this.sendTextMessage(TextMessageTargetMode.CHANNEL, 0, message));
    }

    public CommandFuture<Void> sendChannelMessage(String message) {
        return this.sendTextMessage(TextMessageTargetMode.CHANNEL, 0, message);
    }

    public CommandFuture<Void> sendServerMessage(int serverId, String message) {
        return this.selectVirtualServerById(serverId).then(__ -> this.sendTextMessage(TextMessageTargetMode.SERVER, 0, message));
    }

    public CommandFuture<Void> sendServerMessage(String message) {
        return this.sendTextMessage(TextMessageTargetMode.SERVER, 0, message);
    }

    public CommandFuture<Void> sendPrivateMessage(int clientId, String message) {
        return this.sendTextMessage(TextMessageTargetMode.CLIENT, clientId, message);
    }

    public CommandFuture<Void> setClientChannelGroup(int groupId, int channelId, int clientDBId) {
        Command cmd = ChannelGroupCommands.setClientChannelGroup(groupId, channelId, clientDBId);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> setCustomClientProperties(int clientDBId, Map<String, String> properties) {
        ArrayList futures = new ArrayList(properties.size());
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key == null) continue;
            futures.add(this.setCustomClientProperty(clientDBId, key, value));
        }
        return CommandFuture.ofAll(futures).map(__ -> null);
    }

    public CommandFuture<Void> setCustomClientProperty(int clientDBId, String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        Command cmd = CustomPropertyCommands.customSet(clientDBId, key, value);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> setMessageRead(int messageId) {
        return this.setMessageReadFlag(messageId, true);
    }

    public CommandFuture<Void> setMessageRead(Message message) {
        return this.setMessageReadFlag(message.getId(), true);
    }

    public CommandFuture<Void> setMessageReadFlag(int messageId, boolean read) {
        Command cmd = MessageCommands.messageUpdateFlag(messageId, read);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> setMessageReadFlag(Message message, boolean read) {
        return this.setMessageReadFlag(message.getId(), read);
    }

    public CommandFuture<Void> setNickname(String nickname) {
        Map<ClientProperty, String> options = Collections.singletonMap(ClientProperty.CLIENT_NICKNAME, nickname);
        return this.updateClient(options);
    }

    public CommandFuture<Void> startServer(int serverId) {
        Command cmd = VirtualServerCommands.serverStart(serverId);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> startServer(VirtualServer virtualServer) {
        return this.startServer(virtualServer.getId());
    }

    public CommandFuture<Void> stopServer(int serverId) {
        return this.stopServer(serverId, null);
    }

    public CommandFuture<Void> stopServer(int serverId, String reason) {
        Command cmd = VirtualServerCommands.serverStop(serverId, reason);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> stopServer(VirtualServer virtualServer) {
        return this.stopServer(virtualServer.getId(), null);
    }

    public CommandFuture<Void> stopServer(VirtualServer virtualServer, String reason) {
        return this.stopServer(virtualServer.getId(), reason);
    }

    public CommandFuture<Void> stopServerProcess() {
        return this.stopServerProcess(null);
    }

    public CommandFuture<Void> stopServerProcess(String reason) {
        Command cmd = ServerCommands.serverProcessStop(reason);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> unregisterAllEvents() {
        Command cmd = QueryCommands.serverNotifyUnregister();
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> updateClient(Map<ClientProperty, String> options) {
        Command cmd = ClientCommands.clientUpdate(options);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> updateClient(ClientProperty property, String value) {
        return this.updateClient(Collections.singletonMap(property, value));
    }

    public CommandFuture<String> updateServerQueryLogin(String loginName) {
        Command cmd = ClientCommands.clientSetServerQueryLogin(loginName);
        return this.executeAndReturnStringProperty(cmd, "client_login_password");
    }

    public CommandFuture<Void> uploadFile(InputStream dataIn, long dataLength, String filePath, boolean overwrite, int channelId) {
        return this.uploadFile(dataIn, dataLength, filePath, overwrite, channelId, null);
    }

    public CommandFuture<Void> uploadFile(InputStream dataIn, long dataLength, String filePath, boolean overwrite, int channelId, String channelPassword) {
        FileTransferHelper helper = this.query.getFileTransferHelper();
        int transferId = helper.getClientTransferId();
        Command cmd = FileCommands.ftInitUpload(transferId, filePath, channelId, channelPassword, dataLength, overwrite);
        CommandFuture<Void> future = new CommandFuture<Void>();
        this.executeAndTransformFirst(cmd, FileTransferParameters::new).onSuccess(params -> {
            QueryError error = params.getQueryError();
            if (!error.isSuccessful()) {
                future.fail(new TS3CommandFailedException(error, cmd.getName()));
                return;
            }
            try {
                this.query.getFileTransferHelper().uploadFile(dataIn, dataLength, (FileTransferParameters)params);
            }
            catch (IOException e) {
                future.fail(new TS3FileTransferFailedException("Upload failed", e));
                return;
            }
            future.set(null);
        }).forwardFailure(future);
        return future;
    }

    public CommandFuture<Void> uploadFileDirect(byte[] data, String filePath, boolean overwrite, int channelId) {
        return this.uploadFileDirect(data, filePath, overwrite, channelId, null);
    }

    public CommandFuture<Void> uploadFileDirect(byte[] data, String filePath, boolean overwrite, int channelId, String channelPassword) {
        return this.uploadFile(new ByteArrayInputStream(data), data.length, filePath, overwrite, channelId, channelPassword);
    }

    public CommandFuture<Long> uploadIcon(InputStream dataIn, long dataLength) {
        byte[] data;
        FileTransferHelper helper = this.query.getFileTransferHelper();
        try {
            data = helper.readFully(dataIn, dataLength);
        }
        catch (IOException e) {
            throw new TS3FileTransferFailedException("Reading stream failed", e);
        }
        return this.uploadIconDirect(data);
    }

    public CommandFuture<Long> uploadIconDirect(byte[] data) {
        FileTransferHelper helper = this.query.getFileTransferHelper();
        CommandFuture<Long> future = new CommandFuture<Long>();
        long iconId = helper.getIconId(data);
        String path = "/icon_" + iconId;
        this.uploadFileDirect(data, path, false, 0).onSuccess(__ -> future.set(iconId)).onFailure(TS3ApiAsync.transformError(future, 2050, iconId));
        return future;
    }

    public CommandFuture<Void> usePrivilegeKey(String token) {
        Command cmd = PrivilegeKeyCommands.privilegeKeyUse(token);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> usePrivilegeKey(PrivilegeKey privilegeKey) {
        return this.usePrivilegeKey(privilegeKey.getToken());
    }

    public CommandFuture<ServerQueryInfo> whoAmI() {
        Command cmd = QueryCommands.whoAmI();
        return this.executeAndTransformFirst(cmd, ServerQueryInfo::new);
    }

    private static boolean isQueryError(TS3Exception exception, int errorId) {
        if (exception instanceof TS3CommandFailedException) {
            TS3CommandFailedException cfe = (TS3CommandFailedException)exception;
            return cfe.getError().getId() == errorId;
        }
        return false;
    }

    private static <T> CommandFuture.FailureListener transformError(CommandFuture<T> future, int errorId, T replacement) {
        return exception -> {
            if (TS3ApiAsync.isQueryError(exception, errorId)) {
                future.set(replacement);
            } else {
                future.fail(exception);
            }
        };
    }

    private CommandFuture<Void> executeAndReturnError(Command command) {
        CommandFuture<Void> future = command.getFuture().map(__ -> null);
        this.query.doCommandAsync(command);
        return future;
    }

    private CommandFuture<String> executeAndReturnStringProperty(Command command, String property) {
        CommandFuture<String> future = command.getFuture().map(result -> result.getFirstResponse().get(property));
        this.query.doCommandAsync(command);
        return future;
    }

    private CommandFuture<Integer> executeAndReturnIntProperty(Command command, String property) {
        CommandFuture<Integer> future = command.getFuture().map(result -> result.getFirstResponse().getInt(property));
        this.query.doCommandAsync(command);
        return future;
    }

    private CommandFuture<int[]> executeAndReturnIntArray(Command command, String property) {
        CommandFuture<int[]> future = command.getFuture().map(result -> {
            List<Wrapper> responses = result.getResponses();
            int[] values = new int[responses.size()];
            int i = 0;
            for (Wrapper response : responses) {
                values[i++] = response.getInt(property);
            }
            return values;
        });
        this.query.doCommandAsync(command);
        return future;
    }

    private <T extends Wrapper> CommandFuture<T> executeAndTransformFirst(Command command, Function<Map<String, String>, T> fn) {
        return this.executeAndMapFirst(command, wrapper -> (Wrapper)fn.apply(wrapper.getMap()));
    }

    private <T> CommandFuture<T> executeAndMapFirst(Command command, Function<Wrapper, T> fn) {
        CommandFuture<Object> future = command.getFuture().map(result -> fn.apply(result.getFirstResponse()));
        this.query.doCommandAsync(command);
        return future;
    }

    private <T extends Wrapper> CommandFuture<List<T>> executeAndTransform(Command command, Function<Map<String, String>, T> fn) {
        return this.executeAndMap(command, wrapper -> (Wrapper)fn.apply(wrapper.getMap()));
    }

    private <T> CommandFuture<List<T>> executeAndMap(Command command, Function<Wrapper, T> fn) {
        CommandFuture<List<T>> future = command.getFuture().map(result -> {
            List<Wrapper> response = result.getResponses();
            ArrayList transformed = new ArrayList(response.size());
            for (Wrapper wrapper : response) {
                transformed.add(fn.apply(wrapper));
            }
            return transformed;
        });
        this.query.doCommandAsync(command);
        return future;
    }

    private static <K, V> CommandFuture<List<V>> findByKey(CommandFuture<List<K>> keysFuture, CommandFuture<List<V>> valuesFuture, Function<? super V, ? extends K> keyMapper) {
        CommandFuture future = new CommandFuture();
        keysFuture.onSuccess(keys -> valuesFuture.onSuccess(values -> {
            Map valueMap = values.stream().collect(Collectors.toMap(keyMapper, Function.identity(), (l, r) -> l));
            ArrayList foundValues = new ArrayList(keys.size());
            for (Object key : keys) {
                Object value;
                if (key == null || (value = valueMap.get(key)) == null) continue;
                foundValues.add(value);
            }
            future.set(foundValues);
        }).forwardFailure(future)).forwardFailure(future);
        return future;
    }
}

