/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3.commands.parameter;

import com.github.theholywaffle.teamspeak3.commands.CommandEncoding;
import com.github.theholywaffle.teamspeak3.commands.parameter.Parameter;

public class KeyValueParam
extends Parameter {
    private final String key;
    private final String value;

    public KeyValueParam(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Key was null");
        }
        this.key = key;
        this.value = value != null ? value : "";
    }

    public KeyValueParam(String key, int value) {
        this(key, String.valueOf(value));
    }

    public KeyValueParam(String key, long value) {
        this(key, String.valueOf(value));
    }

    public KeyValueParam(String key, boolean value) {
        this(key, value ? "1" : "0");
    }

    @Override
    public void appendTo(StringBuilder str) {
        str.append(CommandEncoding.encode(this.key));
        str.append('=');
        str.append(CommandEncoding.encode(this.value));
    }
}

