/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3.commands;

import com.github.theholywaffle.teamspeak3.api.event.TS3EventType;
import com.github.theholywaffle.teamspeak3.commands.Command;
import com.github.theholywaffle.teamspeak3.commands.CommandBuilder;
import com.github.theholywaffle.teamspeak3.commands.parameter.KeyValueParam;
import com.github.theholywaffle.teamspeak3.commands.parameter.ValueParam;

public final class QueryCommands {
    private QueryCommands() {
        throw new Error("No instances");
    }

    public static Command logIn(String username, String password) {
        if (username == null || username.isEmpty()) {
            throw new IllegalArgumentException("Username must be a non-empty string");
        }
        if (password == null || password.isEmpty()) {
            throw new IllegalArgumentException("Password must be a non-empty string");
        }
        return new CommandBuilder("login", 2).add(new ValueParam(username)).add(new ValueParam(password)).build();
    }

    public static Command logOut() {
        return new CommandBuilder("logout").build();
    }

    public static Command quit() {
        return new CommandBuilder("quit").build();
    }

    public static Command serverNotifyRegister(TS3EventType eventType, int channelId) {
        if (eventType == null) {
            throw new IllegalArgumentException("Event type cannot be null");
        }
        CommandBuilder builder = new CommandBuilder("servernotifyregister", 2);
        builder.add(new KeyValueParam("event", eventType.toString()));
        builder.addIf(channelId >= 0, new KeyValueParam("id", channelId));
        return builder.build();
    }

    public static Command serverNotifyUnregister() {
        return new CommandBuilder("servernotifyunregister").build();
    }

    public static Command useId(int id) {
        return new CommandBuilder("use", 1).add(new KeyValueParam("sid", id)).build();
    }

    public static Command usePort(int port) {
        return new CommandBuilder("use", 1).add(new KeyValueParam("port", port)).build();
    }

    public static Command whoAmI() {
        return new CommandBuilder("whoami").build();
    }
}

