/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3.api.exception;

import com.github.theholywaffle.teamspeak3.api.exception.TS3Exception;
import com.github.theholywaffle.teamspeak3.api.wrapper.QueryError;

public class TS3CommandFailedException
extends TS3Exception {
    private static final long serialVersionUID = 8179203326662268882L;
    private final QueryError queryError;

    public TS3CommandFailedException(QueryError error) {
        super(TS3CommandFailedException.buildMessage(error));
        this.queryError = error;
    }

    private static String buildMessage(QueryError error) {
        int failedPermissionId;
        StringBuilder msg = new StringBuilder("A command returned with a server error.\n");
        msg.append(">> ").append(error.getMessage()).append(" (ID ").append(error.getId()).append(')');
        String extra = error.getExtraMessage();
        if (extra != null && !extra.isEmpty()) {
            msg.append(": ").append(extra);
        }
        if ((failedPermissionId = error.getFailedPermissionId()) > 0) {
            msg.append(", failed permission with ID ").append(failedPermissionId);
        }
        return msg.toString();
    }

    public QueryError getError() {
        return this.queryError;
    }
}

