/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.FileTransferHelper;
import com.github.theholywaffle.teamspeak3.TS3Query;
import com.github.theholywaffle.teamspeak3.api.ChannelProperty;
import com.github.theholywaffle.teamspeak3.api.ClientProperty;
import com.github.theholywaffle.teamspeak3.api.CommandFuture;
import com.github.theholywaffle.teamspeak3.api.PermissionGroupDatabaseType;
import com.github.theholywaffle.teamspeak3.api.PrivilegeKeyType;
import com.github.theholywaffle.teamspeak3.api.ReasonIdentifier;
import com.github.theholywaffle.teamspeak3.api.ServerGroupType;
import com.github.theholywaffle.teamspeak3.api.ServerInstanceProperty;
import com.github.theholywaffle.teamspeak3.api.Snapshot;
import com.github.theholywaffle.teamspeak3.api.TextMessageTargetMode;
import com.github.theholywaffle.teamspeak3.api.VirtualServerProperty;
import com.github.theholywaffle.teamspeak3.api.event.TS3EventType;
import com.github.theholywaffle.teamspeak3.api.event.TS3Listener;
import com.github.theholywaffle.teamspeak3.api.exception.TS3CommandFailedException;
import com.github.theholywaffle.teamspeak3.api.exception.TS3Exception;
import com.github.theholywaffle.teamspeak3.api.exception.TS3FileTransferFailedException;
import com.github.theholywaffle.teamspeak3.api.wrapper.Ban;
import com.github.theholywaffle.teamspeak3.api.wrapper.Binding;
import com.github.theholywaffle.teamspeak3.api.wrapper.Channel;
import com.github.theholywaffle.teamspeak3.api.wrapper.ChannelBase;
import com.github.theholywaffle.teamspeak3.api.wrapper.ChannelGroup;
import com.github.theholywaffle.teamspeak3.api.wrapper.ChannelGroupClient;
import com.github.theholywaffle.teamspeak3.api.wrapper.ChannelInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.Client;
import com.github.theholywaffle.teamspeak3.api.wrapper.ClientInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.Complaint;
import com.github.theholywaffle.teamspeak3.api.wrapper.ConnectionInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.CreatedVirtualServer;
import com.github.theholywaffle.teamspeak3.api.wrapper.DatabaseClient;
import com.github.theholywaffle.teamspeak3.api.wrapper.DatabaseClientInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.FileInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.FileListEntry;
import com.github.theholywaffle.teamspeak3.api.wrapper.FileTransfer;
import com.github.theholywaffle.teamspeak3.api.wrapper.FileTransferParameters;
import com.github.theholywaffle.teamspeak3.api.wrapper.HostInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.IconFile;
import com.github.theholywaffle.teamspeak3.api.wrapper.InstanceInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.Message;
import com.github.theholywaffle.teamspeak3.api.wrapper.Permission;
import com.github.theholywaffle.teamspeak3.api.wrapper.PermissionAssignment;
import com.github.theholywaffle.teamspeak3.api.wrapper.PermissionInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.PrivilegeKey;
import com.github.theholywaffle.teamspeak3.api.wrapper.QueryError;
import com.github.theholywaffle.teamspeak3.api.wrapper.ServerGroup;
import com.github.theholywaffle.teamspeak3.api.wrapper.ServerGroupClient;
import com.github.theholywaffle.teamspeak3.api.wrapper.ServerQueryInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.Version;
import com.github.theholywaffle.teamspeak3.api.wrapper.VirtualServer;
import com.github.theholywaffle.teamspeak3.api.wrapper.VirtualServerInfo;
import com.github.theholywaffle.teamspeak3.api.wrapper.Wrapper;
import com.github.theholywaffle.teamspeak3.commands.BanCommands;
import com.github.theholywaffle.teamspeak3.commands.ChannelCommands;
import com.github.theholywaffle.teamspeak3.commands.ChannelGroupCommands;
import com.github.theholywaffle.teamspeak3.commands.ClientCommands;
import com.github.theholywaffle.teamspeak3.commands.Command;
import com.github.theholywaffle.teamspeak3.commands.ComplaintCommands;
import com.github.theholywaffle.teamspeak3.commands.DatabaseClientCommands;
import com.github.theholywaffle.teamspeak3.commands.FileCommands;
import com.github.theholywaffle.teamspeak3.commands.MessageCommands;
import com.github.theholywaffle.teamspeak3.commands.PermissionCommands;
import com.github.theholywaffle.teamspeak3.commands.PrivilegeKeyCommands;
import com.github.theholywaffle.teamspeak3.commands.QueryCommands;
import com.github.theholywaffle.teamspeak3.commands.ServerCommands;
import com.github.theholywaffle.teamspeak3.commands.ServerGroupCommands;
import com.github.theholywaffle.teamspeak3.commands.VirtualServerCommands;
import com.github.theholywaffle.teamspeak3.commands.response.DefaultArrayResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TS3ApiAsync {
    private final TS3Query query;

    public TS3ApiAsync(TS3Query query) {
        this.query = query;
    }

    public CommandFuture<Integer> addBan(String ip, String name, String uid, long timeInSeconds, String reason) {
        Command cmd = BanCommands.banAdd(ip, name, uid, timeInSeconds, reason);
        return this.executeAndReturnIntProperty(cmd, "banid");
    }

    public CommandFuture<Void> addChannelClientPermission(int channelId, int clientDBId, String permName, int permValue) {
        Command cmd = PermissionCommands.channelClientAddPerm(channelId, clientDBId, permName, permValue);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Integer> addChannelGroup(String name) {
        return this.addChannelGroup(name, null);
    }

    public CommandFuture<Integer> addChannelGroup(String name, PermissionGroupDatabaseType type) {
        Command cmd = ChannelGroupCommands.channelGroupAdd(name, type);
        return this.executeAndReturnIntProperty(cmd, "cgid");
    }

    public CommandFuture<Void> addChannelGroupPermission(int groupId, String permName, int permValue) {
        Command cmd = PermissionCommands.channelGroupAddPerm(groupId, permName, permValue);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> addChannelPermission(int channelId, String permName, int permValue) {
        Command cmd = PermissionCommands.channelAddPerm(channelId, permName, permValue);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> addClientPermission(int clientDBId, String permName, int value, boolean skipped) {
        Command cmd = PermissionCommands.clientAddPerm(clientDBId, permName, value, skipped);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> addClientToServerGroup(int groupId, int clientDatabaseId) {
        Command cmd = ServerGroupCommands.serverGroupAddClient(groupId, clientDatabaseId);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> addComplaint(int clientDBId, String message) {
        Command cmd = ComplaintCommands.complainAdd(clientDBId, message);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> addPermissionToAllServerGroups(ServerGroupType type, String permName, int value, boolean negated, boolean skipped) {
        Command cmd = PermissionCommands.serverGroupAutoAddPerm(type, permName, value, negated, skipped);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<String> addPrivilegeKey(PrivilegeKeyType type, int groupId, int channelId, String description) {
        Command cmd = PrivilegeKeyCommands.privilegeKeyAdd(type, groupId, channelId, description);
        return this.executeAndReturnStringProperty(cmd, "token");
    }

    public CommandFuture<String> addPrivilegeKeyChannelGroup(int channelGroupId, int channelId, String description) {
        return this.addPrivilegeKey(PrivilegeKeyType.CHANNEL_GROUP, channelGroupId, channelId, description);
    }

    public CommandFuture<String> addPrivilegeKeyServerGroup(int serverGroupId, String description) {
        return this.addPrivilegeKey(PrivilegeKeyType.SERVER_GROUP, serverGroupId, 0, description);
    }

    public CommandFuture<Integer> addServerGroup(String name) {
        return this.addServerGroup(name, PermissionGroupDatabaseType.REGULAR);
    }

    public CommandFuture<Integer> addServerGroup(String name, PermissionGroupDatabaseType type) {
        Command cmd = ServerGroupCommands.serverGroupAdd(name, type);
        return this.executeAndReturnIntProperty(cmd, "sgid");
    }

    public CommandFuture<Void> addServerGroupPermission(int groupId, String permName, int value, boolean negated, boolean skipped) {
        Command cmd = PermissionCommands.serverGroupAddPerm(groupId, permName, value, negated, skipped);
        return this.executeAndReturnError(cmd);
    }

    public void addTS3Listeners(TS3Listener ... listeners) {
        this.query.getEventManager().addListeners(listeners);
    }

    public CommandFuture<int[]> banClient(int clientId, long timeInSeconds) {
        return this.banClient(clientId, timeInSeconds, null);
    }

    public CommandFuture<int[]> banClient(int clientId, long timeInSeconds, String reason) {
        Command cmd = BanCommands.banClient(clientId, timeInSeconds, reason);
        final CommandFuture<int[]> future = new CommandFuture<int[]>();
        cmd.getFuture().onSuccess(new CommandFuture.SuccessListener<DefaultArrayResponse>(){

            @Override
            public void handleSuccess(DefaultArrayResponse result) {
                List<Wrapper> response = result.getResponses();
                int[] banIds = new int[response.size()];
                for (int i = 0; i < banIds.length; ++i) {
                    banIds[i] = response.get(i).getInt("banid");
                }
                future.set(banIds);
            }
        }).forwardFailure(future);
        this.query.doCommandAsync(cmd);
        return future;
    }

    public CommandFuture<int[]> banClient(int clientId, String reason) {
        return this.banClient(clientId, 0L, reason);
    }

    public CommandFuture<Void> broadcast(String message) {
        Command cmd = ServerCommands.gm(message);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> copyChannelGroup(int sourceGroupId, int targetGroupId, PermissionGroupDatabaseType type) {
        if (targetGroupId <= 0) {
            throw new IllegalArgumentException("To create a new channel group, use the method with a String argument");
        }
        Command cmd = ChannelGroupCommands.channelGroupCopy(sourceGroupId, targetGroupId, type);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Integer> copyChannelGroup(int sourceGroupId, String targetName, PermissionGroupDatabaseType type) {
        Command cmd = ChannelGroupCommands.channelGroupCopy(sourceGroupId, targetName, type);
        return this.executeAndReturnIntProperty(cmd, "cgid");
    }

    public CommandFuture<Integer> copyServerGroup(int sourceGroupId, int targetGroupId, PermissionGroupDatabaseType type) {
        if (targetGroupId <= 0) {
            throw new IllegalArgumentException("To create a new server group, use the method with a String argument");
        }
        Command cmd = ServerGroupCommands.serverGroupCopy(sourceGroupId, targetGroupId, type);
        return this.executeAndReturnIntProperty(cmd, "sgid");
    }

    public CommandFuture<Integer> copyServerGroup(int sourceGroupId, String targetName, PermissionGroupDatabaseType type) {
        Command cmd = ServerGroupCommands.serverGroupCopy(sourceGroupId, targetName, type);
        return this.executeAndReturnIntProperty(cmd, "sgid");
    }

    public CommandFuture<Integer> createChannel(String name, Map<ChannelProperty, String> options) {
        Command cmd = ChannelCommands.channelCreate(name, options);
        return this.executeAndReturnIntProperty(cmd, "cid");
    }

    public CommandFuture<Void> createFileDirectory(String directoryPath, int channelId) {
        return this.createFileDirectory(directoryPath, channelId, null);
    }

    public CommandFuture<Void> createFileDirectory(String directoryPath, int channelId, String channelPassword) {
        Command cmd = FileCommands.ftCreateDir(directoryPath, channelId, channelPassword);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<CreatedVirtualServer> createServer(String name, Map<VirtualServerProperty, String> options) {
        Command cmd = VirtualServerCommands.serverCreate(name, options);
        return this.executeAndTransformFirst(cmd, Transformer.CREATED_VIRTUAL_SERVER);
    }

    public CommandFuture<Snapshot> createServerSnapshot() {
        Command cmd = VirtualServerCommands.serverSnapshotCreate();
        final CommandFuture<Snapshot> future = new CommandFuture<Snapshot>();
        cmd.getFuture().onSuccess(new CommandFuture.SuccessListener<DefaultArrayResponse>(){

            @Override
            public void handleSuccess(DefaultArrayResponse result) {
                future.set(new Snapshot(result.getRawResponse()));
            }
        }).forwardFailure(future);
        this.query.doCommandAsync(cmd);
        return future;
    }

    public CommandFuture<Void> deleteAllBans() {
        Command cmd = BanCommands.banDelAll();
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteAllComplaints(int clientDBId) {
        Command cmd = ComplaintCommands.complainDelAll(clientDBId);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteBan(int banId) {
        Command cmd = BanCommands.banDel(banId);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteChannel(int channelId) {
        return this.deleteChannel(channelId, true);
    }

    public CommandFuture<Void> deleteChannel(int channelId, boolean force) {
        Command cmd = ChannelCommands.channelDelete(channelId, force);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteChannelClientPermission(int channelId, int clientDBId, String permName) {
        Command cmd = PermissionCommands.channelClientDelPerm(channelId, clientDBId, permName);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteChannelGroup(int groupId) {
        return this.deleteChannelGroup(groupId, true);
    }

    public CommandFuture<Void> deleteChannelGroup(int groupId, boolean force) {
        Command cmd = ChannelGroupCommands.channelGroupDel(groupId, force);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteChannelGroupPermission(int groupId, String permName) {
        Command cmd = PermissionCommands.channelGroupDelPerm(groupId, permName);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteChannelPermission(int channelId, String permName) {
        Command cmd = PermissionCommands.channelDelPerm(channelId, permName);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteClientPermission(int clientDBId, String permName) {
        Command cmd = PermissionCommands.clientDelPerm(clientDBId, permName);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteComplaint(int targetClientDBId, int fromClientDBId) {
        Command cmd = ComplaintCommands.complainDel(targetClientDBId, fromClientDBId);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteDatabaseClientProperties(int clientDBId) {
        Command cmd = DatabaseClientCommands.clientDBDelete(clientDBId);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteFile(String filePath, int channelId) {
        return this.deleteFile(filePath, channelId, null);
    }

    public CommandFuture<Void> deleteFile(String filePath, int channelId, String channelPassword) {
        Command cmd = FileCommands.ftDeleteFile(channelId, channelPassword, filePath);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteFiles(String[] filePaths, int channelId) {
        return this.deleteFiles(filePaths, channelId, null);
    }

    public CommandFuture<Void> deleteFiles(String[] filePaths, int channelId, String channelPassword) {
        Command cmd = FileCommands.ftDeleteFile(channelId, channelPassword, filePaths);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteIcon(long iconId) {
        String iconPath = "/icon_" + iconId;
        return this.deleteFile(iconPath, 0);
    }

    public CommandFuture<Void> deleteIcons(long ... iconIds) {
        String[] iconPaths = new String[iconIds.length];
        for (int i = 0; i < iconIds.length; ++i) {
            iconPaths[i] = "/icon_" + iconIds[i];
        }
        return this.deleteFiles(iconPaths, 0);
    }

    public CommandFuture<Void> deleteOfflineMessage(int messageId) {
        Command cmd = MessageCommands.messageDel(messageId);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deletePermissionFromAllServerGroups(ServerGroupType type, String permName) {
        Command cmd = PermissionCommands.serverGroupAutoDelPerm(type, permName);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deletePrivilegeKey(String token) {
        Command cmd = PrivilegeKeyCommands.privilegeKeyDelete(token);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteServer(int serverId) {
        Command cmd = VirtualServerCommands.serverDelete(serverId);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteServerGroup(int groupId) {
        return this.deleteServerGroup(groupId, true);
    }

    public CommandFuture<Void> deleteServerGroup(int groupId, boolean force) {
        Command cmd = ServerGroupCommands.serverGroupDel(groupId, force);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deleteServerGroupPermission(int groupId, String permName) {
        Command cmd = PermissionCommands.serverGroupDelPerm(groupId, permName);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> deployServerSnapshot(Snapshot snapshot) {
        return this.deployServerSnapshot(snapshot.get());
    }

    public CommandFuture<Void> deployServerSnapshot(String snapshot) {
        Command cmd = VirtualServerCommands.serverSnapshotDeploy(snapshot);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Long> downloadFile(OutputStream dataOut, String filePath, int channelId) {
        return this.downloadFile(dataOut, filePath, channelId, null);
    }

    public CommandFuture<Long> downloadFile(final OutputStream dataOut, String filePath, int channelId, String channelPassword) {
        FileTransferHelper helper = this.query.getFileTransferHelper();
        int transferId = helper.getClientTransferId();
        Command cmd = FileCommands.ftInitDownload(transferId, filePath, channelId, channelPassword);
        final CommandFuture<Long> future = new CommandFuture<Long>();
        cmd.getFuture().onSuccess(new CommandFuture.SuccessListener<DefaultArrayResponse>(){

            @Override
            public void handleSuccess(DefaultArrayResponse result) {
                FileTransferParameters params = new FileTransferParameters(result.getFirstResponse().getMap());
                QueryError error = params.getQueryError();
                if (!error.isSuccessful()) {
                    future.fail(new TS3CommandFailedException(error));
                    return;
                }
                try {
                    TS3ApiAsync.this.query.getFileTransferHelper().downloadFile(dataOut, params);
                }
                catch (IOException e) {
                    future.fail(new TS3FileTransferFailedException("Download failed", e));
                    return;
                }
                future.set(params.getFileSize());
            }
        }).forwardFailure(future);
        this.query.doCommandAsync(cmd);
        return future;
    }

    public CommandFuture<byte[]> downloadFileDirect(String filePath, int channelId) {
        return this.downloadFileDirect(filePath, channelId, null);
    }

    public CommandFuture<byte[]> downloadFileDirect(String filePath, int channelId, String channelPassword) {
        FileTransferHelper helper = this.query.getFileTransferHelper();
        int transferId = helper.getClientTransferId();
        Command cmd = FileCommands.ftInitDownload(transferId, filePath, channelId, channelPassword);
        final CommandFuture<byte[]> future = new CommandFuture<byte[]>();
        cmd.getFuture().onSuccess(new CommandFuture.SuccessListener<DefaultArrayResponse>(){

            @Override
            public void handleSuccess(DefaultArrayResponse result) {
                FileTransferParameters params = new FileTransferParameters(result.getFirstResponse().getMap());
                QueryError error = params.getQueryError();
                if (!error.isSuccessful()) {
                    future.fail(new TS3CommandFailedException(error));
                    return;
                }
                long fileSize = params.getFileSize();
                if (fileSize > Integer.MAX_VALUE) {
                    future.fail(new TS3FileTransferFailedException("File too big for byte array"));
                    return;
                }
                ByteArrayOutputStream dataOut = new ByteArrayOutputStream((int)fileSize);
                try {
                    TS3ApiAsync.this.query.getFileTransferHelper().downloadFile(dataOut, params);
                }
                catch (IOException e) {
                    future.fail(new TS3FileTransferFailedException("Download failed", e));
                    return;
                }
                future.set(dataOut.toByteArray());
            }
        }).forwardFailure(future);
        this.query.doCommandAsync(cmd);
        return future;
    }

    public CommandFuture<Long> downloadIcon(OutputStream dataOut, long iconId) {
        String iconPath = "/icon_" + iconId;
        return this.downloadFile(dataOut, iconPath, 0);
    }

    public CommandFuture<byte[]> downloadIconDirect(long iconId) {
        String iconPath = "/icon_" + iconId;
        return this.downloadFileDirect(iconPath, 0);
    }

    public CommandFuture<Void> editChannel(int channelId, Map<ChannelProperty, String> options) {
        Command cmd = ChannelCommands.channelEdit(channelId, options);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> editChannel(int channelId, ChannelProperty property, String value) {
        return this.editChannel(channelId, Collections.singletonMap(property, value));
    }

    public CommandFuture<Void> editClient(int clientId, Map<ClientProperty, String> options) {
        Command cmd = ClientCommands.clientEdit(clientId, options);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> editClient(int clientId, ClientProperty property, String value) {
        return this.editClient(clientId, Collections.singletonMap(property, value));
    }

    public CommandFuture<Void> editDatabaseClient(int clientDBId, Map<ClientProperty, String> options) {
        Command cmd = DatabaseClientCommands.clientDBEdit(clientDBId, options);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> editInstance(ServerInstanceProperty property, String value) {
        Command cmd = ServerCommands.instanceEdit(Collections.singletonMap(property, value));
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> editServer(Map<VirtualServerProperty, String> options) {
        Command cmd = VirtualServerCommands.serverEdit(options);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<List<Ban>> getBans() {
        Command cmd = BanCommands.banList();
        return this.executeAndTransform(cmd, Transformer.BAN);
    }

    public CommandFuture<List<Binding>> getBindings() {
        Command cmd = ServerCommands.bindingList();
        return this.executeAndTransform(cmd, Transformer.BINDING);
    }

    public CommandFuture<Channel> getChannelByNameExact(String name, final boolean ignoreCase) {
        final CommandFuture<Channel> future = new CommandFuture<Channel>();
        final String caseName = ignoreCase ? name.toLowerCase(Locale.ROOT) : name;
        this.getChannels().onSuccess(new CommandFuture.SuccessListener<List<Channel>>(){

            @Override
            public void handleSuccess(List<Channel> allChannels) {
                for (Channel c : allChannels) {
                    String channelName = ignoreCase ? c.getName().toLowerCase(Locale.ROOT) : c.getName();
                    if (!caseName.equals(channelName)) continue;
                    future.set(c);
                    return;
                }
                future.set(null);
            }
        }).forwardFailure(future);
        return future;
    }

    public CommandFuture<List<Channel>> getChannelsByName(String name) {
        Command cmd = ChannelCommands.channelFind(name);
        final CommandFuture<List<Channel>> future = new CommandFuture<List<Channel>>();
        cmd.getFuture().onSuccess(new CommandFuture.SuccessListener<DefaultArrayResponse>(){

            @Override
            public void handleSuccess(final DefaultArrayResponse result) {
                TS3ApiAsync.this.getChannels().onSuccess(new CommandFuture.SuccessListener<List<Channel>>(){

                    @Override
                    public void handleSuccess(List<Channel> allChannels) {
                        List<Wrapper> responses = result.getResponses();
                        ArrayList<Channel> channels = new ArrayList<Channel>(responses.size());
                        block0: for (Wrapper response : responses) {
                            int channelId = response.getInt("cid");
                            for (Channel c : allChannels) {
                                if (c.getId() != channelId) continue;
                                channels.add(c);
                                continue block0;
                            }
                        }
                        future.set(channels);
                    }
                }).forwardFailure(future);
            }
        }).onFailure(TS3ApiAsync.transformError(future, 768, Collections.emptyList()));
        this.query.doCommandAsync(cmd);
        return future;
    }

    public CommandFuture<List<Permission>> getChannelClientPermissions(int channelId, int clientDBId) {
        Command cmd = PermissionCommands.channelClientPermList(channelId, clientDBId);
        return this.executeAndTransform(cmd, Transformer.PERMISSION);
    }

    public CommandFuture<List<ChannelGroupClient>> getChannelGroupClients(int channelId, int clientDBId, int groupId) {
        Command cmd = ChannelGroupCommands.channelGroupClientList(channelId, clientDBId, groupId);
        return this.executeAndTransform(cmd, Transformer.CHANNEL_GROUP_CLIENT);
    }

    public CommandFuture<List<ChannelGroupClient>> getChannelGroupClientsByChannelGroupId(int groupId) {
        return this.getChannelGroupClients(-1, -1, groupId);
    }

    public CommandFuture<List<ChannelGroupClient>> getChannelGroupClientsByChannelId(int channelId) {
        return this.getChannelGroupClients(channelId, -1, -1);
    }

    public CommandFuture<List<ChannelGroupClient>> getChannelGroupClientsByClientDBId(int clientDBId) {
        return this.getChannelGroupClients(-1, clientDBId, -1);
    }

    public CommandFuture<List<Permission>> getChannelGroupPermissions(int groupId) {
        Command cmd = PermissionCommands.channelGroupPermList(groupId);
        return this.executeAndTransform(cmd, Transformer.PERMISSION);
    }

    public CommandFuture<List<ChannelGroup>> getChannelGroups() {
        Command cmd = ChannelGroupCommands.channelGroupList();
        return this.executeAndTransform(cmd, Transformer.CHANNEL_GROUP);
    }

    public CommandFuture<ChannelInfo> getChannelInfo(final int channelId) {
        Command cmd = ChannelCommands.channelInfo(channelId);
        final CommandFuture<ChannelInfo> future = new CommandFuture<ChannelInfo>();
        cmd.getFuture().onSuccess(new CommandFuture.SuccessListener<DefaultArrayResponse>(){

            @Override
            public void handleSuccess(DefaultArrayResponse result) {
                future.set(new ChannelInfo(channelId, result.getFirstResponse().getMap()));
            }
        }).forwardFailure(future);
        this.query.doCommandAsync(cmd);
        return future;
    }

    public CommandFuture<List<Permission>> getChannelPermissions(int channelId) {
        Command cmd = PermissionCommands.channelPermList(channelId);
        return this.executeAndTransform(cmd, Transformer.PERMISSION);
    }

    public CommandFuture<List<Channel>> getChannels() {
        Command cmd = ChannelCommands.channelList();
        return this.executeAndTransform(cmd, Transformer.CHANNEL);
    }

    public CommandFuture<Client> getClientByNameExact(String name, final boolean ignoreCase) {
        final CommandFuture<Client> future = new CommandFuture<Client>();
        final String caseName = ignoreCase ? name.toLowerCase(Locale.ROOT) : name;
        this.getClients().onSuccess(new CommandFuture.SuccessListener<List<Client>>(){

            @Override
            public void handleSuccess(List<Client> allClients) {
                for (Client c : allClients) {
                    String clientName = ignoreCase ? c.getNickname().toLowerCase(Locale.ROOT) : c.getNickname();
                    if (!caseName.equals(clientName)) continue;
                    future.set(c);
                    return;
                }
                future.set(null);
            }
        }).forwardFailure(future);
        return future;
    }

    public CommandFuture<List<Client>> getClientsByName(String name) {
        Command cmd = ClientCommands.clientFind(name);
        final CommandFuture<List<Client>> future = new CommandFuture<List<Client>>();
        cmd.getFuture().onSuccess(new CommandFuture.SuccessListener<DefaultArrayResponse>(){

            @Override
            public void handleSuccess(final DefaultArrayResponse result) {
                TS3ApiAsync.this.getClients().onSuccess(new CommandFuture.SuccessListener<List<Client>>(){

                    @Override
                    public void handleSuccess(List<Client> allClients) {
                        List<Wrapper> responses = result.getResponses();
                        ArrayList<Client> clients = new ArrayList<Client>(responses.size());
                        block0: for (Wrapper response : responses) {
                            for (Client c : allClients) {
                                if (c.getId() != response.getInt("clid")) continue;
                                clients.add(c);
                                continue block0;
                            }
                        }
                        future.set(clients);
                    }
                }).forwardFailure(future);
            }
        }).onFailure(TS3ApiAsync.transformError(future, 512, Collections.emptyList()));
        this.query.doCommandAsync(cmd);
        return future;
    }

    public CommandFuture<ClientInfo> getClientByUId(String clientUId) {
        Command cmd = ClientCommands.clientGetIds(clientUId);
        final CommandFuture<ClientInfo> future = new CommandFuture<ClientInfo>();
        cmd.getFuture().onSuccess(new CommandFuture.SuccessListener<DefaultArrayResponse>(){

            @Override
            public void handleSuccess(DefaultArrayResponse result) {
                int clientId = result.getFirstResponse().getInt("clid");
                TS3ApiAsync.this.getClientInfo(clientId).forwardResult(future);
            }
        }).forwardFailure(future);
        this.query.doCommandAsync(cmd);
        return future;
    }

    public CommandFuture<ClientInfo> getClientInfo(final int clientId) {
        Command cmd = ClientCommands.clientInfo(clientId);
        final CommandFuture<ClientInfo> future = new CommandFuture<ClientInfo>();
        cmd.getFuture().onSuccess(new CommandFuture.SuccessListener<DefaultArrayResponse>(){

            @Override
            public void handleSuccess(DefaultArrayResponse result) {
                future.set(new ClientInfo(clientId, result.getFirstResponse().getMap()));
            }
        }).forwardFailure(future);
        this.query.doCommandAsync(cmd);
        return future;
    }

    public CommandFuture<List<Permission>> getClientPermissions(int clientDBId) {
        Command cmd = PermissionCommands.clientPermList(clientDBId);
        return this.executeAndTransform(cmd, Transformer.PERMISSION);
    }

    public CommandFuture<List<Client>> getClients() {
        Command cmd = ClientCommands.clientList();
        return this.executeAndTransform(cmd, Transformer.CLIENT);
    }

    public CommandFuture<List<Complaint>> getComplaints() {
        return this.getComplaints(-1);
    }

    public CommandFuture<List<Complaint>> getComplaints(int clientDBId) {
        Command cmd = ComplaintCommands.complainList(clientDBId);
        return this.executeAndTransform(cmd, Transformer.COMPLAINT);
    }

    public CommandFuture<ConnectionInfo> getConnectionInfo() {
        Command cmd = VirtualServerCommands.serverRequestConnectionInfo();
        return this.executeAndTransformFirst(cmd, Transformer.CONNECTION_INFO);
    }

    public CommandFuture<List<DatabaseClientInfo>> getDatabaseClientsByName(String name) {
        Command cmd = DatabaseClientCommands.clientDBFind(name, false);
        final CommandFuture<List<DatabaseClientInfo>> future = new CommandFuture<List<DatabaseClientInfo>>();
        cmd.getFuture().onSuccess(new CommandFuture.SuccessListener<DefaultArrayResponse>(){

            @Override
            public void handleSuccess(DefaultArrayResponse result) {
                List<Wrapper> responses = result.getResponses();
                ArrayList infoFutures = new ArrayList(responses.size());
                for (Wrapper response : responses) {
                    int databaseId = response.getInt("cldbid");
                    infoFutures.add(TS3ApiAsync.this.getDatabaseClientInfo(databaseId));
                }
                CommandFuture.ofAll(infoFutures).forwardResult(future);
            }
        }).forwardFailure(future);
        this.query.doCommandAsync(cmd);
        return future;
    }

    public CommandFuture<DatabaseClientInfo> getDatabaseClientByUId(String clientUId) {
        Command cmd = DatabaseClientCommands.clientDBFind(clientUId, true);
        final CommandFuture<DatabaseClientInfo> future = new CommandFuture<DatabaseClientInfo>();
        cmd.getFuture().onSuccess(new CommandFuture.SuccessListener<DefaultArrayResponse>(){

            @Override
            public void handleSuccess(DefaultArrayResponse result) {
                if (result.getResponses().isEmpty()) {
                    future.set(null);
                } else {
                    int databaseId = result.getFirstResponse().getInt("cldbid");
                    TS3ApiAsync.this.getDatabaseClientInfo(databaseId).forwardResult(future);
                }
            }
        }).forwardFailure(future);
        this.query.doCommandAsync(cmd);
        return future;
    }

    public CommandFuture<DatabaseClientInfo> getDatabaseClientInfo(int clientDBId) {
        Command cmd = DatabaseClientCommands.clientDBInfo(clientDBId);
        return this.executeAndTransformFirst(cmd, Transformer.DATABASE_CLIENT_INFO);
    }

    public CommandFuture<List<DatabaseClient>> getDatabaseClients() {
        Command cmd = DatabaseClientCommands.clientDBList(0, 1, true);
        final CommandFuture<List<DatabaseClient>> future = new CommandFuture<List<DatabaseClient>>();
        cmd.getFuture().onSuccess(new CommandFuture.SuccessListener<DefaultArrayResponse>(){

            @Override
            public void handleSuccess(DefaultArrayResponse result) {
                int count = result.getFirstResponse().getInt("count");
                int futuresCount = (count - 1) / 200 + 1;
                ArrayList futures = new ArrayList(futuresCount);
                for (int i = 0; i < count; i += 200) {
                    futures.add(TS3ApiAsync.this.getDatabaseClients(i, 200));
                }
                CommandFuture.ofAll(futures).onSuccess(new CommandFuture.SuccessListener<List<List<DatabaseClient>>>(){

                    @Override
                    public void handleSuccess(List<List<DatabaseClient>> result) {
                        int total = 0;
                        for (List<DatabaseClient> list : result) {
                            total += list.size();
                        }
                        ArrayList<DatabaseClient> combination = new ArrayList<DatabaseClient>(total);
                        for (List<DatabaseClient> list : result) {
                            combination.addAll(list);
                        }
                        future.set(combination);
                    }
                }).forwardFailure(future);
            }
        }).forwardFailure(future);
        this.query.doCommandAsync(cmd);
        return future;
    }

    public CommandFuture<List<DatabaseClient>> getDatabaseClients(int offset, int count) {
        Command cmd = DatabaseClientCommands.clientDBList(offset, count, false);
        return this.executeAndTransform(cmd, Transformer.DATABASE_CLIENT);
    }

    public CommandFuture<FileInfo> getFileInfo(String filePath, int channelId) {
        return this.getFileInfo(filePath, channelId, null);
    }

    public CommandFuture<FileInfo> getFileInfo(String filePath, int channelId, String channelPassword) {
        Command cmd = FileCommands.ftGetFileInfo(channelId, channelPassword, filePath);
        return this.executeAndTransformFirst(cmd, Transformer.FILE_INFO);
    }

    public CommandFuture<List<FileInfo>> getFileInfos(String[] filePaths, int channelId) {
        return this.getFileInfos(filePaths, channelId, null);
    }

    public CommandFuture<List<FileInfo>> getFileInfos(String[] filePaths, int channelId, String channelPassword) {
        Command cmd = FileCommands.ftGetFileInfo(channelId, channelPassword, filePaths);
        return this.executeAndTransform(cmd, Transformer.FILE_INFO);
    }

    public CommandFuture<List<FileInfo>> getFileInfos(String[] filePaths, int[] channelIds, String[] channelPasswords) {
        Command cmd = FileCommands.ftGetFileInfo(channelIds, channelPasswords, filePaths);
        return this.executeAndTransform(cmd, Transformer.FILE_INFO);
    }

    public CommandFuture<List<FileListEntry>> getFileList(String directoryPath, int channelId) {
        return this.getFileList(directoryPath, channelId, null);
    }

    public CommandFuture<List<FileListEntry>> getFileList(String directoryPath, int channelId, String channelPassword) {
        Command cmd = FileCommands.ftGetFileList(directoryPath, channelId, channelPassword);
        return this.executeAndTransform(cmd, Transformer.FILE_LIST_ENTRY);
    }

    public CommandFuture<List<FileTransfer>> getFileTransfers() {
        Command cmd = FileCommands.ftList();
        return this.executeAndTransform(cmd, Transformer.FILE_TRANSFER);
    }

    public CommandFuture<HostInfo> getHostInfo() {
        Command cmd = ServerCommands.hostInfo();
        return this.executeAndTransformFirst(cmd, Transformer.HOST_INFO);
    }

    public CommandFuture<List<IconFile>> getIconList() {
        final CommandFuture<List<IconFile>> future = new CommandFuture<List<IconFile>>();
        this.getFileList("/icons/", 0).onSuccess(new CommandFuture.SuccessListener<List<FileListEntry>>(){

            @Override
            public void handleSuccess(List<FileListEntry> result) {
                ArrayList<IconFile> icons = new ArrayList<IconFile>(result.size());
                for (FileListEntry file : result) {
                    if (file.isDirectory() || file.isStillUploading()) continue;
                    icons.add(new IconFile(file.getMap()));
                }
                future.set(icons);
            }
        }).forwardFailure(future);
        return future;
    }

    public CommandFuture<InstanceInfo> getInstanceInfo() {
        Command cmd = ServerCommands.instanceInfo();
        return this.executeAndTransformFirst(cmd, Transformer.INSTANCE_INFO);
    }

    public CommandFuture<List<String>> getInstanceLogEntries(int lines) {
        Command cmd = ServerCommands.logView(lines, true);
        return this.executeAndReturnLogLines(cmd);
    }

    public CommandFuture<List<String>> getInstanceLogEntries() {
        return this.getInstanceLogEntries(100);
    }

    public CommandFuture<String> getOfflineMessage(int messageId) {
        Command cmd = MessageCommands.messageGet(messageId);
        return this.executeAndReturnStringProperty(cmd, "message");
    }

    public CommandFuture<String> getOfflineMessage(Message message) {
        return this.getOfflineMessage(message.getId());
    }

    public CommandFuture<List<Message>> getOfflineMessages() {
        Command cmd = MessageCommands.messageList();
        return this.executeAndTransform(cmd, Transformer.MESSAGE);
    }

    public CommandFuture<List<PermissionAssignment>> getPermissionAssignments(String permName) {
        Command cmd = PermissionCommands.permFind(permName);
        CommandFuture<List<PermissionAssignment>> future = new CommandFuture<List<PermissionAssignment>>();
        this.executeAndTransform(cmd, Transformer.PERMISSION_ASSIGNMENT).forwardSuccess(future).onFailure(TS3ApiAsync.transformError(future, 2562, Collections.emptyList()));
        return future;
    }

    public CommandFuture<Integer> getPermissionIdByName(String permName) {
        Command cmd = PermissionCommands.permIdGetByName(permName);
        return this.executeAndReturnIntProperty(cmd, "permid");
    }

    public CommandFuture<int[]> getPermissionIdsByName(String ... permNames) {
        Command cmd = PermissionCommands.permIdGetByName(permNames);
        final CommandFuture<int[]> future = new CommandFuture<int[]>();
        cmd.getFuture().onSuccess(new CommandFuture.SuccessListener<DefaultArrayResponse>(){

            @Override
            public void handleSuccess(DefaultArrayResponse result) {
                List<Wrapper> responses = result.getResponses();
                int[] ids = new int[responses.size()];
                int i = 0;
                for (Wrapper response : responses) {
                    ids[i++] = response.getInt("permid");
                }
                future.set(ids);
            }
        }).forwardFailure(future);
        this.query.doCommandAsync(cmd);
        return future;
    }

    public CommandFuture<List<PermissionAssignment>> getPermissionOverview(int channelId, int clientDBId) {
        Command cmd = PermissionCommands.permOverview(channelId, clientDBId);
        return this.executeAndTransform(cmd, Transformer.PERMISSION_ASSIGNMENT);
    }

    public CommandFuture<List<PermissionInfo>> getPermissions() {
        Command cmd = PermissionCommands.permissionList();
        return this.executeAndTransform(cmd, Transformer.PERMISSION_INFO);
    }

    public CommandFuture<Integer> getPermissionValue(String permName) {
        Command cmd = PermissionCommands.permGet(permName);
        return this.executeAndReturnIntProperty(cmd, "permvalue");
    }

    public CommandFuture<int[]> getPermissionValues(String ... permNames) {
        Command cmd = PermissionCommands.permGet(permNames);
        final CommandFuture<int[]> future = new CommandFuture<int[]>();
        cmd.getFuture().onSuccess(new CommandFuture.SuccessListener<DefaultArrayResponse>(){

            @Override
            public void handleSuccess(DefaultArrayResponse result) {
                List<Wrapper> responses = result.getResponses();
                int[] values = new int[responses.size()];
                int i = 0;
                for (Wrapper response : responses) {
                    values[i++] = response.getInt("permvalue");
                }
                future.set(values);
            }
        }).forwardFailure(future);
        this.query.doCommandAsync(cmd);
        return future;
    }

    public CommandFuture<List<PrivilegeKey>> getPrivilegeKeys() {
        Command cmd = PrivilegeKeyCommands.privilegeKeyList();
        return this.executeAndTransform(cmd, Transformer.PRIVILEGE_KEY);
    }

    public CommandFuture<List<ServerGroupClient>> getServerGroupClients(int serverGroupId) {
        Command cmd = ServerGroupCommands.serverGroupClientList(serverGroupId);
        return this.executeAndTransform(cmd, Transformer.SERVER_GROUP_CLIENT);
    }

    public CommandFuture<List<ServerGroupClient>> getServerGroupClients(ServerGroup serverGroup) {
        return this.getServerGroupClients(serverGroup.getId());
    }

    public CommandFuture<List<Permission>> getServerGroupPermissions(int serverGroupId) {
        Command cmd = PermissionCommands.serverGroupPermList(serverGroupId);
        return this.executeAndTransform(cmd, Transformer.PERMISSION);
    }

    public CommandFuture<List<Permission>> getServerGroupPermissions(ServerGroup serverGroup) {
        return this.getServerGroupPermissions(serverGroup.getId());
    }

    public CommandFuture<List<ServerGroup>> getServerGroups() {
        Command cmd = ServerGroupCommands.serverGroupList();
        return this.executeAndTransform(cmd, Transformer.SERVER_GROUP);
    }

    public CommandFuture<List<ServerGroup>> getServerGroupsByClientId(int clientDatabaseId) {
        final Command cmd = ServerGroupCommands.serverGroupsByClientId(clientDatabaseId);
        final CommandFuture<List<ServerGroup>> future = new CommandFuture<List<ServerGroup>>();
        this.getServerGroups().onSuccess(new CommandFuture.SuccessListener<List<ServerGroup>>(){

            @Override
            public void handleSuccess(final List<ServerGroup> allServerGroups) {
                cmd.getFuture().onSuccess(new CommandFuture.SuccessListener<DefaultArrayResponse>(){

                    @Override
                    public void handleSuccess(DefaultArrayResponse result) {
                        List<Wrapper> responses = result.getResponses();
                        ArrayList<ServerGroup> list = new ArrayList<ServerGroup>(responses.size());
                        for (Wrapper response : responses) {
                            for (ServerGroup s : allServerGroups) {
                                if (s.getId() != response.getInt("sgid")) continue;
                                list.add(s);
                            }
                        }
                        future.set(list);
                    }
                }).forwardFailure(future);
                TS3ApiAsync.this.query.doCommandAsync(cmd);
            }
        }).forwardFailure(future);
        return future;
    }

    public CommandFuture<List<ServerGroup>> getServerGroupsByClient(Client client) {
        return this.getServerGroupsByClientId(client.getDatabaseId());
    }

    public CommandFuture<Integer> getServerIdByPort(int port) {
        Command cmd = VirtualServerCommands.serverIdGetByPort(port);
        return this.executeAndReturnIntProperty(cmd, "server_id");
    }

    public CommandFuture<VirtualServerInfo> getServerInfo() {
        Command cmd = VirtualServerCommands.serverInfo();
        return this.executeAndTransformFirst(cmd, Transformer.VIRTUAL_SERVER_INFO);
    }

    public CommandFuture<Version> getVersion() {
        Command cmd = ServerCommands.version();
        return this.executeAndTransformFirst(cmd, Transformer.VERSION);
    }

    public CommandFuture<List<VirtualServer>> getVirtualServers() {
        Command cmd = VirtualServerCommands.serverList();
        return this.executeAndTransform(cmd, Transformer.VIRTUAL_SERVER);
    }

    public CommandFuture<List<String>> getVirtualServerLogEntries(int lines) {
        Command cmd = ServerCommands.logView(lines, false);
        return this.executeAndReturnLogLines(cmd);
    }

    public CommandFuture<List<String>> getVirtualServerLogEntries() {
        return this.getVirtualServerLogEntries(100);
    }

    public CommandFuture<Boolean> isClientOnline(int clientId) {
        Command cmd = ClientCommands.clientInfo(clientId);
        final CommandFuture<Boolean> future = new CommandFuture<Boolean>();
        cmd.getFuture().onSuccess(new CommandFuture.SuccessListener<DefaultArrayResponse>(){

            @Override
            public void handleSuccess(DefaultArrayResponse result) {
                future.set(true);
            }
        }).onFailure(TS3ApiAsync.transformError(future, 512, false));
        this.query.doCommandAsync(cmd);
        return future;
    }

    public CommandFuture<Boolean> isClientOnline(String clientUId) {
        Command cmd = ClientCommands.clientGetIds(clientUId);
        final CommandFuture<Boolean> future = new CommandFuture<Boolean>();
        cmd.getFuture().onSuccess(new CommandFuture.SuccessListener<DefaultArrayResponse>(){

            @Override
            public void handleSuccess(DefaultArrayResponse result) {
                future.set(!result.getResponses().isEmpty());
            }
        }).forwardFailure(future);
        this.query.doCommandAsync(cmd);
        return future;
    }

    public CommandFuture<Void> kickClientFromChannel(int ... clientIds) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_CHANNEL, null, clientIds);
    }

    public CommandFuture<Void> kickClientFromChannel(Client ... clients) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_CHANNEL, null, clients);
    }

    public CommandFuture<Void> kickClientFromChannel(String message, int ... clientIds) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_CHANNEL, message, clientIds);
    }

    public CommandFuture<Void> kickClientFromChannel(String message, Client ... clients) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_CHANNEL, message, clients);
    }

    public CommandFuture<Void> kickClientFromServer(int ... clientIds) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_SERVER, null, clientIds);
    }

    public CommandFuture<Void> kickClientFromServer(Client ... clients) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_SERVER, null, clients);
    }

    public CommandFuture<Void> kickClientFromServer(String message, int ... clientIds) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_SERVER, message, clientIds);
    }

    public CommandFuture<Void> kickClientFromServer(String message, Client ... clients) {
        return this.kickClients(ReasonIdentifier.REASON_KICK_SERVER, message, clients);
    }

    private CommandFuture<Void> kickClients(ReasonIdentifier reason, String message, Client ... clients) {
        int[] clientIds = new int[clients.length];
        for (int i = 0; i < clients.length; ++i) {
            clientIds[i] = clients[i].getId();
        }
        return this.kickClients(reason, message, clientIds);
    }

    private CommandFuture<Void> kickClients(ReasonIdentifier reason, String message, int ... clientIds) {
        Command cmd = ClientCommands.clientKick(reason, message, clientIds);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> login(String username, String password) {
        Command cmd = QueryCommands.logIn(username, password);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> logout() {
        Command cmd = QueryCommands.logOut();
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> moveChannel(int channelId, int channelTargetId) {
        return this.moveChannel(channelId, channelTargetId, 0);
    }

    public CommandFuture<Void> moveChannel(int channelId, int channelTargetId, int order) {
        Command cmd = ChannelCommands.channelMove(channelId, channelTargetId, order);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> moveClient(int clientId, int channelId) {
        return this.moveClient(clientId, channelId, null);
    }

    public CommandFuture<Void> moveClients(int[] clientIds, int channelId) {
        return this.moveClients(clientIds, channelId, null);
    }

    public CommandFuture<Void> moveClient(Client client, ChannelBase channel) {
        return this.moveClient(client, channel, null);
    }

    public CommandFuture<Void> moveClients(Client[] clients, ChannelBase channel) {
        return this.moveClients(clients, channel, null);
    }

    public CommandFuture<Void> moveClient(int clientId, int channelId, String channelPassword) {
        Command cmd = ClientCommands.clientMove(clientId, channelId, channelPassword);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> moveClients(int[] clientIds, int channelId, String channelPassword) {
        if (clientIds == null) {
            throw new IllegalArgumentException("Client ID array was null");
        }
        if (clientIds.length == 0) {
            return CommandFuture.immediate(null);
        }
        Command cmd = ClientCommands.clientMove(clientIds, channelId, channelPassword);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> moveClient(Client client, ChannelBase channel, String channelPassword) {
        if (client == null) {
            throw new IllegalArgumentException("Client cannot be null");
        }
        if (channel == null) {
            throw new IllegalArgumentException("Channel cannot be null");
        }
        return this.moveClient(client.getId(), channel.getId(), channelPassword);
    }

    public CommandFuture<Void> moveClients(Client[] clients, ChannelBase channel, String channelPassword) {
        if (clients == null) {
            throw new IllegalArgumentException("Client array cannot be null");
        }
        if (channel == null) {
            throw new IllegalArgumentException("Channel cannot be null");
        }
        int[] clientIds = new int[clients.length];
        for (int i = 0; i < clients.length; ++i) {
            Client client = clients[i];
            clientIds[i] = client.getId();
        }
        return this.moveClients(clientIds, channel.getId(), channelPassword);
    }

    public CommandFuture<Void> moveFile(String oldPath, String newPath, int channelId) {
        return this.moveFile(oldPath, newPath, channelId, null);
    }

    public CommandFuture<Void> moveFile(String oldPath, String newPath, int oldChannelId, int newChannelId) {
        return this.moveFile(oldPath, newPath, oldChannelId, null, newChannelId, null);
    }

    public CommandFuture<Void> moveFile(String oldPath, String newPath, int channelId, String channelPassword) {
        Command cmd = FileCommands.ftRenameFile(oldPath, newPath, channelId, channelPassword);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> moveFile(String oldPath, String newPath, int oldChannelId, String oldPassword, int newChannelId, String newPassword) {
        Command cmd = FileCommands.ftRenameFile(oldPath, newPath, oldChannelId, oldPassword, newChannelId, newPassword);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> moveQuery(int channelId) {
        return this.moveClient(0, channelId, null);
    }

    public CommandFuture<Void> moveQuery(ChannelBase channel) {
        if (channel == null) {
            throw new IllegalArgumentException("Channel cannot be null");
        }
        return this.moveClient(0, channel.getId(), null);
    }

    public CommandFuture<Void> moveQuery(int channelId, String channelPassword) {
        return this.moveClient(0, channelId, channelPassword);
    }

    public CommandFuture<Void> moveQuery(ChannelBase channel, String channelPassword) {
        if (channel == null) {
            throw new IllegalArgumentException("Channel cannot be null");
        }
        return this.moveClient(0, channel.getId(), channelPassword);
    }

    public CommandFuture<Void> pokeClient(int clientId, String message) {
        Command cmd = ClientCommands.clientPoke(clientId, message);
        return this.executeAndReturnError(cmd);
    }

    CommandFuture<Void> quit() {
        Command cmd = QueryCommands.quit();
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> registerAllEvents() {
        final CommandFuture<Void> future = new CommandFuture<Void>();
        ArrayList eventFutures = new ArrayList(5);
        eventFutures.add(this.registerEvent(TS3EventType.SERVER));
        eventFutures.add(this.registerEvent(TS3EventType.TEXT_SERVER));
        eventFutures.add(this.registerEvent(TS3EventType.CHANNEL, 0));
        eventFutures.add(this.registerEvent(TS3EventType.TEXT_CHANNEL, 0));
        eventFutures.add(this.registerEvent(TS3EventType.TEXT_PRIVATE));
        eventFutures.add(this.registerEvent(TS3EventType.PRIVILEGE_KEY_USED));
        CommandFuture.ofAll(eventFutures).onSuccess(new CommandFuture.SuccessListener<List<Void>>(){

            @Override
            public void handleSuccess(List<Void> ignored) {
                future.set(null);
            }
        }).forwardFailure(future);
        return future;
    }

    public CommandFuture<Void> registerEvent(TS3EventType eventType) {
        if (eventType == TS3EventType.CHANNEL || eventType == TS3EventType.TEXT_CHANNEL) {
            return this.registerEvent(eventType, 0);
        }
        return this.registerEvent(eventType, -1);
    }

    public CommandFuture<Void> registerEvent(TS3EventType eventType, int channelId) {
        Command cmd = QueryCommands.serverNotifyRegister(eventType, channelId);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> registerEvents(TS3EventType ... eventTypes) {
        if (eventTypes.length == 0) {
            return CommandFuture.immediate(null);
        }
        ArrayList registerFutures = new ArrayList(eventTypes.length);
        for (TS3EventType type : eventTypes) {
            registerFutures.add(this.registerEvent(type));
        }
        final CommandFuture<Void> future = new CommandFuture<Void>();
        CommandFuture.ofAll(registerFutures).onSuccess(new CommandFuture.SuccessListener<List<Void>>(){

            @Override
            public void handleSuccess(List<Void> ignored) {
                future.set(null);
            }
        }).forwardFailure(future);
        return future;
    }

    public CommandFuture<Void> removeClientFromServerGroup(int serverGroupId, int clientDatabaseId) {
        Command cmd = ServerGroupCommands.serverGroupDelClient(serverGroupId, clientDatabaseId);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> removeClientFromServerGroup(ServerGroup serverGroup, Client client) {
        return this.removeClientFromServerGroup(serverGroup.getId(), client.getDatabaseId());
    }

    public void removeTS3Listeners(TS3Listener ... listeners) {
        this.query.getEventManager().removeListeners(listeners);
    }

    public CommandFuture<Void> renameChannelGroup(int channelGroupId, String name) {
        Command cmd = ChannelGroupCommands.channelGroupRename(channelGroupId, name);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> renameChannelGroup(ChannelGroup channelGroup, String name) {
        return this.renameChannelGroup(channelGroup.getId(), name);
    }

    public CommandFuture<Void> renameServerGroup(int serverGroupId, String name) {
        Command cmd = ServerGroupCommands.serverGroupRename(serverGroupId, name);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> renameServerGroup(ServerGroup serverGroup, String name) {
        return this.renameChannelGroup(serverGroup.getId(), name);
    }

    public CommandFuture<String> resetPermissions() {
        Command cmd = PermissionCommands.permReset();
        return this.executeAndReturnStringProperty(cmd, "token");
    }

    public CommandFuture<Void> selectVirtualServerById(int id) {
        Command cmd = QueryCommands.useId(id);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> selectVirtualServerByPort(int port) {
        Command cmd = QueryCommands.usePort(port);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> selectVirtualServer(VirtualServer server) {
        return this.selectVirtualServerById(server.getId());
    }

    public CommandFuture<Void> sendOfflineMessage(String clientUId, String subject, String message) {
        Command cmd = MessageCommands.messageAdd(clientUId, subject, message);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> sendTextMessage(TextMessageTargetMode targetMode, int targetId, String message) {
        Command cmd = ClientCommands.sendTextMessage(targetMode.getIndex(), targetId, message);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> sendChannelMessage(int channelId, final String message) {
        final CommandFuture<Void> future = new CommandFuture<Void>();
        this.moveQuery(channelId).onSuccess(new CommandFuture.SuccessListener<Void>(){

            @Override
            public void handleSuccess(Void ignored) {
                TS3ApiAsync.this.sendTextMessage(TextMessageTargetMode.CHANNEL, 0, message).forwardResult(future);
            }
        }).forwardFailure(future);
        return future;
    }

    public CommandFuture<Void> sendChannelMessage(String message) {
        return this.sendTextMessage(TextMessageTargetMode.CHANNEL, 0, message);
    }

    public CommandFuture<Void> sendServerMessage(int serverId, final String message) {
        final CommandFuture<Void> future = new CommandFuture<Void>();
        this.selectVirtualServerById(serverId).onSuccess(new CommandFuture.SuccessListener<Void>(){

            @Override
            public void handleSuccess(Void ignored) {
                TS3ApiAsync.this.sendTextMessage(TextMessageTargetMode.SERVER, 0, message).forwardResult(future);
            }
        }).forwardFailure(future);
        return future;
    }

    public CommandFuture<Void> sendServerMessage(String message) {
        return this.sendTextMessage(TextMessageTargetMode.SERVER, 0, message);
    }

    public CommandFuture<Void> sendPrivateMessage(int clientId, String message) {
        return this.sendTextMessage(TextMessageTargetMode.CLIENT, clientId, message);
    }

    public CommandFuture<Void> setClientChannelGroup(int groupId, int channelId, int clientDBId) {
        Command cmd = ChannelGroupCommands.setClientChannelGroup(groupId, channelId, clientDBId);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> setMessageRead(int messageId) {
        return this.setMessageReadFlag(messageId, true);
    }

    public CommandFuture<Void> setMessageRead(Message message) {
        return this.setMessageReadFlag(message.getId(), true);
    }

    public CommandFuture<Void> setMessageReadFlag(int messageId, boolean read) {
        Command cmd = MessageCommands.messageUpdateFlag(messageId, read);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> setMessageReadFlag(Message message, boolean read) {
        return this.setMessageReadFlag(message.getId(), read);
    }

    public CommandFuture<Void> setNickname(String nickname) {
        Map<ClientProperty, String> options = Collections.singletonMap(ClientProperty.CLIENT_NICKNAME, nickname);
        return this.updateClient(options);
    }

    public CommandFuture<Void> startServer(int serverId) {
        Command cmd = VirtualServerCommands.serverStart(serverId);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> startServer(VirtualServer virtualServer) {
        return this.startServer(virtualServer.getId());
    }

    public CommandFuture<Void> stopServer(int serverId) {
        Command cmd = VirtualServerCommands.serverStop(serverId);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> stopServer(VirtualServer virtualServer) {
        return this.stopServer(virtualServer.getId());
    }

    public CommandFuture<Void> stopServerProcess() {
        Command cmd = ServerCommands.serverProcessStop();
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> unregisterAllEvents() {
        Command cmd = QueryCommands.serverNotifyUnregister();
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> updateClient(Map<ClientProperty, String> options) {
        Command cmd = ClientCommands.clientUpdate(options);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> updateClient(ClientProperty property, String value) {
        return this.updateClient(Collections.singletonMap(property, value));
    }

    public CommandFuture<String> updateServerQueryLogin(String loginName) {
        Command cmd = ClientCommands.clientSetServerQueryLogin(loginName);
        return this.executeAndReturnStringProperty(cmd, "client_login_password");
    }

    public CommandFuture<Void> uploadFile(InputStream dataIn, long dataLength, String filePath, boolean overwrite, int channelId) {
        return this.uploadFile(dataIn, dataLength, filePath, overwrite, channelId, null);
    }

    public CommandFuture<Void> uploadFile(final InputStream dataIn, final long dataLength, String filePath, boolean overwrite, int channelId, String channelPassword) {
        FileTransferHelper helper = this.query.getFileTransferHelper();
        int transferId = helper.getClientTransferId();
        Command cmd = FileCommands.ftInitUpload(transferId, filePath, channelId, channelPassword, dataLength, overwrite);
        final CommandFuture<Void> future = new CommandFuture<Void>();
        cmd.getFuture().onSuccess(new CommandFuture.SuccessListener<DefaultArrayResponse>(){

            @Override
            public void handleSuccess(DefaultArrayResponse result) {
                FileTransferParameters params = new FileTransferParameters(result.getFirstResponse().getMap());
                QueryError error = params.getQueryError();
                if (!error.isSuccessful()) {
                    future.fail(new TS3CommandFailedException(error));
                    return;
                }
                try {
                    TS3ApiAsync.this.query.getFileTransferHelper().uploadFile(dataIn, dataLength, params);
                }
                catch (IOException e) {
                    future.fail(new TS3FileTransferFailedException("Upload failed", e));
                    return;
                }
                future.set(null);
            }
        }).forwardFailure(future);
        this.query.doCommandAsync(cmd);
        return future;
    }

    public CommandFuture<Void> uploadFileDirect(byte[] data, String filePath, boolean overwrite, int channelId) {
        return this.uploadFileDirect(data, filePath, overwrite, channelId, null);
    }

    public CommandFuture<Void> uploadFileDirect(byte[] data, String filePath, boolean overwrite, int channelId, String channelPassword) {
        return this.uploadFile(new ByteArrayInputStream(data), data.length, filePath, overwrite, channelId, channelPassword);
    }

    public CommandFuture<Long> uploadIcon(InputStream dataIn, long dataLength) {
        byte[] data;
        FileTransferHelper helper = this.query.getFileTransferHelper();
        try {
            data = helper.readFully(dataIn, dataLength);
        }
        catch (IOException e) {
            throw new TS3FileTransferFailedException("Reading stream failed", e);
        }
        return this.uploadIconDirect(data);
    }

    public CommandFuture<Long> uploadIconDirect(byte[] data) {
        FileTransferHelper helper = this.query.getFileTransferHelper();
        final CommandFuture<Long> future = new CommandFuture<Long>();
        final long iconId = helper.getIconId(data);
        String path = "/icon_" + iconId;
        this.uploadFileDirect(data, path, false, 0).onSuccess(new CommandFuture.SuccessListener<Void>(){

            @Override
            public void handleSuccess(Void ignored) {
                future.set(iconId);
            }
        }).onFailure(TS3ApiAsync.transformError(future, 2050, iconId));
        return future;
    }

    public CommandFuture<Void> usePrivilegeKey(String token) {
        Command cmd = PrivilegeKeyCommands.privilegeKeyUse(token);
        return this.executeAndReturnError(cmd);
    }

    public CommandFuture<Void> usePrivilegeKey(PrivilegeKey privilegeKey) {
        return this.usePrivilegeKey(privilegeKey.getToken());
    }

    public CommandFuture<ServerQueryInfo> whoAmI() {
        Command cmd = QueryCommands.whoAmI();
        return this.executeAndTransformFirst(cmd, Transformer.SERVER_QUERY_INFO);
    }

    private static boolean isQueryError(TS3Exception exception, int errorId) {
        if (exception instanceof TS3CommandFailedException) {
            TS3CommandFailedException cfe = (TS3CommandFailedException)exception;
            return cfe.getError().getId() == errorId;
        }
        return false;
    }

    private static <T> CommandFuture.FailureListener transformError(final CommandFuture<T> future, final int errorId, final T replacement) {
        return new CommandFuture.FailureListener(){

            @Override
            public void handleFailure(TS3Exception exception) {
                if (TS3ApiAsync.isQueryError(exception, errorId)) {
                    future.set(replacement);
                } else {
                    future.fail(exception);
                }
            }
        };
    }

    private CommandFuture<Void> executeAndReturnError(Command command) {
        final CommandFuture<Void> future = new CommandFuture<Void>();
        command.getFuture().onSuccess(new CommandFuture.SuccessListener<DefaultArrayResponse>(){

            @Override
            public void handleSuccess(DefaultArrayResponse result) {
                future.set(null);
            }
        }).forwardFailure(future);
        this.query.doCommandAsync(command);
        return future;
    }

    private CommandFuture<String> executeAndReturnStringProperty(Command command, final String property) {
        final CommandFuture<String> future = new CommandFuture<String>();
        command.getFuture().onSuccess(new CommandFuture.SuccessListener<DefaultArrayResponse>(){

            @Override
            public void handleSuccess(DefaultArrayResponse result) {
                future.set(result.getFirstResponse().get(property));
            }
        }).forwardFailure(future);
        this.query.doCommandAsync(command);
        return future;
    }

    private CommandFuture<Integer> executeAndReturnIntProperty(Command command, final String property) {
        final CommandFuture<Integer> future = new CommandFuture<Integer>();
        command.getFuture().onSuccess(new CommandFuture.SuccessListener<DefaultArrayResponse>(){

            @Override
            public void handleSuccess(DefaultArrayResponse result) {
                future.set(result.getFirstResponse().getInt(property));
            }
        }).forwardFailure(future);
        this.query.doCommandAsync(command);
        return future;
    }

    private CommandFuture<List<String>> executeAndReturnLogLines(Command command) {
        final CommandFuture<List<String>> future = new CommandFuture<List<String>>();
        command.getFuture().onSuccess(new CommandFuture.SuccessListener<DefaultArrayResponse>(){

            @Override
            public void handleSuccess(DefaultArrayResponse result) {
                List<Wrapper> responses = result.getResponses();
                ArrayList<String> lines = new ArrayList<String>(responses.size());
                for (Wrapper r : result.getResponses()) {
                    lines.add(r.getMap().get("l"));
                }
                future.set(lines);
            }
        }).forwardFailure(future);
        this.query.doCommandAsync(command);
        return future;
    }

    private <T extends Wrapper> CommandFuture<T> executeAndTransformFirst(Command command, final Transformer<T> transformer) {
        final CommandFuture future = new CommandFuture();
        command.getFuture().onSuccess(new CommandFuture.SuccessListener<DefaultArrayResponse>(){

            @Override
            public void handleSuccess(DefaultArrayResponse result) {
                Wrapper firstResponse = result.getFirstResponse();
                Object transformed = transformer.apply(firstResponse.getMap());
                future.set(transformed);
            }
        }).forwardFailure(future);
        this.query.doCommandAsync(command);
        return future;
    }

    private <T extends Wrapper> CommandFuture<List<T>> executeAndTransform(Command command, final Transformer<T> transformer) {
        final CommandFuture<List<T>> future = new CommandFuture<List<T>>();
        command.getFuture().onSuccess(new CommandFuture.SuccessListener<DefaultArrayResponse>(){

            @Override
            public void handleSuccess(DefaultArrayResponse result) {
                List<Wrapper> response = result.getResponses();
                ArrayList transformed = new ArrayList(response.size());
                for (Wrapper wrapper : response) {
                    transformed.add(transformer.apply(wrapper.getMap()));
                }
                future.set(transformed);
            }
        }).forwardFailure(future);
        this.query.doCommandAsync(command);
        return future;
    }

    private static class ReflectiveTransformer<T extends Wrapper>
    implements Transformer<T> {
        private final Class<T> wrapperClass;
        private final MethodHandle constructor;

        public ReflectiveTransformer(Class<T> wrapperClass) {
            this.wrapperClass = wrapperClass;
            try {
                MethodType type = MethodType.methodType(Void.TYPE, Map.class);
                this.constructor = MethodHandles.publicLookup().in(wrapperClass).findConstructor(wrapperClass, type);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new Error("Missing public constructor of wrapper class " + wrapperClass.getSimpleName(), e);
            }
        }

        @Override
        public T apply(Map<String, String> map) {
            try {
                return (T)((Wrapper)this.wrapperClass.cast(this.constructor.invoke(map)));
            }
            catch (Throwable t) {
                throw new Error("Method handle error", t);
            }
        }
    }

    private static interface Transformer<T extends Wrapper> {
        public static final Transformer<Ban> BAN = new ReflectiveTransformer<Ban>(Ban.class);
        public static final Transformer<Binding> BINDING = new ReflectiveTransformer<Binding>(Binding.class);
        public static final Transformer<Channel> CHANNEL = new ReflectiveTransformer<Channel>(Channel.class);
        public static final Transformer<ChannelGroup> CHANNEL_GROUP = new ReflectiveTransformer<ChannelGroup>(ChannelGroup.class);
        public static final Transformer<ChannelGroupClient> CHANNEL_GROUP_CLIENT = new ReflectiveTransformer<ChannelGroupClient>(ChannelGroupClient.class);
        public static final Transformer<Client> CLIENT = new ReflectiveTransformer<Client>(Client.class);
        public static final Transformer<Complaint> COMPLAINT = new ReflectiveTransformer<Complaint>(Complaint.class);
        public static final Transformer<ConnectionInfo> CONNECTION_INFO = new ReflectiveTransformer<ConnectionInfo>(ConnectionInfo.class);
        public static final Transformer<CreatedVirtualServer> CREATED_VIRTUAL_SERVER = new ReflectiveTransformer<CreatedVirtualServer>(CreatedVirtualServer.class);
        public static final Transformer<DatabaseClient> DATABASE_CLIENT = new ReflectiveTransformer<DatabaseClient>(DatabaseClient.class);
        public static final Transformer<DatabaseClientInfo> DATABASE_CLIENT_INFO = new ReflectiveTransformer<DatabaseClientInfo>(DatabaseClientInfo.class);
        public static final Transformer<FileInfo> FILE_INFO = new ReflectiveTransformer<FileInfo>(FileInfo.class);
        public static final Transformer<FileListEntry> FILE_LIST_ENTRY = new ReflectiveTransformer<FileListEntry>(FileListEntry.class);
        public static final Transformer<FileTransfer> FILE_TRANSFER = new ReflectiveTransformer<FileTransfer>(FileTransfer.class);
        public static final Transformer<HostInfo> HOST_INFO = new ReflectiveTransformer<HostInfo>(HostInfo.class);
        public static final Transformer<InstanceInfo> INSTANCE_INFO = new ReflectiveTransformer<InstanceInfo>(InstanceInfo.class);
        public static final Transformer<Message> MESSAGE = new ReflectiveTransformer<Message>(Message.class);
        public static final Transformer<Permission> PERMISSION = new ReflectiveTransformer<Permission>(Permission.class);
        public static final Transformer<PermissionAssignment> PERMISSION_ASSIGNMENT = new ReflectiveTransformer<PermissionAssignment>(PermissionAssignment.class);
        public static final Transformer<PermissionInfo> PERMISSION_INFO = new ReflectiveTransformer<PermissionInfo>(PermissionInfo.class);
        public static final Transformer<PrivilegeKey> PRIVILEGE_KEY = new ReflectiveTransformer<PrivilegeKey>(PrivilegeKey.class);
        public static final Transformer<ServerGroup> SERVER_GROUP = new ReflectiveTransformer<ServerGroup>(ServerGroup.class);
        public static final Transformer<ServerGroupClient> SERVER_GROUP_CLIENT = new ReflectiveTransformer<ServerGroupClient>(ServerGroupClient.class);
        public static final Transformer<ServerQueryInfo> SERVER_QUERY_INFO = new ReflectiveTransformer<ServerQueryInfo>(ServerQueryInfo.class);
        public static final Transformer<Version> VERSION = new ReflectiveTransformer<Version>(Version.class);
        public static final Transformer<VirtualServer> VIRTUAL_SERVER = new ReflectiveTransformer<VirtualServer>(VirtualServer.class);
        public static final Transformer<VirtualServerInfo> VIRTUAL_SERVER_INFO = new ReflectiveTransformer<VirtualServerInfo>(VirtualServerInfo.class);

        public T apply(Map<String, String> var1);
    }
}

