/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.SocketWriter;
import com.github.theholywaffle.teamspeak3.TS3ApiAsync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeepAliveThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(KeepAliveThread.class);
    private static final int SLEEP = 60000;
    private final SocketWriter writer;
    private final TS3ApiAsync asyncApi;

    public KeepAliveThread(SocketWriter writer, TS3ApiAsync asyncApi) {
        super("[TeamSpeak-3-Java-API] Keep alive");
        this.writer = writer;
        this.asyncApi = asyncApi;
    }

    @Override
    public void run() {
        try {
            while (!this.isInterrupted()) {
                long idleTime = this.writer.getIdleTime();
                if (idleTime >= 60000L) {
                    this.asyncApi.whoAmI().await();
                    continue;
                }
                Thread.sleep(60000L - idleTime);
            }
        }
        catch (InterruptedException idleTime) {
        }
        catch (Exception e) {
            log.warn("KeepAlive thread has stopped!", (Throwable)e);
        }
    }
}

