/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.util;

import it.auties.curve25519.Curve25519;
import it.auties.whatsapp.api.AsyncCaptchaCodeSupplier;
import it.auties.whatsapp.api.AsyncVerificationCodeSupplier;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.crypto.AesGmc;
import it.auties.whatsapp.exception.RegistrationException;
import it.auties.whatsapp.model.mobile.VerificationCodeError;
import it.auties.whatsapp.model.mobile.VerificationCodeMethod;
import it.auties.whatsapp.model.mobile.VerificationCodeResponse;
import it.auties.whatsapp.model.request.Attributes;
import it.auties.whatsapp.model.signal.auth.UserAgent;
import it.auties.whatsapp.model.signal.auth.Version;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.Json;
import it.auties.whatsapp.util.MetadataHelper;
import it.auties.whatsapp.util.ProxyAuthenticator;
import it.auties.whatsapp.util.Spec;
import it.auties.whatsapp.util.Validate;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public final class RegistrationHelper {
    public static CompletableFuture<Void> registerPhoneNumber(Store store, Keys keys, AsyncVerificationCodeSupplier codeHandler, AsyncCaptchaCodeSupplier captchaHandler, VerificationCodeMethod method) {
        if (method == VerificationCodeMethod.NONE) {
            return RegistrationHelper.sendVerificationCode(store, keys, codeHandler, captchaHandler);
        }
        return RegistrationHelper.requestVerificationCode(store, keys, method, false).thenComposeAsync(ignored -> RegistrationHelper.sendVerificationCode(store, keys, codeHandler, captchaHandler));
    }

    public static CompletableFuture<Void> requestVerificationCode(Store store, Keys keys, VerificationCodeMethod method) {
        return RegistrationHelper.requestVerificationCode(store, keys, method, false);
    }

    private static CompletableFuture<Void> requestVerificationCode(Store store, Keys keys, VerificationCodeMethod method, boolean badToken) {
        if (method == VerificationCodeMethod.NONE) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)((CompletableFuture)RegistrationHelper.requestVerificationCodeOptions(store, keys, method, badToken).thenComposeAsync(attrs -> RegistrationHelper.sendRegistrationRequest(store, "/code", attrs))).thenComposeAsync(result -> RegistrationHelper.checkRequestResponse(store, keys, method, result))).thenRunAsync(() -> RegistrationHelper.saveRegistrationStatus(store, keys, false));
    }

    private static CompletableFuture<Void> checkRequestResponse(Store store, Keys keys, VerificationCodeMethod method, HttpResponse<String> result) {
        Validate.isTrue(result.statusCode() == 200, "Invalid status code: %s", RegistrationException.class, result.statusCode(), result.body());
        VerificationCodeResponse response = Json.readValue(result.body(), VerificationCodeResponse.class);
        if (response.status().isSuccessful()) {
            return CompletableFuture.completedFuture(null);
        }
        if (response.errorReason() == VerificationCodeError.BAD_TOKEN || response.errorReason() == VerificationCodeError.OLD_VERSION) {
            return RegistrationHelper.requestVerificationCode(store, keys, method, true);
        }
        throw new RegistrationException(response);
    }

    private static CompletableFuture<Map<String, Object>> requestVerificationCodeOptions(Store store, Keys keys, VerificationCodeMethod method, boolean badToken) {
        return RegistrationHelper.getRegistrationOptions(store, keys, badToken, Map.entry("mcc", store.phoneNumber().orElseThrow().countryCode().mcc()), Map.entry("mnc", store.phoneNumber().orElseThrow().countryCode().mnc()), Map.entry("sim_mcc", "000"), Map.entry("sim_mnc", "000"), Map.entry("method", method.type()), Map.entry("reason", ""), Map.entry("hasav", "1"));
    }

    public static CompletableFuture<Void> sendVerificationCode(Store store, Keys keys, AsyncVerificationCodeSupplier handler, AsyncCaptchaCodeSupplier captchaHandler) {
        return ((CompletableFuture)((CompletableFuture)handler.get()).thenComposeAsync(result -> RegistrationHelper.sendVerificationCode(store, keys, result, captchaHandler, false))).thenRunAsync(() -> RegistrationHelper.saveRegistrationStatus(store, keys, true));
    }

    private static void saveRegistrationStatus(Store store, Keys keys, boolean registered) {
        keys.registered(registered);
        if (registered) {
            store.jid(store.phoneNumber().orElseThrow().toJid());
            store.addLinkedDevice(store.jid(), 0);
        }
        keys.serialize(true);
        store.serialize(true);
    }

    private static CompletableFuture<Void> sendVerificationCode(Store store, Keys keys, String code, AsyncCaptchaCodeSupplier captchaHandler, boolean badToken) {
        return ((CompletableFuture)RegistrationHelper.getRegistrationOptions(store, keys, badToken, Map.entry("code", RegistrationHelper.normalizeCodeResult(code))).thenComposeAsync(attrs -> RegistrationHelper.sendRegistrationRequest(store, "/register", attrs))).thenComposeAsync(result -> RegistrationHelper.checkVerificationResponse(store, keys, code, result, captchaHandler));
    }

    private static CompletableFuture<Void> sendVerificationCode(Store store, Keys keys, String code, String captcha) {
        return ((CompletableFuture)RegistrationHelper.getRegistrationOptions(store, keys, false, Map.entry("code", RegistrationHelper.normalizeCodeResult(code)), Map.entry("fraud_checkpoint_code", RegistrationHelper.normalizeCodeResult(captcha))).thenComposeAsync(attrs -> RegistrationHelper.sendRegistrationRequest(store, "/register", attrs))).thenComposeAsync(result -> RegistrationHelper.checkVerificationResponse(store, keys, code, result, null));
    }

    private static CompletableFuture<Void> checkVerificationResponse(Store store, Keys keys, String code, HttpResponse<String> result, AsyncCaptchaCodeSupplier captchaHandler) {
        System.out.println(result.body());
        Validate.isTrue(result.statusCode() == 200, "Invalid status code: %s", RegistrationException.class, result.statusCode(), result.body());
        VerificationCodeResponse response = Json.readValue(result.body(), VerificationCodeResponse.class);
        if (response.errorReason() == VerificationCodeError.BAD_TOKEN || response.errorReason() == VerificationCodeError.OLD_VERSION) {
            return RegistrationHelper.sendVerificationCode(store, keys, code, captchaHandler, true);
        }
        if (response.errorReason() == VerificationCodeError.CAPTCHA) {
            Objects.requireNonNull(captchaHandler, "Received captcha error, but no handler was specified in the options");
            return ((CompletableFuture)captchaHandler.apply(response)).thenComposeAsync(captcha -> RegistrationHelper.sendVerificationCode(store, keys, code, captcha));
        }
        if (!response.status().isSuccessful()) {
            throw new RegistrationException(response);
        }
        return CompletableFuture.completedFuture(null);
    }

    private static String normalizeCodeResult(String captcha) {
        return captcha.replaceAll("-", "").trim();
    }

    private static CompletableFuture<HttpResponse<String>> sendRegistrationRequest(Store store, String path, Map<String, Object> params) {
        HttpClient client = RegistrationHelper.createClient(store);
        String encodedParams = RegistrationHelper.toFormParams(params);
        SignalKeyPair keypair = SignalKeyPair.random();
        byte[] key = Curve25519.sharedKey((byte[])Spec.Whatsapp.REGISTRATION_PUBLIC_KEY, (byte[])keypair.privateKey());
        byte[] buffer = AesGmc.encrypt(new byte[12], encodedParams.getBytes(StandardCharsets.UTF_8), key);
        String enc = Base64.getUrlEncoder().encodeToString(BytesHelper.concat(keypair.publicKey(), buffer));
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("%s%s?ENC=%s".formatted("https://v.whatsapp.net/v2", path, enc))).GET().header("Content-Type", "application/x-www-form-urlencoded").header("User-Agent", RegistrationHelper.getUserAgent(store)).header("WaMsysRequest", "1").header("request_token", UUID.randomUUID().toString()).build();
        return client.sendAsync(request, HttpResponse.BodyHandlers.ofString());
    }

    private static String getUserAgent(Store store) {
        String osName = RegistrationHelper.getMobileOsName(store);
        Version osVersion = store.device().osVersion();
        String manufacturer = store.device().manufacturer();
        String model = store.device().model().replaceAll(" ", "_");
        return "WhatsApp/%s %s/%s Device/%s-%s".formatted(store.version(), osName, osVersion, manufacturer, model);
    }

    private static String getMobileOsName(Store store) {
        return switch (store.device().osType()) {
            case UserAgent.UserAgentPlatform.ANDROID -> {
                if (store.business()) {
                    yield "SMBA";
                }
                yield "Android";
            }
            case UserAgent.UserAgentPlatform.IOS -> {
                if (store.business()) {
                    yield "SMBI";
                }
                yield "iOS";
            }
            default -> throw new IllegalStateException("Unsupported mobile os: " + store.device().osType());
        };
    }

    private static HttpClient createClient(Store store) {
        HttpClient.Builder clientBuilder = HttpClient.newBuilder();
        store.proxy().ifPresent(proxy -> {
            clientBuilder.proxy(ProxySelector.of(new InetSocketAddress(proxy.getHost(), proxy.getPort())));
            clientBuilder.authenticator(new ProxyAuthenticator());
        });
        return clientBuilder.build();
    }

    @SafeVarargs
    private static CompletableFuture<Map<String, Object>> getRegistrationOptions(Store store, Keys keys, boolean isRetry, Map.Entry<String, Object> ... attributes) {
        return MetadataHelper.getToken(store.phoneNumber().orElseThrow().numberWithoutPrefix(), store.device().osType(), store.business(), !isRetry).thenApplyAsync(token -> RegistrationHelper.getRegistrationOptions(store, keys, token, attributes));
    }

    private static Map<String, Object> getRegistrationOptions(Store store, Keys keys, String token, Map.Entry<String, Object>[] attributes) {
        return Attributes.of(attributes).put("cc", store.phoneNumber().orElseThrow().countryCode().prefix()).put("in", store.phoneNumber().orElseThrow().numberWithoutPrefix()).put("rc", store.releaseChannel().index()).put("lg", "en").put("lc", "GB").put("mistyped", "6").put("authkey", Base64.getUrlEncoder().encodeToString(keys.noiseKeyPair().publicKey())).put("e_regid", Base64.getUrlEncoder().encodeToString(keys.encodedRegistrationId())).put("e_keytype", "BQ").put("e_ident", Base64.getUrlEncoder().encodeToString(keys.identityKeyPair().publicKey())).put("e_skey_id", Base64.getUrlEncoder().encodeToString(keys.signedKeyPair().encodedId())).put("e_skey_val", Base64.getUrlEncoder().encodeToString(keys.signedKeyPair().publicKey())).put("e_skey_sig", Base64.getUrlEncoder().encodeToString(keys.signedKeyPair().signature())).put("fdid", keys.phoneId()).put("network_ratio_type", "1").put("simnum", "1").put("hasinrc", "1").put("expid", keys.deviceId()).put("pid", ProcessHandle.current().pid()).put("id", keys.recoveryToken()).put("token", token).toMap();
    }

    private static String toFormParams(Map<String, Object> values) {
        return values.entrySet().stream().map(entry -> "%s=%s".formatted(entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
    }

    private RegistrationHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

