/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.sync;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufMessage;
import it.auties.protobuf.base.ProtobufName;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.media.AttachmentProvider;
import it.auties.whatsapp.model.media.AttachmentType;
import it.auties.whatsapp.util.Clock;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Arrays;

@ProtobufName(value="StickerMetadata")
@JsonDeserialize(builder=StickerMetadataBuilder.class)
public final class StickerMetadata
implements ProtobufMessage,
AttachmentProvider {
    @ProtobufProperty(index=1, type=ProtobufType.STRING)
    private String mediaUrl;
    @ProtobufProperty(index=2, type=ProtobufType.BYTES)
    private byte[] mediaSha256;
    @ProtobufProperty(index=3, type=ProtobufType.BYTES)
    private byte[] mediaEncryptedSha256;
    @ProtobufProperty(index=4, type=ProtobufType.BYTES)
    private byte[] mediaKey;
    @ProtobufProperty(index=5, type=ProtobufType.STRING)
    private String mimetype;
    @ProtobufProperty(index=6, type=ProtobufType.UINT32)
    private int height;
    @ProtobufProperty(index=7, type=ProtobufType.UINT32)
    private int width;
    @ProtobufProperty(index=8, type=ProtobufType.STRING)
    private String mediaDirectPath;
    @ProtobufProperty(index=9, type=ProtobufType.UINT64)
    private long mediaSize;
    @ProtobufProperty(index=10, type=ProtobufType.FLOAT)
    private float weight;
    @ProtobufProperty(index=11, type=ProtobufType.INT64)
    private long lastStickerSentSeconds;

    public ZonedDateTime lastStickerSent() {
        return Clock.parseSeconds(this.lastStickerSentSeconds);
    }

    @Override
    public AttachmentType attachmentType() {
        return AttachmentType.IMAGE;
    }

    public static StickerMetadataBuilder builder() {
        return new StickerMetadataBuilder();
    }

    public StickerMetadata(String mediaUrl, byte[] mediaSha256, byte[] mediaEncryptedSha256, byte[] mediaKey, String mimetype, int height, int width, String mediaDirectPath, long mediaSize, float weight, long lastStickerSentSeconds) {
        this.mediaUrl = mediaUrl;
        this.mediaSha256 = mediaSha256;
        this.mediaEncryptedSha256 = mediaEncryptedSha256;
        this.mediaKey = mediaKey;
        this.mimetype = mimetype;
        this.height = height;
        this.width = width;
        this.mediaDirectPath = mediaDirectPath;
        this.mediaSize = mediaSize;
        this.weight = weight;
        this.lastStickerSentSeconds = lastStickerSentSeconds;
    }

    @Override
    public String mediaUrl() {
        return this.mediaUrl;
    }

    @Override
    public byte[] mediaSha256() {
        return this.mediaSha256;
    }

    @Override
    public byte[] mediaEncryptedSha256() {
        return this.mediaEncryptedSha256;
    }

    @Override
    public byte[] mediaKey() {
        return this.mediaKey;
    }

    public String mimetype() {
        return this.mimetype;
    }

    public int height() {
        return this.height;
    }

    public int width() {
        return this.width;
    }

    @Override
    public String mediaDirectPath() {
        return this.mediaDirectPath;
    }

    @Override
    public long mediaSize() {
        return this.mediaSize;
    }

    public float weight() {
        return this.weight;
    }

    public long lastStickerSentSeconds() {
        return this.lastStickerSentSeconds;
    }

    @Override
    public StickerMetadata mediaUrl(String mediaUrl) {
        this.mediaUrl = mediaUrl;
        return this;
    }

    @Override
    public StickerMetadata mediaSha256(byte[] mediaSha256) {
        this.mediaSha256 = mediaSha256;
        return this;
    }

    @Override
    public StickerMetadata mediaEncryptedSha256(byte[] mediaEncryptedSha256) {
        this.mediaEncryptedSha256 = mediaEncryptedSha256;
        return this;
    }

    @Override
    public StickerMetadata mediaKey(byte[] mediaKey) {
        this.mediaKey = mediaKey;
        return this;
    }

    public StickerMetadata mimetype(String mimetype) {
        this.mimetype = mimetype;
        return this;
    }

    public StickerMetadata height(int height) {
        this.height = height;
        return this;
    }

    public StickerMetadata width(int width) {
        this.width = width;
        return this;
    }

    @Override
    public StickerMetadata mediaDirectPath(String mediaDirectPath) {
        this.mediaDirectPath = mediaDirectPath;
        return this;
    }

    @Override
    public StickerMetadata mediaSize(long mediaSize) {
        this.mediaSize = mediaSize;
        return this;
    }

    public StickerMetadata weight(float weight) {
        this.weight = weight;
        return this;
    }

    public StickerMetadata lastStickerSentSeconds(long lastStickerSentSeconds) {
        this.lastStickerSentSeconds = lastStickerSentSeconds;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StickerMetadata)) {
            return false;
        }
        StickerMetadata other = (StickerMetadata)o;
        if (this.height() != other.height()) {
            return false;
        }
        if (this.width() != other.width()) {
            return false;
        }
        if (this.mediaSize() != other.mediaSize()) {
            return false;
        }
        if (Float.compare(this.weight(), other.weight()) != 0) {
            return false;
        }
        if (this.lastStickerSentSeconds() != other.lastStickerSentSeconds()) {
            return false;
        }
        String this$mediaUrl = this.mediaUrl();
        String other$mediaUrl = other.mediaUrl();
        if (this$mediaUrl == null ? other$mediaUrl != null : !this$mediaUrl.equals(other$mediaUrl)) {
            return false;
        }
        if (!Arrays.equals(this.mediaSha256(), other.mediaSha256())) {
            return false;
        }
        if (!Arrays.equals(this.mediaEncryptedSha256(), other.mediaEncryptedSha256())) {
            return false;
        }
        if (!Arrays.equals(this.mediaKey(), other.mediaKey())) {
            return false;
        }
        String this$mimetype = this.mimetype();
        String other$mimetype = other.mimetype();
        if (this$mimetype == null ? other$mimetype != null : !this$mimetype.equals(other$mimetype)) {
            return false;
        }
        String this$mediaDirectPath = this.mediaDirectPath();
        String other$mediaDirectPath = other.mediaDirectPath();
        return !(this$mediaDirectPath == null ? other$mediaDirectPath != null : !this$mediaDirectPath.equals(other$mediaDirectPath));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.height();
        result = result * 59 + this.width();
        long $mediaSize = this.mediaSize();
        result = result * 59 + (int)($mediaSize >>> 32 ^ $mediaSize);
        result = result * 59 + Float.floatToIntBits(this.weight());
        long $lastStickerSentSeconds = this.lastStickerSentSeconds();
        result = result * 59 + (int)($lastStickerSentSeconds >>> 32 ^ $lastStickerSentSeconds);
        String $mediaUrl = this.mediaUrl();
        result = result * 59 + ($mediaUrl == null ? 43 : $mediaUrl.hashCode());
        result = result * 59 + Arrays.hashCode(this.mediaSha256());
        result = result * 59 + Arrays.hashCode(this.mediaEncryptedSha256());
        result = result * 59 + Arrays.hashCode(this.mediaKey());
        String $mimetype = this.mimetype();
        result = result * 59 + ($mimetype == null ? 43 : $mimetype.hashCode());
        String $mediaDirectPath = this.mediaDirectPath();
        result = result * 59 + ($mediaDirectPath == null ? 43 : $mediaDirectPath.hashCode());
        return result;
    }

    public String toString() {
        return "StickerMetadata(mediaUrl=" + this.mediaUrl() + ", mediaSha256=" + Arrays.toString(this.mediaSha256()) + ", mediaEncryptedSha256=" + Arrays.toString(this.mediaEncryptedSha256()) + ", mediaKey=" + Arrays.toString(this.mediaKey()) + ", mimetype=" + this.mimetype() + ", height=" + this.height() + ", width=" + this.width() + ", mediaDirectPath=" + this.mediaDirectPath() + ", mediaSize=" + this.mediaSize() + ", weight=" + this.weight() + ", lastStickerSentSeconds=" + this.lastStickerSentSeconds() + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        protobufOutputStream.writeUInt64(9, this.mediaSize);
        protobufOutputStream.writeUInt32(7, this.width);
        if (this.mediaUrl != null) {
            protobufOutputStream.writeString(1, this.mediaUrl);
        }
        if (this.mediaDirectPath != null) {
            protobufOutputStream.writeString(8, this.mediaDirectPath);
        }
        if (this.mediaSha256 != null) {
            protobufOutputStream.writeBytes(2, this.mediaSha256);
        }
        if (this.mimetype != null) {
            protobufOutputStream.writeString(5, this.mimetype);
        }
        protobufOutputStream.writeInt64(11, this.lastStickerSentSeconds);
        if (this.mediaEncryptedSha256 != null) {
            protobufOutputStream.writeBytes(3, this.mediaEncryptedSha256);
        }
        protobufOutputStream.writeUInt32(6, this.height);
        if (this.mediaKey != null) {
            protobufOutputStream.writeBytes(4, this.mediaKey);
        }
        protobufOutputStream.writeFloat(10, this.weight);
        return protobufOutputStream.toByteArray();
    }

    public static StickerMetadata ofProtobuf(byte[] byArray) {
        int n;
        StickerMetadataBuilder stickerMetadataBuilder = StickerMetadata.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        block13: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 9: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMetadataBuilder.mediaSize(protobufInputStream.readInt64());
                    continue block13;
                }
                case 7: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMetadataBuilder.width(protobufInputStream.readInt32());
                    continue block13;
                }
                case 1: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMetadataBuilder.mediaUrl(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block13;
                }
                case 8: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMetadataBuilder.mediaDirectPath(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block13;
                }
                case 2: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMetadataBuilder.mediaSha256(protobufInputStream.readBytes());
                    continue block13;
                }
                case 5: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMetadataBuilder.mimetype(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block13;
                }
                case 11: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMetadataBuilder.lastStickerSentSeconds(protobufInputStream.readInt64());
                    continue block13;
                }
                case 3: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMetadataBuilder.mediaEncryptedSha256(protobufInputStream.readBytes());
                    continue block13;
                }
                case 6: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMetadataBuilder.height(protobufInputStream.readInt32());
                    continue block13;
                }
                case 4: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMetadataBuilder.mediaKey(protobufInputStream.readBytes());
                    continue block13;
                }
                case 10: {
                    if (n3 != 5) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMetadataBuilder.weight(protobufInputStream.readFloat());
                    continue block13;
                }
            }
            protobufInputStream.readBytes();
        }
        return stickerMetadataBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class StickerMetadataBuilder {
        private String mediaUrl;
        private byte[] mediaSha256;
        private byte[] mediaEncryptedSha256;
        private byte[] mediaKey;
        private String mimetype;
        private int height;
        private int width;
        private String mediaDirectPath;
        private long mediaSize;
        private float weight;
        private long lastStickerSentSeconds;

        StickerMetadataBuilder() {
        }

        public StickerMetadataBuilder mediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
            return this;
        }

        public StickerMetadataBuilder mediaSha256(byte[] mediaSha256) {
            this.mediaSha256 = mediaSha256;
            return this;
        }

        public StickerMetadataBuilder mediaEncryptedSha256(byte[] mediaEncryptedSha256) {
            this.mediaEncryptedSha256 = mediaEncryptedSha256;
            return this;
        }

        public StickerMetadataBuilder mediaKey(byte[] mediaKey) {
            this.mediaKey = mediaKey;
            return this;
        }

        public StickerMetadataBuilder mimetype(String mimetype) {
            this.mimetype = mimetype;
            return this;
        }

        public StickerMetadataBuilder height(int height) {
            this.height = height;
            return this;
        }

        public StickerMetadataBuilder width(int width) {
            this.width = width;
            return this;
        }

        public StickerMetadataBuilder mediaDirectPath(String mediaDirectPath) {
            this.mediaDirectPath = mediaDirectPath;
            return this;
        }

        public StickerMetadataBuilder mediaSize(long mediaSize) {
            this.mediaSize = mediaSize;
            return this;
        }

        public StickerMetadataBuilder weight(float weight) {
            this.weight = weight;
            return this;
        }

        public StickerMetadataBuilder lastStickerSentSeconds(long lastStickerSentSeconds) {
            this.lastStickerSentSeconds = lastStickerSentSeconds;
            return this;
        }

        public StickerMetadata build() {
            return new StickerMetadata(this.mediaUrl, this.mediaSha256, this.mediaEncryptedSha256, this.mediaKey, this.mimetype, this.height, this.width, this.mediaDirectPath, this.mediaSize, this.weight, this.lastStickerSentSeconds);
        }

        public String toString() {
            return "StickerMetadata.StickerMetadataBuilder(mediaUrl=" + this.mediaUrl + ", mediaSha256=" + Arrays.toString(this.mediaSha256) + ", mediaEncryptedSha256=" + Arrays.toString(this.mediaEncryptedSha256) + ", mediaKey=" + Arrays.toString(this.mediaKey) + ", mimetype=" + this.mimetype + ", height=" + this.height + ", width=" + this.width + ", mediaDirectPath=" + this.mediaDirectPath + ", mediaSize=" + this.mediaSize + ", weight=" + this.weight + ", lastStickerSentSeconds=" + this.lastStickerSentSeconds + ")";
        }
    }
}

