/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.session;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.model.signal.session.SessionChain;
import it.auties.whatsapp.model.signal.session.SessionPreKey;
import java.util.Arrays;
import java.util.HexFormat;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;

@JsonDeserialize(builder=SessionStateBuilder.class)
public class SessionState {
    private final int version;
    private final int registrationId;
    private final byte @NonNull [] baseKey;
    private final byte @NonNull [] remoteIdentityKey;
    @NonNull
    private final ConcurrentHashMap<String, SessionChain> chains;
    private byte @NonNull [] rootKey;
    private SessionPreKey pendingPreKey;
    @NonNull
    private SignalKeyPair ephemeralKeyPair;
    private byte @NonNull [] lastRemoteEphemeralKey;
    private int previousCounter;
    private boolean closed;

    public boolean hasChain(byte[] senderEphemeral) {
        return this.chains.containsKey(HexFormat.of().formatHex(senderEphemeral));
    }

    public Optional<SessionChain> findChain(byte[] senderEphemeral) {
        return Optional.ofNullable(this.chains.get(HexFormat.of().formatHex(senderEphemeral)));
    }

    public SessionState addChain(byte[] senderEphemeral, SessionChain chain) {
        this.chains.put(HexFormat.of().formatHex(senderEphemeral), chain);
        return this;
    }

    public void removeChain(byte[] senderEphemeral) {
        Objects.requireNonNull(this.chains.remove(HexFormat.of().formatHex(senderEphemeral)), "Cannot remove chain");
    }

    public boolean hasPreKey() {
        return this.pendingPreKey != null;
    }

    public int hashCode() {
        return Objects.hash(this.version(), Arrays.hashCode(this.baseKey()));
    }

    public boolean equals(Object other) {
        SessionState that;
        return other instanceof SessionState && this.contentEquals((that = (SessionState)other).version(), that.baseKey());
    }

    public boolean contentEquals(int version, byte[] baseKey) {
        return this.version() == version && Arrays.equals(this.baseKey(), baseKey);
    }

    private static ConcurrentHashMap<String, SessionChain> $default$chains() {
        return new ConcurrentHashMap<String, SessionChain>();
    }

    public static SessionStateBuilder builder() {
        return new SessionStateBuilder();
    }

    public SessionState(int version, int registrationId, byte @NonNull [] baseKey, byte @NonNull [] remoteIdentityKey, @NonNull ConcurrentHashMap<String, SessionChain> chains, byte @NonNull [] rootKey, SessionPreKey pendingPreKey, @NonNull SignalKeyPair ephemeralKeyPair, byte @NonNull [] lastRemoteEphemeralKey, int previousCounter, boolean closed) {
        if (chains == null) {
            throw new NullPointerException("chains is marked non-null but is null");
        }
        if (ephemeralKeyPair == null) {
            throw new NullPointerException("ephemeralKeyPair is marked non-null but is null");
        }
        if (baseKey == null) {
            throw new NullPointerException("baseKey is marked non-null but is null");
        }
        if (remoteIdentityKey == null) {
            throw new NullPointerException("remoteIdentityKey is marked non-null but is null");
        }
        if (rootKey == null) {
            throw new NullPointerException("rootKey is marked non-null but is null");
        }
        if (lastRemoteEphemeralKey == null) {
            throw new NullPointerException("lastRemoteEphemeralKey is marked non-null but is null");
        }
        this.version = version;
        this.registrationId = registrationId;
        this.baseKey = baseKey;
        this.remoteIdentityKey = remoteIdentityKey;
        this.chains = chains;
        this.rootKey = rootKey;
        this.pendingPreKey = pendingPreKey;
        this.ephemeralKeyPair = ephemeralKeyPair;
        this.lastRemoteEphemeralKey = lastRemoteEphemeralKey;
        this.previousCounter = previousCounter;
        this.closed = closed;
    }

    public int version() {
        return this.version;
    }

    public int registrationId() {
        return this.registrationId;
    }

    public byte @NonNull [] baseKey() {
        return this.baseKey;
    }

    public byte @NonNull [] remoteIdentityKey() {
        return this.remoteIdentityKey;
    }

    public byte @NonNull [] rootKey() {
        return this.rootKey;
    }

    public SessionState rootKey(byte @NonNull [] rootKey) {
        if (rootKey == null) {
            throw new NullPointerException("rootKey is marked non-null but is null");
        }
        this.rootKey = rootKey;
        return this;
    }

    public SessionPreKey pendingPreKey() {
        return this.pendingPreKey;
    }

    public SessionState pendingPreKey(SessionPreKey pendingPreKey) {
        this.pendingPreKey = pendingPreKey;
        return this;
    }

    @NonNull
    public SignalKeyPair ephemeralKeyPair() {
        return this.ephemeralKeyPair;
    }

    public SessionState ephemeralKeyPair(@NonNull SignalKeyPair ephemeralKeyPair) {
        if (ephemeralKeyPair == null) {
            throw new NullPointerException("ephemeralKeyPair is marked non-null but is null");
        }
        this.ephemeralKeyPair = ephemeralKeyPair;
        return this;
    }

    public byte @NonNull [] lastRemoteEphemeralKey() {
        return this.lastRemoteEphemeralKey;
    }

    public SessionState lastRemoteEphemeralKey(byte @NonNull [] lastRemoteEphemeralKey) {
        if (lastRemoteEphemeralKey == null) {
            throw new NullPointerException("lastRemoteEphemeralKey is marked non-null but is null");
        }
        this.lastRemoteEphemeralKey = lastRemoteEphemeralKey;
        return this;
    }

    public int previousCounter() {
        return this.previousCounter;
    }

    public SessionState previousCounter(int previousCounter) {
        this.previousCounter = previousCounter;
        return this;
    }

    public boolean closed() {
        return this.closed;
    }

    public SessionState closed(boolean closed) {
        this.closed = closed;
        return this;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class SessionStateBuilder {
        private int version;
        private int registrationId;
        private byte @NonNull [] baseKey;
        private byte @NonNull [] remoteIdentityKey;
        private boolean chains$set;
        private ConcurrentHashMap<String, SessionChain> chains$value;
        private byte @NonNull [] rootKey;
        private SessionPreKey pendingPreKey;
        private SignalKeyPair ephemeralKeyPair;
        private byte @NonNull [] lastRemoteEphemeralKey;
        private int previousCounter;
        private boolean closed;

        SessionStateBuilder() {
        }

        public SessionStateBuilder version(int version) {
            this.version = version;
            return this;
        }

        public SessionStateBuilder registrationId(int registrationId) {
            this.registrationId = registrationId;
            return this;
        }

        public SessionStateBuilder baseKey(byte @NonNull [] baseKey) {
            if (baseKey == null) {
                throw new NullPointerException("baseKey is marked non-null but is null");
            }
            this.baseKey = baseKey;
            return this;
        }

        public SessionStateBuilder remoteIdentityKey(byte @NonNull [] remoteIdentityKey) {
            if (remoteIdentityKey == null) {
                throw new NullPointerException("remoteIdentityKey is marked non-null but is null");
            }
            this.remoteIdentityKey = remoteIdentityKey;
            return this;
        }

        public SessionStateBuilder chains(@NonNull ConcurrentHashMap<String, SessionChain> chains) {
            if (chains == null) {
                throw new NullPointerException("chains is marked non-null but is null");
            }
            this.chains$value = chains;
            this.chains$set = true;
            return this;
        }

        public SessionStateBuilder rootKey(byte @NonNull [] rootKey) {
            if (rootKey == null) {
                throw new NullPointerException("rootKey is marked non-null but is null");
            }
            this.rootKey = rootKey;
            return this;
        }

        public SessionStateBuilder pendingPreKey(SessionPreKey pendingPreKey) {
            this.pendingPreKey = pendingPreKey;
            return this;
        }

        public SessionStateBuilder ephemeralKeyPair(@NonNull SignalKeyPair ephemeralKeyPair) {
            if (ephemeralKeyPair == null) {
                throw new NullPointerException("ephemeralKeyPair is marked non-null but is null");
            }
            this.ephemeralKeyPair = ephemeralKeyPair;
            return this;
        }

        public SessionStateBuilder lastRemoteEphemeralKey(byte @NonNull [] lastRemoteEphemeralKey) {
            if (lastRemoteEphemeralKey == null) {
                throw new NullPointerException("lastRemoteEphemeralKey is marked non-null but is null");
            }
            this.lastRemoteEphemeralKey = lastRemoteEphemeralKey;
            return this;
        }

        public SessionStateBuilder previousCounter(int previousCounter) {
            this.previousCounter = previousCounter;
            return this;
        }

        public SessionStateBuilder closed(boolean closed) {
            this.closed = closed;
            return this;
        }

        public SessionState build() {
            ConcurrentHashMap<String, SessionChain> chains$value = this.chains$value;
            if (!this.chains$set) {
                chains$value = SessionState.$default$chains();
            }
            return new SessionState(this.version, this.registrationId, this.baseKey, this.remoteIdentityKey, chains$value, this.rootKey, this.pendingPreKey, this.ephemeralKeyPair, this.lastRemoteEphemeralKey, this.previousCounter, this.closed);
        }

        public String toString() {
            return "SessionState.SessionStateBuilder(version=" + this.version + ", registrationId=" + this.registrationId + ", baseKey=" + this.baseKey + ", remoteIdentityKey=" + this.remoteIdentityKey + ", chains$value=" + this.chains$value + ", rootKey=" + this.rootKey + ", pendingPreKey=" + this.pendingPreKey + ", ephemeralKeyPair=" + this.ephemeralKeyPair + ", lastRemoteEphemeralKey=" + this.lastRemoteEphemeralKey + ", previousCounter=" + this.previousCounter + ", closed=" + this.closed + ")";
        }
    }
}

