/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.session;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;

@JsonDeserialize(builder=SessionChainBuilder.class)
public record SessionChain(AtomicInteger counter, AtomicReference<byte[]> key, ConcurrentHashMap<Integer, byte[]> messageKeys) {
    public SessionChain(int counter, byte @NonNull [] key) {
        this(new AtomicInteger(counter), new AtomicReference<byte[]>(key), new ConcurrentHashMap<Integer, byte[]>());
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
    }

    public boolean hasMessageKey(int counter) {
        return this.messageKeys.containsKey(counter);
    }

    public static SessionChainBuilder builder() {
        return new SessionChainBuilder();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class SessionChainBuilder {
        private AtomicInteger counter;
        private AtomicReference<byte[]> key;
        private ConcurrentHashMap<Integer, byte[]> messageKeys;

        SessionChainBuilder() {
        }

        public SessionChainBuilder counter(AtomicInteger counter) {
            this.counter = counter;
            return this;
        }

        public SessionChainBuilder key(AtomicReference<byte[]> key) {
            this.key = key;
            return this;
        }

        public SessionChainBuilder messageKeys(ConcurrentHashMap<Integer, byte[]> messageKeys) {
            this.messageKeys = messageKeys;
            return this;
        }

        public SessionChain build() {
            return new SessionChain(this.counter, this.key, this.messageKeys);
        }

        public String toString() {
            return "SessionChain.SessionChainBuilder(counter=" + this.counter + ", key=" + this.key + ", messageKeys=" + this.messageKeys + ")";
        }
    }
}

