/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.request;

import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.model.info.MessageInfo;
import java.util.List;
import java.util.Map;

public record MessageSendRequest(MessageInfo info, List<ContactJid> recipients, boolean force, boolean peer, Map<String, Object> additionalAttributes) {
    public static MessageSendRequest of(MessageInfo info) {
        return MessageSendRequest.builder().info(info).build();
    }

    public boolean hasRecipientOverride() {
        return this.recipients != null && !this.recipients.isEmpty();
    }

    public static MessageSendRequestBuilder builder() {
        return new MessageSendRequestBuilder();
    }

    public static class MessageSendRequestBuilder {
        private MessageInfo info;
        private List<ContactJid> recipients;
        private boolean force;
        private boolean peer;
        private Map<String, Object> additionalAttributes;

        MessageSendRequestBuilder() {
        }

        public MessageSendRequestBuilder info(MessageInfo info) {
            this.info = info;
            return this;
        }

        public MessageSendRequestBuilder recipients(List<ContactJid> recipients) {
            this.recipients = recipients;
            return this;
        }

        public MessageSendRequestBuilder force(boolean force) {
            this.force = force;
            return this;
        }

        public MessageSendRequestBuilder peer(boolean peer) {
            this.peer = peer;
            return this;
        }

        public MessageSendRequestBuilder additionalAttributes(Map<String, Object> additionalAttributes) {
            this.additionalAttributes = additionalAttributes;
            return this;
        }

        public MessageSendRequest build() {
            return new MessageSendRequest(this.info, this.recipients, this.force, this.peer, this.additionalAttributes);
        }

        public String toString() {
            return "MessageSendRequest.MessageSendRequestBuilder(info=" + this.info + ", recipients=" + this.recipients + ", force=" + this.force + ", peer=" + this.peer + ", additionalAttributes=" + this.additionalAttributes + ")";
        }
    }
}

