/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.privacy;

import it.auties.whatsapp.model.privacy.PrivacySettingValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;

public enum PrivacySettingType {
    LAST_SEEN("last", Set.of(PrivacySettingValue.EVERYONE, PrivacySettingValue.CONTACTS, PrivacySettingValue.CONTACTS_EXCEPT, PrivacySettingValue.NOBODY)),
    ONLINE("online", Set.of(PrivacySettingValue.EVERYONE, PrivacySettingValue.MATCH_LAST_SEEN)),
    PROFILE_PIC("profile", Set.of(PrivacySettingValue.EVERYONE, PrivacySettingValue.CONTACTS, PrivacySettingValue.CONTACTS_EXCEPT, PrivacySettingValue.NOBODY)),
    STATUS("status", Set.of(PrivacySettingValue.EVERYONE, PrivacySettingValue.CONTACTS, PrivacySettingValue.CONTACTS_EXCEPT, PrivacySettingValue.NOBODY)),
    ADD_ME_TO_GROUPS("groupadd", Set.of(PrivacySettingValue.EVERYONE, PrivacySettingValue.CONTACTS, PrivacySettingValue.CONTACTS_EXCEPT)),
    READ_RECEIPTS("readreceipts", Set.of(PrivacySettingValue.EVERYONE, PrivacySettingValue.NOBODY)),
    CALL_ADD("calladd", Set.of(PrivacySettingValue.EVERYONE));

    private final String data;
    private final Set<PrivacySettingValue> values;

    public static Optional<PrivacySettingType> of(String id) {
        return Arrays.stream(PrivacySettingType.values()).filter(entry -> Objects.equals(entry.data(), id)).findFirst();
    }

    public Set<PrivacySettingValue> supportedValues() {
        return Collections.unmodifiableSet(this.values);
    }

    public boolean isSupported(@NonNull PrivacySettingValue value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.values.contains((Object)value);
    }

    private PrivacySettingType(String data, Set<PrivacySettingValue> values) {
        this.data = data;
        this.values = values;
    }

    public String data() {
        return this.data;
    }
}

