/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufName;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.crypto.Sha256;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.model.contact.ContactJidProvider;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.message.model.ContextualMessage;
import it.auties.whatsapp.model.message.model.MessageCategory;
import it.auties.whatsapp.model.message.model.MessageType;
import it.auties.whatsapp.model.poll.PollOption;
import it.auties.whatsapp.util.KeyHelper;
import it.auties.whatsapp.util.Validate;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;

@ProtobufName(value="PollCreationMessage")
@JsonDeserialize(builder=PollCreationMessageBuilderImpl.class)
public final class PollCreationMessage
extends ContextualMessage {
    @ProtobufProperty(index=2, name="name", type=ProtobufType.STRING)
    private String title;
    @ProtobufProperty(implementation=PollOption.class, index=3, name="options", repeated=true, type=ProtobufType.MESSAGE)
    private List<PollOption> selectableOptions;
    @ProtobufProperty(index=4, name="selectableOptionsCount", type=ProtobufType.UINT32)
    private int selectableOptionsCount;
    private Map<String, PollOption> selectableOptionsHashesMap;
    private Map<ContactJid, List<PollOption>> selectedOptionsMap;
    @ProtobufProperty(index=1, name="encKey", type=ProtobufType.BYTES)
    private byte[] encryptionKey;
    @ProtobufProperty(index=5, name="contextInfo", type=ProtobufType.MESSAGE)
    private ContextInfo contextInfo;

    public static PollCreationMessage of(@NonNull String title, @NonNull List<PollOption> selectableOptions) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (selectableOptions == null) {
            throw new NullPointerException("selectableOptions is marked non-null but is null");
        }
        Validate.isTrue(!title.isBlank(), "Title cannot be empty", new Object[0]);
        Validate.isTrue(selectableOptions.size() > 1, "Options must have at least two entries", new Object[0]);
        return ((PollCreationMessageBuilder)((PollCreationMessageBuilder)PollCreationMessage.builder().encryptionKey(KeyHelper.senderKey())).title(title)).selectableOptions(selectableOptions).build();
    }

    public List<PollOption> selectedOptions(@NonNull ContactJidProvider contact) {
        if (contact == null) {
            throw new NullPointerException("contact is marked non-null but is null");
        }
        return Optional.of(this.selectedOptionsMap.get(contact.toJid())).map(Collections::unmodifiableList).orElseGet(List::of);
    }

    @Override
    public MessageType type() {
        return MessageType.POLL_CREATION;
    }

    @Override
    public MessageCategory category() {
        return MessageCategory.STANDARD;
    }

    private static Map<String, PollOption> $default$selectableOptionsHashesMap() {
        return new ConcurrentHashMap<String, PollOption>();
    }

    private static Map<ContactJid, List<PollOption>> $default$selectedOptionsMap() {
        return new ConcurrentHashMap<ContactJid, List<PollOption>>();
    }

    protected PollCreationMessage(PollCreationMessageBuilder<?, ?> b) {
        super(b);
        this.title = b.title;
        this.selectableOptions = b.selectableOptions;
        this.selectableOptionsCount = b.selectableOptionsCount;
        this.selectableOptionsHashesMap = b.selectableOptionsHashesMap$set ? b.selectableOptionsHashesMap$value : PollCreationMessage.$default$selectableOptionsHashesMap();
        this.selectedOptionsMap = b.selectedOptionsMap$set ? b.selectedOptionsMap$value : PollCreationMessage.$default$selectedOptionsMap();
        this.encryptionKey = b.encryptionKey;
        this.contextInfo = b.contextInfo;
    }

    public static PollCreationMessageBuilder<?, ?> builder() {
        return new PollCreationMessageBuilderImpl();
    }

    public static SimplePollCreationMessageBuilder simpleBuilder() {
        return new SimplePollCreationMessageBuilder();
    }

    public PollCreationMessage(String title, List<PollOption> selectableOptions, int selectableOptionsCount, Map<String, PollOption> selectableOptionsHashesMap, Map<ContactJid, List<PollOption>> selectedOptionsMap, byte[] encryptionKey, ContextInfo contextInfo) {
        this.title = title;
        this.selectableOptions = selectableOptions;
        this.selectableOptionsCount = selectableOptionsCount;
        this.selectableOptionsHashesMap = selectableOptionsHashesMap;
        this.selectedOptionsMap = selectedOptionsMap;
        this.encryptionKey = encryptionKey;
        this.contextInfo = contextInfo;
    }

    public String title() {
        return this.title;
    }

    public List<PollOption> selectableOptions() {
        return this.selectableOptions;
    }

    public int selectableOptionsCount() {
        return this.selectableOptionsCount;
    }

    public Map<String, PollOption> selectableOptionsHashesMap() {
        return this.selectableOptionsHashesMap;
    }

    public Map<ContactJid, List<PollOption>> selectedOptionsMap() {
        return this.selectedOptionsMap;
    }

    public byte[] encryptionKey() {
        return this.encryptionKey;
    }

    @Override
    public ContextInfo contextInfo() {
        return this.contextInfo;
    }

    public PollCreationMessage title(String title) {
        this.title = title;
        return this;
    }

    public PollCreationMessage selectableOptions(List<PollOption> selectableOptions) {
        this.selectableOptions = selectableOptions;
        return this;
    }

    public PollCreationMessage selectableOptionsCount(int selectableOptionsCount) {
        this.selectableOptionsCount = selectableOptionsCount;
        return this;
    }

    public PollCreationMessage selectableOptionsHashesMap(Map<String, PollOption> selectableOptionsHashesMap) {
        this.selectableOptionsHashesMap = selectableOptionsHashesMap;
        return this;
    }

    public PollCreationMessage selectedOptionsMap(Map<ContactJid, List<PollOption>> selectedOptionsMap) {
        this.selectedOptionsMap = selectedOptionsMap;
        return this;
    }

    public PollCreationMessage encryptionKey(byte[] encryptionKey) {
        this.encryptionKey = encryptionKey;
        return this;
    }

    @Override
    public PollCreationMessage contextInfo(ContextInfo contextInfo) {
        this.contextInfo = contextInfo;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PollCreationMessage)) {
            return false;
        }
        PollCreationMessage other = (PollCreationMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.selectableOptionsCount() != other.selectableOptionsCount()) {
            return false;
        }
        String this$title = this.title();
        String other$title = other.title();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        List<PollOption> this$selectableOptions = this.selectableOptions();
        List<PollOption> other$selectableOptions = other.selectableOptions();
        if (this$selectableOptions == null ? other$selectableOptions != null : !((Object)this$selectableOptions).equals(other$selectableOptions)) {
            return false;
        }
        Map<String, PollOption> this$selectableOptionsHashesMap = this.selectableOptionsHashesMap();
        Map<String, PollOption> other$selectableOptionsHashesMap = other.selectableOptionsHashesMap();
        if (this$selectableOptionsHashesMap == null ? other$selectableOptionsHashesMap != null : !((Object)this$selectableOptionsHashesMap).equals(other$selectableOptionsHashesMap)) {
            return false;
        }
        Map<ContactJid, List<PollOption>> this$selectedOptionsMap = this.selectedOptionsMap();
        Map<ContactJid, List<PollOption>> other$selectedOptionsMap = other.selectedOptionsMap();
        if (this$selectedOptionsMap == null ? other$selectedOptionsMap != null : !((Object)this$selectedOptionsMap).equals(other$selectedOptionsMap)) {
            return false;
        }
        if (!Arrays.equals(this.encryptionKey(), other.encryptionKey())) {
            return false;
        }
        ContextInfo this$contextInfo = this.contextInfo();
        ContextInfo other$contextInfo = other.contextInfo();
        return !(this$contextInfo == null ? other$contextInfo != null : !((Object)this$contextInfo).equals(other$contextInfo));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PollCreationMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.selectableOptionsCount();
        String $title = this.title();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        List<PollOption> $selectableOptions = this.selectableOptions();
        result = result * 59 + ($selectableOptions == null ? 43 : ((Object)$selectableOptions).hashCode());
        Map<String, PollOption> $selectableOptionsHashesMap = this.selectableOptionsHashesMap();
        result = result * 59 + ($selectableOptionsHashesMap == null ? 43 : ((Object)$selectableOptionsHashesMap).hashCode());
        Map<ContactJid, List<PollOption>> $selectedOptionsMap = this.selectedOptionsMap();
        result = result * 59 + ($selectedOptionsMap == null ? 43 : ((Object)$selectedOptionsMap).hashCode());
        result = result * 59 + Arrays.hashCode(this.encryptionKey());
        ContextInfo $contextInfo = this.contextInfo();
        result = result * 59 + ($contextInfo == null ? 43 : ((Object)$contextInfo).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "PollCreationMessage(super=" + super.toString() + ", title=" + this.title() + ", selectableOptions=" + this.selectableOptions() + ", selectableOptionsCount=" + this.selectableOptionsCount() + ", selectedOptionsMap=" + this.selectedOptionsMap() + ", encryptionKey=" + Arrays.toString(this.encryptionKey()) + ", contextInfo=" + this.contextInfo() + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        if (this.contextInfo != null) {
            protobufOutputStream.writeBytes(17, this.contextInfo.toEncodedProtobuf());
        }
        if (this.selectableOptions != null) {
            for (PollOption pollOption : this.selectableOptions) {
                protobufOutputStream.writeBytes(3, pollOption.toEncodedProtobuf());
            }
        }
        if (this.title != null) {
            protobufOutputStream.writeString(2, this.title);
        }
        protobufOutputStream.writeUInt32(4, this.selectableOptionsCount);
        if (this.encryptionKey != null) {
            protobufOutputStream.writeBytes(1, this.encryptionKey);
        }
        if (this.contextInfo != null) {
            protobufOutputStream.writeBytes(5, this.contextInfo.toEncodedProtobuf());
        }
        return protobufOutputStream.toByteArray();
    }

    public static PollCreationMessage ofProtobuf(byte[] byArray) {
        int n;
        PollCreationMessageBuilder<?, ?> pollCreationMessageBuilder = PollCreationMessage.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        ArrayList<PollOption> arrayList = new ArrayList<PollOption>();
        block8: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 17: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    pollCreationMessageBuilder.contextInfo(ContextInfo.ofProtobuf(protobufInputStream.readBytes()));
                    continue block8;
                }
                case 3: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    arrayList.add(PollOption.ofProtobuf(protobufInputStream.readBytes()));
                    continue block8;
                }
                case 2: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    pollCreationMessageBuilder.title(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block8;
                }
                case 4: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    pollCreationMessageBuilder.selectableOptionsCount(protobufInputStream.readInt32());
                    continue block8;
                }
                case 1: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    pollCreationMessageBuilder.encryptionKey(protobufInputStream.readBytes());
                    continue block8;
                }
                case 5: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    pollCreationMessageBuilder.contextInfo(ContextInfo.ofProtobuf(protobufInputStream.readBytes()));
                    continue block8;
                }
            }
            protobufInputStream.readBytes();
        }
        pollCreationMessageBuilder.selectableOptions(arrayList);
        return pollCreationMessageBuilder.build();
    }

    public static abstract class PollCreationMessageBuilder<C extends PollCreationMessage, B extends PollCreationMessageBuilder<C, B>>
    extends ContextualMessage.ContextualMessageBuilder<C, B> {
        private String title;
        private List<PollOption> selectableOptions;
        private int selectableOptionsCount;
        private boolean selectableOptionsHashesMap$set;
        private Map<String, PollOption> selectableOptionsHashesMap$value;
        private boolean selectedOptionsMap$set;
        private Map<ContactJid, List<PollOption>> selectedOptionsMap$value;
        private byte[] encryptionKey;
        private ContextInfo contextInfo;

        public PollCreationMessageBuilder<C, B> selectableOptions(List<PollOption> selectableOptions) {
            if (this.selectableOptions == null) {
                this.selectableOptions = new ArrayList<PollOption>();
            }
            this.selectableOptionsHashesMap$set = true;
            if (this.selectableOptionsHashesMap$value == null) {
                this.selectableOptionsHashesMap$value = new HashMap<String, PollOption>();
            }
            selectableOptions.forEach(entry -> {
                String sha256 = HexFormat.of().formatHex(Sha256.calculate(entry.name()));
                this.selectableOptionsHashesMap$value.put(sha256, (PollOption)entry);
            });
            this.selectableOptions.addAll(selectableOptions);
            this.selectableOptionsCount = selectableOptions.size();
            return this;
        }

        public B title(String title) {
            this.title = title;
            return (B)this.self();
        }

        public B selectableOptionsCount(int selectableOptionsCount) {
            this.selectableOptionsCount = selectableOptionsCount;
            return (B)this.self();
        }

        public B selectableOptionsHashesMap(Map<String, PollOption> selectableOptionsHashesMap) {
            this.selectableOptionsHashesMap$value = selectableOptionsHashesMap;
            this.selectableOptionsHashesMap$set = true;
            return (B)this.self();
        }

        public B selectedOptionsMap(Map<ContactJid, List<PollOption>> selectedOptionsMap) {
            this.selectedOptionsMap$value = selectedOptionsMap;
            this.selectedOptionsMap$set = true;
            return (B)this.self();
        }

        public B encryptionKey(byte[] encryptionKey) {
            this.encryptionKey = encryptionKey;
            return (B)this.self();
        }

        @Override
        public B contextInfo(ContextInfo contextInfo) {
            this.contextInfo = contextInfo;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "PollCreationMessage.PollCreationMessageBuilder(super=" + super.toString() + ", title=" + this.title + ", selectableOptions=" + this.selectableOptions + ", selectableOptionsCount=" + this.selectableOptionsCount + ", selectableOptionsHashesMap$value=" + this.selectableOptionsHashesMap$value + ", selectedOptionsMap$value=" + this.selectedOptionsMap$value + ", encryptionKey=" + Arrays.toString(this.encryptionKey) + ", contextInfo=" + this.contextInfo + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class PollCreationMessageBuilderImpl
    extends PollCreationMessageBuilder<PollCreationMessage, PollCreationMessageBuilderImpl> {
        private PollCreationMessageBuilderImpl() {
        }

        @Override
        protected PollCreationMessageBuilderImpl self() {
            return this;
        }

        @Override
        public PollCreationMessage build() {
            return new PollCreationMessage(this);
        }
    }

    public static class SimplePollCreationMessageBuilder {
        private String title;
        private List<PollOption> selectableOptions;

        SimplePollCreationMessageBuilder() {
        }

        public SimplePollCreationMessageBuilder title(@NonNull String title) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            this.title = title;
            return this;
        }

        public SimplePollCreationMessageBuilder selectableOptions(@NonNull List<PollOption> selectableOptions) {
            if (selectableOptions == null) {
                throw new NullPointerException("selectableOptions is marked non-null but is null");
            }
            this.selectableOptions = selectableOptions;
            return this;
        }

        public PollCreationMessage build() {
            return PollCreationMessage.of(this.title, this.selectableOptions);
        }

        public String toString() {
            return "PollCreationMessage.SimplePollCreationMessageBuilder(title=" + this.title + ", selectableOptions=" + this.selectableOptions + ")";
        }
    }
}

