/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.button.template.hsm.HighlyStructuredFourRowTemplateTitle;
import it.auties.whatsapp.model.button.template.hsm.HighlyStructuredFourRowTemplateTitleType;
import it.auties.whatsapp.model.button.template.hydrated.HydratedFourRowTemplateTitle;
import it.auties.whatsapp.model.button.template.hydrated.HydratedFourRowTemplateTitleType;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.interactive.InteractiveHeaderAttachment;
import it.auties.whatsapp.model.location.InteractiveLocationAnnotation;
import it.auties.whatsapp.model.media.MediaDimensions;
import it.auties.whatsapp.model.message.button.ButtonsMessageHeader;
import it.auties.whatsapp.model.message.model.ContextualMessage;
import it.auties.whatsapp.model.message.model.MediaMessage;
import it.auties.whatsapp.model.message.model.MediaMessageType;
import it.auties.whatsapp.util.Clock;
import it.auties.whatsapp.util.Medias;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=ImageMessageBuilderImpl.class)
public final class ImageMessage
extends MediaMessage
implements InteractiveHeaderAttachment,
ButtonsMessageHeader,
HighlyStructuredFourRowTemplateTitle,
HydratedFourRowTemplateTitle {
    @ProtobufProperty(index=1, type=ProtobufType.STRING)
    private String mediaUrl;
    @ProtobufProperty(index=2, type=ProtobufType.STRING)
    private String mimetype;
    @ProtobufProperty(index=3, type=ProtobufType.STRING)
    private String caption;
    @ProtobufProperty(index=4, type=ProtobufType.BYTES)
    private byte[] mediaSha256;
    @ProtobufProperty(index=5, type=ProtobufType.UINT64)
    private long mediaSize;
    @ProtobufProperty(index=6, type=ProtobufType.UINT32)
    private Integer height;
    @ProtobufProperty(index=7, type=ProtobufType.UINT32)
    private Integer width;
    @ProtobufProperty(index=8, type=ProtobufType.BYTES)
    private byte[] mediaKey;
    @ProtobufProperty(index=9, type=ProtobufType.BYTES)
    private byte[] mediaEncryptedSha256;
    @ProtobufProperty(index=10, type=ProtobufType.MESSAGE, implementation=InteractiveLocationAnnotation.class, repeated=true)
    private List<InteractiveLocationAnnotation> interactiveAnnotations;
    @ProtobufProperty(index=11, type=ProtobufType.STRING)
    private String mediaDirectPath;
    @ProtobufProperty(index=12, type=ProtobufType.UINT64)
    private long mediaKeyTimestamp;
    @ProtobufProperty(index=16, type=ProtobufType.BYTES)
    private byte[] thumbnail;
    @ProtobufProperty(index=18, type=ProtobufType.BYTES)
    private byte[] firstScanSidecar;
    @ProtobufProperty(index=19, type=ProtobufType.UINT32)
    private Integer firstScanLength;
    @ProtobufProperty(index=20, type=ProtobufType.UINT32)
    private Integer experimentGroupId;
    @ProtobufProperty(index=21, type=ProtobufType.BYTES)
    private byte[] scansSidecar;
    @ProtobufProperty(index=22, type=ProtobufType.UINT32, repeated=true)
    private List<Integer> scanLengths;
    @ProtobufProperty(index=23, type=ProtobufType.BYTES)
    private byte[] midQualityFileSha256;
    @ProtobufProperty(index=24, type=ProtobufType.BYTES)
    private byte[] midQualityFileEncSha256;
    @ProtobufProperty(index=25, name="viewOnce", type=ProtobufType.BOOL)
    private boolean viewOnce;
    @ProtobufProperty(index=26, name="thumbnailDirectPath", type=ProtobufType.STRING)
    private String thumbnailDirectPath;
    @ProtobufProperty(index=27, name="thumbnailSha256", type=ProtobufType.BYTES)
    private byte[] thumbnailSha256;
    @ProtobufProperty(index=28, name="thumbnailEncSha256", type=ProtobufType.BYTES)
    private byte[] thumbnailEncSha256;
    @ProtobufProperty(index=29, name="staticUrl", type=ProtobufType.STRING)
    private String staticUrl;

    private static ImageMessage customBuilder(byte[] media, String mimeType, String caption, byte[] thumbnail, ContextInfo contextInfo) {
        MediaDimensions dimensions = Medias.getDimensions(media, false);
        return ((ImageMessageBuilder)((ContextualMessage.ContextualMessageBuilder)((ImageMessageBuilder)((ImageMessageBuilder)((ImageMessageBuilder)((ImageMessageBuilder)((ImageMessageBuilder)((ImageMessageBuilder)ImageMessage.builder().decodedMedia(media)).mediaKeyTimestamp(Clock.nowSeconds())).mimetype(Objects.requireNonNullElse(mimeType, MediaMessageType.IMAGE.defaultMimeType()))).caption(caption)).width(dimensions.width())).height(dimensions.height())).thumbnail(thumbnail != null ? thumbnail : (byte[])Medias.getThumbnail(media, Medias.Format.JPG).orElse(null))).contextInfo(Objects.requireNonNullElseGet(contextInfo, ContextInfo::new))).build();
    }

    @Override
    public MediaMessageType mediaType() {
        return MediaMessageType.IMAGE;
    }

    @Override
    public HighlyStructuredFourRowTemplateTitleType titleType() {
        return HighlyStructuredFourRowTemplateTitleType.IMAGE;
    }

    @Override
    public HydratedFourRowTemplateTitleType hydratedTitleType() {
        return HydratedFourRowTemplateTitleType.IMAGE;
    }

    protected ImageMessage(ImageMessageBuilder<?, ?> b) {
        super((MediaMessage.MediaMessageBuilder<?, ?>)b);
        this.mediaUrl = b.mediaUrl;
        this.mimetype = b.mimetype;
        this.caption = b.caption;
        this.mediaSha256 = b.mediaSha256;
        this.mediaSize = b.mediaSize;
        this.height = b.height;
        this.width = b.width;
        this.mediaKey = b.mediaKey;
        this.mediaEncryptedSha256 = b.mediaEncryptedSha256;
        this.interactiveAnnotations = b.interactiveAnnotations;
        this.mediaDirectPath = b.mediaDirectPath;
        this.mediaKeyTimestamp = b.mediaKeyTimestamp;
        this.thumbnail = b.thumbnail;
        this.firstScanSidecar = b.firstScanSidecar;
        this.firstScanLength = b.firstScanLength;
        this.experimentGroupId = b.experimentGroupId;
        this.scansSidecar = b.scansSidecar;
        this.scanLengths = b.scanLengths;
        this.midQualityFileSha256 = b.midQualityFileSha256;
        this.midQualityFileEncSha256 = b.midQualityFileEncSha256;
        this.viewOnce = b.viewOnce;
        this.thumbnailDirectPath = b.thumbnailDirectPath;
        this.thumbnailSha256 = b.thumbnailSha256;
        this.thumbnailEncSha256 = b.thumbnailEncSha256;
        this.staticUrl = b.staticUrl;
    }

    public static ImageMessageBuilder<?, ?> builder() {
        return new ImageMessageBuilderImpl();
    }

    public static SimpleImageBuilder simpleBuilder() {
        return new SimpleImageBuilder();
    }

    public ImageMessage(String mediaUrl, String mimetype, String caption, byte[] mediaSha256, long mediaSize, Integer height, Integer width, byte[] mediaKey, byte[] mediaEncryptedSha256, List<InteractiveLocationAnnotation> interactiveAnnotations, String mediaDirectPath, long mediaKeyTimestamp, byte[] thumbnail, byte[] firstScanSidecar, Integer firstScanLength, Integer experimentGroupId, byte[] scansSidecar, List<Integer> scanLengths, byte[] midQualityFileSha256, byte[] midQualityFileEncSha256, boolean viewOnce, String thumbnailDirectPath, byte[] thumbnailSha256, byte[] thumbnailEncSha256, String staticUrl) {
        this.mediaUrl = mediaUrl;
        this.mimetype = mimetype;
        this.caption = caption;
        this.mediaSha256 = mediaSha256;
        this.mediaSize = mediaSize;
        this.height = height;
        this.width = width;
        this.mediaKey = mediaKey;
        this.mediaEncryptedSha256 = mediaEncryptedSha256;
        this.interactiveAnnotations = interactiveAnnotations;
        this.mediaDirectPath = mediaDirectPath;
        this.mediaKeyTimestamp = mediaKeyTimestamp;
        this.thumbnail = thumbnail;
        this.firstScanSidecar = firstScanSidecar;
        this.firstScanLength = firstScanLength;
        this.experimentGroupId = experimentGroupId;
        this.scansSidecar = scansSidecar;
        this.scanLengths = scanLengths;
        this.midQualityFileSha256 = midQualityFileSha256;
        this.midQualityFileEncSha256 = midQualityFileEncSha256;
        this.viewOnce = viewOnce;
        this.thumbnailDirectPath = thumbnailDirectPath;
        this.thumbnailSha256 = thumbnailSha256;
        this.thumbnailEncSha256 = thumbnailEncSha256;
        this.staticUrl = staticUrl;
    }

    public ImageMessage() {
    }

    @Override
    public String mediaUrl() {
        return this.mediaUrl;
    }

    public String mimetype() {
        return this.mimetype;
    }

    public String caption() {
        return this.caption;
    }

    @Override
    public byte[] mediaSha256() {
        return this.mediaSha256;
    }

    @Override
    public long mediaSize() {
        return this.mediaSize;
    }

    public Integer height() {
        return this.height;
    }

    public Integer width() {
        return this.width;
    }

    @Override
    public byte[] mediaKey() {
        return this.mediaKey;
    }

    @Override
    public byte[] mediaEncryptedSha256() {
        return this.mediaEncryptedSha256;
    }

    public List<InteractiveLocationAnnotation> interactiveAnnotations() {
        return this.interactiveAnnotations;
    }

    @Override
    public String mediaDirectPath() {
        return this.mediaDirectPath;
    }

    @Override
    public long mediaKeyTimestamp() {
        return this.mediaKeyTimestamp;
    }

    public byte[] thumbnail() {
        return this.thumbnail;
    }

    public byte[] firstScanSidecar() {
        return this.firstScanSidecar;
    }

    public Integer firstScanLength() {
        return this.firstScanLength;
    }

    public Integer experimentGroupId() {
        return this.experimentGroupId;
    }

    public byte[] scansSidecar() {
        return this.scansSidecar;
    }

    public List<Integer> scanLengths() {
        return this.scanLengths;
    }

    public byte[] midQualityFileSha256() {
        return this.midQualityFileSha256;
    }

    public byte[] midQualityFileEncSha256() {
        return this.midQualityFileEncSha256;
    }

    public boolean viewOnce() {
        return this.viewOnce;
    }

    public String thumbnailDirectPath() {
        return this.thumbnailDirectPath;
    }

    public byte[] thumbnailSha256() {
        return this.thumbnailSha256;
    }

    public byte[] thumbnailEncSha256() {
        return this.thumbnailEncSha256;
    }

    public String staticUrl() {
        return this.staticUrl;
    }

    @Override
    public ImageMessage mediaUrl(String mediaUrl) {
        this.mediaUrl = mediaUrl;
        return this;
    }

    public ImageMessage mimetype(String mimetype) {
        this.mimetype = mimetype;
        return this;
    }

    public ImageMessage caption(String caption) {
        this.caption = caption;
        return this;
    }

    @Override
    public ImageMessage mediaSha256(byte[] mediaSha256) {
        this.mediaSha256 = mediaSha256;
        return this;
    }

    @Override
    public ImageMessage mediaSize(long mediaSize) {
        this.mediaSize = mediaSize;
        return this;
    }

    public ImageMessage height(Integer height) {
        this.height = height;
        return this;
    }

    public ImageMessage width(Integer width) {
        this.width = width;
        return this;
    }

    @Override
    public ImageMessage mediaKey(byte[] mediaKey) {
        this.mediaKey = mediaKey;
        return this;
    }

    @Override
    public ImageMessage mediaEncryptedSha256(byte[] mediaEncryptedSha256) {
        this.mediaEncryptedSha256 = mediaEncryptedSha256;
        return this;
    }

    public ImageMessage interactiveAnnotations(List<InteractiveLocationAnnotation> interactiveAnnotations) {
        this.interactiveAnnotations = interactiveAnnotations;
        return this;
    }

    @Override
    public ImageMessage mediaDirectPath(String mediaDirectPath) {
        this.mediaDirectPath = mediaDirectPath;
        return this;
    }

    public ImageMessage mediaKeyTimestamp(long mediaKeyTimestamp) {
        this.mediaKeyTimestamp = mediaKeyTimestamp;
        return this;
    }

    public ImageMessage thumbnail(byte[] thumbnail) {
        this.thumbnail = thumbnail;
        return this;
    }

    public ImageMessage firstScanSidecar(byte[] firstScanSidecar) {
        this.firstScanSidecar = firstScanSidecar;
        return this;
    }

    public ImageMessage firstScanLength(Integer firstScanLength) {
        this.firstScanLength = firstScanLength;
        return this;
    }

    public ImageMessage experimentGroupId(Integer experimentGroupId) {
        this.experimentGroupId = experimentGroupId;
        return this;
    }

    public ImageMessage scansSidecar(byte[] scansSidecar) {
        this.scansSidecar = scansSidecar;
        return this;
    }

    public ImageMessage scanLengths(List<Integer> scanLengths) {
        this.scanLengths = scanLengths;
        return this;
    }

    public ImageMessage midQualityFileSha256(byte[] midQualityFileSha256) {
        this.midQualityFileSha256 = midQualityFileSha256;
        return this;
    }

    public ImageMessage midQualityFileEncSha256(byte[] midQualityFileEncSha256) {
        this.midQualityFileEncSha256 = midQualityFileEncSha256;
        return this;
    }

    public ImageMessage viewOnce(boolean viewOnce) {
        this.viewOnce = viewOnce;
        return this;
    }

    public ImageMessage thumbnailDirectPath(String thumbnailDirectPath) {
        this.thumbnailDirectPath = thumbnailDirectPath;
        return this;
    }

    public ImageMessage thumbnailSha256(byte[] thumbnailSha256) {
        this.thumbnailSha256 = thumbnailSha256;
        return this;
    }

    public ImageMessage thumbnailEncSha256(byte[] thumbnailEncSha256) {
        this.thumbnailEncSha256 = thumbnailEncSha256;
        return this;
    }

    public ImageMessage staticUrl(String staticUrl) {
        this.staticUrl = staticUrl;
        return this;
    }

    @Override
    public String toString() {
        return "ImageMessage(super=" + super.toString() + ", mediaUrl=" + this.mediaUrl() + ", mimetype=" + this.mimetype() + ", caption=" + this.caption() + ", mediaSha256=" + Arrays.toString(this.mediaSha256()) + ", mediaSize=" + this.mediaSize() + ", height=" + this.height() + ", width=" + this.width() + ", mediaKey=" + Arrays.toString(this.mediaKey()) + ", mediaEncryptedSha256=" + Arrays.toString(this.mediaEncryptedSha256()) + ", interactiveAnnotations=" + this.interactiveAnnotations() + ", mediaDirectPath=" + this.mediaDirectPath() + ", mediaKeyTimestamp=" + this.mediaKeyTimestamp() + ", thumbnail=" + Arrays.toString(this.thumbnail()) + ", firstScanSidecar=" + Arrays.toString(this.firstScanSidecar()) + ", firstScanLength=" + this.firstScanLength() + ", experimentGroupId=" + this.experimentGroupId() + ", scansSidecar=" + Arrays.toString(this.scansSidecar()) + ", scanLengths=" + this.scanLengths() + ", midQualityFileSha256=" + Arrays.toString(this.midQualityFileSha256()) + ", midQualityFileEncSha256=" + Arrays.toString(this.midQualityFileEncSha256()) + ", viewOnce=" + this.viewOnce() + ", thumbnailDirectPath=" + this.thumbnailDirectPath() + ", thumbnailSha256=" + Arrays.toString(this.thumbnailSha256()) + ", thumbnailEncSha256=" + Arrays.toString(this.thumbnailEncSha256()) + ", staticUrl=" + this.staticUrl() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageMessage)) {
            return false;
        }
        ImageMessage other = (ImageMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.mediaSize() != other.mediaSize()) {
            return false;
        }
        if (this.mediaKeyTimestamp() != other.mediaKeyTimestamp()) {
            return false;
        }
        if (this.viewOnce() != other.viewOnce()) {
            return false;
        }
        Integer this$height = this.height();
        Integer other$height = other.height();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Integer this$width = this.width();
        Integer other$width = other.width();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Integer this$firstScanLength = this.firstScanLength();
        Integer other$firstScanLength = other.firstScanLength();
        if (this$firstScanLength == null ? other$firstScanLength != null : !((Object)this$firstScanLength).equals(other$firstScanLength)) {
            return false;
        }
        Integer this$experimentGroupId = this.experimentGroupId();
        Integer other$experimentGroupId = other.experimentGroupId();
        if (this$experimentGroupId == null ? other$experimentGroupId != null : !((Object)this$experimentGroupId).equals(other$experimentGroupId)) {
            return false;
        }
        String this$mediaUrl = this.mediaUrl();
        String other$mediaUrl = other.mediaUrl();
        if (this$mediaUrl == null ? other$mediaUrl != null : !this$mediaUrl.equals(other$mediaUrl)) {
            return false;
        }
        String this$mimetype = this.mimetype();
        String other$mimetype = other.mimetype();
        if (this$mimetype == null ? other$mimetype != null : !this$mimetype.equals(other$mimetype)) {
            return false;
        }
        String this$caption = this.caption();
        String other$caption = other.caption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        if (!Arrays.equals(this.mediaSha256(), other.mediaSha256())) {
            return false;
        }
        if (!Arrays.equals(this.mediaKey(), other.mediaKey())) {
            return false;
        }
        if (!Arrays.equals(this.mediaEncryptedSha256(), other.mediaEncryptedSha256())) {
            return false;
        }
        List<InteractiveLocationAnnotation> this$interactiveAnnotations = this.interactiveAnnotations();
        List<InteractiveLocationAnnotation> other$interactiveAnnotations = other.interactiveAnnotations();
        if (this$interactiveAnnotations == null ? other$interactiveAnnotations != null : !((Object)this$interactiveAnnotations).equals(other$interactiveAnnotations)) {
            return false;
        }
        String this$mediaDirectPath = this.mediaDirectPath();
        String other$mediaDirectPath = other.mediaDirectPath();
        if (this$mediaDirectPath == null ? other$mediaDirectPath != null : !this$mediaDirectPath.equals(other$mediaDirectPath)) {
            return false;
        }
        if (!Arrays.equals(this.thumbnail(), other.thumbnail())) {
            return false;
        }
        if (!Arrays.equals(this.firstScanSidecar(), other.firstScanSidecar())) {
            return false;
        }
        if (!Arrays.equals(this.scansSidecar(), other.scansSidecar())) {
            return false;
        }
        List<Integer> this$scanLengths = this.scanLengths();
        List<Integer> other$scanLengths = other.scanLengths();
        if (this$scanLengths == null ? other$scanLengths != null : !((Object)this$scanLengths).equals(other$scanLengths)) {
            return false;
        }
        if (!Arrays.equals(this.midQualityFileSha256(), other.midQualityFileSha256())) {
            return false;
        }
        if (!Arrays.equals(this.midQualityFileEncSha256(), other.midQualityFileEncSha256())) {
            return false;
        }
        String this$thumbnailDirectPath = this.thumbnailDirectPath();
        String other$thumbnailDirectPath = other.thumbnailDirectPath();
        if (this$thumbnailDirectPath == null ? other$thumbnailDirectPath != null : !this$thumbnailDirectPath.equals(other$thumbnailDirectPath)) {
            return false;
        }
        if (!Arrays.equals(this.thumbnailSha256(), other.thumbnailSha256())) {
            return false;
        }
        if (!Arrays.equals(this.thumbnailEncSha256(), other.thumbnailEncSha256())) {
            return false;
        }
        String this$staticUrl = this.staticUrl();
        String other$staticUrl = other.staticUrl();
        return !(this$staticUrl == null ? other$staticUrl != null : !this$staticUrl.equals(other$staticUrl));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ImageMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $mediaSize = this.mediaSize();
        result = result * 59 + (int)($mediaSize >>> 32 ^ $mediaSize);
        long $mediaKeyTimestamp = this.mediaKeyTimestamp();
        result = result * 59 + (int)($mediaKeyTimestamp >>> 32 ^ $mediaKeyTimestamp);
        result = result * 59 + (this.viewOnce() ? 79 : 97);
        Integer $height = this.height();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Integer $width = this.width();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Integer $firstScanLength = this.firstScanLength();
        result = result * 59 + ($firstScanLength == null ? 43 : ((Object)$firstScanLength).hashCode());
        Integer $experimentGroupId = this.experimentGroupId();
        result = result * 59 + ($experimentGroupId == null ? 43 : ((Object)$experimentGroupId).hashCode());
        String $mediaUrl = this.mediaUrl();
        result = result * 59 + ($mediaUrl == null ? 43 : $mediaUrl.hashCode());
        String $mimetype = this.mimetype();
        result = result * 59 + ($mimetype == null ? 43 : $mimetype.hashCode());
        String $caption = this.caption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        result = result * 59 + Arrays.hashCode(this.mediaSha256());
        result = result * 59 + Arrays.hashCode(this.mediaKey());
        result = result * 59 + Arrays.hashCode(this.mediaEncryptedSha256());
        List<InteractiveLocationAnnotation> $interactiveAnnotations = this.interactiveAnnotations();
        result = result * 59 + ($interactiveAnnotations == null ? 43 : ((Object)$interactiveAnnotations).hashCode());
        String $mediaDirectPath = this.mediaDirectPath();
        result = result * 59 + ($mediaDirectPath == null ? 43 : $mediaDirectPath.hashCode());
        result = result * 59 + Arrays.hashCode(this.thumbnail());
        result = result * 59 + Arrays.hashCode(this.firstScanSidecar());
        result = result * 59 + Arrays.hashCode(this.scansSidecar());
        List<Integer> $scanLengths = this.scanLengths();
        result = result * 59 + ($scanLengths == null ? 43 : ((Object)$scanLengths).hashCode());
        result = result * 59 + Arrays.hashCode(this.midQualityFileSha256());
        result = result * 59 + Arrays.hashCode(this.midQualityFileEncSha256());
        String $thumbnailDirectPath = this.thumbnailDirectPath();
        result = result * 59 + ($thumbnailDirectPath == null ? 43 : $thumbnailDirectPath.hashCode());
        result = result * 59 + Arrays.hashCode(this.thumbnailSha256());
        result = result * 59 + Arrays.hashCode(this.thumbnailEncSha256());
        String $staticUrl = this.staticUrl();
        result = result * 59 + ($staticUrl == null ? 43 : $staticUrl.hashCode());
        return result;
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        if (this.interactiveAnnotations != null) {
            for (InteractiveLocationAnnotation interactiveLocationAnnotation : this.interactiveAnnotations) {
                protobufOutputStream.writeBytes(10, interactiveLocationAnnotation.toEncodedProtobuf());
            }
        }
        if (this.firstScanLength != null) {
            protobufOutputStream.writeUInt32(19, this.firstScanLength);
        }
        if (this.midQualityFileEncSha256 != null) {
            protobufOutputStream.writeBytes(24, this.midQualityFileEncSha256);
        }
        if (this.thumbnail != null) {
            protobufOutputStream.writeBytes(16, this.thumbnail);
        }
        if (this.width != null) {
            protobufOutputStream.writeUInt32(7, this.width);
        }
        if (this.mediaUrl != null) {
            protobufOutputStream.writeString(1, this.mediaUrl);
        }
        if (this.mimetype != null) {
            protobufOutputStream.writeString(2, this.mimetype);
        }
        if (this.scansSidecar != null) {
            protobufOutputStream.writeBytes(21, this.scansSidecar);
        }
        if (this.thumbnailDirectPath != null) {
            protobufOutputStream.writeString(26, this.thumbnailDirectPath);
        }
        if (this.thumbnailEncSha256 != null) {
            protobufOutputStream.writeBytes(28, this.thumbnailEncSha256);
        }
        protobufOutputStream.writeUInt64(12, this.mediaKeyTimestamp);
        if (this.firstScanSidecar != null) {
            protobufOutputStream.writeBytes(18, this.firstScanSidecar);
        }
        if (this.mediaDirectPath != null) {
            protobufOutputStream.writeString(11, this.mediaDirectPath);
        }
        protobufOutputStream.writeBool(25, this.viewOnce);
        if (this.caption != null) {
            protobufOutputStream.writeString(3, this.caption);
        }
        if (this.mediaSha256 != null) {
            protobufOutputStream.writeBytes(4, this.mediaSha256);
        }
        if (this.height != null) {
            protobufOutputStream.writeUInt32(6, this.height);
        }
        if (this.midQualityFileSha256 != null) {
            protobufOutputStream.writeBytes(23, this.midQualityFileSha256);
        }
        protobufOutputStream.writeUInt64(5, this.mediaSize);
        if (this.experimentGroupId != null) {
            protobufOutputStream.writeUInt32(20, this.experimentGroupId);
        }
        if (this.thumbnailSha256 != null) {
            protobufOutputStream.writeBytes(27, this.thumbnailSha256);
        }
        if (this.mediaEncryptedSha256 != null) {
            protobufOutputStream.writeBytes(9, this.mediaEncryptedSha256);
        }
        if (this.staticUrl != null) {
            protobufOutputStream.writeString(29, this.staticUrl);
        }
        if (this.scanLengths != null) {
            for (Integer n : this.scanLengths) {
                protobufOutputStream.writeUInt32(22, n);
            }
        }
        if (this.mediaKey != null) {
            protobufOutputStream.writeBytes(8, this.mediaKey);
        }
        if (this.contextInfo != null) {
            protobufOutputStream.writeBytes(17, this.contextInfo.toEncodedProtobuf());
        }
        return protobufOutputStream.toByteArray();
    }

    public static ImageMessage ofProtobuf(byte[] byArray) {
        int n;
        ImageMessageBuilder<?, ?> imageMessageBuilder = ImageMessage.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        ArrayList<InteractiveLocationAnnotation> arrayList = new ArrayList<InteractiveLocationAnnotation>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            block0 : switch (n2) {
                case 10: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    arrayList.add(InteractiveLocationAnnotation.ofProtobuf(protobufInputStream.readBytes()));
                    break;
                }
                case 19: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    imageMessageBuilder.firstScanLength(protobufInputStream.readInt32());
                    break;
                }
                case 24: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    imageMessageBuilder.midQualityFileEncSha256(protobufInputStream.readBytes());
                    break;
                }
                case 16: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    imageMessageBuilder.thumbnail(protobufInputStream.readBytes());
                    break;
                }
                case 7: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    imageMessageBuilder.width(protobufInputStream.readInt32());
                    break;
                }
                case 1: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    imageMessageBuilder.mediaUrl(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    break;
                }
                case 2: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    imageMessageBuilder.mimetype(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    break;
                }
                case 21: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    imageMessageBuilder.scansSidecar(protobufInputStream.readBytes());
                    break;
                }
                case 26: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    imageMessageBuilder.thumbnailDirectPath(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    break;
                }
                case 28: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    imageMessageBuilder.thumbnailEncSha256(protobufInputStream.readBytes());
                    break;
                }
                case 12: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    imageMessageBuilder.mediaKeyTimestamp(protobufInputStream.readInt64());
                    break;
                }
                case 18: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    imageMessageBuilder.firstScanSidecar(protobufInputStream.readBytes());
                    break;
                }
                case 11: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    imageMessageBuilder.mediaDirectPath(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    break;
                }
                case 25: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    imageMessageBuilder.viewOnce(protobufInputStream.readBool());
                    break;
                }
                case 3: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    imageMessageBuilder.caption(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    break;
                }
                case 4: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    imageMessageBuilder.mediaSha256(protobufInputStream.readBytes());
                    break;
                }
                case 6: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    imageMessageBuilder.height(protobufInputStream.readInt32());
                    break;
                }
                case 23: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    imageMessageBuilder.midQualityFileSha256(protobufInputStream.readBytes());
                    break;
                }
                case 5: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    imageMessageBuilder.mediaSize(protobufInputStream.readInt64());
                    break;
                }
                case 20: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    imageMessageBuilder.experimentGroupId(protobufInputStream.readInt32());
                    break;
                }
                case 27: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    imageMessageBuilder.thumbnailSha256(protobufInputStream.readBytes());
                    break;
                }
                case 9: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    imageMessageBuilder.mediaEncryptedSha256(protobufInputStream.readBytes());
                    break;
                }
                case 29: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    imageMessageBuilder.staticUrl(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    break;
                }
                case 22: {
                    switch (n3) {
                        case 2: {
                            arrayList2.addAll(protobufInputStream.readInt32Packed());
                            break block0;
                        }
                        case 0: {
                            arrayList2.add(protobufInputStream.readInt32());
                            break block0;
                        }
                    }
                    throw ProtobufDeserializationException.invalidTag((int)n3);
                }
                case 8: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    imageMessageBuilder.mediaKey(protobufInputStream.readBytes());
                    break;
                }
                case 17: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    imageMessageBuilder.contextInfo(ContextInfo.ofProtobuf(protobufInputStream.readBytes()));
                    break;
                }
                default: {
                    protobufInputStream.readBytes();
                    break;
                }
            }
        }
        imageMessageBuilder.interactiveAnnotations(arrayList);
        imageMessageBuilder.scanLengths(arrayList2);
        return imageMessageBuilder.build();
    }

    public static abstract class ImageMessageBuilder<C extends ImageMessage, B extends ImageMessageBuilder<C, B>>
    extends MediaMessage.MediaMessageBuilder<C, B> {
        private String mediaUrl;
        private String mimetype;
        private String caption;
        private byte[] mediaSha256;
        private long mediaSize;
        private Integer height;
        private Integer width;
        private byte[] mediaKey;
        private byte[] mediaEncryptedSha256;
        private List<InteractiveLocationAnnotation> interactiveAnnotations;
        private String mediaDirectPath;
        private long mediaKeyTimestamp;
        private byte[] thumbnail;
        private byte[] firstScanSidecar;
        private Integer firstScanLength;
        private Integer experimentGroupId;
        private byte[] scansSidecar;
        private List<Integer> scanLengths;
        private byte[] midQualityFileSha256;
        private byte[] midQualityFileEncSha256;
        private boolean viewOnce;
        private String thumbnailDirectPath;
        private byte[] thumbnailSha256;
        private byte[] thumbnailEncSha256;
        private String staticUrl;

        public B mediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
            return (B)this.self();
        }

        public B mimetype(String mimetype) {
            this.mimetype = mimetype;
            return (B)this.self();
        }

        public B caption(String caption) {
            this.caption = caption;
            return (B)this.self();
        }

        public B mediaSha256(byte[] mediaSha256) {
            this.mediaSha256 = mediaSha256;
            return (B)this.self();
        }

        public B mediaSize(long mediaSize) {
            this.mediaSize = mediaSize;
            return (B)this.self();
        }

        public B height(Integer height) {
            this.height = height;
            return (B)this.self();
        }

        public B width(Integer width) {
            this.width = width;
            return (B)this.self();
        }

        public B mediaKey(byte[] mediaKey) {
            this.mediaKey = mediaKey;
            return (B)this.self();
        }

        public B mediaEncryptedSha256(byte[] mediaEncryptedSha256) {
            this.mediaEncryptedSha256 = mediaEncryptedSha256;
            return (B)this.self();
        }

        public B interactiveAnnotations(List<InteractiveLocationAnnotation> interactiveAnnotations) {
            this.interactiveAnnotations = interactiveAnnotations;
            return (B)this.self();
        }

        public B mediaDirectPath(String mediaDirectPath) {
            this.mediaDirectPath = mediaDirectPath;
            return (B)this.self();
        }

        public B mediaKeyTimestamp(long mediaKeyTimestamp) {
            this.mediaKeyTimestamp = mediaKeyTimestamp;
            return (B)this.self();
        }

        public B thumbnail(byte[] thumbnail) {
            this.thumbnail = thumbnail;
            return (B)this.self();
        }

        public B firstScanSidecar(byte[] firstScanSidecar) {
            this.firstScanSidecar = firstScanSidecar;
            return (B)this.self();
        }

        public B firstScanLength(Integer firstScanLength) {
            this.firstScanLength = firstScanLength;
            return (B)this.self();
        }

        public B experimentGroupId(Integer experimentGroupId) {
            this.experimentGroupId = experimentGroupId;
            return (B)this.self();
        }

        public B scansSidecar(byte[] scansSidecar) {
            this.scansSidecar = scansSidecar;
            return (B)this.self();
        }

        public B scanLengths(List<Integer> scanLengths) {
            this.scanLengths = scanLengths;
            return (B)this.self();
        }

        public B midQualityFileSha256(byte[] midQualityFileSha256) {
            this.midQualityFileSha256 = midQualityFileSha256;
            return (B)this.self();
        }

        public B midQualityFileEncSha256(byte[] midQualityFileEncSha256) {
            this.midQualityFileEncSha256 = midQualityFileEncSha256;
            return (B)this.self();
        }

        public B viewOnce(boolean viewOnce) {
            this.viewOnce = viewOnce;
            return (B)this.self();
        }

        public B thumbnailDirectPath(String thumbnailDirectPath) {
            this.thumbnailDirectPath = thumbnailDirectPath;
            return (B)this.self();
        }

        public B thumbnailSha256(byte[] thumbnailSha256) {
            this.thumbnailSha256 = thumbnailSha256;
            return (B)this.self();
        }

        public B thumbnailEncSha256(byte[] thumbnailEncSha256) {
            this.thumbnailEncSha256 = thumbnailEncSha256;
            return (B)this.self();
        }

        public B staticUrl(String staticUrl) {
            this.staticUrl = staticUrl;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ImageMessage.ImageMessageBuilder(super=" + super.toString() + ", mediaUrl=" + this.mediaUrl + ", mimetype=" + this.mimetype + ", caption=" + this.caption + ", mediaSha256=" + Arrays.toString(this.mediaSha256) + ", mediaSize=" + this.mediaSize + ", height=" + this.height + ", width=" + this.width + ", mediaKey=" + Arrays.toString(this.mediaKey) + ", mediaEncryptedSha256=" + Arrays.toString(this.mediaEncryptedSha256) + ", interactiveAnnotations=" + this.interactiveAnnotations + ", mediaDirectPath=" + this.mediaDirectPath + ", mediaKeyTimestamp=" + this.mediaKeyTimestamp + ", thumbnail=" + Arrays.toString(this.thumbnail) + ", firstScanSidecar=" + Arrays.toString(this.firstScanSidecar) + ", firstScanLength=" + this.firstScanLength + ", experimentGroupId=" + this.experimentGroupId + ", scansSidecar=" + Arrays.toString(this.scansSidecar) + ", scanLengths=" + this.scanLengths + ", midQualityFileSha256=" + Arrays.toString(this.midQualityFileSha256) + ", midQualityFileEncSha256=" + Arrays.toString(this.midQualityFileEncSha256) + ", viewOnce=" + this.viewOnce + ", thumbnailDirectPath=" + this.thumbnailDirectPath + ", thumbnailSha256=" + Arrays.toString(this.thumbnailSha256) + ", thumbnailEncSha256=" + Arrays.toString(this.thumbnailEncSha256) + ", staticUrl=" + this.staticUrl + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class ImageMessageBuilderImpl
    extends ImageMessageBuilder<ImageMessage, ImageMessageBuilderImpl> {
        private ImageMessageBuilderImpl() {
        }

        @Override
        protected ImageMessageBuilderImpl self() {
            return this;
        }

        @Override
        public ImageMessage build() {
            return new ImageMessage(this);
        }
    }

    public static class SimpleImageBuilder {
        private byte[] media;
        private String mimeType;
        private String caption;
        private byte[] thumbnail;
        private ContextInfo contextInfo;

        SimpleImageBuilder() {
        }

        public SimpleImageBuilder media(byte[] media) {
            this.media = media;
            return this;
        }

        public SimpleImageBuilder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public SimpleImageBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public SimpleImageBuilder thumbnail(byte[] thumbnail) {
            this.thumbnail = thumbnail;
            return this;
        }

        public SimpleImageBuilder contextInfo(ContextInfo contextInfo) {
            this.contextInfo = contextInfo;
            return this;
        }

        public ImageMessage build() {
            return ImageMessage.customBuilder(this.media, this.mimeType, this.caption, this.thumbnail, this.contextInfo);
        }

        public String toString() {
            return "ImageMessage.SimpleImageBuilder(media=" + Arrays.toString(this.media) + ", mimeType=" + this.mimeType + ", caption=" + this.caption + ", thumbnail=" + Arrays.toString(this.thumbnail) + ", contextInfo=" + this.contextInfo + ")";
        }
    }
}

