/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.model;

import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.contact.Contact;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.message.model.MessageContainer;
import it.auties.whatsapp.model.message.model.MessageMetadataProvider;
import java.util.Objects;
import java.util.Optional;
import lombok.NonNull;

public final class QuotedMessage
implements MessageMetadataProvider {
    @NonNull
    private final String id;
    @NonNull
    private final Chat chat;
    private final Contact sender;
    @NonNull
    private final MessageContainer message;

    public static Optional<QuotedMessage> of(@NonNull ContextInfo contextInfo) {
        if (contextInfo == null) {
            throw new NullPointerException("contextInfo is marked non-null but is null");
        }
        if (!contextInfo.hasQuotedMessage()) {
            return Optional.empty();
        }
        String id = contextInfo.quotedMessageId().get();
        Chat chat = contextInfo.quotedMessageChat().get();
        Contact sender = contextInfo.quotedMessageSender().orElse(null);
        MessageContainer message = contextInfo.quotedMessage().get();
        return Optional.of(new QuotedMessage(id, chat, sender, message));
    }

    @Override
    public ContactJid senderJid() {
        return Objects.requireNonNullElseGet(this.sender.jid(), this.chat::jid);
    }

    @Override
    public Optional<Contact> sender() {
        return Optional.ofNullable(this.sender);
    }

    @Override
    @NonNull
    public String id() {
        return this.id;
    }

    @Override
    @NonNull
    public Chat chat() {
        return this.chat;
    }

    @Override
    @NonNull
    public MessageContainer message() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuotedMessage)) {
            return false;
        }
        QuotedMessage other = (QuotedMessage)o;
        String this$id = this.id();
        String other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Chat this$chat = this.chat();
        Chat other$chat = other.chat();
        if (this$chat == null ? other$chat != null : !((Object)this$chat).equals(other$chat)) {
            return false;
        }
        Optional<Contact> this$sender = this.sender();
        Optional<Contact> other$sender = other.sender();
        if (this$sender == null ? other$sender != null : !((Object)this$sender).equals(other$sender)) {
            return false;
        }
        MessageContainer this$message = this.message();
        MessageContainer other$message = other.message();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Chat $chat = this.chat();
        result = result * 59 + ($chat == null ? 43 : ((Object)$chat).hashCode());
        Optional<Contact> $sender = this.sender();
        result = result * 59 + ($sender == null ? 43 : ((Object)$sender).hashCode());
        MessageContainer $message = this.message();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "QuotedMessage(id=" + this.id() + ", chat=" + this.chat() + ", sender=" + this.sender() + ", message=" + this.message() + ")";
    }

    public QuotedMessage(@NonNull String id, @NonNull Chat chat, Contact sender, @NonNull MessageContainer message) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.id = id;
        this.chat = chat;
        this.sender = sender;
        this.message = message;
    }
}

