/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.model;

import it.auties.whatsapp.model.media.AttachmentProvider;
import it.auties.whatsapp.model.media.AttachmentType;
import it.auties.whatsapp.model.message.model.ContextualMessage;
import it.auties.whatsapp.model.message.model.MediaMessageType;
import it.auties.whatsapp.model.message.model.MessageCategory;
import it.auties.whatsapp.model.message.model.MessageType;
import it.auties.whatsapp.util.Medias;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Optional;
import lombok.NonNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class MediaMessage
extends ContextualMessage
implements AttachmentProvider {
    private byte[] decodedMedia;

    public Path save(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        try {
            byte[] data = this.decodedMedia().orElseThrow(() -> new NoSuchElementException("Cannot save a media that wasn't decoded correctly"));
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, data, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            return path;
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot write media to file", exception);
        }
    }

    public Optional<byte[]> decodedMedia() {
        if (this.decodedMedia == null) {
            this.decodedMedia = Medias.download(this).join().orElse(null);
        }
        return Optional.ofNullable(this.decodedMedia);
    }

    public abstract long mediaKeyTimestamp();

    @Override
    public MessageCategory category() {
        return MessageCategory.MEDIA;
    }

    public abstract MediaMessageType mediaType();

    @Override
    public MessageType type() {
        return this.mediaType().toMessageType();
    }

    @Override
    public AttachmentType attachmentType() {
        return this.mediaType().toAttachmentType();
    }

    protected MediaMessage(MediaMessageBuilder<?, ?> b) {
        super(b);
        this.decodedMedia = b.decodedMedia;
    }

    public MediaMessage(byte[] decodedMedia) {
        this.decodedMedia = decodedMedia;
    }

    public MediaMessage() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MediaMessage)) {
            return false;
        }
        MediaMessage other = (MediaMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Optional<byte[]> this$decodedMedia = this.decodedMedia();
        Optional<byte[]> other$decodedMedia = other.decodedMedia();
        return !(this$decodedMedia == null ? other$decodedMedia != null : !((Object)this$decodedMedia).equals(other$decodedMedia));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MediaMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Optional<byte[]> $decodedMedia = this.decodedMedia();
        result = result * 59 + ($decodedMedia == null ? 43 : ((Object)$decodedMedia).hashCode());
        return result;
    }

    public static abstract class MediaMessageBuilder<C extends MediaMessage, B extends MediaMessageBuilder<C, B>>
    extends ContextualMessage.ContextualMessageBuilder<C, B> {
        private byte[] decodedMedia;

        public B decodedMedia(byte[] decodedMedia) {
            this.decodedMedia = decodedMedia;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "MediaMessage.MediaMessageBuilder(super=" + super.toString() + ", decodedMedia=" + Arrays.toString(this.decodedMedia) + ")";
        }
    }
}

