/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.button;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufMessage;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.button.base.Button;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.MessageInfo;
import it.auties.whatsapp.model.message.button.ButtonsMessage;
import it.auties.whatsapp.model.message.model.ButtonReplyMessage;
import it.auties.whatsapp.model.message.model.MessageType;
import it.auties.whatsapp.util.Validate;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import lombok.NonNull;

@JsonDeserialize(builder=ButtonsResponseMessageBuilderImpl.class)
public final class ButtonsResponseMessage
extends ButtonReplyMessage {
    @ProtobufProperty(index=1, type=ProtobufType.STRING)
    private String buttonId;
    @ProtobufProperty(index=2, type=ProtobufType.STRING)
    private String buttonText;
    @ProtobufProperty(index=3, type=ProtobufType.MESSAGE, implementation=ContextInfo.class)
    private ContextInfo contextInfo;
    @ProtobufProperty(index=4, name="type", type=ProtobufType.MESSAGE)
    private ResponseType responseType;

    public static ButtonsResponseMessage of(@NonNull MessageInfo quoted, @NonNull Button button) {
        if (quoted == null) {
            throw new NullPointerException("quoted is marked non-null but is null");
        }
        if (button == null) {
            throw new NullPointerException("button is marked non-null but is null");
        }
        Validate.isTrue(quoted.message().content() instanceof ButtonsMessage, "Cannot select buttons message, erroneous type: %s" + quoted.message().content(), new Object[0]);
        return ((ButtonsResponseMessageBuilder)((ButtonsResponseMessageBuilder)((ButtonsResponseMessageBuilder)ButtonsResponseMessage.builder().buttonId(button.id())).buttonText(button.bodyText().content())).contextInfo(ContextInfo.of(quoted))).build();
    }

    @Override
    public MessageType type() {
        return MessageType.BUTTONS_RESPONSE;
    }

    public ResponseType responseType() {
        if (this.buttonText != null) {
            return ResponseType.SELECTED_DISPLAY_TEXT;
        }
        return ResponseType.UNKNOWN;
    }

    protected ButtonsResponseMessage(ButtonsResponseMessageBuilder<?, ?> b) {
        super((ButtonReplyMessage.ButtonReplyMessageBuilder<?, ?>)b);
        this.buttonId = b.buttonId;
        this.buttonText = b.buttonText;
        this.contextInfo = b.contextInfo;
        this.responseType = b.responseType;
    }

    public static ButtonsResponseMessageBuilder<?, ?> builder() {
        return new ButtonsResponseMessageBuilderImpl();
    }

    public ButtonsResponseMessage(String buttonId, String buttonText, ContextInfo contextInfo, ResponseType responseType) {
        this.buttonId = buttonId;
        this.buttonText = buttonText;
        this.contextInfo = contextInfo;
        this.responseType = responseType;
    }

    public ButtonsResponseMessage() {
    }

    public String buttonId() {
        return this.buttonId;
    }

    public String buttonText() {
        return this.buttonText;
    }

    @Override
    public ContextInfo contextInfo() {
        return this.contextInfo;
    }

    public ButtonsResponseMessage buttonId(String buttonId) {
        this.buttonId = buttonId;
        return this;
    }

    public ButtonsResponseMessage buttonText(String buttonText) {
        this.buttonText = buttonText;
        return this;
    }

    @Override
    public ButtonsResponseMessage contextInfo(ContextInfo contextInfo) {
        this.contextInfo = contextInfo;
        return this;
    }

    public ButtonsResponseMessage responseType(ResponseType responseType) {
        this.responseType = responseType;
        return this;
    }

    @Override
    public String toString() {
        return "ButtonsResponseMessage(super=" + super.toString() + ", buttonId=" + this.buttonId() + ", buttonText=" + this.buttonText() + ", contextInfo=" + this.contextInfo() + ", responseType=" + this.responseType() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ButtonsResponseMessage)) {
            return false;
        }
        ButtonsResponseMessage other = (ButtonsResponseMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$buttonId = this.buttonId();
        String other$buttonId = other.buttonId();
        if (this$buttonId == null ? other$buttonId != null : !this$buttonId.equals(other$buttonId)) {
            return false;
        }
        String this$buttonText = this.buttonText();
        String other$buttonText = other.buttonText();
        if (this$buttonText == null ? other$buttonText != null : !this$buttonText.equals(other$buttonText)) {
            return false;
        }
        ContextInfo this$contextInfo = this.contextInfo();
        ContextInfo other$contextInfo = other.contextInfo();
        if (this$contextInfo == null ? other$contextInfo != null : !((Object)this$contextInfo).equals(other$contextInfo)) {
            return false;
        }
        ResponseType this$responseType = this.responseType();
        ResponseType other$responseType = other.responseType();
        return !(this$responseType == null ? other$responseType != null : !((Object)((Object)this$responseType)).equals((Object)other$responseType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ButtonsResponseMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $buttonId = this.buttonId();
        result = result * 59 + ($buttonId == null ? 43 : $buttonId.hashCode());
        String $buttonText = this.buttonText();
        result = result * 59 + ($buttonText == null ? 43 : $buttonText.hashCode());
        ContextInfo $contextInfo = this.contextInfo();
        result = result * 59 + ($contextInfo == null ? 43 : ((Object)$contextInfo).hashCode());
        ResponseType $responseType = this.responseType();
        result = result * 59 + ($responseType == null ? 43 : ((Object)((Object)$responseType)).hashCode());
        return result;
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        if (this.buttonText != null) {
            protobufOutputStream.writeString(2, this.buttonText);
        }
        if (this.contextInfo != null) {
            protobufOutputStream.writeBytes(3, this.contextInfo.toEncodedProtobuf());
        }
        if (this.buttonId != null) {
            protobufOutputStream.writeString(1, this.buttonId);
        }
        if (this.responseType != null) {
            protobufOutputStream.writeUInt32(4, this.responseType.index());
        }
        if (this.contextInfo != null) {
            protobufOutputStream.writeBytes(17, this.contextInfo.toEncodedProtobuf());
        }
        return protobufOutputStream.toByteArray();
    }

    public static ButtonsResponseMessage ofProtobuf(byte[] byArray) {
        int n;
        ButtonsResponseMessageBuilder<?, ?> buttonsResponseMessageBuilder = ButtonsResponseMessage.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        block7: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 2: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    buttonsResponseMessageBuilder.buttonText(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block7;
                }
                case 3: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    buttonsResponseMessageBuilder.contextInfo(ContextInfo.ofProtobuf(protobufInputStream.readBytes()));
                    continue block7;
                }
                case 1: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    buttonsResponseMessageBuilder.buttonId(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block7;
                }
                case 4: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    buttonsResponseMessageBuilder.responseType(ResponseType.of(protobufInputStream.readInt32()));
                    continue block7;
                }
                case 17: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    buttonsResponseMessageBuilder.contextInfo(ContextInfo.ofProtobuf(protobufInputStream.readBytes()));
                    continue block7;
                }
            }
            protobufInputStream.readBytes();
        }
        return buttonsResponseMessageBuilder.build();
    }

    public static abstract class ButtonsResponseMessageBuilder<C extends ButtonsResponseMessage, B extends ButtonsResponseMessageBuilder<C, B>>
    extends ButtonReplyMessage.ButtonReplyMessageBuilder<C, B> {
        private String buttonId;
        private String buttonText;
        private ContextInfo contextInfo;
        private ResponseType responseType;

        public B buttonId(String buttonId) {
            this.buttonId = buttonId;
            return (B)this.self();
        }

        public B buttonText(String buttonText) {
            this.buttonText = buttonText;
            return (B)this.self();
        }

        @Override
        public B contextInfo(ContextInfo contextInfo) {
            this.contextInfo = contextInfo;
            return (B)this.self();
        }

        public B responseType(ResponseType responseType) {
            this.responseType = responseType;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ButtonsResponseMessage.ButtonsResponseMessageBuilder(super=" + super.toString() + ", buttonId=" + this.buttonId + ", buttonText=" + this.buttonText + ", contextInfo=" + this.contextInfo + ", responseType=" + this.responseType + ")";
        }
    }

    public static enum ResponseType implements ProtobufMessage
    {
        UNKNOWN(0),
        SELECTED_DISPLAY_TEXT(1);

        private final int index;

        private ResponseType(int index) {
            this.index = index;
        }

        public int index() {
            return this.index;
        }

        public static ResponseType of(byte[] byArray) {
            throw new UnsupportedOperationException();
        }

        public byte[] toEncodedProtobuf() {
            ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
            return protobufOutputStream.toByteArray();
        }

        public static ResponseType of(int n) {
            Iterator iterator = Arrays.stream(ResponseType.values()).iterator();
            while (iterator.hasNext()) {
                ResponseType responseType = (ResponseType)((Object)iterator.next());
                if (responseType.index() != n) continue;
                return responseType;
            }
            return null;
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class ButtonsResponseMessageBuilderImpl
    extends ButtonsResponseMessageBuilder<ButtonsResponseMessage, ButtonsResponseMessageBuilderImpl> {
        private ButtonsResponseMessageBuilderImpl() {
        }

        @Override
        protected ButtonsResponseMessageBuilderImpl self() {
            return this;
        }

        @Override
        public ButtonsResponseMessage build() {
            return new ButtonsResponseMessage(this);
        }
    }
}

