/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.info;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufMessage;
import it.auties.protobuf.base.ProtobufName;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.business.BusinessPrivacyStatus;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.contact.Contact;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.model.info.Info;
import it.auties.whatsapp.model.info.PaymentInfo;
import it.auties.whatsapp.model.media.MediaData;
import it.auties.whatsapp.model.message.model.ContextualMessage;
import it.auties.whatsapp.model.message.model.KeepInChat;
import it.auties.whatsapp.model.message.model.MessageContainer;
import it.auties.whatsapp.model.message.model.MessageKey;
import it.auties.whatsapp.model.message.model.MessageMetadataProvider;
import it.auties.whatsapp.model.message.model.MessageReceipt;
import it.auties.whatsapp.model.message.model.MessageStatus;
import it.auties.whatsapp.model.message.model.PublicServiceAnnouncementStatus;
import it.auties.whatsapp.model.message.model.QuotedMessage;
import it.auties.whatsapp.model.message.standard.LiveLocationMessage;
import it.auties.whatsapp.model.message.standard.ReactionMessage;
import it.auties.whatsapp.model.poll.PollAdditionalMetadata;
import it.auties.whatsapp.model.poll.PollUpdate;
import it.auties.whatsapp.model.sync.PhotoChange;
import it.auties.whatsapp.util.Clock;
import it.auties.whatsapp.util.Json;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.NonNull;

@ProtobufName(value="WebMessageInfo")
@JsonDeserialize(builder=MessageInfoBuilder.class)
public final class MessageInfo
implements Info,
ProtobufMessage,
MessageMetadataProvider {
    @ProtobufProperty(index=1, type=ProtobufType.MESSAGE, implementation=MessageKey.class)
    @NonNull
    private MessageKey key;
    @ProtobufProperty(index=2, type=ProtobufType.MESSAGE, implementation=MessageContainer.class)
    @NonNull
    private MessageContainer message;
    @ProtobufProperty(index=3, type=ProtobufType.UINT64)
    private long timestampSeconds;
    @ProtobufProperty(index=4, type=ProtobufType.MESSAGE, implementation=MessageStatus.class)
    @NonNull
    private MessageStatus status;
    @ProtobufProperty(index=5, type=ProtobufType.STRING)
    private ContactJid senderJid;
    private Contact sender;
    @ProtobufProperty(index=16, type=ProtobufType.BOOL)
    private boolean ignore;
    @ProtobufProperty(index=17, type=ProtobufType.BOOL)
    private boolean starred;
    @ProtobufProperty(index=18, type=ProtobufType.BOOL)
    private boolean broadcast;
    @ProtobufProperty(index=19, type=ProtobufType.STRING)
    private String pushName;
    @ProtobufProperty(index=20, type=ProtobufType.BYTES)
    private byte[] mediaCiphertextSha256;
    @ProtobufProperty(index=21, type=ProtobufType.BOOL)
    private boolean multicast;
    @ProtobufProperty(index=22, type=ProtobufType.BOOL)
    private boolean urlText;
    @ProtobufProperty(index=23, type=ProtobufType.BOOL)
    private boolean urlNumber;
    @ProtobufProperty(index=24, type=ProtobufType.MESSAGE, implementation=StubType.class)
    private StubType stubType;
    @ProtobufProperty(index=25, type=ProtobufType.BOOL)
    private boolean clearMedia;
    @ProtobufProperty(index=26, type=ProtobufType.STRING, repeated=true)
    private List<String> stubParameters;
    @ProtobufProperty(index=27, type=ProtobufType.UINT32)
    private int duration;
    @ProtobufProperty(index=28, type=ProtobufType.STRING, repeated=true)
    private List<String> labels;
    @ProtobufProperty(index=29, type=ProtobufType.MESSAGE, implementation=PaymentInfo.class)
    private PaymentInfo paymentInfo;
    @ProtobufProperty(index=30, type=ProtobufType.MESSAGE, implementation=LiveLocationMessage.class)
    private LiveLocationMessage finalLiveLocation;
    @ProtobufProperty(index=31, type=ProtobufType.MESSAGE, implementation=PaymentInfo.class)
    private PaymentInfo quotedPaymentInfo;
    @ProtobufProperty(index=32, type=ProtobufType.UINT64)
    private long ephemeralStartTimestamp;
    @ProtobufProperty(index=33, type=ProtobufType.UINT32)
    private int ephemeralDuration;
    @ProtobufProperty(index=34, type=ProtobufType.BOOL)
    private boolean enableEphemeral;
    @ProtobufProperty(index=35, type=ProtobufType.BOOL)
    private boolean ephemeralOutOfSync;
    @ProtobufProperty(index=36, type=ProtobufType.MESSAGE, implementation=BusinessPrivacyStatus.class)
    private BusinessPrivacyStatus businessPrivacyStatus;
    @ProtobufProperty(index=37, type=ProtobufType.STRING)
    private String businessVerifiedName;
    @ProtobufProperty(index=38, type=ProtobufType.MESSAGE, implementation=MediaData.class)
    private MediaData mediaData;
    @ProtobufProperty(index=39, type=ProtobufType.MESSAGE, implementation=PhotoChange.class)
    private PhotoChange photoChange;
    @ProtobufProperty(index=40, type=ProtobufType.MESSAGE, implementation=MessageReceipt.class)
    private MessageReceipt receipt;
    @ProtobufProperty(index=41, type=ProtobufType.MESSAGE, implementation=ReactionMessage.class, repeated=true)
    private List<ReactionMessage> reactions;
    @ProtobufProperty(index=42, type=ProtobufType.MESSAGE, implementation=MediaData.class)
    private MediaData quotedStickerData;
    @ProtobufProperty(index=43, type=ProtobufType.BYTES)
    private byte[] futureProofData;
    @ProtobufProperty(index=44, type=ProtobufType.MESSAGE, implementation=PublicServiceAnnouncementStatus.class)
    private PublicServiceAnnouncementStatus psaStatus;
    @ProtobufProperty(index=6, name="messageC2STimestamp", type=ProtobufType.UINT64)
    private long messageC2STimestamp;
    @ProtobufProperty(implementation=PollUpdate.class, index=45, name="pollUpdates", repeated=true, type=ProtobufType.MESSAGE)
    private List<PollUpdate> pollUpdates;
    @ProtobufProperty(index=46, name="pollAdditionalMetadata", type=ProtobufType.MESSAGE)
    private PollAdditionalMetadata pollAdditionalMetadata;
    @ProtobufProperty(index=47, name="agentId", type=ProtobufType.STRING)
    private String agentId;
    @ProtobufProperty(index=48, name="statusAlreadyViewed", type=ProtobufType.BOOL)
    private boolean statusAlreadyViewed;
    @ProtobufProperty(index=49, name="messageSecret", type=ProtobufType.BYTES)
    private byte[] messageSecret;
    @ProtobufProperty(index=50, name="keepInChat", type=ProtobufType.MESSAGE)
    private KeepInChat keepInChat;
    @ProtobufProperty(index=51, name="originalSelfAuthorUserJidString", type=ProtobufType.STRING)
    private ContactJid originalSender;
    @ProtobufProperty(index=52, name="revokeMessageTimestamp", type=ProtobufType.UINT64)
    private long revokeTimestampSeconds;

    public MessageInfo(@NonNull MessageKey key, @NonNull MessageContainer container) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (container == null) {
            throw new NullPointerException("container is marked non-null but is null");
        }
        this.key = key;
        this.timestampSeconds = Clock.nowSeconds();
        this.status = MessageStatus.PENDING;
        this.message = container;
    }

    public boolean fromMe() {
        return this.key.fromMe();
    }

    public String chatName() {
        return this.chat() == null ? this.chatJid().user() : this.chat().name();
    }

    public ContactJid chatJid() {
        return this.key.chatJid();
    }

    public String senderName() {
        return this.sender().map(Contact::name).orElseGet(this.senderJid()::user);
    }

    public Optional<QuotedMessage> quotedMessage() {
        return Optional.of(this.message).flatMap(MessageContainer::contentWithContext).map(ContextualMessage::contextInfo).flatMap(QuotedMessage::of);
    }

    public Optional<String> pushName() {
        return Optional.ofNullable(this.pushName);
    }

    public Optional<String> businessVerifiedName() {
        return Optional.ofNullable(this.businessVerifiedName);
    }

    public Optional<BusinessPrivacyStatus> businessPrivacyStatus() {
        return Optional.ofNullable(this.businessPrivacyStatus);
    }

    public Optional<StubType> stubType() {
        return Optional.ofNullable(this.stubType);
    }

    public Optional<PaymentInfo> paymentInfo() {
        return Optional.ofNullable(this.paymentInfo);
    }

    public Optional<PaymentInfo> quotedPaymentInfo() {
        return Optional.ofNullable(this.quotedPaymentInfo);
    }

    public Optional<byte[]> futureProofData() {
        return Optional.ofNullable(this.futureProofData);
    }

    public Optional<PublicServiceAnnouncementStatus> psaStatus() {
        return Optional.ofNullable(this.psaStatus);
    }

    public ZonedDateTime timestamp() {
        return Clock.parseSeconds(this.timestampSeconds);
    }

    public ZonedDateTime revokeTimestamp() {
        return Clock.parseSeconds(this.revokeTimestampSeconds);
    }

    public Optional<ContactJid> originalSender() {
        return Optional.ofNullable(this.originalSender);
    }

    public Optional<KeepInChat> keepInChat() {
        return Optional.ofNullable(this.keepInChat);
    }

    public Optional<byte[]> messageSecret() {
        return Optional.ofNullable(this.messageSecret);
    }

    public Optional<String> agentId() {
        return Optional.ofNullable(this.agentId);
    }

    public Optional<PollAdditionalMetadata> pollAdditionalMetadata() {
        return Optional.ofNullable(this.pollAdditionalMetadata);
    }

    public String toJson() {
        return Json.writeValueAsString(this, true);
    }

    public boolean hasStub() {
        return this.stubType != null;
    }

    public int hashCode() {
        return Objects.hashCode(this.id());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof MessageInfo)) return false;
        MessageInfo that = (MessageInfo)object;
        if (!Objects.equals(this.id(), that.id())) return false;
        if (!Objects.equals((Object)this.stubType, (Object)that.stubType)) return false;
        return true;
    }

    @Override
    public String id() {
        return this.key.id();
    }

    @Override
    public Chat chat() {
        return this.key.chat();
    }

    @Override
    public ContactJid senderJid() {
        return Objects.requireNonNullElseGet(this.senderJid, () -> this.key.senderJid().orElseGet(this.key::chatJid));
    }

    @Override
    public Optional<Contact> sender() {
        return Optional.ofNullable(this.sender).or(this.key::sender);
    }

    private static MessageContainer $default$message() {
        return new MessageContainer();
    }

    private static MessageStatus $default$status() {
        return MessageStatus.PENDING;
    }

    private static List<String> $default$stubParameters() {
        return new ArrayList<String>();
    }

    private static List<String> $default$labels() {
        return new ArrayList<String>();
    }

    private static MessageReceipt $default$receipt() {
        return MessageReceipt.of();
    }

    private static List<ReactionMessage> $default$reactions() {
        return new ArrayList<ReactionMessage>();
    }

    private static List<PollUpdate> $default$pollUpdates() {
        return new ArrayList<PollUpdate>();
    }

    public static MessageInfoBuilder builder() {
        return new MessageInfoBuilder();
    }

    public MessageInfo(@NonNull MessageKey key, @NonNull MessageContainer message, long timestampSeconds, @NonNull MessageStatus status, ContactJid senderJid, Contact sender, boolean ignore, boolean starred, boolean broadcast, String pushName, byte[] mediaCiphertextSha256, boolean multicast, boolean urlText, boolean urlNumber, StubType stubType, boolean clearMedia, List<String> stubParameters, int duration, List<String> labels, PaymentInfo paymentInfo, LiveLocationMessage finalLiveLocation, PaymentInfo quotedPaymentInfo, long ephemeralStartTimestamp, int ephemeralDuration, boolean enableEphemeral, boolean ephemeralOutOfSync, BusinessPrivacyStatus businessPrivacyStatus, String businessVerifiedName, MediaData mediaData, PhotoChange photoChange, MessageReceipt receipt, List<ReactionMessage> reactions, MediaData quotedStickerData, byte[] futureProofData, PublicServiceAnnouncementStatus psaStatus, long messageC2STimestamp, List<PollUpdate> pollUpdates, PollAdditionalMetadata pollAdditionalMetadata, String agentId, boolean statusAlreadyViewed, byte[] messageSecret, KeepInChat keepInChat, ContactJid originalSender, long revokeTimestampSeconds) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        this.key = key;
        this.message = message;
        this.timestampSeconds = timestampSeconds;
        this.status = status;
        this.senderJid = senderJid;
        this.sender = sender;
        this.ignore = ignore;
        this.starred = starred;
        this.broadcast = broadcast;
        this.pushName = pushName;
        this.mediaCiphertextSha256 = mediaCiphertextSha256;
        this.multicast = multicast;
        this.urlText = urlText;
        this.urlNumber = urlNumber;
        this.stubType = stubType;
        this.clearMedia = clearMedia;
        this.stubParameters = stubParameters;
        this.duration = duration;
        this.labels = labels;
        this.paymentInfo = paymentInfo;
        this.finalLiveLocation = finalLiveLocation;
        this.quotedPaymentInfo = quotedPaymentInfo;
        this.ephemeralStartTimestamp = ephemeralStartTimestamp;
        this.ephemeralDuration = ephemeralDuration;
        this.enableEphemeral = enableEphemeral;
        this.ephemeralOutOfSync = ephemeralOutOfSync;
        this.businessPrivacyStatus = businessPrivacyStatus;
        this.businessVerifiedName = businessVerifiedName;
        this.mediaData = mediaData;
        this.photoChange = photoChange;
        this.receipt = receipt;
        this.reactions = reactions;
        this.quotedStickerData = quotedStickerData;
        this.futureProofData = futureProofData;
        this.psaStatus = psaStatus;
        this.messageC2STimestamp = messageC2STimestamp;
        this.pollUpdates = pollUpdates;
        this.pollAdditionalMetadata = pollAdditionalMetadata;
        this.agentId = agentId;
        this.statusAlreadyViewed = statusAlreadyViewed;
        this.messageSecret = messageSecret;
        this.keepInChat = keepInChat;
        this.originalSender = originalSender;
        this.revokeTimestampSeconds = revokeTimestampSeconds;
    }

    @NonNull
    public MessageKey key() {
        return this.key;
    }

    @Override
    @NonNull
    public MessageContainer message() {
        return this.message;
    }

    public long timestampSeconds() {
        return this.timestampSeconds;
    }

    @NonNull
    public MessageStatus status() {
        return this.status;
    }

    public boolean ignore() {
        return this.ignore;
    }

    public boolean starred() {
        return this.starred;
    }

    public boolean broadcast() {
        return this.broadcast;
    }

    public byte[] mediaCiphertextSha256() {
        return this.mediaCiphertextSha256;
    }

    public boolean multicast() {
        return this.multicast;
    }

    public boolean urlText() {
        return this.urlText;
    }

    public boolean urlNumber() {
        return this.urlNumber;
    }

    public boolean clearMedia() {
        return this.clearMedia;
    }

    public List<String> stubParameters() {
        return this.stubParameters;
    }

    public int duration() {
        return this.duration;
    }

    public List<String> labels() {
        return this.labels;
    }

    public LiveLocationMessage finalLiveLocation() {
        return this.finalLiveLocation;
    }

    public long ephemeralStartTimestamp() {
        return this.ephemeralStartTimestamp;
    }

    public int ephemeralDuration() {
        return this.ephemeralDuration;
    }

    public boolean enableEphemeral() {
        return this.enableEphemeral;
    }

    public boolean ephemeralOutOfSync() {
        return this.ephemeralOutOfSync;
    }

    public MediaData mediaData() {
        return this.mediaData;
    }

    public PhotoChange photoChange() {
        return this.photoChange;
    }

    public MessageReceipt receipt() {
        return this.receipt;
    }

    public List<ReactionMessage> reactions() {
        return this.reactions;
    }

    public MediaData quotedStickerData() {
        return this.quotedStickerData;
    }

    public long messageC2STimestamp() {
        return this.messageC2STimestamp;
    }

    public List<PollUpdate> pollUpdates() {
        return this.pollUpdates;
    }

    public boolean statusAlreadyViewed() {
        return this.statusAlreadyViewed;
    }

    public long revokeTimestampSeconds() {
        return this.revokeTimestampSeconds;
    }

    public MessageInfo key(@NonNull MessageKey key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.key = key;
        return this;
    }

    public MessageInfo message(@NonNull MessageContainer message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.message = message;
        return this;
    }

    public MessageInfo timestampSeconds(long timestampSeconds) {
        this.timestampSeconds = timestampSeconds;
        return this;
    }

    public MessageInfo status(@NonNull MessageStatus status) {
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        this.status = status;
        return this;
    }

    public MessageInfo sender(Contact sender) {
        this.sender = sender;
        return this;
    }

    public MessageInfo ignore(boolean ignore) {
        this.ignore = ignore;
        return this;
    }

    public MessageInfo starred(boolean starred) {
        this.starred = starred;
        return this;
    }

    public MessageInfo broadcast(boolean broadcast) {
        this.broadcast = broadcast;
        return this;
    }

    public MessageInfo pushName(String pushName) {
        this.pushName = pushName;
        return this;
    }

    public MessageInfo mediaCiphertextSha256(byte[] mediaCiphertextSha256) {
        this.mediaCiphertextSha256 = mediaCiphertextSha256;
        return this;
    }

    public MessageInfo multicast(boolean multicast) {
        this.multicast = multicast;
        return this;
    }

    public MessageInfo urlText(boolean urlText) {
        this.urlText = urlText;
        return this;
    }

    public MessageInfo urlNumber(boolean urlNumber) {
        this.urlNumber = urlNumber;
        return this;
    }

    public MessageInfo stubType(StubType stubType) {
        this.stubType = stubType;
        return this;
    }

    public MessageInfo clearMedia(boolean clearMedia) {
        this.clearMedia = clearMedia;
        return this;
    }

    public MessageInfo stubParameters(List<String> stubParameters) {
        this.stubParameters = stubParameters;
        return this;
    }

    public MessageInfo duration(int duration) {
        this.duration = duration;
        return this;
    }

    public MessageInfo labels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public MessageInfo paymentInfo(PaymentInfo paymentInfo) {
        this.paymentInfo = paymentInfo;
        return this;
    }

    public MessageInfo finalLiveLocation(LiveLocationMessage finalLiveLocation) {
        this.finalLiveLocation = finalLiveLocation;
        return this;
    }

    public MessageInfo quotedPaymentInfo(PaymentInfo quotedPaymentInfo) {
        this.quotedPaymentInfo = quotedPaymentInfo;
        return this;
    }

    public MessageInfo ephemeralStartTimestamp(long ephemeralStartTimestamp) {
        this.ephemeralStartTimestamp = ephemeralStartTimestamp;
        return this;
    }

    public MessageInfo ephemeralDuration(int ephemeralDuration) {
        this.ephemeralDuration = ephemeralDuration;
        return this;
    }

    public MessageInfo enableEphemeral(boolean enableEphemeral) {
        this.enableEphemeral = enableEphemeral;
        return this;
    }

    public MessageInfo ephemeralOutOfSync(boolean ephemeralOutOfSync) {
        this.ephemeralOutOfSync = ephemeralOutOfSync;
        return this;
    }

    public MessageInfo businessPrivacyStatus(BusinessPrivacyStatus businessPrivacyStatus) {
        this.businessPrivacyStatus = businessPrivacyStatus;
        return this;
    }

    public MessageInfo businessVerifiedName(String businessVerifiedName) {
        this.businessVerifiedName = businessVerifiedName;
        return this;
    }

    public MessageInfo mediaData(MediaData mediaData) {
        this.mediaData = mediaData;
        return this;
    }

    public MessageInfo photoChange(PhotoChange photoChange) {
        this.photoChange = photoChange;
        return this;
    }

    public MessageInfo receipt(MessageReceipt receipt) {
        this.receipt = receipt;
        return this;
    }

    public MessageInfo reactions(List<ReactionMessage> reactions) {
        this.reactions = reactions;
        return this;
    }

    public MessageInfo quotedStickerData(MediaData quotedStickerData) {
        this.quotedStickerData = quotedStickerData;
        return this;
    }

    public MessageInfo futureProofData(byte[] futureProofData) {
        this.futureProofData = futureProofData;
        return this;
    }

    public MessageInfo psaStatus(PublicServiceAnnouncementStatus psaStatus) {
        this.psaStatus = psaStatus;
        return this;
    }

    public MessageInfo messageC2STimestamp(long messageC2STimestamp) {
        this.messageC2STimestamp = messageC2STimestamp;
        return this;
    }

    public MessageInfo pollUpdates(List<PollUpdate> pollUpdates) {
        this.pollUpdates = pollUpdates;
        return this;
    }

    public MessageInfo pollAdditionalMetadata(PollAdditionalMetadata pollAdditionalMetadata) {
        this.pollAdditionalMetadata = pollAdditionalMetadata;
        return this;
    }

    public MessageInfo agentId(String agentId) {
        this.agentId = agentId;
        return this;
    }

    public MessageInfo statusAlreadyViewed(boolean statusAlreadyViewed) {
        this.statusAlreadyViewed = statusAlreadyViewed;
        return this;
    }

    public MessageInfo messageSecret(byte[] messageSecret) {
        this.messageSecret = messageSecret;
        return this;
    }

    public MessageInfo keepInChat(KeepInChat keepInChat) {
        this.keepInChat = keepInChat;
        return this;
    }

    public MessageInfo originalSender(ContactJid originalSender) {
        this.originalSender = originalSender;
        return this;
    }

    public MessageInfo revokeTimestampSeconds(long revokeTimestampSeconds) {
        this.revokeTimestampSeconds = revokeTimestampSeconds;
        return this;
    }

    public String toString() {
        return "MessageInfo(key=" + this.key() + ", message=" + this.message() + ", timestampSeconds=" + this.timestampSeconds() + ", status=" + this.status() + ", senderJid=" + this.senderJid() + ", sender=" + this.sender() + ", ignore=" + this.ignore() + ", starred=" + this.starred() + ", broadcast=" + this.broadcast() + ", pushName=" + this.pushName() + ", mediaCiphertextSha256=" + Arrays.toString(this.mediaCiphertextSha256()) + ", multicast=" + this.multicast() + ", urlText=" + this.urlText() + ", urlNumber=" + this.urlNumber() + ", stubType=" + this.stubType() + ", clearMedia=" + this.clearMedia() + ", stubParameters=" + this.stubParameters() + ", duration=" + this.duration() + ", labels=" + this.labels() + ", paymentInfo=" + this.paymentInfo() + ", finalLiveLocation=" + this.finalLiveLocation() + ", quotedPaymentInfo=" + this.quotedPaymentInfo() + ", ephemeralStartTimestamp=" + this.ephemeralStartTimestamp() + ", ephemeralDuration=" + this.ephemeralDuration() + ", enableEphemeral=" + this.enableEphemeral() + ", ephemeralOutOfSync=" + this.ephemeralOutOfSync() + ", businessPrivacyStatus=" + this.businessPrivacyStatus() + ", businessVerifiedName=" + this.businessVerifiedName() + ", mediaData=" + this.mediaData() + ", photoChange=" + this.photoChange() + ", receipt=" + this.receipt() + ", reactions=" + this.reactions() + ", quotedStickerData=" + this.quotedStickerData() + ", futureProofData=" + this.futureProofData() + ", psaStatus=" + this.psaStatus() + ", messageC2STimestamp=" + this.messageC2STimestamp() + ", pollUpdates=" + this.pollUpdates() + ", pollAdditionalMetadata=" + this.pollAdditionalMetadata() + ", agentId=" + this.agentId() + ", statusAlreadyViewed=" + this.statusAlreadyViewed() + ", messageSecret=" + this.messageSecret() + ", keepInChat=" + this.keepInChat() + ", originalSender=" + this.originalSender() + ", revokeTimestampSeconds=" + this.revokeTimestampSeconds() + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        protobufOutputStream.writeBool(17, this.starred);
        protobufOutputStream.writeUInt64(32, this.ephemeralStartTimestamp);
        if (this.psaStatus != null) {
            protobufOutputStream.writeBytes(44, this.psaStatus.toEncodedProtobuf());
        }
        protobufOutputStream.writeUInt64(6, this.messageC2STimestamp);
        protobufOutputStream.writeBool(21, this.multicast);
        protobufOutputStream.writeUInt32(27, this.duration);
        if (this.finalLiveLocation != null) {
            protobufOutputStream.writeBytes(30, this.finalLiveLocation.toEncodedProtobuf());
        }
        if (this.businessVerifiedName != null) {
            protobufOutputStream.writeString(37, this.businessVerifiedName);
        }
        protobufOutputStream.writeUInt64(3, this.timestampSeconds);
        if (this.photoChange != null) {
            protobufOutputStream.writeBytes(39, this.photoChange.toEncodedProtobuf());
        }
        if (this.stubParameters != null) {
            for (String string : this.stubParameters) {
                protobufOutputStream.writeString(26, string);
            }
        }
        if (this.stubType != null) {
            protobufOutputStream.writeUInt32(24, this.stubType.index());
        }
        protobufOutputStream.writeBool(35, this.ephemeralOutOfSync);
        if (this.senderJid != null) {
            protobufOutputStream.writeString(5, this.senderJid.toValue());
        }
        if (this.key != null) {
            protobufOutputStream.writeBytes(1, this.key.toEncodedProtobuf());
        }
        if (this.quotedStickerData != null) {
            protobufOutputStream.writeBytes(42, this.quotedStickerData.toEncodedProtobuf());
        }
        if (this.paymentInfo != null) {
            protobufOutputStream.writeBytes(29, this.paymentInfo.toEncodedProtobuf());
        }
        if (this.mediaCiphertextSha256 != null) {
            protobufOutputStream.writeBytes(20, this.mediaCiphertextSha256);
        }
        if (this.quotedPaymentInfo != null) {
            protobufOutputStream.writeBytes(31, this.quotedPaymentInfo.toEncodedProtobuf());
        }
        protobufOutputStream.writeBool(22, this.urlText);
        if (this.pollAdditionalMetadata != null) {
            protobufOutputStream.writeBytes(46, this.pollAdditionalMetadata.toEncodedProtobuf());
        }
        protobufOutputStream.writeBool(48, this.statusAlreadyViewed);
        if (this.messageSecret != null) {
            protobufOutputStream.writeBytes(49, this.messageSecret);
        }
        if (this.mediaData != null) {
            protobufOutputStream.writeBytes(38, this.mediaData.toEncodedProtobuf());
        }
        if (this.originalSender != null) {
            protobufOutputStream.writeString(51, this.originalSender.toValue());
        }
        if (this.labels != null) {
            for (String string : this.labels) {
                protobufOutputStream.writeString(28, string);
            }
        }
        protobufOutputStream.writeBool(34, this.enableEphemeral);
        protobufOutputStream.writeBool(18, this.broadcast);
        if (this.message != null) {
            protobufOutputStream.writeBytes(2, this.message.toEncodedProtobuf());
        }
        if (this.businessPrivacyStatus != null) {
            protobufOutputStream.writeUInt32(36, this.businessPrivacyStatus.index());
        }
        if (this.status != null) {
            protobufOutputStream.writeUInt32(4, this.status.index());
        }
        if (this.futureProofData != null) {
            protobufOutputStream.writeBytes(43, this.futureProofData);
        }
        if (this.agentId != null) {
            protobufOutputStream.writeString(47, this.agentId);
        }
        if (this.reactions != null) {
            for (ReactionMessage reactionMessage : this.reactions) {
                protobufOutputStream.writeBytes(41, reactionMessage.toEncodedProtobuf());
            }
        }
        if (this.pushName != null) {
            protobufOutputStream.writeString(19, this.pushName);
        }
        if (this.receipt != null) {
            protobufOutputStream.writeBytes(40, this.receipt.toEncodedProtobuf());
        }
        protobufOutputStream.writeBool(16, this.ignore);
        if (this.pollUpdates != null) {
            for (PollUpdate pollUpdate : this.pollUpdates) {
                protobufOutputStream.writeBytes(45, pollUpdate.toEncodedProtobuf());
            }
        }
        if (this.keepInChat != null) {
            protobufOutputStream.writeBytes(50, this.keepInChat.toEncodedProtobuf());
        }
        protobufOutputStream.writeUInt64(52, this.revokeTimestampSeconds);
        protobufOutputStream.writeBool(23, this.urlNumber);
        protobufOutputStream.writeBool(25, this.clearMedia);
        protobufOutputStream.writeUInt32(33, this.ephemeralDuration);
        return protobufOutputStream.toByteArray();
    }

    public static MessageInfo ofProtobuf(byte[] byArray) {
        int n;
        MessageInfoBuilder messageInfoBuilder = MessageInfo.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        ArrayList<ReactionMessage> arrayList = new ArrayList<ReactionMessage>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<PollUpdate> arrayList4 = new ArrayList<PollUpdate>();
        block45: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 17: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.starred(protobufInputStream.readBool());
                    continue block45;
                }
                case 32: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.ephemeralStartTimestamp(protobufInputStream.readInt64());
                    continue block45;
                }
                case 44: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.psaStatus(PublicServiceAnnouncementStatus.ofProtobuf(protobufInputStream.readBytes()));
                    continue block45;
                }
                case 6: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.messageC2STimestamp(protobufInputStream.readInt64());
                    continue block45;
                }
                case 21: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.multicast(protobufInputStream.readBool());
                    continue block45;
                }
                case 27: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.duration(protobufInputStream.readInt32());
                    continue block45;
                }
                case 30: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.finalLiveLocation(LiveLocationMessage.ofProtobuf(protobufInputStream.readBytes()));
                    continue block45;
                }
                case 37: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.businessVerifiedName(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block45;
                }
                case 3: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.timestampSeconds(protobufInputStream.readInt64());
                    continue block45;
                }
                case 39: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.photoChange(PhotoChange.ofProtobuf(protobufInputStream.readBytes()));
                    continue block45;
                }
                case 26: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    arrayList3.add(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block45;
                }
                case 24: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.stubType(StubType.of(protobufInputStream.readInt32()));
                    continue block45;
                }
                case 35: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.ephemeralOutOfSync(protobufInputStream.readBool());
                    continue block45;
                }
                case 5: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.senderJid(ContactJid.ofProtobuf(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8)));
                    continue block45;
                }
                case 1: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.key(MessageKey.ofProtobuf(protobufInputStream.readBytes()));
                    continue block45;
                }
                case 42: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.quotedStickerData(MediaData.ofProtobuf(protobufInputStream.readBytes()));
                    continue block45;
                }
                case 29: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.paymentInfo(PaymentInfo.ofProtobuf(protobufInputStream.readBytes()));
                    continue block45;
                }
                case 20: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.mediaCiphertextSha256(protobufInputStream.readBytes());
                    continue block45;
                }
                case 31: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.quotedPaymentInfo(PaymentInfo.ofProtobuf(protobufInputStream.readBytes()));
                    continue block45;
                }
                case 22: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.urlText(protobufInputStream.readBool());
                    continue block45;
                }
                case 46: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.pollAdditionalMetadata(PollAdditionalMetadata.ofProtobuf(protobufInputStream.readBytes()));
                    continue block45;
                }
                case 48: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.statusAlreadyViewed(protobufInputStream.readBool());
                    continue block45;
                }
                case 49: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.messageSecret(protobufInputStream.readBytes());
                    continue block45;
                }
                case 38: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.mediaData(MediaData.ofProtobuf(protobufInputStream.readBytes()));
                    continue block45;
                }
                case 51: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.originalSender(ContactJid.ofProtobuf(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8)));
                    continue block45;
                }
                case 28: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    arrayList2.add(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block45;
                }
                case 34: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.enableEphemeral(protobufInputStream.readBool());
                    continue block45;
                }
                case 18: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.broadcast(protobufInputStream.readBool());
                    continue block45;
                }
                case 2: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.message(MessageContainer.ofProtobuf(protobufInputStream.readBytes()));
                    continue block45;
                }
                case 36: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.businessPrivacyStatus(BusinessPrivacyStatus.of(protobufInputStream.readInt32()));
                    continue block45;
                }
                case 4: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.status(MessageStatus.of(protobufInputStream.readInt32()));
                    continue block45;
                }
                case 43: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.futureProofData(protobufInputStream.readBytes());
                    continue block45;
                }
                case 47: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.agentId(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block45;
                }
                case 41: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    arrayList.add(ReactionMessage.ofProtobuf(protobufInputStream.readBytes()));
                    continue block45;
                }
                case 19: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.pushName(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block45;
                }
                case 40: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.receipt(MessageReceipt.ofProtobuf(protobufInputStream.readBytes()));
                    continue block45;
                }
                case 16: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.ignore(protobufInputStream.readBool());
                    continue block45;
                }
                case 45: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    arrayList4.add(PollUpdate.ofProtobuf(protobufInputStream.readBytes()));
                    continue block45;
                }
                case 50: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.keepInChat(KeepInChat.ofProtobuf(protobufInputStream.readBytes()));
                    continue block45;
                }
                case 52: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.revokeTimestampSeconds(protobufInputStream.readInt64());
                    continue block45;
                }
                case 23: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.urlNumber(protobufInputStream.readBool());
                    continue block45;
                }
                case 25: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.clearMedia(protobufInputStream.readBool());
                    continue block45;
                }
                case 33: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageInfoBuilder.ephemeralDuration(protobufInputStream.readInt32());
                    continue block45;
                }
            }
            protobufInputStream.readBytes();
        }
        messageInfoBuilder.reactions(arrayList);
        messageInfoBuilder.labels(arrayList2);
        messageInfoBuilder.stubParameters(arrayList3);
        messageInfoBuilder.pollUpdates(arrayList4);
        return messageInfoBuilder.build();
    }

    public static enum StubType implements ProtobufMessage
    {
        UNKNOWN(0, List.of("unknown")),
        REVOKE(1, List.of("revoked")),
        CIPHERTEXT(2, List.of("ciphertext")),
        FUTUREPROOF(3, List.of("phone")),
        NON_VERIFIED_TRANSITION(4, List.of("non_verified_transition")),
        UNVERIFIED_TRANSITION(5, List.of("unverified_transition")),
        VERIFIED_TRANSITION(6, List.of("verified_transition")),
        VERIFIED_LOW_UNKNOWN(7, List.of("verified_low_unknown")),
        VERIFIED_HIGH(8, List.of("verified_high")),
        VERIFIED_INITIAL_UNKNOWN(9, List.of("verified_initial_unknown")),
        VERIFIED_INITIAL_LOW(10, List.of("verified_initial_low")),
        VERIFIED_INITIAL_HIGH(11, List.of("verified_initial_high")),
        VERIFIED_TRANSITION_ANY_TO_NONE(12, List.of("verified_transition_any_to_none")),
        VERIFIED_TRANSITION_ANY_TO_HIGH(13, List.of("verified_transition_any_to_high")),
        VERIFIED_TRANSITION_HIGH_TO_LOW(14, List.of("verified_transition_high_to_low")),
        VERIFIED_TRANSITION_HIGH_TO_UNKNOWN(15, List.of("verified_transition_high_to_unknown")),
        VERIFIED_TRANSITION_UNKNOWN_TO_LOW(16, List.of("verified_transition_unknown_to_low")),
        VERIFIED_TRANSITION_LOW_TO_UNKNOWN(17, List.of("verified_transition_low_to_unknown")),
        VERIFIED_TRANSITION_NONE_TO_LOW(18, List.of("verified_transition_none_to_low")),
        VERIFIED_TRANSITION_NONE_TO_UNKNOWN(19, List.of("verified_transition_none_to_unknown")),
        GROUP_CREATE(20, List.of("create")),
        GROUP_CHANGE_SUBJECT(21, List.of("subject")),
        GROUP_CHANGE_ICON(22, List.of("picture")),
        GROUP_CHANGE_INVITE_LINK(23, List.of("revoke_invite")),
        GROUP_CHANGE_DESCRIPTION(24, List.of("description")),
        GROUP_CHANGE_RESTRICT(25, List.of("restrict", "locked", "unlocked")),
        GROUP_CHANGE_ANNOUNCE(26, List.of("announce", "announcement", "not_announcement")),
        GROUP_PARTICIPANT_ADD(27, List.of("add")),
        GROUP_PARTICIPANT_REMOVE(28, List.of("remove")),
        GROUP_PARTICIPANT_PROMOTE(29, List.of("promote")),
        GROUP_PARTICIPANT_DEMOTE(30, List.of("demote")),
        GROUP_PARTICIPANT_INVITE(31, List.of("invite")),
        GROUP_PARTICIPANT_LEAVE(32, List.of("leave")),
        GROUP_PARTICIPANT_CHANGE_NUMBER(33, List.of("modify")),
        BROADCAST_CREATE(34, List.of("create")),
        BROADCAST_ADD(35, List.of("add")),
        BROADCAST_REMOVE(36, List.of("remove")),
        GENERIC_NOTIFICATION(37, List.of("notification")),
        E2E_IDENTITY_CHANGED(38, List.of("identity")),
        E2E_ENCRYPTED(39, List.of("encrypt")),
        CALL_MISSED_VOICE(40, List.of("miss")),
        CALL_MISSED_VIDEO(41, List.of("miss_video")),
        INDIVIDUAL_CHANGE_NUMBER(42, List.of("change_number")),
        GROUP_DELETE(43, List.of("delete")),
        GROUP_ANNOUNCE_MODE_MESSAGE_BOUNCE(44, List.of("announce_msg_bounce")),
        CALL_MISSED_GROUP_VOICE(45, List.of("miss_group")),
        CALL_MISSED_GROUP_VIDEO(46, List.of("miss_group_video")),
        PAYMENT_CIPHERTEXT(47, List.of("ciphertext")),
        PAYMENT_FUTUREPROOF(48, List.of("futureproof")),
        PAYMENT_TRANSACTION_STATUS_UPDATE_FAILED(49, List.of("payment_transaction_status_update_failed")),
        PAYMENT_TRANSACTION_STATUS_UPDATE_REFUNDED(50, List.of("payment_transaction_status_update_refunded")),
        PAYMENT_TRANSACTION_STATUS_UPDATE_REFUND_FAILED(51, List.of("payment_transaction_status_update_refund_failed")),
        PAYMENT_TRANSACTION_STATUS_RECEIVER_PENDING_SETUP(52, List.of("payment_transaction_status_receiver_pending_setup")),
        PAYMENT_TRANSACTION_STATUS_RECEIVER_SUCCESS_AFTER_HICCUP(53, List.of("payment_transaction_status_receiver_success_after_hiccup")),
        PAYMENT_ACTION_ACCOUNT_SETUP_REMINDER(54, List.of("payment_action_account_setup_reminder")),
        PAYMENT_ACTION_SEND_PAYMENT_REMINDER(55, List.of("payment_action_send_payment_reminder")),
        PAYMENT_ACTION_SEND_PAYMENT_INVITATION(56, List.of("payment_action_send_payment_invitation")),
        PAYMENT_ACTION_REQUEST_DECLINED(57, List.of("payment_action_request_declined")),
        PAYMENT_ACTION_REQUEST_EXPIRED(58, List.of("payment_action_request_expired")),
        PAYMENT_ACTION_REQUEST_CANCELLED(59, List.of("payment_transaction_request_cancelled")),
        BIZ_VERIFIED_TRANSITION_TOP_TO_BOTTOM(60, List.of("biz_verified_transition_top_to_bottom")),
        BIZ_VERIFIED_TRANSITION_BOTTOM_TO_TOP(61, List.of("biz_verified_transition_bottom_to_top")),
        BIZ_INTRO_TOP(62, List.of("biz_intro_top")),
        BIZ_INTRO_BOTTOM(63, List.of("biz_intro_bottom")),
        BIZ_NAME_CHANGE(64, List.of("biz_name_change")),
        BIZ_MOVE_TO_CONSUMER_APP(65, List.of("biz_move_to_consumer_app")),
        BIZ_TWO_TIER_MIGRATION_TOP(66, List.of("biz_two_tier_migration_top")),
        BIZ_TWO_TIER_MIGRATION_BOTTOM(67, List.of("biz_two_tier_migration_bottom")),
        OVERSIZED(68, List.of("oversized")),
        GROUP_CHANGE_NO_FREQUENTLY_FORWARDED(69, List.of("frequently_forwarded_ok", "no_frequently_forwarded")),
        GROUP_V4_ADD_INVITE_SENT(70, List.of("v4_add_invite_sent")),
        GROUP_PARTICIPANT_ADD_REQUEST_JOIN(71, List.of("v4_add_invite_join")),
        CHANGE_EPHEMERAL_SETTING(72, List.of("ephemeral", "not_ephemeral")),
        E2E_DEVICE_CHANGED(73, List.of("device")),
        VIEWED_ONCE(74, List.of()),
        E2E_ENCRYPTED_NOW(75, List.of("encrypt_now")),
        BLUE_MSG_BSP_FB_TO_BSP_PREMISE(76, List.of("blue_msg_bsp_fb_to_bsp_premise")),
        BLUE_MSG_BSP_FB_TO_SELF_FB(77, List.of("blue_msg_bsp_fb_to_self_fb")),
        BLUE_MSG_BSP_FB_TO_SELF_PREMISE(78, List.of("blue_msg_bsp_fb_to_self_premise")),
        BLUE_MSG_BSP_FB_UNVERIFIED(79, List.of("blue_msg_bsp_fb_unverified")),
        BLUE_MSG_BSP_FB_UNVERIFIED_TO_SELF_PREMISE_VERIFIED(80, List.of("blue_msg_bsp_fb_unverified_to_self_premise_verified")),
        BLUE_MSG_BSP_FB_VERIFIED(81, List.of("blue_msg_bsp_fb_verified")),
        BLUE_MSG_BSP_FB_VERIFIED_TO_SELF_PREMISE_UNVERIFIED(82, List.of("blue_msg_bsp_fb_verified_to_self_premise_unverified")),
        BLUE_MSG_BSP_PREMISE_TO_SELF_PREMISE(83, List.of("blue_msg_bsp_premise_to_self_premise")),
        BLUE_MSG_BSP_PREMISE_UNVERIFIED(84, List.of("blue_msg_bsp_premise_unverified")),
        BLUE_MSG_BSP_PREMISE_UNVERIFIED_TO_SELF_PREMISE_VERIFIED(85, List.of("blue_msg_bsp_premise_unverified_to_self_premise_verified")),
        BLUE_MSG_BSP_PREMISE_VERIFIED(86, List.of("blue_msg_bsp_premise_verified")),
        BLUE_MSG_BSP_PREMISE_VERIFIED_TO_SELF_PREMISE_UNVERIFIED(87, List.of("blue_msg_bsp_premise_verified_to_self_premise_unverified")),
        BLUE_MSG_CONSUMER_TO_BSP_FB_UNVERIFIED(88, List.of("blue_msg_consumer_to_bsp_fb_unverified")),
        BLUE_MSG_CONSUMER_TO_BSP_PREMISE_UNVERIFIED(89, List.of("blue_msg_consumer_to_bsp_premise_unverified")),
        BLUE_MSG_CONSUMER_TO_SELF_FB_UNVERIFIED(90, List.of("blue_msg_consumer_to_self_fb_unverified")),
        BLUE_MSG_CONSUMER_TO_SELF_PREMISE_UNVERIFIED(91, List.of("blue_msg_consumer_to_self_premise_unverified")),
        BLUE_MSG_SELF_FB_TO_BSP_PREMISE(92, List.of("blue_msg_self_fb_to_bsp_premise")),
        BLUE_MSG_SELF_FB_TO_SELF_PREMISE(93, List.of("blue_msg_self_fb_to_self_premise")),
        BLUE_MSG_SELF_FB_UNVERIFIED(94, List.of("blue_msg_self_fb_unverified")),
        BLUE_MSG_SELF_FB_UNVERIFIED_TO_SELF_PREMISE_VERIFIED(95, List.of("blue_msg_self_fb_unverified_to_self_premise_verified")),
        BLUE_MSG_SELF_FB_VERIFIED(96, List.of("blue_msg_self_fb_verified")),
        BLUE_MSG_SELF_FB_VERIFIED_TO_SELF_PREMISE_UNVERIFIED(97, List.of("blue_msg_self_fb_verified_to_self_premise_unverified")),
        BLUE_MSG_SELF_PREMISE_TO_BSP_PREMISE(98, List.of("blue_msg_self_premise_to_bsp_premise")),
        BLUE_MSG_SELF_PREMISE_UNVERIFIED(99, List.of("blue_msg_self_premise_unverified")),
        BLUE_MSG_SELF_PREMISE_VERIFIED(100, List.of("blue_msg_self_premise_verified")),
        BLUE_MSG_TO_BSP_FB(101, List.of("blue_msg_to_bsp_fb")),
        BLUE_MSG_TO_CONSUMER(102, List.of("blue_msg_to_consumer")),
        BLUE_MSG_TO_SELF_FB(103, List.of("blue_msg_to_self_fb")),
        BLUE_MSG_UNVERIFIED_TO_BSP_FB_VERIFIED(104, List.of("blue_msg_unverified_to_bsp_fb_verified")),
        BLUE_MSG_UNVERIFIED_TO_BSP_PREMISE_VERIFIED(105, List.of("blue_msg_unverified_to_bsp_premise_verified")),
        BLUE_MSG_UNVERIFIED_TO_SELF_FB_VERIFIED(106, List.of("blue_msg_unverified_to_self_fb_verified")),
        BLUE_MSG_UNVERIFIED_TO_VERIFIED(107, List.of("blue_msg_unverified_to_verified")),
        BLUE_MSG_VERIFIED_TO_BSP_FB_UNVERIFIED(108, List.of("blue_msg_verified_to_bsp_fb_unverified")),
        BLUE_MSG_VERIFIED_TO_BSP_PREMISE_UNVERIFIED(109, List.of("blue_msg_verified_to_bsp_premise_unverified")),
        BLUE_MSG_VERIFIED_TO_SELF_FB_UNVERIFIED(110, List.of("blue_msg_verified_to_self_fb_unverified")),
        BLUE_MSG_VERIFIED_TO_UNVERIFIED(111, List.of("blue_msg_verified_to_unverified")),
        BLUE_MSG_BSP_FB_UNVERIFIED_TO_BSP_PREMISE_VERIFIED(112, List.of("blue_msg_bsp_fb_unverified_to_bsp_premise_verified")),
        BLUE_MSG_BSP_FB_UNVERIFIED_TO_SELF_FB_VERIFIED(113, List.of("blue_msg_bsp_fb_unverified_to_self_fb_verified")),
        BLUE_MSG_BSP_FB_VERIFIED_TO_BSP_PREMISE_UNVERIFIED(114, List.of("blue_msg_bsp_fb_verified_to_bsp_premise_unverified")),
        BLUE_MSG_BSP_FB_VERIFIED_TO_SELF_FB_UNVERIFIED(115, List.of("blue_msg_bsp_fb_verified_to_self_fb_unverified")),
        BLUE_MSG_SELF_FB_UNVERIFIED_TO_BSP_PREMISE_VERIFIED(116, List.of("blue_msg_self_fb_unverified_to_bsp_premise_verified")),
        BLUE_MSG_SELF_FB_VERIFIED_TO_BSP_PREMISE_UNVERIFIED(117, List.of("blue_msg_self_fb_verified_to_bsp_premise_unverified")),
        E2E_IDENTITY_UNAVAILABLE(118, List.of("e2e_identity_unavailable")),
        GROUP_CREATING(119, List.of()),
        GROUP_CREATE_FAILED(120, List.of()),
        GROUP_BOUNCED(121, List.of()),
        BLOCK_CONTACT(122, List.of("block_contact")),
        EPHEMERAL_SETTING_NOT_APPLIED(123, List.of()),
        SYNC_FAILED(124, List.of()),
        SYNCING(125, List.of()),
        BIZ_PRIVACY_MODE_INIT_FB(126, List.of("biz_privacy_mode_init_fb")),
        BIZ_PRIVACY_MODE_INIT_BSP(127, List.of("biz_privacy_mode_init_bsp")),
        BIZ_PRIVACY_MODE_TO_FB(128, List.of("biz_privacy_mode_to_fb")),
        BIZ_PRIVACY_MODE_TO_BSP(129, List.of("biz_privacy_mode_to_bsp")),
        DISAPPEARING_MODE(130, List.of("disappearing_mode")),
        E2E_DEVICE_FETCH_FAILED(131, List.of()),
        ADMIN_REVOKE(132, List.of("admin")),
        GROUP_INVITE_LINK_GROWTH_LOCKED(133, List.of("growth_locked", "growth_unlocked")),
        COMMUNITY_LINK_PARENT_GROUP(134, List.of("parent_group_link")),
        COMMUNITY_LINK_SIBLING_GROUP(135, List.of("sibling_group_link")),
        COMMUNITY_LINK_SUB_GROUP(136, List.of("sub_group_link", "link")),
        COMMUNITY_UNLINK_PARENT_GROUP(137, List.of("parent_group_unlink")),
        COMMUNITY_UNLINK_SIBLING_GROUP(138, List.of("sibling_group_unlink")),
        COMMUNITY_UNLINK_SUB_GROUP(139, List.of("sub_group_unlink", "unlink")),
        GROUP_PARTICIPANT_ACCEPT(140, List.of()),
        GROUP_PARTICIPANT_LINKED_GROUP_JOIN(141, List.of("linked_group_join")),
        COMMUNITY_CREATE(142, List.of("community_create")),
        EPHEMERAL_KEEP_IN_CHAT(143, List.of("ephemeral_keep_in_chat")),
        GROUP_MEMBERSHIP_JOIN_APPROVAL_REQUEST(144, List.of("membership_approval_request")),
        GROUP_MEMBERSHIP_JOIN_APPROVAL_MODE(145, List.of("membership_approval_mode")),
        INTEGRITY_UNLINK_PARENT_GROUP(146, List.of("integrity_parent_group_unlink")),
        COMMUNITY_PARTICIPANT_PROMOTE(147, List.of("linked_group_promote")),
        COMMUNITY_PARTICIPANT_DEMOTE(148, List.of("linked_group_demote")),
        COMMUNITY_PARENT_GROUP_DELETED(149, List.of("delete_parent_group")),
        COMMUNITY_LINK_PARENT_GROUP_MEMBERSHIP_APPROVAL(150, List.of("parent_group_link_membership_approval")),
        GROUP_PARTICIPANT_JOINED_GROUP_AND_PARENT_GROUP(151, List.of("auto_add")),
        MASKED_THREAD_CREATED(152, List.of("masked_thread_created")),
        MASKED_THREAD_UNMASKED(153, List.of()),
        BIZ_CHAT_ASSIGNMENT(154, List.of("chat_assignment")),
        CHAT_PSA(155, List.of("e2e_notification")),
        CHAT_POLL_CREATION_MESSAGE(156, List.of()),
        CAG_MASKED_THREAD_CREATED(157, List.of("cag_masked_thread_created")),
        COMMUNITY_PARENT_GROUP_SUBJECT_CHANGED(158, List.of("subject")),
        CAG_INVITE_AUTO_ADD(159, List.of("invite_auto_add")),
        BIZ_CHAT_ASSIGNMENT_UNASSIGN(160, List.of("chat_assignment_unassign")),
        CAG_INVITE_AUTO_JOINED(161, List.of("invite_auto_add"));

        private final int index;
        private final List<String> symbols;

        public static Optional<StubType> of(String symbol) {
            return Arrays.stream(StubType.values()).filter(entry -> entry.symbols().contains(symbol)).findFirst();
        }

        private StubType(int index, List<String> symbols) {
            this.index = index;
            this.symbols = symbols;
        }

        public int index() {
            return this.index;
        }

        public List<String> symbols() {
            return this.symbols;
        }

        private static /* synthetic */ boolean lambda$of$0(int index, StubType entry) {
            return entry.index() == index;
        }

        public byte[] toEncodedProtobuf() {
            ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
            return protobufOutputStream.toByteArray();
        }

        public static StubType of(int n) {
            Iterator iterator = Arrays.stream(StubType.values()).iterator();
            while (iterator.hasNext()) {
                StubType stubType = (StubType)((Object)iterator.next());
                if (stubType.index() != n) continue;
                return stubType;
            }
            return null;
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class MessageInfoBuilder {
        private MessageKey key;
        private boolean message$set;
        private MessageContainer message$value;
        private long timestampSeconds;
        private boolean status$set;
        private MessageStatus status$value;
        private ContactJid senderJid;
        private Contact sender;
        private boolean ignore;
        private boolean starred;
        private boolean broadcast;
        private String pushName;
        private byte[] mediaCiphertextSha256;
        private boolean multicast;
        private boolean urlText;
        private boolean urlNumber;
        private StubType stubType;
        private boolean clearMedia;
        private boolean stubParameters$set;
        private List<String> stubParameters$value;
        private int duration;
        private boolean labels$set;
        private List<String> labels$value;
        private PaymentInfo paymentInfo;
        private LiveLocationMessage finalLiveLocation;
        private PaymentInfo quotedPaymentInfo;
        private long ephemeralStartTimestamp;
        private int ephemeralDuration;
        private boolean enableEphemeral;
        private boolean ephemeralOutOfSync;
        private BusinessPrivacyStatus businessPrivacyStatus;
        private String businessVerifiedName;
        private MediaData mediaData;
        private PhotoChange photoChange;
        private boolean receipt$set;
        private MessageReceipt receipt$value;
        private boolean reactions$set;
        private List<ReactionMessage> reactions$value;
        private MediaData quotedStickerData;
        private byte[] futureProofData;
        private PublicServiceAnnouncementStatus psaStatus;
        private long messageC2STimestamp;
        private boolean pollUpdates$set;
        private List<PollUpdate> pollUpdates$value;
        private PollAdditionalMetadata pollAdditionalMetadata;
        private String agentId;
        private boolean statusAlreadyViewed;
        private byte[] messageSecret;
        private KeepInChat keepInChat;
        private ContactJid originalSender;
        private long revokeTimestampSeconds;

        MessageInfoBuilder() {
        }

        public MessageInfoBuilder key(@NonNull MessageKey key) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.key = key;
            return this;
        }

        public MessageInfoBuilder message(@NonNull MessageContainer message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message$value = message;
            this.message$set = true;
            return this;
        }

        public MessageInfoBuilder timestampSeconds(long timestampSeconds) {
            this.timestampSeconds = timestampSeconds;
            return this;
        }

        public MessageInfoBuilder status(@NonNull MessageStatus status) {
            if (status == null) {
                throw new NullPointerException("status is marked non-null but is null");
            }
            this.status$value = status;
            this.status$set = true;
            return this;
        }

        public MessageInfoBuilder senderJid(ContactJid senderJid) {
            this.senderJid = senderJid;
            return this;
        }

        public MessageInfoBuilder sender(Contact sender) {
            this.sender = sender;
            return this;
        }

        public MessageInfoBuilder ignore(boolean ignore) {
            this.ignore = ignore;
            return this;
        }

        public MessageInfoBuilder starred(boolean starred) {
            this.starred = starred;
            return this;
        }

        public MessageInfoBuilder broadcast(boolean broadcast) {
            this.broadcast = broadcast;
            return this;
        }

        public MessageInfoBuilder pushName(String pushName) {
            this.pushName = pushName;
            return this;
        }

        public MessageInfoBuilder mediaCiphertextSha256(byte[] mediaCiphertextSha256) {
            this.mediaCiphertextSha256 = mediaCiphertextSha256;
            return this;
        }

        public MessageInfoBuilder multicast(boolean multicast) {
            this.multicast = multicast;
            return this;
        }

        public MessageInfoBuilder urlText(boolean urlText) {
            this.urlText = urlText;
            return this;
        }

        public MessageInfoBuilder urlNumber(boolean urlNumber) {
            this.urlNumber = urlNumber;
            return this;
        }

        public MessageInfoBuilder stubType(StubType stubType) {
            this.stubType = stubType;
            return this;
        }

        public MessageInfoBuilder clearMedia(boolean clearMedia) {
            this.clearMedia = clearMedia;
            return this;
        }

        public MessageInfoBuilder stubParameters(List<String> stubParameters) {
            this.stubParameters$value = stubParameters;
            this.stubParameters$set = true;
            return this;
        }

        public MessageInfoBuilder duration(int duration) {
            this.duration = duration;
            return this;
        }

        public MessageInfoBuilder labels(List<String> labels) {
            this.labels$value = labels;
            this.labels$set = true;
            return this;
        }

        public MessageInfoBuilder paymentInfo(PaymentInfo paymentInfo) {
            this.paymentInfo = paymentInfo;
            return this;
        }

        public MessageInfoBuilder finalLiveLocation(LiveLocationMessage finalLiveLocation) {
            this.finalLiveLocation = finalLiveLocation;
            return this;
        }

        public MessageInfoBuilder quotedPaymentInfo(PaymentInfo quotedPaymentInfo) {
            this.quotedPaymentInfo = quotedPaymentInfo;
            return this;
        }

        public MessageInfoBuilder ephemeralStartTimestamp(long ephemeralStartTimestamp) {
            this.ephemeralStartTimestamp = ephemeralStartTimestamp;
            return this;
        }

        public MessageInfoBuilder ephemeralDuration(int ephemeralDuration) {
            this.ephemeralDuration = ephemeralDuration;
            return this;
        }

        public MessageInfoBuilder enableEphemeral(boolean enableEphemeral) {
            this.enableEphemeral = enableEphemeral;
            return this;
        }

        public MessageInfoBuilder ephemeralOutOfSync(boolean ephemeralOutOfSync) {
            this.ephemeralOutOfSync = ephemeralOutOfSync;
            return this;
        }

        public MessageInfoBuilder businessPrivacyStatus(BusinessPrivacyStatus businessPrivacyStatus) {
            this.businessPrivacyStatus = businessPrivacyStatus;
            return this;
        }

        public MessageInfoBuilder businessVerifiedName(String businessVerifiedName) {
            this.businessVerifiedName = businessVerifiedName;
            return this;
        }

        public MessageInfoBuilder mediaData(MediaData mediaData) {
            this.mediaData = mediaData;
            return this;
        }

        public MessageInfoBuilder photoChange(PhotoChange photoChange) {
            this.photoChange = photoChange;
            return this;
        }

        public MessageInfoBuilder receipt(MessageReceipt receipt) {
            this.receipt$value = receipt;
            this.receipt$set = true;
            return this;
        }

        public MessageInfoBuilder reactions(List<ReactionMessage> reactions) {
            this.reactions$value = reactions;
            this.reactions$set = true;
            return this;
        }

        public MessageInfoBuilder quotedStickerData(MediaData quotedStickerData) {
            this.quotedStickerData = quotedStickerData;
            return this;
        }

        public MessageInfoBuilder futureProofData(byte[] futureProofData) {
            this.futureProofData = futureProofData;
            return this;
        }

        public MessageInfoBuilder psaStatus(PublicServiceAnnouncementStatus psaStatus) {
            this.psaStatus = psaStatus;
            return this;
        }

        public MessageInfoBuilder messageC2STimestamp(long messageC2STimestamp) {
            this.messageC2STimestamp = messageC2STimestamp;
            return this;
        }

        public MessageInfoBuilder pollUpdates(List<PollUpdate> pollUpdates) {
            this.pollUpdates$value = pollUpdates;
            this.pollUpdates$set = true;
            return this;
        }

        public MessageInfoBuilder pollAdditionalMetadata(PollAdditionalMetadata pollAdditionalMetadata) {
            this.pollAdditionalMetadata = pollAdditionalMetadata;
            return this;
        }

        public MessageInfoBuilder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public MessageInfoBuilder statusAlreadyViewed(boolean statusAlreadyViewed) {
            this.statusAlreadyViewed = statusAlreadyViewed;
            return this;
        }

        public MessageInfoBuilder messageSecret(byte[] messageSecret) {
            this.messageSecret = messageSecret;
            return this;
        }

        public MessageInfoBuilder keepInChat(KeepInChat keepInChat) {
            this.keepInChat = keepInChat;
            return this;
        }

        public MessageInfoBuilder originalSender(ContactJid originalSender) {
            this.originalSender = originalSender;
            return this;
        }

        public MessageInfoBuilder revokeTimestampSeconds(long revokeTimestampSeconds) {
            this.revokeTimestampSeconds = revokeTimestampSeconds;
            return this;
        }

        public MessageInfo build() {
            MessageContainer message$value = this.message$value;
            if (!this.message$set) {
                message$value = MessageInfo.$default$message();
            }
            MessageStatus status$value = this.status$value;
            if (!this.status$set) {
                status$value = MessageInfo.$default$status();
            }
            List<String> stubParameters$value = this.stubParameters$value;
            if (!this.stubParameters$set) {
                stubParameters$value = MessageInfo.$default$stubParameters();
            }
            List<String> labels$value = this.labels$value;
            if (!this.labels$set) {
                labels$value = MessageInfo.$default$labels();
            }
            MessageReceipt receipt$value = this.receipt$value;
            if (!this.receipt$set) {
                receipt$value = MessageInfo.$default$receipt();
            }
            List<ReactionMessage> reactions$value = this.reactions$value;
            if (!this.reactions$set) {
                reactions$value = MessageInfo.$default$reactions();
            }
            List<PollUpdate> pollUpdates$value = this.pollUpdates$value;
            if (!this.pollUpdates$set) {
                pollUpdates$value = MessageInfo.$default$pollUpdates();
            }
            return new MessageInfo(this.key, message$value, this.timestampSeconds, status$value, this.senderJid, this.sender, this.ignore, this.starred, this.broadcast, this.pushName, this.mediaCiphertextSha256, this.multicast, this.urlText, this.urlNumber, this.stubType, this.clearMedia, stubParameters$value, this.duration, labels$value, this.paymentInfo, this.finalLiveLocation, this.quotedPaymentInfo, this.ephemeralStartTimestamp, this.ephemeralDuration, this.enableEphemeral, this.ephemeralOutOfSync, this.businessPrivacyStatus, this.businessVerifiedName, this.mediaData, this.photoChange, receipt$value, reactions$value, this.quotedStickerData, this.futureProofData, this.psaStatus, this.messageC2STimestamp, pollUpdates$value, this.pollAdditionalMetadata, this.agentId, this.statusAlreadyViewed, this.messageSecret, this.keepInChat, this.originalSender, this.revokeTimestampSeconds);
        }

        public String toString() {
            return "MessageInfo.MessageInfoBuilder(key=" + this.key + ", message$value=" + this.message$value + ", timestampSeconds=" + this.timestampSeconds + ", status$value=" + this.status$value + ", senderJid=" + this.senderJid + ", sender=" + this.sender + ", ignore=" + this.ignore + ", starred=" + this.starred + ", broadcast=" + this.broadcast + ", pushName=" + this.pushName + ", mediaCiphertextSha256=" + Arrays.toString(this.mediaCiphertextSha256) + ", multicast=" + this.multicast + ", urlText=" + this.urlText + ", urlNumber=" + this.urlNumber + ", stubType=" + this.stubType + ", clearMedia=" + this.clearMedia + ", stubParameters$value=" + this.stubParameters$value + ", duration=" + this.duration + ", labels$value=" + this.labels$value + ", paymentInfo=" + this.paymentInfo + ", finalLiveLocation=" + this.finalLiveLocation + ", quotedPaymentInfo=" + this.quotedPaymentInfo + ", ephemeralStartTimestamp=" + this.ephemeralStartTimestamp + ", ephemeralDuration=" + this.ephemeralDuration + ", enableEphemeral=" + this.enableEphemeral + ", ephemeralOutOfSync=" + this.ephemeralOutOfSync + ", businessPrivacyStatus=" + this.businessPrivacyStatus + ", businessVerifiedName=" + this.businessVerifiedName + ", mediaData=" + this.mediaData + ", photoChange=" + this.photoChange + ", receipt$value=" + this.receipt$value + ", reactions$value=" + this.reactions$value + ", quotedStickerData=" + this.quotedStickerData + ", futureProofData=" + Arrays.toString(this.futureProofData) + ", psaStatus=" + this.psaStatus + ", messageC2STimestamp=" + this.messageC2STimestamp + ", pollUpdates$value=" + this.pollUpdates$value + ", pollAdditionalMetadata=" + this.pollAdditionalMetadata + ", agentId=" + this.agentId + ", statusAlreadyViewed=" + this.statusAlreadyViewed + ", messageSecret=" + Arrays.toString(this.messageSecret) + ", keepInChat=" + this.keepInChat + ", originalSender=" + this.originalSender + ", revokeTimestampSeconds=" + this.revokeTimestampSeconds + ")";
        }
    }
}

