/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.info;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufMessage;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.chat.ChatDisappear;
import it.auties.whatsapp.model.contact.Contact;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.model.info.AdReplyInfo;
import it.auties.whatsapp.model.info.ExternalAdReplyInfo;
import it.auties.whatsapp.model.info.Info;
import it.auties.whatsapp.model.message.model.ActionLink;
import it.auties.whatsapp.model.message.model.MessageContainer;
import it.auties.whatsapp.model.message.model.MessageKey;
import it.auties.whatsapp.model.message.model.MessageMetadataProvider;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

@JsonDeserialize(builder=ContextInfoBuilder.class)
public final class ContextInfo
implements Info,
ProtobufMessage {
    @ProtobufProperty(index=1, type=ProtobufType.STRING)
    private String quotedMessageId;
    @ProtobufProperty(index=2, type=ProtobufType.STRING)
    private ContactJid quotedMessageSenderJid;
    private Contact quotedMessageSender;
    @ProtobufProperty(index=3, type=ProtobufType.MESSAGE, implementation=MessageContainer.class)
    private MessageContainer quotedMessage;
    @ProtobufProperty(index=4, type=ProtobufType.STRING)
    private ContactJid quotedMessageChatJid;
    @JsonBackReference
    private Chat quotedMessageChat;
    @ProtobufProperty(index=15, type=ProtobufType.STRING, repeated=true, implementation=ContactJid.class)
    private List<ContactJid> mentions;
    @ProtobufProperty(index=18, type=ProtobufType.STRING)
    private String conversionSource;
    @ProtobufProperty(index=19, type=ProtobufType.BYTES)
    private byte[] conversionData;
    @ProtobufProperty(index=20, type=ProtobufType.UINT32)
    private int conversionDelaySeconds;
    @ProtobufProperty(index=21, type=ProtobufType.UINT32)
    private int forwardingScore;
    @ProtobufProperty(index=22, type=ProtobufType.BOOL)
    private boolean forwarded;
    @ProtobufProperty(index=23, type=ProtobufType.MESSAGE, implementation=AdReplyInfo.class)
    private AdReplyInfo quotedAd;
    @ProtobufProperty(index=24, type=ProtobufType.MESSAGE, implementation=MessageKey.class)
    private MessageKey placeholderKey;
    @ProtobufProperty(index=25, type=ProtobufType.UINT32)
    private int ephemeralExpiration;
    @ProtobufProperty(index=26, type=ProtobufType.INT64)
    private long ephemeralSettingTimestamp;
    @ProtobufProperty(index=27, type=ProtobufType.BYTES)
    private byte[] ephemeralSharedSecret;
    @ProtobufProperty(index=28, type=ProtobufType.MESSAGE, implementation=ExternalAdReplyInfo.class)
    private ExternalAdReplyInfo externalAdReply;
    @ProtobufProperty(index=29, type=ProtobufType.STRING)
    private String entryPointConversionSource;
    @ProtobufProperty(index=30, type=ProtobufType.STRING)
    private String entryPointConversionApp;
    @ProtobufProperty(index=31, type=ProtobufType.UINT32)
    private int entryPointConversionDelaySeconds;
    @ProtobufProperty(index=32, type=ProtobufType.MESSAGE, implementation=ChatDisappear.class)
    private ChatDisappear disappearingMode;
    @ProtobufProperty(index=33, type=ProtobufType.MESSAGE)
    private ActionLink actionLink;
    @ProtobufProperty(index=34, type=ProtobufType.STRING)
    private String groupSubject;
    @ProtobufProperty(index=35, type=ProtobufType.STRING)
    private ContactJid parentGroup;
    @ProtobufProperty(index=37, name="trustBannerType", type=ProtobufType.STRING)
    private String trustBannerType;
    @ProtobufProperty(index=38, name="trustBannerAction", type=ProtobufType.UINT32)
    private Integer trustBannerAction;

    private ContextInfo(@NonNull MessageMetadataProvider quotedMessage) {
        if (quotedMessage == null) {
            throw new NullPointerException("quotedMessage is marked non-null but is null");
        }
        this.quotedMessageId = quotedMessage.id();
        this.quotedMessageSenderJid = quotedMessage.senderJid();
        this.quotedMessageSender = quotedMessage.sender().orElse(null);
        this.quotedMessageChatJid = quotedMessage.chat().jid();
        this.quotedMessageChat = quotedMessage.chat();
        this.quotedMessage = quotedMessage.message();
    }

    public static ContextInfo of(@NonNull MessageMetadataProvider quotedMessage) {
        if (quotedMessage == null) {
            throw new NullPointerException("quotedMessage is marked non-null but is null");
        }
        return new ContextInfo(quotedMessage);
    }

    public Optional<Contact> quotedMessageSender() {
        return Optional.ofNullable(this.quotedMessageSender);
    }

    public Optional<ContactJid> quotedMessageChatJid() {
        return Optional.ofNullable(this.quotedMessageChatJid).or(this::quotedMessageSenderJid);
    }

    public Optional<ContactJid> quotedMessageSenderJid() {
        return Optional.ofNullable(this.quotedMessageSenderJid);
    }

    public boolean hasQuotedMessage() {
        return this.quotedMessageId().isPresent() && this.quotedMessage().isPresent() && this.quotedMessageChat().isPresent();
    }

    public Optional<String> quotedMessageId() {
        return Optional.ofNullable(this.quotedMessageId);
    }

    public Optional<MessageContainer> quotedMessage() {
        return Optional.ofNullable(this.quotedMessage);
    }

    public Optional<Chat> quotedMessageChat() {
        return Optional.ofNullable(this.quotedMessageChat);
    }

    private static List<ContactJid> $default$mentions() {
        return new ArrayList<ContactJid>();
    }

    public static ContextInfoBuilder builder() {
        return new ContextInfoBuilder();
    }

    public ContextInfo(String quotedMessageId, ContactJid quotedMessageSenderJid, Contact quotedMessageSender, MessageContainer quotedMessage, ContactJid quotedMessageChatJid, Chat quotedMessageChat, List<ContactJid> mentions, String conversionSource, byte[] conversionData, int conversionDelaySeconds, int forwardingScore, boolean forwarded, AdReplyInfo quotedAd, MessageKey placeholderKey, int ephemeralExpiration, long ephemeralSettingTimestamp, byte[] ephemeralSharedSecret, ExternalAdReplyInfo externalAdReply, String entryPointConversionSource, String entryPointConversionApp, int entryPointConversionDelaySeconds, ChatDisappear disappearingMode, ActionLink actionLink, String groupSubject, ContactJid parentGroup, String trustBannerType, Integer trustBannerAction) {
        this.quotedMessageId = quotedMessageId;
        this.quotedMessageSenderJid = quotedMessageSenderJid;
        this.quotedMessageSender = quotedMessageSender;
        this.quotedMessage = quotedMessage;
        this.quotedMessageChatJid = quotedMessageChatJid;
        this.quotedMessageChat = quotedMessageChat;
        this.mentions = mentions;
        this.conversionSource = conversionSource;
        this.conversionData = conversionData;
        this.conversionDelaySeconds = conversionDelaySeconds;
        this.forwardingScore = forwardingScore;
        this.forwarded = forwarded;
        this.quotedAd = quotedAd;
        this.placeholderKey = placeholderKey;
        this.ephemeralExpiration = ephemeralExpiration;
        this.ephemeralSettingTimestamp = ephemeralSettingTimestamp;
        this.ephemeralSharedSecret = ephemeralSharedSecret;
        this.externalAdReply = externalAdReply;
        this.entryPointConversionSource = entryPointConversionSource;
        this.entryPointConversionApp = entryPointConversionApp;
        this.entryPointConversionDelaySeconds = entryPointConversionDelaySeconds;
        this.disappearingMode = disappearingMode;
        this.actionLink = actionLink;
        this.groupSubject = groupSubject;
        this.parentGroup = parentGroup;
        this.trustBannerType = trustBannerType;
        this.trustBannerAction = trustBannerAction;
    }

    public ContextInfo() {
        this.mentions = ContextInfo.$default$mentions();
    }

    public List<ContactJid> mentions() {
        return this.mentions;
    }

    public String conversionSource() {
        return this.conversionSource;
    }

    public byte[] conversionData() {
        return this.conversionData;
    }

    public int conversionDelaySeconds() {
        return this.conversionDelaySeconds;
    }

    public int forwardingScore() {
        return this.forwardingScore;
    }

    public boolean forwarded() {
        return this.forwarded;
    }

    public AdReplyInfo quotedAd() {
        return this.quotedAd;
    }

    public MessageKey placeholderKey() {
        return this.placeholderKey;
    }

    public int ephemeralExpiration() {
        return this.ephemeralExpiration;
    }

    public long ephemeralSettingTimestamp() {
        return this.ephemeralSettingTimestamp;
    }

    public byte[] ephemeralSharedSecret() {
        return this.ephemeralSharedSecret;
    }

    public ExternalAdReplyInfo externalAdReply() {
        return this.externalAdReply;
    }

    public String entryPointConversionSource() {
        return this.entryPointConversionSource;
    }

    public String entryPointConversionApp() {
        return this.entryPointConversionApp;
    }

    public int entryPointConversionDelaySeconds() {
        return this.entryPointConversionDelaySeconds;
    }

    public ChatDisappear disappearingMode() {
        return this.disappearingMode;
    }

    public ActionLink actionLink() {
        return this.actionLink;
    }

    public String groupSubject() {
        return this.groupSubject;
    }

    public ContactJid parentGroup() {
        return this.parentGroup;
    }

    public String trustBannerType() {
        return this.trustBannerType;
    }

    public Integer trustBannerAction() {
        return this.trustBannerAction;
    }

    public ContextInfo quotedMessageSender(Contact quotedMessageSender) {
        this.quotedMessageSender = quotedMessageSender;
        return this;
    }

    public ContextInfo quotedMessageChat(Chat quotedMessageChat) {
        this.quotedMessageChat = quotedMessageChat;
        return this;
    }

    public ContextInfo mentions(List<ContactJid> mentions) {
        this.mentions = mentions;
        return this;
    }

    public ContextInfo conversionSource(String conversionSource) {
        this.conversionSource = conversionSource;
        return this;
    }

    public ContextInfo conversionData(byte[] conversionData) {
        this.conversionData = conversionData;
        return this;
    }

    public ContextInfo conversionDelaySeconds(int conversionDelaySeconds) {
        this.conversionDelaySeconds = conversionDelaySeconds;
        return this;
    }

    public ContextInfo forwardingScore(int forwardingScore) {
        this.forwardingScore = forwardingScore;
        return this;
    }

    public ContextInfo forwarded(boolean forwarded) {
        this.forwarded = forwarded;
        return this;
    }

    public ContextInfo quotedAd(AdReplyInfo quotedAd) {
        this.quotedAd = quotedAd;
        return this;
    }

    public ContextInfo placeholderKey(MessageKey placeholderKey) {
        this.placeholderKey = placeholderKey;
        return this;
    }

    public ContextInfo ephemeralExpiration(int ephemeralExpiration) {
        this.ephemeralExpiration = ephemeralExpiration;
        return this;
    }

    public ContextInfo ephemeralSettingTimestamp(long ephemeralSettingTimestamp) {
        this.ephemeralSettingTimestamp = ephemeralSettingTimestamp;
        return this;
    }

    public ContextInfo ephemeralSharedSecret(byte[] ephemeralSharedSecret) {
        this.ephemeralSharedSecret = ephemeralSharedSecret;
        return this;
    }

    public ContextInfo externalAdReply(ExternalAdReplyInfo externalAdReply) {
        this.externalAdReply = externalAdReply;
        return this;
    }

    public ContextInfo entryPointConversionSource(String entryPointConversionSource) {
        this.entryPointConversionSource = entryPointConversionSource;
        return this;
    }

    public ContextInfo entryPointConversionApp(String entryPointConversionApp) {
        this.entryPointConversionApp = entryPointConversionApp;
        return this;
    }

    public ContextInfo entryPointConversionDelaySeconds(int entryPointConversionDelaySeconds) {
        this.entryPointConversionDelaySeconds = entryPointConversionDelaySeconds;
        return this;
    }

    public ContextInfo disappearingMode(ChatDisappear disappearingMode) {
        this.disappearingMode = disappearingMode;
        return this;
    }

    public ContextInfo actionLink(ActionLink actionLink) {
        this.actionLink = actionLink;
        return this;
    }

    public ContextInfo groupSubject(String groupSubject) {
        this.groupSubject = groupSubject;
        return this;
    }

    public ContextInfo parentGroup(ContactJid parentGroup) {
        this.parentGroup = parentGroup;
        return this;
    }

    public ContextInfo trustBannerType(String trustBannerType) {
        this.trustBannerType = trustBannerType;
        return this;
    }

    public ContextInfo trustBannerAction(Integer trustBannerAction) {
        this.trustBannerAction = trustBannerAction;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextInfo)) {
            return false;
        }
        ContextInfo other = (ContextInfo)o;
        if (this.conversionDelaySeconds() != other.conversionDelaySeconds()) {
            return false;
        }
        if (this.forwardingScore() != other.forwardingScore()) {
            return false;
        }
        if (this.forwarded() != other.forwarded()) {
            return false;
        }
        if (this.ephemeralExpiration() != other.ephemeralExpiration()) {
            return false;
        }
        if (this.ephemeralSettingTimestamp() != other.ephemeralSettingTimestamp()) {
            return false;
        }
        if (this.entryPointConversionDelaySeconds() != other.entryPointConversionDelaySeconds()) {
            return false;
        }
        Integer this$trustBannerAction = this.trustBannerAction();
        Integer other$trustBannerAction = other.trustBannerAction();
        if (this$trustBannerAction == null ? other$trustBannerAction != null : !((Object)this$trustBannerAction).equals(other$trustBannerAction)) {
            return false;
        }
        Optional<String> this$quotedMessageId = this.quotedMessageId();
        Optional<String> other$quotedMessageId = other.quotedMessageId();
        if (this$quotedMessageId == null ? other$quotedMessageId != null : !((Object)this$quotedMessageId).equals(other$quotedMessageId)) {
            return false;
        }
        Optional<ContactJid> this$quotedMessageSenderJid = this.quotedMessageSenderJid();
        Optional<ContactJid> other$quotedMessageSenderJid = other.quotedMessageSenderJid();
        if (this$quotedMessageSenderJid == null ? other$quotedMessageSenderJid != null : !((Object)this$quotedMessageSenderJid).equals(other$quotedMessageSenderJid)) {
            return false;
        }
        Optional<Contact> this$quotedMessageSender = this.quotedMessageSender();
        Optional<Contact> other$quotedMessageSender = other.quotedMessageSender();
        if (this$quotedMessageSender == null ? other$quotedMessageSender != null : !((Object)this$quotedMessageSender).equals(other$quotedMessageSender)) {
            return false;
        }
        Optional<MessageContainer> this$quotedMessage = this.quotedMessage();
        Optional<MessageContainer> other$quotedMessage = other.quotedMessage();
        if (this$quotedMessage == null ? other$quotedMessage != null : !((Object)this$quotedMessage).equals(other$quotedMessage)) {
            return false;
        }
        Optional<ContactJid> this$quotedMessageChatJid = this.quotedMessageChatJid();
        Optional<ContactJid> other$quotedMessageChatJid = other.quotedMessageChatJid();
        if (this$quotedMessageChatJid == null ? other$quotedMessageChatJid != null : !((Object)this$quotedMessageChatJid).equals(other$quotedMessageChatJid)) {
            return false;
        }
        Optional<Chat> this$quotedMessageChat = this.quotedMessageChat();
        Optional<Chat> other$quotedMessageChat = other.quotedMessageChat();
        if (this$quotedMessageChat == null ? other$quotedMessageChat != null : !((Object)this$quotedMessageChat).equals(other$quotedMessageChat)) {
            return false;
        }
        List<ContactJid> this$mentions = this.mentions();
        List<ContactJid> other$mentions = other.mentions();
        if (this$mentions == null ? other$mentions != null : !((Object)this$mentions).equals(other$mentions)) {
            return false;
        }
        String this$conversionSource = this.conversionSource();
        String other$conversionSource = other.conversionSource();
        if (this$conversionSource == null ? other$conversionSource != null : !this$conversionSource.equals(other$conversionSource)) {
            return false;
        }
        if (!Arrays.equals(this.conversionData(), other.conversionData())) {
            return false;
        }
        AdReplyInfo this$quotedAd = this.quotedAd();
        AdReplyInfo other$quotedAd = other.quotedAd();
        if (this$quotedAd == null ? other$quotedAd != null : !((Object)this$quotedAd).equals(other$quotedAd)) {
            return false;
        }
        MessageKey this$placeholderKey = this.placeholderKey();
        MessageKey other$placeholderKey = other.placeholderKey();
        if (this$placeholderKey == null ? other$placeholderKey != null : !((Object)this$placeholderKey).equals(other$placeholderKey)) {
            return false;
        }
        if (!Arrays.equals(this.ephemeralSharedSecret(), other.ephemeralSharedSecret())) {
            return false;
        }
        ExternalAdReplyInfo this$externalAdReply = this.externalAdReply();
        ExternalAdReplyInfo other$externalAdReply = other.externalAdReply();
        if (this$externalAdReply == null ? other$externalAdReply != null : !((Object)this$externalAdReply).equals(other$externalAdReply)) {
            return false;
        }
        String this$entryPointConversionSource = this.entryPointConversionSource();
        String other$entryPointConversionSource = other.entryPointConversionSource();
        if (this$entryPointConversionSource == null ? other$entryPointConversionSource != null : !this$entryPointConversionSource.equals(other$entryPointConversionSource)) {
            return false;
        }
        String this$entryPointConversionApp = this.entryPointConversionApp();
        String other$entryPointConversionApp = other.entryPointConversionApp();
        if (this$entryPointConversionApp == null ? other$entryPointConversionApp != null : !this$entryPointConversionApp.equals(other$entryPointConversionApp)) {
            return false;
        }
        ChatDisappear this$disappearingMode = this.disappearingMode();
        ChatDisappear other$disappearingMode = other.disappearingMode();
        if (this$disappearingMode == null ? other$disappearingMode != null : !((Object)this$disappearingMode).equals(other$disappearingMode)) {
            return false;
        }
        ActionLink this$actionLink = this.actionLink();
        ActionLink other$actionLink = other.actionLink();
        if (this$actionLink == null ? other$actionLink != null : !((Object)this$actionLink).equals(other$actionLink)) {
            return false;
        }
        String this$groupSubject = this.groupSubject();
        String other$groupSubject = other.groupSubject();
        if (this$groupSubject == null ? other$groupSubject != null : !this$groupSubject.equals(other$groupSubject)) {
            return false;
        }
        ContactJid this$parentGroup = this.parentGroup();
        ContactJid other$parentGroup = other.parentGroup();
        if (this$parentGroup == null ? other$parentGroup != null : !((Object)this$parentGroup).equals(other$parentGroup)) {
            return false;
        }
        String this$trustBannerType = this.trustBannerType();
        String other$trustBannerType = other.trustBannerType();
        return !(this$trustBannerType == null ? other$trustBannerType != null : !this$trustBannerType.equals(other$trustBannerType));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.conversionDelaySeconds();
        result = result * 59 + this.forwardingScore();
        result = result * 59 + (this.forwarded() ? 79 : 97);
        result = result * 59 + this.ephemeralExpiration();
        long $ephemeralSettingTimestamp = this.ephemeralSettingTimestamp();
        result = result * 59 + (int)($ephemeralSettingTimestamp >>> 32 ^ $ephemeralSettingTimestamp);
        result = result * 59 + this.entryPointConversionDelaySeconds();
        Integer $trustBannerAction = this.trustBannerAction();
        result = result * 59 + ($trustBannerAction == null ? 43 : ((Object)$trustBannerAction).hashCode());
        Optional<String> $quotedMessageId = this.quotedMessageId();
        result = result * 59 + ($quotedMessageId == null ? 43 : ((Object)$quotedMessageId).hashCode());
        Optional<ContactJid> $quotedMessageSenderJid = this.quotedMessageSenderJid();
        result = result * 59 + ($quotedMessageSenderJid == null ? 43 : ((Object)$quotedMessageSenderJid).hashCode());
        Optional<Contact> $quotedMessageSender = this.quotedMessageSender();
        result = result * 59 + ($quotedMessageSender == null ? 43 : ((Object)$quotedMessageSender).hashCode());
        Optional<MessageContainer> $quotedMessage = this.quotedMessage();
        result = result * 59 + ($quotedMessage == null ? 43 : ((Object)$quotedMessage).hashCode());
        Optional<ContactJid> $quotedMessageChatJid = this.quotedMessageChatJid();
        result = result * 59 + ($quotedMessageChatJid == null ? 43 : ((Object)$quotedMessageChatJid).hashCode());
        Optional<Chat> $quotedMessageChat = this.quotedMessageChat();
        result = result * 59 + ($quotedMessageChat == null ? 43 : ((Object)$quotedMessageChat).hashCode());
        List<ContactJid> $mentions = this.mentions();
        result = result * 59 + ($mentions == null ? 43 : ((Object)$mentions).hashCode());
        String $conversionSource = this.conversionSource();
        result = result * 59 + ($conversionSource == null ? 43 : $conversionSource.hashCode());
        result = result * 59 + Arrays.hashCode(this.conversionData());
        AdReplyInfo $quotedAd = this.quotedAd();
        result = result * 59 + ($quotedAd == null ? 43 : ((Object)$quotedAd).hashCode());
        MessageKey $placeholderKey = this.placeholderKey();
        result = result * 59 + ($placeholderKey == null ? 43 : ((Object)$placeholderKey).hashCode());
        result = result * 59 + Arrays.hashCode(this.ephemeralSharedSecret());
        ExternalAdReplyInfo $externalAdReply = this.externalAdReply();
        result = result * 59 + ($externalAdReply == null ? 43 : ((Object)$externalAdReply).hashCode());
        String $entryPointConversionSource = this.entryPointConversionSource();
        result = result * 59 + ($entryPointConversionSource == null ? 43 : $entryPointConversionSource.hashCode());
        String $entryPointConversionApp = this.entryPointConversionApp();
        result = result * 59 + ($entryPointConversionApp == null ? 43 : $entryPointConversionApp.hashCode());
        ChatDisappear $disappearingMode = this.disappearingMode();
        result = result * 59 + ($disappearingMode == null ? 43 : ((Object)$disappearingMode).hashCode());
        ActionLink $actionLink = this.actionLink();
        result = result * 59 + ($actionLink == null ? 43 : ((Object)$actionLink).hashCode());
        String $groupSubject = this.groupSubject();
        result = result * 59 + ($groupSubject == null ? 43 : $groupSubject.hashCode());
        ContactJid $parentGroup = this.parentGroup();
        result = result * 59 + ($parentGroup == null ? 43 : ((Object)$parentGroup).hashCode());
        String $trustBannerType = this.trustBannerType();
        result = result * 59 + ($trustBannerType == null ? 43 : $trustBannerType.hashCode());
        return result;
    }

    public String toString() {
        return "ContextInfo(quotedMessageId=" + this.quotedMessageId() + ", quotedMessageSenderJid=" + this.quotedMessageSenderJid() + ", quotedMessageSender=" + this.quotedMessageSender() + ", quotedMessage=" + this.quotedMessage() + ", quotedMessageChatJid=" + this.quotedMessageChatJid() + ", mentions=" + this.mentions() + ", conversionSource=" + this.conversionSource() + ", conversionData=" + Arrays.toString(this.conversionData()) + ", conversionDelaySeconds=" + this.conversionDelaySeconds() + ", forwardingScore=" + this.forwardingScore() + ", forwarded=" + this.forwarded() + ", quotedAd=" + this.quotedAd() + ", placeholderKey=" + this.placeholderKey() + ", ephemeralExpiration=" + this.ephemeralExpiration() + ", ephemeralSettingTimestamp=" + this.ephemeralSettingTimestamp() + ", ephemeralSharedSecret=" + Arrays.toString(this.ephemeralSharedSecret()) + ", externalAdReply=" + this.externalAdReply() + ", entryPointConversionSource=" + this.entryPointConversionSource() + ", entryPointConversionApp=" + this.entryPointConversionApp() + ", entryPointConversionDelaySeconds=" + this.entryPointConversionDelaySeconds() + ", disappearingMode=" + this.disappearingMode() + ", actionLink=" + this.actionLink() + ", groupSubject=" + this.groupSubject() + ", parentGroup=" + this.parentGroup() + ", trustBannerType=" + this.trustBannerType() + ", trustBannerAction=" + this.trustBannerAction() + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        if (this.conversionData != null) {
            protobufOutputStream.writeBytes(19, this.conversionData);
        }
        protobufOutputStream.writeUInt32(25, this.ephemeralExpiration);
        protobufOutputStream.writeUInt32(20, this.conversionDelaySeconds);
        if (this.externalAdReply != null) {
            protobufOutputStream.writeBytes(28, this.externalAdReply.toEncodedProtobuf());
        }
        if (this.conversionSource != null) {
            protobufOutputStream.writeString(18, this.conversionSource);
        }
        protobufOutputStream.writeBool(22, this.forwarded);
        if (this.parentGroup != null) {
            protobufOutputStream.writeString(35, this.parentGroup.toValue());
        }
        if (this.trustBannerType != null) {
            protobufOutputStream.writeString(37, this.trustBannerType);
        }
        if (this.entryPointConversionSource != null) {
            protobufOutputStream.writeString(29, this.entryPointConversionSource);
        }
        if (this.mentions != null) {
            for (ContactJid contactJid : this.mentions) {
                protobufOutputStream.writeString(15, contactJid.toValue());
            }
        }
        protobufOutputStream.writeInt64(26, this.ephemeralSettingTimestamp);
        protobufOutputStream.writeUInt32(21, this.forwardingScore);
        if (this.groupSubject != null) {
            protobufOutputStream.writeString(34, this.groupSubject);
        }
        if (this.quotedMessageChatJid != null) {
            protobufOutputStream.writeString(4, this.quotedMessageChatJid.toValue());
        }
        if (this.quotedMessageSenderJid != null) {
            protobufOutputStream.writeString(2, this.quotedMessageSenderJid.toValue());
        }
        protobufOutputStream.writeUInt32(31, this.entryPointConversionDelaySeconds);
        if (this.quotedAd != null) {
            protobufOutputStream.writeBytes(23, this.quotedAd.toEncodedProtobuf());
        }
        if (this.disappearingMode != null) {
            protobufOutputStream.writeBytes(32, this.disappearingMode.toEncodedProtobuf());
        }
        if (this.entryPointConversionApp != null) {
            protobufOutputStream.writeString(30, this.entryPointConversionApp);
        }
        if (this.ephemeralSharedSecret != null) {
            protobufOutputStream.writeBytes(27, this.ephemeralSharedSecret);
        }
        if (this.trustBannerAction != null) {
            protobufOutputStream.writeUInt32(38, this.trustBannerAction);
        }
        if (this.placeholderKey != null) {
            protobufOutputStream.writeBytes(24, this.placeholderKey.toEncodedProtobuf());
        }
        if (this.quotedMessage != null) {
            protobufOutputStream.writeBytes(3, this.quotedMessage.toEncodedProtobuf());
        }
        if (this.actionLink != null) {
            protobufOutputStream.writeBytes(33, this.actionLink.toEncodedProtobuf());
        }
        if (this.quotedMessageId != null) {
            protobufOutputStream.writeString(1, this.quotedMessageId);
        }
        return protobufOutputStream.toByteArray();
    }

    public static ContextInfo ofProtobuf(byte[] byArray) {
        int n;
        ContextInfoBuilder contextInfoBuilder = ContextInfo.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        ArrayList<ContactJid> arrayList = new ArrayList<ContactJid>();
        block27: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 19: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    contextInfoBuilder.conversionData(protobufInputStream.readBytes());
                    continue block27;
                }
                case 25: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    contextInfoBuilder.ephemeralExpiration(protobufInputStream.readInt32());
                    continue block27;
                }
                case 20: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    contextInfoBuilder.conversionDelaySeconds(protobufInputStream.readInt32());
                    continue block27;
                }
                case 28: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    contextInfoBuilder.externalAdReply(ExternalAdReplyInfo.ofProtobuf(protobufInputStream.readBytes()));
                    continue block27;
                }
                case 18: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    contextInfoBuilder.conversionSource(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block27;
                }
                case 22: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    contextInfoBuilder.forwarded(protobufInputStream.readBool());
                    continue block27;
                }
                case 35: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    contextInfoBuilder.parentGroup(ContactJid.ofProtobuf(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8)));
                    continue block27;
                }
                case 37: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    contextInfoBuilder.trustBannerType(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block27;
                }
                case 29: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    contextInfoBuilder.entryPointConversionSource(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block27;
                }
                case 15: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    arrayList.add(ContactJid.ofProtobuf(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8)));
                    continue block27;
                }
                case 26: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    contextInfoBuilder.ephemeralSettingTimestamp(protobufInputStream.readInt64());
                    continue block27;
                }
                case 21: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    contextInfoBuilder.forwardingScore(protobufInputStream.readInt32());
                    continue block27;
                }
                case 34: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    contextInfoBuilder.groupSubject(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block27;
                }
                case 4: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    contextInfoBuilder.quotedMessageChatJid(ContactJid.ofProtobuf(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8)));
                    continue block27;
                }
                case 2: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    contextInfoBuilder.quotedMessageSenderJid(ContactJid.ofProtobuf(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8)));
                    continue block27;
                }
                case 31: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    contextInfoBuilder.entryPointConversionDelaySeconds(protobufInputStream.readInt32());
                    continue block27;
                }
                case 23: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    contextInfoBuilder.quotedAd(AdReplyInfo.ofProtobuf(protobufInputStream.readBytes()));
                    continue block27;
                }
                case 32: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    contextInfoBuilder.disappearingMode(ChatDisappear.ofProtobuf(protobufInputStream.readBytes()));
                    continue block27;
                }
                case 30: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    contextInfoBuilder.entryPointConversionApp(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block27;
                }
                case 27: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    contextInfoBuilder.ephemeralSharedSecret(protobufInputStream.readBytes());
                    continue block27;
                }
                case 38: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    contextInfoBuilder.trustBannerAction(protobufInputStream.readInt32());
                    continue block27;
                }
                case 24: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    contextInfoBuilder.placeholderKey(MessageKey.ofProtobuf(protobufInputStream.readBytes()));
                    continue block27;
                }
                case 3: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    contextInfoBuilder.quotedMessage(MessageContainer.ofProtobuf(protobufInputStream.readBytes()));
                    continue block27;
                }
                case 33: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    contextInfoBuilder.actionLink(ActionLink.ofProtobuf(protobufInputStream.readBytes()));
                    continue block27;
                }
                case 1: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    contextInfoBuilder.quotedMessageId(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block27;
                }
            }
            protobufInputStream.readBytes();
        }
        contextInfoBuilder.mentions(arrayList);
        return contextInfoBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class ContextInfoBuilder {
        private String quotedMessageId;
        private ContactJid quotedMessageSenderJid;
        private Contact quotedMessageSender;
        private MessageContainer quotedMessage;
        private ContactJid quotedMessageChatJid;
        private Chat quotedMessageChat;
        private boolean mentions$set;
        private List<ContactJid> mentions$value;
        private String conversionSource;
        private byte[] conversionData;
        private int conversionDelaySeconds;
        private int forwardingScore;
        private boolean forwarded;
        private AdReplyInfo quotedAd;
        private MessageKey placeholderKey;
        private int ephemeralExpiration;
        private long ephemeralSettingTimestamp;
        private byte[] ephemeralSharedSecret;
        private ExternalAdReplyInfo externalAdReply;
        private String entryPointConversionSource;
        private String entryPointConversionApp;
        private int entryPointConversionDelaySeconds;
        private ChatDisappear disappearingMode;
        private ActionLink actionLink;
        private String groupSubject;
        private ContactJid parentGroup;
        private String trustBannerType;
        private Integer trustBannerAction;

        ContextInfoBuilder() {
        }

        public ContextInfoBuilder quotedMessageId(String quotedMessageId) {
            this.quotedMessageId = quotedMessageId;
            return this;
        }

        public ContextInfoBuilder quotedMessageSenderJid(ContactJid quotedMessageSenderJid) {
            this.quotedMessageSenderJid = quotedMessageSenderJid;
            return this;
        }

        public ContextInfoBuilder quotedMessageSender(Contact quotedMessageSender) {
            this.quotedMessageSender = quotedMessageSender;
            return this;
        }

        public ContextInfoBuilder quotedMessage(MessageContainer quotedMessage) {
            this.quotedMessage = quotedMessage;
            return this;
        }

        public ContextInfoBuilder quotedMessageChatJid(ContactJid quotedMessageChatJid) {
            this.quotedMessageChatJid = quotedMessageChatJid;
            return this;
        }

        public ContextInfoBuilder quotedMessageChat(Chat quotedMessageChat) {
            this.quotedMessageChat = quotedMessageChat;
            return this;
        }

        public ContextInfoBuilder mentions(List<ContactJid> mentions) {
            this.mentions$value = mentions;
            this.mentions$set = true;
            return this;
        }

        public ContextInfoBuilder conversionSource(String conversionSource) {
            this.conversionSource = conversionSource;
            return this;
        }

        public ContextInfoBuilder conversionData(byte[] conversionData) {
            this.conversionData = conversionData;
            return this;
        }

        public ContextInfoBuilder conversionDelaySeconds(int conversionDelaySeconds) {
            this.conversionDelaySeconds = conversionDelaySeconds;
            return this;
        }

        public ContextInfoBuilder forwardingScore(int forwardingScore) {
            this.forwardingScore = forwardingScore;
            return this;
        }

        public ContextInfoBuilder forwarded(boolean forwarded) {
            this.forwarded = forwarded;
            return this;
        }

        public ContextInfoBuilder quotedAd(AdReplyInfo quotedAd) {
            this.quotedAd = quotedAd;
            return this;
        }

        public ContextInfoBuilder placeholderKey(MessageKey placeholderKey) {
            this.placeholderKey = placeholderKey;
            return this;
        }

        public ContextInfoBuilder ephemeralExpiration(int ephemeralExpiration) {
            this.ephemeralExpiration = ephemeralExpiration;
            return this;
        }

        public ContextInfoBuilder ephemeralSettingTimestamp(long ephemeralSettingTimestamp) {
            this.ephemeralSettingTimestamp = ephemeralSettingTimestamp;
            return this;
        }

        public ContextInfoBuilder ephemeralSharedSecret(byte[] ephemeralSharedSecret) {
            this.ephemeralSharedSecret = ephemeralSharedSecret;
            return this;
        }

        public ContextInfoBuilder externalAdReply(ExternalAdReplyInfo externalAdReply) {
            this.externalAdReply = externalAdReply;
            return this;
        }

        public ContextInfoBuilder entryPointConversionSource(String entryPointConversionSource) {
            this.entryPointConversionSource = entryPointConversionSource;
            return this;
        }

        public ContextInfoBuilder entryPointConversionApp(String entryPointConversionApp) {
            this.entryPointConversionApp = entryPointConversionApp;
            return this;
        }

        public ContextInfoBuilder entryPointConversionDelaySeconds(int entryPointConversionDelaySeconds) {
            this.entryPointConversionDelaySeconds = entryPointConversionDelaySeconds;
            return this;
        }

        public ContextInfoBuilder disappearingMode(ChatDisappear disappearingMode) {
            this.disappearingMode = disappearingMode;
            return this;
        }

        public ContextInfoBuilder actionLink(ActionLink actionLink) {
            this.actionLink = actionLink;
            return this;
        }

        public ContextInfoBuilder groupSubject(String groupSubject) {
            this.groupSubject = groupSubject;
            return this;
        }

        public ContextInfoBuilder parentGroup(ContactJid parentGroup) {
            this.parentGroup = parentGroup;
            return this;
        }

        public ContextInfoBuilder trustBannerType(String trustBannerType) {
            this.trustBannerType = trustBannerType;
            return this;
        }

        public ContextInfoBuilder trustBannerAction(Integer trustBannerAction) {
            this.trustBannerAction = trustBannerAction;
            return this;
        }

        public ContextInfo build() {
            List<ContactJid> mentions$value = this.mentions$value;
            if (!this.mentions$set) {
                mentions$value = ContextInfo.$default$mentions();
            }
            return new ContextInfo(this.quotedMessageId, this.quotedMessageSenderJid, this.quotedMessageSender, this.quotedMessage, this.quotedMessageChatJid, this.quotedMessageChat, mentions$value, this.conversionSource, this.conversionData, this.conversionDelaySeconds, this.forwardingScore, this.forwarded, this.quotedAd, this.placeholderKey, this.ephemeralExpiration, this.ephemeralSettingTimestamp, this.ephemeralSharedSecret, this.externalAdReply, this.entryPointConversionSource, this.entryPointConversionApp, this.entryPointConversionDelaySeconds, this.disappearingMode, this.actionLink, this.groupSubject, this.parentGroup, this.trustBannerType, this.trustBannerAction);
        }

        public String toString() {
            return "ContextInfo.ContextInfoBuilder(quotedMessageId=" + this.quotedMessageId + ", quotedMessageSenderJid=" + this.quotedMessageSenderJid + ", quotedMessageSender=" + this.quotedMessageSender + ", quotedMessage=" + this.quotedMessage + ", quotedMessageChatJid=" + this.quotedMessageChatJid + ", quotedMessageChat=" + this.quotedMessageChat + ", mentions$value=" + this.mentions$value + ", conversionSource=" + this.conversionSource + ", conversionData=" + Arrays.toString(this.conversionData) + ", conversionDelaySeconds=" + this.conversionDelaySeconds + ", forwardingScore=" + this.forwardingScore + ", forwarded=" + this.forwarded + ", quotedAd=" + this.quotedAd + ", placeholderKey=" + this.placeholderKey + ", ephemeralExpiration=" + this.ephemeralExpiration + ", ephemeralSettingTimestamp=" + this.ephemeralSettingTimestamp + ", ephemeralSharedSecret=" + Arrays.toString(this.ephemeralSharedSecret) + ", externalAdReply=" + this.externalAdReply + ", entryPointConversionSource=" + this.entryPointConversionSource + ", entryPointConversionApp=" + this.entryPointConversionApp + ", entryPointConversionDelaySeconds=" + this.entryPointConversionDelaySeconds + ", disappearingMode=" + this.disappearingMode + ", actionLink=" + this.actionLink + ", groupSubject=" + this.groupSubject + ", parentGroup=" + this.parentGroup + ", trustBannerType=" + this.trustBannerType + ", trustBannerAction=" + this.trustBannerAction + ")";
        }
    }
}

