/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.contact;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import it.auties.protobuf.base.ProtobufConverter;
import it.auties.whatsapp.model.contact.ContactJidProvider;
import it.auties.whatsapp.model.signal.session.SessionAddress;
import java.util.Arrays;
import java.util.Objects;
import lombok.NonNull;

public record ContactJid(String user, @NonNull Server server, int device, int agent) implements ContactJidProvider
{
    public ContactJid(String user, @NonNull Server server, int device, int agent) {
        if (server == null) {
            throw new NullPointerException("server is marked non-null but is null");
        }
        this.user = user != null && user.startsWith("+") ? user.substring(1) : user;
        this.server = server;
        this.device = device;
        this.agent = agent;
    }

    public static ContactJid ofServer(@NonNull Server server) {
        if (server == null) {
            throw new NullPointerException("server is marked non-null but is null");
        }
        return ContactJid.of(null, server);
    }

    public static ContactJid of(String jid, @NonNull Server server) {
        if (server == null) {
            throw new NullPointerException("server is marked non-null but is null");
        }
        String complexUser = ContactJid.withoutServer(jid);
        if (complexUser == null) {
            return new ContactJid(null, server, 0, 0);
        }
        if (complexUser.contains(":")) {
            String[] simpleUser = complexUser.split(":", 2);
            String user = simpleUser[0];
            int device = Integer.parseUnsignedInt(simpleUser[1]);
            if (user.contains("_")) {
                String[] simpleUserAgent = user.split("_", 2);
                int agent = ContactJid.tryParseAgent(simpleUserAgent[1]);
                return new ContactJid(simpleUserAgent[0], server, device, agent);
            }
            return new ContactJid(user, server, device, 0);
        }
        if (!complexUser.contains("_")) {
            return new ContactJid(complexUser, server, 0, 0);
        }
        String[] simpleUserAgent = complexUser.split("_", 2);
        int agent = ContactJid.tryParseAgent(simpleUserAgent[1]);
        return new ContactJid(simpleUserAgent[0], server, 0, agent);
    }

    public static String withoutServer(String jid) {
        if (jid == null) {
            return null;
        }
        for (Server server : Server.values()) {
            jid = jid.replace("@%s".formatted(new Object[]{server}), "");
        }
        return jid;
    }

    private static int tryParseAgent(String string) {
        try {
            return Integer.parseUnsignedInt(string);
        }
        catch (NumberFormatException exception) {
            return 0;
        }
    }

    public static ContactJid ofDevice(String jid, int device, int agent) {
        return new ContactJid(ContactJid.withoutServer(jid), Server.WHATSAPP, device, agent);
    }

    public static ContactJid ofDevice(String jid, int device) {
        return new ContactJid(ContactJid.withoutServer(jid), Server.WHATSAPP, device, 0);
    }

    @ProtobufConverter
    public static ContactJid ofProtobuf(String input) {
        return input == null ? null : ContactJid.of(input);
    }

    @ProtobufConverter
    public String toValue() {
        return this.toString();
    }

    @JsonCreator
    public static ContactJid of(@NonNull String jid) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        return ContactJid.of(jid, Server.of(jid));
    }

    public static ContactJid of(long jid) {
        return ContactJid.of(String.valueOf(jid), Server.WHATSAPP);
    }

    public Type type() {
        Type type;
        if (this.isCompanion()) {
            type = Type.COMPANION;
        } else {
            block0 : switch (this.server()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case WHATSAPP: {
                    if (Objects.equals(this.user(), "16505361212")) {
                        type = Type.OFFICIAL_SURVEY_ACCOUNT;
                        break;
                    }
                    type = Type.USER;
                    break;
                }
                case LID: {
                    type = Type.LID;
                    break;
                }
                case BROADCAST: {
                    if (Objects.equals(this.user(), "status")) {
                        type = Type.STATUS;
                        break;
                    }
                    type = Type.BROADCAST;
                    break;
                }
                case GROUP: {
                    type = Type.GROUP;
                    break;
                }
                case GROUP_CALL: {
                    type = Type.GROUP_CALL;
                    break;
                }
                case USER: {
                    switch (this.user()) {
                        case "server": {
                            type = Type.SERVER;
                            break block0;
                        }
                        case "0": {
                            type = Type.ANNOUNCEMENT;
                            break block0;
                        }
                        case "16508638904": {
                            type = Type.IAS;
                            break block0;
                        }
                        case "16505361212": {
                            type = Type.OFFICIAL_BUSINESS_ACCOUNT;
                            break block0;
                        }
                    }
                    type = Type.UNKNOWN;
                }
            }
        }
        return type;
    }

    public boolean isCompanion() {
        return this.device() != 0;
    }

    public boolean hasServer(Server server) {
        return this.server() == server;
    }

    public boolean isServerJid(Server server) {
        return this.user() == null && this.server() == server;
    }

    public ContactJid toWhatsappJid() {
        return ContactJid.of(this.user(), this.server());
    }

    public String toPhoneNumber() {
        return "+%s".formatted(this.user);
    }

    @Override
    @JsonValue
    public String toString() {
        String user = Objects.requireNonNullElse(this.user(), "");
        String agent = this.agent() != 0 ? "_%s".formatted(this.agent()) : "";
        String device = this.device() != 0 ? ":%s".formatted(this.device()) : "";
        String leading = "%s%s%s".formatted(user, agent, device);
        return leading.isEmpty() ? this.server().toString() : "%s@%s".formatted(new Object[]{leading, this.server()});
    }

    public SessionAddress toSignalAddress() {
        return new SessionAddress(this.user(), this.device());
    }

    @Override
    @NonNull
    public ContactJid toJid() {
        return this;
    }

    public boolean hasDevice() {
        return this.device != 0;
    }

    public boolean hasAgent() {
        return this.agent != 0;
    }

    public static ContactJidBuilder builder() {
        return new ContactJidBuilder();
    }

    public ContactJid withUser(String user) {
        return this.user == user ? this : new ContactJid(user, this.server, this.device, this.agent);
    }

    public ContactJid withServer(@NonNull Server server) {
        if (server == null) {
            throw new NullPointerException("server is marked non-null but is null");
        }
        return this.server == server ? this : new ContactJid(this.user, server, this.device, this.agent);
    }

    public ContactJid withDevice(int device) {
        return this.device == device ? this : new ContactJid(this.user, this.server, device, this.agent);
    }

    public ContactJid withAgent(int agent) {
        return this.agent == agent ? this : new ContactJid(this.user, this.server, this.device, agent);
    }

    public static enum Server {
        USER("c.us"),
        GROUP("g.us"),
        BROADCAST("broadcast"),
        GROUP_CALL("call"),
        WHATSAPP("s.whatsapp.net"),
        LID("lid");

        private final String address;

        @JsonCreator
        public static Server of(String address) {
            return Arrays.stream(Server.values()).filter(entry -> address != null && address.endsWith(entry.address())).findFirst().orElse(WHATSAPP);
        }

        public ContactJid toJid() {
            return ContactJid.ofServer(this);
        }

        @JsonValue
        public String toString() {
            return this.address();
        }

        private Server(String address) {
            this.address = address;
        }

        public String address() {
            return this.address;
        }
    }

    public static enum Type {
        COMPANION,
        USER,
        OFFICIAL_SURVEY_ACCOUNT,
        LID,
        BROADCAST,
        OFFICIAL_BUSINESS_ACCOUNT,
        GROUP,
        GROUP_CALL,
        SERVER,
        ANNOUNCEMENT,
        IAS,
        STATUS,
        UNKNOWN;

    }

    public static class ContactJidBuilder {
        private String user;
        private Server server;
        private int device;
        private int agent;

        ContactJidBuilder() {
        }

        public ContactJidBuilder user(String user) {
            this.user = user;
            return this;
        }

        public ContactJidBuilder server(@NonNull Server server) {
            if (server == null) {
                throw new NullPointerException("server is marked non-null but is null");
            }
            this.server = server;
            return this;
        }

        public ContactJidBuilder device(int device) {
            this.device = device;
            return this;
        }

        public ContactJidBuilder agent(int agent) {
            this.agent = agent;
            return this;
        }

        public ContactJid build() {
            return new ContactJid(this.user, this.server, this.device, this.agent);
        }

        public String toString() {
            return "ContactJid.ContactJidBuilder(user=" + this.user + ", server=" + this.server + ", device=" + this.device + ", agent=" + this.agent + ")";
        }
    }
}

