/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.business;

import it.auties.whatsapp.model.business.BusinessCategory;
import it.auties.whatsapp.model.business.BusinessHours;
import it.auties.whatsapp.model.business.BusinessHoursEntry;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.model.request.Node;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import lombok.NonNull;

public final class BusinessProfile {
    @NonNull
    private final ContactJid jid;
    private final String description;
    private final String address;
    private final String email;
    private final BusinessHours hours;
    private final boolean cartEnabled;
    @NonNull
    private final List<URI> websites;
    @NonNull
    private final List<BusinessCategory> categories;

    public static BusinessProfile of(@NonNull Node node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        ContactJid jid = node.attributes().getJid("jid").orElseThrow(() -> new NoSuchElementException("Missing jid from business profile"));
        String address = node.findNode("address").flatMap(Node::contentAsString).orElse(null);
        String description = node.findNode("description").flatMap(Node::contentAsString).orElse(null);
        List<URI> websites = node.findNodes("website").stream().map(Node::contentAsString).flatMap(Optional::stream).map(URI::create).toList();
        String email = node.findNode("email").flatMap(Node::contentAsString).orElse(null);
        List<BusinessCategory> categories = node.findNodes("categories").stream().map(entry -> entry.findNode("category")).flatMap(Optional::stream).map(BusinessCategory::of).toList();
        Optional<Node> commerceExperience = node.findNode("profile_options");
        Boolean cartEnabled = commerceExperience.flatMap(entry -> entry.findNode("cart_enabled")).flatMap(Node::contentAsBoolean).orElse(commerceExperience.isEmpty());
        BusinessHours hours = BusinessProfile.createHours(node);
        return new BusinessProfile(jid, description, address, email, hours, cartEnabled, websites, categories);
    }

    private static BusinessHours createHours(Node node) {
        String timezone = node.findNode("business_hours").map(Node::attributes).map(attributes -> attributes.getNullableString("timezone")).orElse(null);
        if (timezone == null) {
            return null;
        }
        List<BusinessHoursEntry> entries = node.findNode("business_hours").stream().map(entry -> entry.findNodes("business_hours_config")).flatMap(Collection::stream).map(BusinessHoursEntry::of).toList();
        return new BusinessHours(timezone, entries);
    }

    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public Optional<String> address() {
        return Optional.ofNullable(this.address);
    }

    public Optional<String> email() {
        return Optional.ofNullable(this.email);
    }

    public Optional<BusinessHours> hours() {
        return Optional.ofNullable(this.hours);
    }

    @NonNull
    public ContactJid jid() {
        return this.jid;
    }

    public boolean cartEnabled() {
        return this.cartEnabled;
    }

    @NonNull
    public List<URI> websites() {
        return this.websites;
    }

    @NonNull
    public List<BusinessCategory> categories() {
        return this.categories;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessProfile)) {
            return false;
        }
        BusinessProfile other = (BusinessProfile)o;
        if (this.cartEnabled() != other.cartEnabled()) {
            return false;
        }
        ContactJid this$jid = this.jid();
        ContactJid other$jid = other.jid();
        if (this$jid == null ? other$jid != null : !((Object)this$jid).equals(other$jid)) {
            return false;
        }
        Optional<String> this$description = this.description();
        Optional<String> other$description = other.description();
        if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
            return false;
        }
        Optional<String> this$address = this.address();
        Optional<String> other$address = other.address();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        Optional<String> this$email = this.email();
        Optional<String> other$email = other.email();
        if (this$email == null ? other$email != null : !((Object)this$email).equals(other$email)) {
            return false;
        }
        Optional<BusinessHours> this$hours = this.hours();
        Optional<BusinessHours> other$hours = other.hours();
        if (this$hours == null ? other$hours != null : !((Object)this$hours).equals(other$hours)) {
            return false;
        }
        List<URI> this$websites = this.websites();
        List<URI> other$websites = other.websites();
        if (this$websites == null ? other$websites != null : !((Object)this$websites).equals(other$websites)) {
            return false;
        }
        List<BusinessCategory> this$categories = this.categories();
        List<BusinessCategory> other$categories = other.categories();
        return !(this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.cartEnabled() ? 79 : 97);
        ContactJid $jid = this.jid();
        result = result * 59 + ($jid == null ? 43 : ((Object)$jid).hashCode());
        Optional<String> $description = this.description();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        Optional<String> $address = this.address();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        Optional<String> $email = this.email();
        result = result * 59 + ($email == null ? 43 : ((Object)$email).hashCode());
        Optional<BusinessHours> $hours = this.hours();
        result = result * 59 + ($hours == null ? 43 : ((Object)$hours).hashCode());
        List<URI> $websites = this.websites();
        result = result * 59 + ($websites == null ? 43 : ((Object)$websites).hashCode());
        List<BusinessCategory> $categories = this.categories();
        result = result * 59 + ($categories == null ? 43 : ((Object)$categories).hashCode());
        return result;
    }

    public String toString() {
        return "BusinessProfile(jid=" + this.jid() + ", description=" + this.description() + ", address=" + this.address() + ", email=" + this.email() + ", hours=" + this.hours() + ", cartEnabled=" + this.cartEnabled() + ", websites=" + this.websites() + ", categories=" + this.categories() + ")";
    }

    public BusinessProfile(@NonNull ContactJid jid, String description, String address, String email, BusinessHours hours, boolean cartEnabled, @NonNull List<URI> websites, @NonNull List<BusinessCategory> categories) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        if (websites == null) {
            throw new NullPointerException("websites is marked non-null but is null");
        }
        if (categories == null) {
            throw new NullPointerException("categories is marked non-null but is null");
        }
        this.jid = jid;
        this.description = description;
        this.address = address;
        this.email = email;
        this.hours = hours;
        this.cartEnabled = cartEnabled;
        this.websites = websites;
        this.categories = categories;
    }
}

