/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.business;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufName;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.business.BusinessDateTimeComponent;
import it.auties.whatsapp.model.business.BusinessDateTimeType;
import it.auties.whatsapp.model.business.BusinessDateTimeUnixEpoch;
import it.auties.whatsapp.model.business.BusinessDateTimeValue;
import it.auties.whatsapp.model.business.BusinessLocalizableParameterType;
import it.auties.whatsapp.model.business.BusinessLocalizableParameterValue;
import java.util.Optional;
import lombok.NonNull;

@ProtobufName(value="HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime")
@JsonDeserialize(builder=BusinessDateTimeBuilder.class)
public final class BusinessDateTime
implements BusinessLocalizableParameterValue {
    @ProtobufProperty(index=1, type=ProtobufType.MESSAGE, implementation=BusinessDateTimeComponent.class)
    private BusinessDateTimeComponent dateComponent;
    @ProtobufProperty(index=2, type=ProtobufType.MESSAGE, implementation=BusinessDateTimeUnixEpoch.class)
    private BusinessDateTimeUnixEpoch dateUnixEpoch;

    public static BusinessDateTime of(@NonNull BusinessDateTimeValue dateComponent) {
        if (dateComponent == null) {
            throw new NullPointerException("dateComponent is marked non-null but is null");
        }
        if (dateComponent instanceof BusinessDateTimeComponent) {
            BusinessDateTimeComponent businessDateTimeComponent = (BusinessDateTimeComponent)dateComponent;
            return new BusinessDateTime(businessDateTimeComponent, null);
        }
        if (dateComponent instanceof BusinessDateTimeUnixEpoch) {
            BusinessDateTimeUnixEpoch businessDateTimeUnixEpoch = (BusinessDateTimeUnixEpoch)dateComponent;
            return new BusinessDateTime(null, businessDateTimeUnixEpoch);
        }
        throw new IllegalArgumentException();
    }

    public BusinessDateTimeType dateType() {
        return this.date().map(BusinessDateTimeValue::dateType).orElse(BusinessDateTimeType.NONE);
    }

    public Optional<BusinessDateTimeValue> date() {
        if (this.dateComponent != null) {
            return Optional.of(this.dateComponent);
        }
        if (this.dateUnixEpoch != null) {
            return Optional.of(this.dateUnixEpoch);
        }
        return Optional.empty();
    }

    public Optional<BusinessDateTimeComponent> dateComponent() {
        return Optional.ofNullable(this.dateComponent);
    }

    public Optional<BusinessDateTimeUnixEpoch> dateUnixEpoch() {
        return Optional.ofNullable(this.dateUnixEpoch);
    }

    @Override
    public BusinessLocalizableParameterType parameterType() {
        return BusinessLocalizableParameterType.DATE_TIME;
    }

    public static BusinessDateTimeBuilder builder() {
        return new BusinessDateTimeBuilder();
    }

    public BusinessDateTime(BusinessDateTimeComponent dateComponent, BusinessDateTimeUnixEpoch dateUnixEpoch) {
        this.dateComponent = dateComponent;
        this.dateUnixEpoch = dateUnixEpoch;
    }

    public BusinessDateTime dateComponent(BusinessDateTimeComponent dateComponent) {
        this.dateComponent = dateComponent;
        return this;
    }

    public BusinessDateTime dateUnixEpoch(BusinessDateTimeUnixEpoch dateUnixEpoch) {
        this.dateUnixEpoch = dateUnixEpoch;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessDateTime)) {
            return false;
        }
        BusinessDateTime other = (BusinessDateTime)o;
        Optional<BusinessDateTimeComponent> this$dateComponent = this.dateComponent();
        Optional<BusinessDateTimeComponent> other$dateComponent = other.dateComponent();
        if (this$dateComponent == null ? other$dateComponent != null : !((Object)this$dateComponent).equals(other$dateComponent)) {
            return false;
        }
        Optional<BusinessDateTimeUnixEpoch> this$dateUnixEpoch = this.dateUnixEpoch();
        Optional<BusinessDateTimeUnixEpoch> other$dateUnixEpoch = other.dateUnixEpoch();
        return !(this$dateUnixEpoch == null ? other$dateUnixEpoch != null : !((Object)this$dateUnixEpoch).equals(other$dateUnixEpoch));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<BusinessDateTimeComponent> $dateComponent = this.dateComponent();
        result = result * 59 + ($dateComponent == null ? 43 : ((Object)$dateComponent).hashCode());
        Optional<BusinessDateTimeUnixEpoch> $dateUnixEpoch = this.dateUnixEpoch();
        result = result * 59 + ($dateUnixEpoch == null ? 43 : ((Object)$dateUnixEpoch).hashCode());
        return result;
    }

    public String toString() {
        return "BusinessDateTime(dateComponent=" + this.dateComponent() + ", dateUnixEpoch=" + this.dateUnixEpoch() + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        if (this.dateComponent != null) {
            protobufOutputStream.writeBytes(1, this.dateComponent.toEncodedProtobuf());
        }
        if (this.dateUnixEpoch != null) {
            protobufOutputStream.writeBytes(2, this.dateUnixEpoch.toEncodedProtobuf());
        }
        return protobufOutputStream.toByteArray();
    }

    public static BusinessDateTime ofProtobuf(byte[] byArray) {
        int n;
        BusinessDateTimeBuilder businessDateTimeBuilder = BusinessDateTime.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        block4: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 1: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    businessDateTimeBuilder.dateComponent(BusinessDateTimeComponent.ofProtobuf(protobufInputStream.readBytes()));
                    continue block4;
                }
                case 2: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    businessDateTimeBuilder.dateUnixEpoch(BusinessDateTimeUnixEpoch.ofProtobuf(protobufInputStream.readBytes()));
                    continue block4;
                }
            }
            protobufInputStream.readBytes();
        }
        return businessDateTimeBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class BusinessDateTimeBuilder {
        private BusinessDateTimeComponent dateComponent;
        private BusinessDateTimeUnixEpoch dateUnixEpoch;

        BusinessDateTimeBuilder() {
        }

        public BusinessDateTimeBuilder dateComponent(BusinessDateTimeComponent dateComponent) {
            this.dateComponent = dateComponent;
            return this;
        }

        public BusinessDateTimeBuilder dateUnixEpoch(BusinessDateTimeUnixEpoch dateUnixEpoch) {
            this.dateUnixEpoch = dateUnixEpoch;
            return this;
        }

        public BusinessDateTime build() {
            return new BusinessDateTime(this.dateComponent, this.dateUnixEpoch);
        }

        public String toString() {
            return "BusinessDateTime.BusinessDateTimeBuilder(dateComponent=" + this.dateComponent + ", dateUnixEpoch=" + this.dateUnixEpoch + ")";
        }
    }
}

