/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.business;

import it.auties.whatsapp.model.request.Node;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import lombok.NonNull;

public record BusinessCategory(@NonNull String id, @NonNull String name) {
    public BusinessCategory(@NonNull String id, @NonNull String name) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
    }

    public static BusinessCategory of(@NonNull Node node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        String id = node.attributes().getRequiredString("id");
        String name = URLDecoder.decode(node.contentAsString().orElseThrow(), StandardCharsets.UTF_8);
        return new BusinessCategory(id, name);
    }
}

