/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.listener;

import it.auties.whatsapp.api.DisconnectReason;
import it.auties.whatsapp.api.SocketEvent;
import it.auties.whatsapp.api.Whatsapp;
import it.auties.whatsapp.model.action.Action;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.contact.Contact;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.model.contact.ContactStatus;
import it.auties.whatsapp.model.info.MessageIndexInfo;
import it.auties.whatsapp.model.info.MessageInfo;
import it.auties.whatsapp.model.message.model.MessageStatus;
import it.auties.whatsapp.model.message.model.QuotedMessage;
import it.auties.whatsapp.model.privacy.PrivacySettingEntry;
import it.auties.whatsapp.model.request.Node;
import it.auties.whatsapp.model.setting.Setting;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface Listener {
    default public void onNodeSent(Whatsapp whatsapp, Node outgoing) {
    }

    default public void onNodeSent(Node outgoing) {
    }

    default public void onNodeReceived(Whatsapp whatsapp, Node incoming) {
    }

    default public void onNodeReceived(Node incoming) {
    }

    default public void onLoggedIn(Whatsapp whatsapp) {
    }

    default public void onLoggedIn() {
    }

    default public void onMetadata(Whatsapp whatsapp, Map<String, String> metadata) {
    }

    default public void onMetadata(Map<String, String> metadata) {
    }

    default public void onDisconnected(Whatsapp whatsapp, DisconnectReason reason) {
    }

    default public void onDisconnected(DisconnectReason reason) {
    }

    default public void onAction(Whatsapp whatsapp, Action action, MessageIndexInfo messageIndexInfo) {
    }

    default public void onAction(Action action, MessageIndexInfo messageIndexInfo) {
    }

    default public void onSetting(Whatsapp whatsapp, Setting setting) {
    }

    default public void onSetting(Setting setting) {
    }

    default public void onFeatures(Whatsapp whatsapp, List<String> features) {
    }

    default public void onFeatures(List<String> features) {
    }

    default public void onContacts(Whatsapp whatsapp, Collection<Contact> contacts) {
    }

    default public void onContacts(Collection<Contact> contacts) {
    }

    default public void onContactPresence(Whatsapp whatsapp, Chat chat, ContactJid contactJid, ContactStatus status) {
    }

    default public void onContactPresence(Chat chat, ContactJid contactJid, ContactStatus status) {
    }

    default public void onChats(Whatsapp whatsapp, Collection<Chat> chats) {
    }

    default public void onChats(Collection<Chat> chats) {
    }

    default public void onChatMessagesSync(Whatsapp whatsapp, Chat chat, boolean last) {
    }

    default public void onChatMessagesSync(Chat chat, boolean last) {
    }

    default public void onHistorySyncProgress(int percentage, boolean recent) {
    }

    default public void onHistorySyncProgress(Whatsapp whatsapp, int percentage, boolean recent) {
    }

    default public void onNewMessage(Whatsapp whatsapp, MessageInfo info) {
    }

    default public void onNewMessage(MessageInfo info) {
    }

    default public void onNewMessage(Whatsapp whatsapp, MessageInfo info, boolean offline) {
    }

    default public void onNewMessage(MessageInfo info, boolean offline) {
    }

    default public void onMessageDeleted(Whatsapp whatsapp, MessageInfo info, boolean everyone) {
    }

    default public void onMessageDeleted(MessageInfo info, boolean everyone) {
    }

    default public void onConversationMessageStatus(Whatsapp whatsapp, MessageInfo info, MessageStatus status) {
    }

    default public void onConversationMessageStatus(MessageInfo info, MessageStatus status) {
    }

    default public void onAnyMessageStatus(Whatsapp whatsapp, Chat chat, Contact contact, MessageInfo info, MessageStatus status) {
    }

    default public void onAnyMessageStatus(Chat chat, Contact contact, MessageInfo info, MessageStatus status) {
    }

    default public void onStatus(Whatsapp whatsapp, Collection<MessageInfo> status) {
    }

    default public void onStatus(Collection<MessageInfo> status) {
    }

    default public void onNewStatus(Whatsapp whatsapp, MessageInfo status) {
    }

    default public void onNewStatus(MessageInfo status) {
    }

    default public void onSocketEvent(Whatsapp whatsapp, SocketEvent event) {
    }

    default public void onSocketEvent(SocketEvent event) {
    }

    default public void onMessageReply(MessageInfo info, QuotedMessage quoted) {
    }

    default public void onMessageReply(Whatsapp whatsapp, MessageInfo info, QuotedMessage quoted) {
    }

    default public void onContactPictureChange(Contact contact) {
    }

    default public void onContactPictureChange(Whatsapp whatsapp, Contact contact) {
    }

    default public void onGroupPictureChange(Chat group) {
    }

    default public void onGroupPictureChange(Whatsapp whatsapp, Chat group) {
    }

    default public void onUserNameChange(String oldName, String newName) {
    }

    default public void onUserNameChange(Whatsapp whatsapp, String oldName, String newName) {
    }

    default public void onUserAboutChange(String oldAbout, String newAbout) {
    }

    default public void onUserAboutChange(Whatsapp whatsapp, String oldAbout, String newAbout) {
    }

    default public void onUserPictureChange(URI oldPicture, URI newPicture) {
    }

    default public void onUserPictureChange(Whatsapp whatsapp, URI oldPicture, URI newPicture) {
    }

    default public void onUserLocaleChange(String oldLocale, String newLocale) {
    }

    default public void onUserLocaleChange(Whatsapp whatsapp, String oldLocale, String newLocale) {
    }

    default public void onContactBlocked(Contact contact) {
    }

    default public void onContactBlocked(Whatsapp whatsapp, Contact contact) {
    }

    default public void onNewContact(Whatsapp whatsapp, Contact contact) {
    }

    default public void onNewContact(Contact contact) {
    }

    default public void onPrivacySettingChanged(Whatsapp whatsapp, PrivacySettingEntry oldPrivacyEntry, PrivacySettingEntry newPrivacyEntry) {
    }

    default public void onPrivacySettingChanged(PrivacySettingEntry oldPrivacyEntry, PrivacySettingEntry newPrivacyEntry) {
    }

    default public void onLinkedDevices(Whatsapp whatsapp, Collection<ContactJid> devices) {
    }

    default public void onLinkedDevices(Collection<ContactJid> devices) {
    }

    default public void onRegistrationCode(long code) {
    }

    default public void onRegistrationCode(Whatsapp whatsapp, long code) {
    }
}

