/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.crypto;

import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.model.signal.message.SignalDistributionMessage;
import it.auties.whatsapp.model.signal.sender.SenderKeyName;
import it.auties.whatsapp.model.signal.sender.SenderKeyRecord;
import it.auties.whatsapp.model.signal.sender.SenderKeyState;
import it.auties.whatsapp.util.KeyHelper;
import lombok.NonNull;

public record GroupBuilder(@NonNull Keys keys) {
    public GroupBuilder(@NonNull Keys keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
    }

    public byte[] createOutgoing(SenderKeyName name) {
        SenderKeyRecord record = this.keys.findSenderKeyByName(name);
        if (record.isEmpty()) {
            record.addState(KeyHelper.senderKeyId(), 0, KeyHelper.senderKey(), SignalKeyPair.random());
        }
        SenderKeyState state = record.findState();
        SignalDistributionMessage message = new SignalDistributionMessage(state.id(), state.chainKey().iteration(), state.chainKey().seed(), state.signingKey().encodedPublicKey());
        return message.serialized();
    }

    public void createIncoming(SenderKeyName name, SignalDistributionMessage message) {
        SenderKeyRecord record = this.keys.findSenderKeyByName(name);
        record.addState((int)message.id(), (int)message.iteration(), message.chainKey(), message.signingKey());
    }
}

