/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.api;

import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.api.ConnectionType;
import it.auties.whatsapp.api.OptionsBuilder;
import it.auties.whatsapp.api.PairingCodeHandler;
import it.auties.whatsapp.api.QrHandler;
import it.auties.whatsapp.api.WebHistoryLength;
import it.auties.whatsapp.api.Whatsapp;
import it.auties.whatsapp.controller.ControllerSerializer;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import java.util.Optional;
import java.util.UUID;
import lombok.NonNull;

public final class WebOptionsBuilder
extends OptionsBuilder<WebOptionsBuilder> {
    private Whatsapp whatsapp;

    private WebOptionsBuilder(Store store, Keys keys) {
        super(store, keys);
    }

    static WebOptionsBuilder of(UUID connectionUuid, ControllerSerializer serializer, ConnectionType connectionType) {
        UUID uuid = WebOptionsBuilder.getCorrectUuid(connectionUuid, serializer, connectionType, ClientType.WEB);
        Store store = Store.of(uuid, ClientType.WEB, serializer);
        Keys keys = Keys.of(uuid, ClientType.WEB, serializer);
        return new WebOptionsBuilder(store, keys);
    }

    static Optional<WebOptionsBuilder> ofNullable(UUID connectionUuid, ControllerSerializer serializer, ConnectionType connectionType) {
        UUID uuid = WebOptionsBuilder.getCorrectUuid(connectionUuid, serializer, connectionType, ClientType.WEB);
        Optional<Store> store = Store.ofNullable(uuid, ClientType.WEB, serializer);
        Optional<Keys> keys = Keys.ofNullable(uuid, ClientType.WEB, serializer);
        if (store.isEmpty() || keys.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new WebOptionsBuilder(store.get(), keys.get()));
    }

    static WebOptionsBuilder of(long phoneNumber, ControllerSerializer serializer) {
        UUID uuid = UUID.randomUUID();
        Store store = Store.of(uuid, phoneNumber, ClientType.WEB, serializer);
        Keys keys = Keys.of(uuid, phoneNumber, ClientType.WEB, serializer);
        return new WebOptionsBuilder(store, keys);
    }

    static Optional<WebOptionsBuilder> ofNullable(Long phoneNumber, ControllerSerializer serializer) {
        Optional<Store> store = Store.ofNullable(phoneNumber, ClientType.WEB, serializer);
        Optional<Keys> keys = Keys.ofNullable(phoneNumber, ClientType.WEB, serializer);
        if (store.isEmpty() || keys.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new WebOptionsBuilder(store.get(), keys.get()));
    }

    static WebOptionsBuilder of(String alias, ControllerSerializer serializer) {
        UUID uuid = UUID.randomUUID();
        Store store = Store.of(uuid, alias, ClientType.WEB, serializer);
        Keys keys = Keys.of(uuid, alias, ClientType.WEB, serializer);
        return new WebOptionsBuilder(store, keys);
    }

    static Optional<WebOptionsBuilder> ofNullable(String alias, ControllerSerializer serializer) {
        Optional<Store> store = Store.ofNullable(alias, ClientType.WEB, serializer);
        Optional<Keys> keys = Keys.ofNullable(alias, ClientType.WEB, serializer);
        if (store.isEmpty() || keys.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new WebOptionsBuilder(store.get(), keys.get()));
    }

    public WebOptionsBuilder historyLength(@NonNull WebHistoryLength historyLength) {
        if (historyLength == null) {
            throw new NullPointerException("historyLength is marked non-null but is null");
        }
        this.store.historyLength(historyLength);
        return this;
    }

    public Whatsapp unregistered(@NonNull QrHandler qrHandler) {
        if (qrHandler == null) {
            throw new NullPointerException("qrHandler is marked non-null but is null");
        }
        if (this.whatsapp == null) {
            this.whatsapp = Whatsapp.customBuilder().store(this.store).keys(this.keys).errorHandler(this.errorHandler).socketExecutor(this.socketExecutor).webVerificationSupport(qrHandler).build();
        }
        return this.whatsapp;
    }

    public Whatsapp unregistered(long phoneNumber, @NonNull PairingCodeHandler pairingCodeHandler) {
        if (pairingCodeHandler == null) {
            throw new NullPointerException("pairingCodeHandler is marked non-null but is null");
        }
        if (this.whatsapp == null) {
            this.store.phoneNumber(PhoneNumber.of(phoneNumber));
            this.whatsapp = Whatsapp.customBuilder().store(this.store).keys(this.keys).errorHandler(this.errorHandler).socketExecutor(this.socketExecutor).webVerificationSupport(pairingCodeHandler).build();
        }
        return this.whatsapp;
    }

    public Optional<Whatsapp> registered() {
        if (!this.keys.registered()) {
            return Optional.empty();
        }
        if (this.whatsapp == null) {
            this.whatsapp = Whatsapp.customBuilder().store(this.store).keys(this.keys).errorHandler(this.errorHandler).socketExecutor(this.socketExecutor).build();
        }
        return Optional.of(this.whatsapp);
    }
}

