/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.api;

import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.api.ConnectionType;
import it.auties.whatsapp.api.MobileRegistrationBuilder;
import it.auties.whatsapp.api.OptionsBuilder;
import it.auties.whatsapp.api.Whatsapp;
import it.auties.whatsapp.controller.ControllerSerializer;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.model.business.BusinessCategory;
import it.auties.whatsapp.model.companion.CompanionDevice;
import java.util.Optional;
import java.util.UUID;
import lombok.NonNull;

public final class MobileOptionsBuilder
extends OptionsBuilder<MobileOptionsBuilder> {
    private MobileOptionsBuilder(Store store, Keys keys) {
        super(store, keys);
    }

    static MobileOptionsBuilder of(UUID connectionUuid, ControllerSerializer serializer, ConnectionType connectionType) {
        UUID uuid = MobileOptionsBuilder.getCorrectUuid(connectionUuid, serializer, connectionType, ClientType.MOBILE);
        Store store = Store.of(uuid, ClientType.MOBILE, serializer);
        Keys keys = Keys.of(uuid, ClientType.MOBILE, serializer);
        return new MobileOptionsBuilder(store, keys);
    }

    static Optional<MobileOptionsBuilder> ofNullable(UUID connectionUuid, ControllerSerializer serializer, ConnectionType connectionType) {
        UUID uuid = MobileOptionsBuilder.getCorrectUuid(connectionUuid, serializer, connectionType, ClientType.MOBILE);
        Optional<Store> store = Store.ofNullable(uuid, ClientType.MOBILE, serializer);
        Optional<Keys> keys = Keys.ofNullable(uuid, ClientType.MOBILE, serializer);
        if (store.isEmpty() || keys.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new MobileOptionsBuilder(store.get(), keys.get()));
    }

    static MobileOptionsBuilder of(long phoneNumber, ControllerSerializer serializer) {
        UUID uuid = UUID.randomUUID();
        Store store = Store.of(uuid, phoneNumber, ClientType.MOBILE, serializer);
        Keys keys = Keys.of(uuid, phoneNumber, ClientType.MOBILE, serializer);
        return new MobileOptionsBuilder(store, keys);
    }

    static Optional<MobileOptionsBuilder> ofNullable(Long phoneNumber, ControllerSerializer serializer) {
        Optional<Store> store = Store.ofNullable(phoneNumber, ClientType.MOBILE, serializer);
        Optional<Keys> keys = Keys.ofNullable(phoneNumber, ClientType.MOBILE, serializer);
        if (store.isEmpty() || keys.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new MobileOptionsBuilder(store.get(), keys.get()));
    }

    static MobileOptionsBuilder of(String alias, ControllerSerializer serializer) {
        UUID uuid = UUID.randomUUID();
        Store store = Store.of(uuid, alias, ClientType.MOBILE, serializer);
        Keys keys = Keys.of(uuid, alias, ClientType.MOBILE, serializer);
        return new MobileOptionsBuilder(store, keys);
    }

    static Optional<MobileOptionsBuilder> ofNullable(String alias, ControllerSerializer serializer) {
        Optional<Store> store = Store.ofNullable(alias, ClientType.MOBILE, serializer);
        Optional<Keys> keys = Keys.ofNullable(alias, ClientType.MOBILE, serializer);
        if (store.isEmpty() || keys.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new MobileOptionsBuilder(store.get(), keys.get()));
    }

    public MobileOptionsBuilder device(@NonNull CompanionDevice device) {
        if (device == null) {
            throw new NullPointerException("device is marked non-null but is null");
        }
        if (this.store != null) {
            this.store.device(device);
        }
        return this;
    }

    public MobileOptionsBuilder business(boolean business) {
        if (this.store != null) {
            this.store.business(business);
        }
        return this;
    }

    public MobileOptionsBuilder businessAddress(String businessAddress) {
        if (this.store != null) {
            this.store.businessAddress(businessAddress);
        }
        return this;
    }

    public MobileOptionsBuilder businessLongitude(Double businessLongitude) {
        if (this.store != null) {
            this.store.businessLongitude(businessLongitude);
        }
        return this;
    }

    public MobileOptionsBuilder businessLatitude(Double businessLatitude) {
        if (this.store != null) {
            this.store.businessLatitude(businessLatitude);
        }
        return this;
    }

    public MobileOptionsBuilder businessDescription(String businessDescription) {
        if (this.store != null) {
            this.store.businessDescription(businessDescription);
        }
        return this;
    }

    public MobileOptionsBuilder businessWebsite(String businessWebsite) {
        if (this.store != null) {
            this.store.businessWebsite(businessWebsite);
        }
        return this;
    }

    public MobileOptionsBuilder businessEmail(String businessEmail) {
        if (this.store != null) {
            this.store.businessEmail(businessEmail);
        }
        return this;
    }

    public MobileOptionsBuilder businessCategory(BusinessCategory businessCategory) {
        if (this.store != null) {
            this.store.businessCategory(businessCategory);
        }
        return this;
    }

    public Optional<Whatsapp> registered() {
        if (!this.keys.registered()) {
            return Optional.empty();
        }
        return Optional.of(Whatsapp.customBuilder().store(this.store).keys(this.keys).errorHandler(this.errorHandler).socketExecutor(this.socketExecutor).build());
    }

    public MobileRegistrationBuilder.Unregistered unregistered() {
        return new MobileRegistrationBuilder.Unregistered(this.store, this.keys, this.errorHandler, this.socketExecutor);
    }

    public MobileRegistrationBuilder.Unverified unverified() {
        return new MobileRegistrationBuilder.Unverified(this.store, this.keys, this.errorHandler, this.socketExecutor);
    }
}

