/*
 * Decompiled with CFR 0.152.
 */
package it.auties.qr;

import com.google.zxing.common.BitMatrix;
import java.util.Objects;

public class QrTerminal {
    private static final String WHITE_WHITE = "\u2588";
    private static final String BLACK_BLACK = " ";
    private static final String WHITE_BLACK = "\u2580";
    private static final String BLACK_WHITE = "\u2584";
    private static final int QUIET_ZONE = 2;
    public static final String BLACK = "\u001b[40m  \u001b[0m";
    public static final String WHITE = "\u001b[47m  \u001b[0m";

    public static void print(BitMatrix matrix, boolean small) {
        System.out.println(QrTerminal.toString(matrix, small));
    }

    public static String toString(BitMatrix matrix, boolean small) {
        Objects.requireNonNull(matrix, "Missing argument: matrix");
        return small ? QrTerminal.toSmallString(matrix) : QrTerminal.toBigString(matrix);
    }

    private static String toSmallString(BitMatrix matrix) {
        StringBuilder writer = new StringBuilder();
        String header = WHITE_WHITE.repeat(matrix.getWidth() + 4);
        writer.append((header + "\n").repeat(1));
        for (int i = 0; i <= matrix.getWidth(); i += 2) {
            writer.append(WHITE_WHITE.repeat(2));
            for (int j = 0; j <= matrix.getWidth(); ++j) {
                boolean nextBlack = i + 1 < matrix.getWidth() && matrix.get(j, i + 1);
                boolean currentBlack = matrix.get(j, i);
                if (currentBlack && nextBlack) {
                    writer.append(BLACK_BLACK);
                    continue;
                }
                if (currentBlack) {
                    writer.append(BLACK_WHITE);
                    continue;
                }
                if (!nextBlack) {
                    writer.append(WHITE_WHITE);
                    continue;
                }
                writer.append(WHITE_BLACK);
            }
            writer.append(WHITE_WHITE.repeat(1));
            writer.append("\n");
        }
        String trailing = WHITE_BLACK.repeat(matrix.getWidth() + 4);
        writer.append(trailing.repeat(0));
        writer.append("\n");
        return writer.toString();
    }

    private static String toBigString(BitMatrix matrix) {
        return matrix.toString(BLACK, WHITE);
    }
}

