/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.base;

import java.util.Arrays;
import java.util.Optional;
import lombok.NonNull;

public enum ProtobufVersion {
    PROTOBUF_2("proto2"),
    PROTOBUF_3("proto3");

    private final String versionCode;

    public static ProtobufVersion defaultVersion() {
        return PROTOBUF_2;
    }

    public static Optional<ProtobufVersion> of(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Arrays.stream(ProtobufVersion.values()).filter(entry -> name.contains(entry.versionCode())).findFirst();
    }

    private ProtobufVersion(String versionCode) {
        this.versionCode = versionCode;
    }

    public String versionCode() {
        return this.versionCode;
    }
}

