/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.base;

import it.auties.protobuf.base.ProtobufMessage;
import java.util.Arrays;
import java.util.Optional;
import lombok.NonNull;

public enum ProtobufType {
    MESSAGE(ProtobufMessage.class, ProtobufMessage.class),
    FLOAT(Float.TYPE, Float.class),
    DOUBLE(Double.TYPE, Double.class),
    BOOL(Boolean.TYPE, Boolean.class),
    STRING(String.class, String.class),
    BYTES(byte[].class, byte[].class),
    INT32(Integer.TYPE, Integer.class),
    SINT32(Integer.TYPE, Integer.class),
    UINT32(Integer.TYPE, Integer.class),
    FIXED32(Integer.TYPE, Integer.class),
    SFIXED32(Integer.TYPE, Integer.class),
    INT64(Long.TYPE, Long.class),
    SINT64(Long.TYPE, Long.class),
    UINT64(Long.TYPE, Long.class),
    FIXED64(Long.TYPE, Long.class),
    SFIXED64(Long.TYPE, Long.class);

    @NonNull
    private final Class<?> primitiveType;
    @NonNull
    private final Class<?> wrappedType;

    public static Optional<ProtobufType> of(String name) {
        return Arrays.stream(ProtobufType.values()).filter(entry -> entry.name().equalsIgnoreCase(name)).findFirst();
    }

    public boolean isMessage() {
        return this == MESSAGE;
    }

    public boolean isAssignableFrom(Class<?> clazz) {
        return this.primitiveType().isAssignableFrom(clazz) || this.wrappedType.isAssignableFrom(clazz);
    }

    private ProtobufType(Class<?> primitiveType, Class<?> wrappedType) {
        if (primitiveType == null) {
            throw new NullPointerException("primitiveType is marked non-null but is null");
        }
        if (wrappedType == null) {
            throw new NullPointerException("wrappedType is marked non-null but is null");
        }
        this.primitiveType = primitiveType;
        this.wrappedType = wrappedType;
    }

    @NonNull
    public Class<?> primitiveType() {
        return this.primitiveType;
    }

    @NonNull
    public Class<?> wrappedType() {
        return this.wrappedType;
    }
}

