/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.base;

import it.auties.protobuf.base.ProtobufDeserializationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ProtobufInputStream {
    private final byte[] buffer;
    private final int limit;
    private int pos;

    public ProtobufInputStream(byte[] buffer) {
        this.buffer = buffer;
        this.limit = buffer.length;
        this.pos = 0;
    }

    public int readTag() {
        return this.isAtEnd() ? 0 : this.readInt32();
    }

    public List<Float> readFloatPacked() {
        ArrayList<Float> results = new ArrayList<Float>();
        ProtobufInputStream input = new ProtobufInputStream(this.readBytes());
        while (!input.isAtEnd()) {
            results.add(Float.valueOf(input.readFloat()));
        }
        return results;
    }

    public List<Double> readDoublePacked() {
        ArrayList<Double> results = new ArrayList<Double>();
        ProtobufInputStream input = new ProtobufInputStream(this.readBytes());
        while (!input.isAtEnd()) {
            results.add(input.readDouble());
        }
        return results;
    }

    public List<Integer> readInt32Packed() {
        ArrayList<Integer> results = new ArrayList<Integer>();
        ProtobufInputStream input = new ProtobufInputStream(this.readBytes());
        while (!input.isAtEnd()) {
            results.add(input.readInt32());
        }
        return results;
    }

    public List<Long> readInt64Packed() {
        ArrayList<Long> results = new ArrayList<Long>();
        ProtobufInputStream input = new ProtobufInputStream(this.readBytes());
        while (!input.isAtEnd()) {
            results.add(input.readInt64());
        }
        return results;
    }

    public List<Integer> readFixed32Packed() {
        ArrayList<Integer> results = new ArrayList<Integer>();
        ProtobufInputStream input = new ProtobufInputStream(this.readBytes());
        while (!input.isAtEnd()) {
            results.add(input.readInt32());
        }
        return results;
    }

    public List<Long> readFixed64Packed() {
        ArrayList<Long> results = new ArrayList<Long>();
        ProtobufInputStream input = new ProtobufInputStream(this.readBytes());
        while (!input.isAtEnd()) {
            results.add(input.readInt64());
        }
        return results;
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readFixed32());
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readFixed64());
    }

    public boolean readBool() {
        return this.readInt64() == 1L;
    }

    public List<Boolean> readBoolPacked() {
        ArrayList<Boolean> results = new ArrayList<Boolean>();
        ProtobufInputStream input = new ProtobufInputStream(this.readBytes());
        while (!input.isAtEnd()) {
            results.add(input.readInt64() == 1L);
        }
        return results;
    }

    public int readInt32() {
        block4: {
            int x;
            int tempPos;
            block6: {
                byte[] buffer;
                block8: {
                    block7: {
                        block5: {
                            tempPos = this.pos;
                            buffer = this.buffer;
                            if ((x = buffer[tempPos++]) >= 0) {
                                this.pos = tempPos;
                                return x;
                            }
                            if (this.limit - tempPos < 9) break block4;
                            if ((x ^= buffer[tempPos++] << 7) >= 0) break block5;
                            x ^= 0xFFFFFF80;
                            break block6;
                        }
                        if ((x ^= buffer[tempPos++] << 14) < 0) break block7;
                        x ^= 0x3F80;
                        break block6;
                    }
                    if ((x ^= buffer[tempPos++] << 21) >= 0) break block8;
                    x ^= 0xFFE03F80;
                    break block6;
                }
                byte y = buffer[tempPos++];
                x ^= y << 28;
                x ^= 0xFE03F80;
                if (y < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0) break block4;
            }
            this.pos = tempPos;
            return x;
        }
        return (int)this.readVarInt64Slow();
    }

    public long readInt64() {
        block4: {
            long x;
            int tempPos;
            block6: {
                byte[] buffer;
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                int y;
                                block8: {
                                    block7: {
                                        block5: {
                                            tempPos = this.pos;
                                            buffer = this.buffer;
                                            if ((y = buffer[tempPos++]) >= 0) {
                                                this.pos = tempPos;
                                                return y;
                                            }
                                            if (this.limit - tempPos < 9) break block4;
                                            if ((y ^= buffer[tempPos++] << 7) >= 0) break block5;
                                            x = y ^ 0xFFFFFF80;
                                            break block6;
                                        }
                                        if ((y ^= buffer[tempPos++] << 14) < 0) break block7;
                                        x = y ^ 0x3F80;
                                        break block6;
                                    }
                                    if ((y ^= buffer[tempPos++] << 21) >= 0) break block8;
                                    x = y ^ 0xFFE03F80;
                                    break block6;
                                }
                                if ((x = (long)y ^ (long)buffer[tempPos++] << 28) < 0L) break block9;
                                x ^= 0xFE03F80L;
                                break block6;
                            }
                            if ((x ^= (long)buffer[tempPos++] << 35) >= 0L) break block10;
                            x ^= 0xFFFFFFF80FE03F80L;
                            break block6;
                        }
                        if ((x ^= (long)buffer[tempPos++] << 42) < 0L) break block11;
                        x ^= 0x3F80FE03F80L;
                        break block6;
                    }
                    if ((x ^= (long)buffer[tempPos++] << 49) >= 0L) break block12;
                    x ^= 0xFFFE03F80FE03F80L;
                    break block6;
                }
                x ^= (long)buffer[tempPos++] << 56;
                if ((x ^= 0xFE03F80FE03F80L) < 0L && (long)buffer[tempPos++] < 0L) break block4;
            }
            this.pos = tempPos;
            return x;
        }
        return this.readVarInt64Slow();
    }

    private long readVarInt64Slow() {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw ProtobufDeserializationException.malformedVarInt();
    }

    public int readFixed32() {
        int tempPos = this.pos;
        if (this.limit - tempPos < 4) {
            throw ProtobufDeserializationException.truncatedMessage();
        }
        byte[] buffer = this.buffer;
        this.pos = tempPos + 4;
        return buffer[tempPos] & 0xFF | (buffer[tempPos + 1] & 0xFF) << 8 | (buffer[tempPos + 2] & 0xFF) << 16 | (buffer[tempPos + 3] & 0xFF) << 24;
    }

    public long readFixed64() {
        int tempPos = this.pos;
        if (this.limit - tempPos < 8) {
            throw ProtobufDeserializationException.truncatedMessage();
        }
        byte[] buffer = this.buffer;
        this.pos = tempPos + 8;
        return (long)buffer[tempPos] & 0xFFL | ((long)buffer[tempPos + 1] & 0xFFL) << 8 | ((long)buffer[tempPos + 2] & 0xFFL) << 16 | ((long)buffer[tempPos + 3] & 0xFFL) << 24 | ((long)buffer[tempPos + 4] & 0xFFL) << 32 | ((long)buffer[tempPos + 5] & 0xFFL) << 40 | ((long)buffer[tempPos + 6] & 0xFFL) << 48 | ((long)buffer[tempPos + 7] & 0xFFL) << 56;
    }

    public byte readByte() {
        return this.buffer[this.pos++];
    }

    public byte[] readBytes() {
        int size = this.readInt32();
        if (size > 0 && size <= this.limit - this.pos) {
            this.pos += size;
            return Arrays.copyOfRange(this.buffer, this.pos - size, this.pos);
        }
        return size == 0 ? new byte[]{} : this.readBytes(size);
    }

    private byte[] readBytes(int length) {
        int tempPos = this.pos;
        this.pos += length;
        return Arrays.copyOfRange(this.buffer, tempPos, this.pos);
    }

    public boolean isAtEnd() {
        return this.pos >= this.limit;
    }

    public int position() {
        return this.pos;
    }
}

