/*
 * Decompiled with CFR 0.152.
 */
package it.auties.linkpreview;

import java.net.URI;
import java.util.Objects;
import lombok.NonNull;

public record LinkPreviewMedia(@NonNull URI uri, int width, int height) {
    public LinkPreviewMedia(@NonNull URI uri, int width, int height) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
    }

    public LinkPreviewMedia(@NonNull URI uri) {
        this(uri, -1, -1);
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
    }

    public boolean hasDimensions() {
        return this.width >= 0 && this.height >= 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof LinkPreviewMedia)) return false;
        LinkPreviewMedia that = (LinkPreviewMedia)obj;
        if (!Objects.equals(this.uri(), that.uri())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.uri());
    }
}

