/*
 * Decompiled with CFR 0.152.
 */
package it.auties.curve25519;

import it.auties.curve25519.XecUtils;
import it.auties.curve25519.crypto.curve_sigs;
import it.auties.curve25519.crypto.scalarmult;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.XECPrivateKey;
import java.security.interfaces.XECPublicKey;
import java.util.Objects;

public class Curve25519 {
    private static final int KEY_LENGTH = 32;
    private static final int SIGNATURE_LENGTH = 64;

    public static XECPrivateKey randomPrivateKey() {
        SecureRandom random = new SecureRandom();
        byte[] rawPrivateKey = new byte[32];
        random.nextBytes(rawPrivateKey);
        rawPrivateKey[0] = (byte)(rawPrivateKey[0] & 0xF8);
        rawPrivateKey[31] = (byte)(rawPrivateKey[31] & 0x7F);
        rawPrivateKey[31] = (byte)(rawPrivateKey[31] | 0x40);
        return XecUtils.toPrivateKey(rawPrivateKey);
    }

    public static XECPublicKey forPrivateKey(PrivateKey privateKey) {
        if (!(privateKey instanceof XECPrivateKey)) {
            throw new IllegalArgumentException("Invalid key type!");
        }
        return Curve25519.forPrivateKey(XecUtils.toBytes((XECPrivateKey)privateKey));
    }

    public static XECPublicKey forPrivateKey(byte[] privateKey) {
        byte[] rawPublicKey = new byte[32];
        curve_sigs.curve25519_keygen(rawPublicKey, privateKey);
        return XecUtils.toPublicKey(rawPublicKey);
    }

    public static KeyPair randomKeyPair() {
        XECPrivateKey privateKey = Curve25519.randomPrivateKey();
        XECPublicKey publicKey = Curve25519.forPrivateKey(privateKey);
        return new KeyPair(publicKey, privateKey);
    }

    public static byte[] sharedKey(KeyPair keyPair) {
        Objects.requireNonNull(keyPair, "Key pair cannot be null!");
        return Curve25519.sharedKey(keyPair.getPublic(), keyPair.getPrivate());
    }

    public static byte[] sharedKey(PublicKey publicKey, PrivateKey privateKey) {
        if (!(publicKey instanceof XECPublicKey) || !(privateKey instanceof XECPrivateKey)) {
            throw new IllegalArgumentException("Invalid key type!");
        }
        return Curve25519.sharedKey(XecUtils.toBytes((XECPublicKey)publicKey), XecUtils.toBytes((XECPrivateKey)privateKey));
    }

    public static byte[] sharedKey(PublicKey publicKey, byte[] privateKey) {
        if (!(publicKey instanceof XECPublicKey)) {
            throw new IllegalArgumentException("Invalid key type!");
        }
        return Curve25519.sharedKey(XecUtils.toBytes((XECPublicKey)publicKey), privateKey);
    }

    public static byte[] sharedKey(byte[] publicKey, PrivateKey privateKey) {
        if (!(privateKey instanceof XECPrivateKey)) {
            throw new IllegalArgumentException("Invalid key type!");
        }
        return Curve25519.sharedKey(publicKey, XecUtils.toBytes((XECPrivateKey)privateKey));
    }

    public static byte[] sharedKey(byte[] publicKey, byte[] privateKey) {
        Curve25519.checkKey(publicKey);
        Curve25519.checkKey(privateKey);
        byte[] agreement = new byte[32];
        scalarmult.crypto_scalarmult(agreement, privateKey, publicKey);
        return agreement;
    }

    public static byte[] sign(KeyPair keyPair, byte[] message, boolean deterministic) {
        return Curve25519.sign(keyPair, message, Curve25519.randomSignatureHash(deterministic));
    }

    public static byte[] sign(KeyPair keyPair, byte[] message, byte[] hash) {
        Objects.requireNonNull(keyPair, "Key pair cannot be null!");
        return Curve25519.sign(keyPair.getPrivate(), message, hash);
    }

    public static byte[] sign(PrivateKey privateKey, byte[] message, boolean deterministic) {
        return Curve25519.sign(privateKey, message, Curve25519.randomSignatureHash(deterministic));
    }

    public static byte[] sign(PrivateKey privateKey, byte[] message, byte[] hash) {
        if (!(privateKey instanceof XECPrivateKey)) {
            throw new IllegalArgumentException("Invalid private key type!");
        }
        return Curve25519.sign(XecUtils.toBytes((XECPrivateKey)privateKey), message, hash);
    }

    public static byte[] sign(byte[] privateKey, byte[] message, boolean deterministic) {
        return Curve25519.sign(privateKey, message, Curve25519.randomSignatureHash(deterministic));
    }

    public static byte[] sign(byte[] privateKey, byte[] message, byte[] hash) {
        Curve25519.checkKey(privateKey);
        Curve25519.checkHash(hash);
        byte[] signature = new byte[64];
        if (curve_sigs.curve25519_sign(signature, privateKey, message, message.length, hash) != 0) {
            throw new IllegalArgumentException("Message exceeds max length!");
        }
        return signature;
    }

    public static boolean verifySignature(PublicKey publicKey, byte[] message, byte[] signature) {
        if (!(publicKey instanceof XECPublicKey)) {
            throw new IllegalArgumentException("Invalid key type!");
        }
        return Curve25519.verifySignature(XecUtils.toBytes((XECPublicKey)publicKey), message, signature);
    }

    public static boolean verifySignature(byte[] publicKey, byte[] message, byte[] signature) {
        Curve25519.checkKey(publicKey);
        return message != null && signature != null && signature.length == 64 && curve_sigs.curve25519_verify(signature, publicKey, message, message.length) == 0;
    }

    private static byte[] randomSignatureHash(boolean deterministic) {
        if (deterministic) {
            return null;
        }
        byte[] random = new byte[64];
        new SecureRandom().nextBytes(random);
        return random;
    }

    private static void checkKey(byte[] key) {
        Objects.requireNonNull(key, "Key cannot be null!");
        if (key.length == 32) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid key length: expected %s, got %s", 32, key.length));
    }

    private static void checkHash(byte[] hash) {
        if (hash == null || hash.length == 64) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid hash length: expected %s, got %s", 64, hash.length));
    }
}

