/*
 * Decompiled with CFR 0.152.
 */
package com.flowpowered.network.util;

import com.flowpowered.network.Message;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AnnotatedMessageHandler {
    private final Map<Class<?>, Method> handles = Collections.synchronizedMap(new HashMap());
    private final Object handler;

    public AnnotatedMessageHandler(Object handler) {
        this.handler = handler;
        this.registerHandlers();
    }

    public void handle(Message message) {
        Method handle = this.handles.get(message.getClass());
        if (handle == null) {
            throw new IllegalArgumentException("No handle for message type [" + message.getClass().getName() + "]");
        }
        try {
            handle.invoke(this.handler, message);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to handle message [" + message + "]", ex);
        }
    }

    private void registerHandlers() {
        for (Method method : this.handler.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Handle.class)) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1) {
                throw new IllegalStateException("Expected only 1 parameter for message handler method [" + method.getName() + "]");
            }
            Class<?> messageType = parameterTypes[0];
            if (!Message.class.isAssignableFrom(messageType)) {
                throw new IllegalStateException("Expected parameter to be a subclass of Message for handler method [" + method.getName() + "]");
            }
            method.setAccessible(true);
            this.handles.put(messageType, method);
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Handle {
    }
}

