/*
 * Decompiled with CFR 0.152.
 */
package com.flowpowered.network.session;

import com.flowpowered.network.Message;
import com.flowpowered.network.MessageHandler;
import com.flowpowered.network.exception.ChannelClosedException;
import com.flowpowered.network.processor.MessageProcessor;
import com.flowpowered.network.protocol.AbstractProtocol;
import com.flowpowered.network.session.Session;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Random;
import org.slf4j.Logger;

public class BasicSession
implements Session {
    private static final Random random = new Random();
    private final Channel channel;
    private final String sessionId = Long.toString(random.nextLong(), 16).trim();
    private AbstractProtocol protocol;

    public BasicSession(Channel channel, AbstractProtocol bootstrapProtocol) {
        this.channel = channel;
        this.protocol = bootstrapProtocol;
    }

    private void handleMessage(Message message) {
        Class<?> messageClass = message.getClass();
        MessageHandler<?, ?> handler = this.protocol.getMessageHandle(messageClass);
        if (handler != null) {
            try {
                handler.handle(this, message);
            }
            catch (Throwable t) {
                this.onHandlerThrowable(message, handler, t);
            }
        }
    }

    public ChannelFuture sendWithFuture(Message message) throws ChannelClosedException {
        if (!this.channel.isActive()) {
            throw new ChannelClosedException("Trying to send a message when a session is inactive!");
        }
        return this.channel.writeAndFlush((Object)message).addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> future) throws Exception {
                if (future.cause() != null) {
                    BasicSession.this.onOutboundThrowable(future.cause());
                }
            }
        });
    }

    @Override
    public void send(Message message) throws ChannelClosedException {
        this.sendWithFuture(message);
    }

    @Override
    public void sendAll(Message ... messages) throws ChannelClosedException {
        for (Message msg : messages) {
            this.send(msg);
        }
    }

    public InetSocketAddress getAddress() {
        SocketAddress addr = this.channel.remoteAddress();
        if (!(addr instanceof InetSocketAddress)) {
            return null;
        }
        return (InetSocketAddress)addr;
    }

    public String toString() {
        return this.getClass().getName() + " [address=" + this.channel.remoteAddress() + "]";
    }

    public void messageReceived(Message message) {
        this.handleMessage(message);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public AbstractProtocol getProtocol() {
        return this.protocol;
    }

    protected void setProtocol(AbstractProtocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public MessageProcessor getProcessor() {
        return null;
    }

    public boolean isActive() {
        return this.channel.isActive();
    }

    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public void disconnect() {
        this.channel.close();
    }

    @Override
    public void onDisconnect() {
    }

    @Override
    public void onReady() {
    }

    @Override
    public void onInboundThrowable(Throwable throwable) {
    }

    public void onOutboundThrowable(Throwable throwable) {
    }

    public void onHandlerThrowable(Message message, MessageHandler<?, ?> handle, Throwable throwable) {
    }

    public <T> void setOption(ChannelOption<T> option, T value) {
        this.channel.config().setOption(option, value);
    }

    @Override
    public Logger getLogger() {
        return this.protocol.getLogger();
    }
}

