/*
 * Decompiled with CFR 0.152.
 */
package com.flowpowered.network.pipeline;

import com.flowpowered.network.ConnectionManager;
import com.flowpowered.network.Message;
import com.flowpowered.network.session.Session;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHandler
extends SimpleChannelInboundHandler<Message> {
    private final AtomicReference<Session> session = new AtomicReference<Object>(null);
    private final ConnectionManager connectionManager;

    public MessageHandler(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        Channel c = ctx.channel();
        Session s = this.connectionManager.newSession(c);
        if (!this.session.compareAndSet(null, s)) {
            throw new IllegalStateException("Session may not be set more than once");
        }
        s.onReady();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        Session session = this.session.get();
        session.onDisconnect();
        this.connectionManager.sessionInactivated(session);
    }

    protected void channelRead0(ChannelHandlerContext ctx, Message i) {
        this.session.get().messageReceived(i);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.session.get().onInboundThrowable(cause);
    }

    public Session getSession() {
        return this.session.get();
    }

    protected Logger getLogger() {
        String loggerName = "";
        if (this.session.get() != null) {
            Logger protocolLogger = this.session.get().getLogger();
            loggerName = protocolLogger != null ? protocolLogger.getName() + "." : "";
        }
        return LoggerFactory.getLogger((String)(loggerName + ((Object)((Object)this)).getClass().getSimpleName()));
    }
}

