/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct stbtt__bitmap")
public class STBTTBitmap
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int W;
    public static final int H;
    public static final int STRIDE;
    public static final int PIXELS;

    public STBTTBitmap(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), STBTTBitmap.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int w() {
        return STBTTBitmap.nw(this.address());
    }

    public int h() {
        return STBTTBitmap.nh(this.address());
    }

    public int stride() {
        return STBTTBitmap.nstride(this.address());
    }

    @NativeType(value="unsigned char *")
    public ByteBuffer pixels(int capacity) {
        return STBTTBitmap.npixels(this.address(), capacity);
    }

    public STBTTBitmap w(int value) {
        STBTTBitmap.nw(this.address(), value);
        return this;
    }

    public STBTTBitmap h(int value) {
        STBTTBitmap.nh(this.address(), value);
        return this;
    }

    public STBTTBitmap stride(int value) {
        STBTTBitmap.nstride(this.address(), value);
        return this;
    }

    public STBTTBitmap pixels(@NativeType(value="unsigned char *") ByteBuffer value) {
        STBTTBitmap.npixels(this.address(), value);
        return this;
    }

    public STBTTBitmap set(int w, int h, int stride, ByteBuffer pixels) {
        this.w(w);
        this.h(h);
        this.stride(stride);
        this.pixels(pixels);
        return this;
    }

    public STBTTBitmap set(STBTTBitmap src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static STBTTBitmap malloc() {
        return (STBTTBitmap)STBTTBitmap.wrap(STBTTBitmap.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static STBTTBitmap calloc() {
        return (STBTTBitmap)STBTTBitmap.wrap(STBTTBitmap.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static STBTTBitmap create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (STBTTBitmap)STBTTBitmap.wrap(STBTTBitmap.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static STBTTBitmap create(long address) {
        return (STBTTBitmap)STBTTBitmap.wrap(STBTTBitmap.class, (long)address);
    }

    @Nullable
    public static STBTTBitmap createSafe(long address) {
        return address == 0L ? null : (STBTTBitmap)STBTTBitmap.wrap(STBTTBitmap.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)STBTTBitmap.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)STBTTBitmap.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)STBTTBitmap.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = STBTTBitmap.__create((int)capacity, (int)SIZEOF);
        return (Buffer)STBTTBitmap.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)STBTTBitmap.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)STBTTBitmap.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static STBTTBitmap mallocStack() {
        return STBTTBitmap.mallocStack(MemoryStack.stackGet());
    }

    public static STBTTBitmap callocStack() {
        return STBTTBitmap.callocStack(MemoryStack.stackGet());
    }

    public static STBTTBitmap mallocStack(MemoryStack stack) {
        return (STBTTBitmap)STBTTBitmap.wrap(STBTTBitmap.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static STBTTBitmap callocStack(MemoryStack stack) {
        return (STBTTBitmap)STBTTBitmap.wrap(STBTTBitmap.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return STBTTBitmap.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return STBTTBitmap.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)STBTTBitmap.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)STBTTBitmap.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nw(long struct) {
        return UNSAFE.getInt(null, struct + (long)W);
    }

    public static int nh(long struct) {
        return UNSAFE.getInt(null, struct + (long)H);
    }

    public static int nstride(long struct) {
        return UNSAFE.getInt(null, struct + (long)STRIDE);
    }

    public static ByteBuffer npixels(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PIXELS)), (int)capacity);
    }

    public static void nw(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)W, value);
    }

    public static void nh(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)H, value);
    }

    public static void nstride(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STRIDE, value);
    }

    public static void npixels(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PIXELS), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PIXELS)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            STBTTBitmap.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = STBTTBitmap.__struct((Struct.Member[])new Struct.Member[]{STBTTBitmap.__member((int)4), STBTTBitmap.__member((int)4), STBTTBitmap.__member((int)4), STBTTBitmap.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        W = layout.offsetof(0);
        H = layout.offsetof(1);
        STRIDE = layout.offsetof(2);
        PIXELS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<STBTTBitmap, Buffer>
    implements NativeResource {
        private static final STBTTBitmap ELEMENT_FACTORY = STBTTBitmap.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected STBTTBitmap getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int w() {
            return STBTTBitmap.nw(this.address());
        }

        public int h() {
            return STBTTBitmap.nh(this.address());
        }

        public int stride() {
            return STBTTBitmap.nstride(this.address());
        }

        @NativeType(value="unsigned char *")
        public ByteBuffer pixels(int capacity) {
            return STBTTBitmap.npixels(this.address(), capacity);
        }

        public Buffer w(int value) {
            STBTTBitmap.nw(this.address(), value);
            return this;
        }

        public Buffer h(int value) {
            STBTTBitmap.nh(this.address(), value);
            return this;
        }

        public Buffer stride(int value) {
            STBTTBitmap.nstride(this.address(), value);
            return this;
        }

        public Buffer pixels(@NativeType(value="unsigned char *") ByteBuffer value) {
            STBTTBitmap.npixels(this.address(), value);
            return this;
        }
    }
}

