/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.util;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;
import org.kitteh.irc.client.library.util.TriFunction;

public abstract class AbstractNameValueProcessor<NameValue> {
    private final Client.WithManagement client;
    private final Map<String, Creator<NameValue>> registeredNames = new ConcurrentHashMap<String, Creator<NameValue>>();

    protected AbstractNameValueProcessor(Client.WithManagement client) {
        this.client = client;
    }

    public Client.WithManagement getClient() {
        return this.client;
    }

    protected final Map<String, Creator<NameValue>> getRegistrations() {
        return this.registeredNames;
    }

    protected final @NonNull Optional<TriFunction<Client, String, String, ? extends NameValue>> getCreatorByName(@NonNull String name) {
        return this.optional(this.registeredNames.get(Sanity.nullCheck(name, "Name")));
    }

    protected final @NonNull Optional<TriFunction<Client, String, String, ? extends NameValue>> registerCreator(@NonNull String name, @NonNull Creator<NameValue> creator) {
        return this.optional(this.registeredNames.put(Sanity.nullCheck(name, "Name"), creator));
    }

    protected final @NonNull Optional<TriFunction<Client, String, String, ? extends NameValue>> unregisterCreator(@NonNull String name) {
        return this.optional(this.registeredNames.remove(Sanity.nullCheck(name, "Name")));
    }

    private @NonNull Optional<TriFunction<Client, String, String, ? extends NameValue>> optional(@Nullable Creator<NameValue> creator) {
        return creator == null ? Optional.empty() : Optional.of(creator.getFunction());
    }

    public @NonNull String toString() {
        return new ToStringer(this).toString();
    }

    public static class Creator<NameValue> {
        private final TriFunction<Client, String, String, ? extends NameValue> function;

        public Creator(@NonNull TriFunction<Client, String, String, ? extends NameValue> function) {
            this.function = Sanity.nullCheck(function, "Function");
        }

        public @NonNull TriFunction<Client, String, String, ? extends NameValue> getFunction() {
            return this.function;
        }
    }
}

