/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.feature.filter;

import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.engio.mbassy.listener.Filter;
import net.engio.mbassy.listener.IMessageFilter;
import net.engio.mbassy.subscription.SubscriptionContext;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.event.helper.ServerMessageEvent;
import org.kitteh.irc.client.library.feature.filter.FilterProcessor;

@Filter(value=Processor.class)
@Repeatable(value=Tags.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface TagFilter {
    public @NonNull String value();

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Tags {
        public @NonNull TagFilter[] value();
    }

    public static class Processor
    implements FilterProcessor<ServerMessageEvent, TagFilter>,
    IMessageFilter<ServerMessageEvent> {
        public boolean accepts(@NonNull ServerMessageEvent event, @NonNull TagFilter[] tagFilters) {
            for (TagFilter tagFilter : tagFilters) {
                if (!event.getTag(tagFilter.value()).isPresent()) continue;
                return true;
            }
            return false;
        }

        public boolean accepts(ServerMessageEvent event, SubscriptionContext context) {
            return this.accepts(event, (TagFilter[])context.getHandler().getMethod().getAnnotationsByType(TagFilter.class));
        }
    }
}

