/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.event.capabilities;

import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.element.CapabilityState;
import org.kitteh.irc.client.library.element.ServerMessage;
import org.kitteh.irc.client.library.event.abstractbase.CapabilityNegotiationResponseEventBase;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class CapabilitiesAcknowledgedEvent
extends CapabilityNegotiationResponseEventBase {
    private final List<CapabilityState> acknowledgedCapabilities;

    public CapabilitiesAcknowledgedEvent(@NonNull Client client, @NonNull ServerMessage sourceMessage, boolean negotiating, @NonNull List<CapabilityState> acknowledgedCapabilities) {
        super(client, sourceMessage, negotiating);
        Sanity.nullCheck(acknowledgedCapabilities, "Capabilities list");
        this.acknowledgedCapabilities = Collections.unmodifiableList(acknowledgedCapabilities);
    }

    public @NonNull List<CapabilityState> getAcknowledgedCapabilities() {
        return this.acknowledgedCapabilities;
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("acknowledgedCapabilities", this.acknowledgedCapabilities);
    }
}

