/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.element;

import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.command.ChannelModeCommand;
import org.kitteh.irc.client.library.command.KickCommand;
import org.kitteh.irc.client.library.command.TopicCommand;
import org.kitteh.irc.client.library.element.Actor;
import org.kitteh.irc.client.library.element.MessageReceiver;
import org.kitteh.irc.client.library.element.Staleable;
import org.kitteh.irc.client.library.element.User;
import org.kitteh.irc.client.library.element.mode.ChannelMode;
import org.kitteh.irc.client.library.element.mode.ChannelUserMode;
import org.kitteh.irc.client.library.element.mode.ModeInfo;
import org.kitteh.irc.client.library.element.mode.ModeStatusList;
import org.kitteh.irc.client.library.util.Sanity;

public interface Channel
extends MessageReceiver,
Staleable {
    default public @NonNull Optional<Channel> getLatest() {
        return this.getClient().getChannel(this.getName());
    }

    public @NonNull Optional<List<ModeInfo>> getModeInfoList(@NonNull ChannelMode var1);

    public @NonNull ModeStatusList<ChannelMode> getModes();

    public @NonNull List<String> getNicknames();

    public @NonNull Topic getTopic();

    public @NonNull Optional<User> getUser(@NonNull String var1);

    public @NonNull List<User> getUsers();

    public @NonNull Optional<SortedSet<ChannelUserMode>> getUserModes(@NonNull String var1);

    default public @NonNull Optional<SortedSet<ChannelUserMode>> getUserModes(@NonNull User user) {
        return this.getUserModes(Sanity.nullCheck(user, "User").getNick());
    }

    public boolean hasCompleteUserData();

    default public void join() {
        this.getClient().addChannel(this.getName());
    }

    default public void join(@NonNull String key) {
        this.getClient().addKeyProtectedChannel(this.getName(), key);
    }

    default public void kick(@NonNull User user, @NonNull String reason) {
        this.commands().kick().target(user).reason(reason).execute();
    }

    default public void kick(@NonNull User user) {
        this.commands().kick().target(user).execute();
    }

    public @NonNull Commands commands();

    default public void part() {
        this.getClient().removeChannel(this.getName());
    }

    default public void part(@NonNull String reason) {
        this.getClient().removeChannel(this.getName(), reason);
    }

    public void setModeInfoTracking(@NonNull ChannelMode var1, boolean var2);

    default public void setTopic(@NonNull String topic) {
        this.commands().topic().topic(topic).execute();
    }

    public static interface Topic {
        public @NonNull Optional<Actor> getSetter();

        public @NonNull Optional<Instant> getTime();

        public @NonNull Optional<String> getValue();
    }

    public static interface Commands {
        public @NonNull ChannelModeCommand mode();

        public @NonNull KickCommand kick();

        public @NonNull TopicCommand topic();
    }
}

