/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.defaults.listener;

import net.engio.mbassy.listener.Handler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.defaults.listener.AbstractDefaultListenerBase;
import org.kitteh.irc.client.library.element.Actor;
import org.kitteh.irc.client.library.element.Channel;
import org.kitteh.irc.client.library.element.User;
import org.kitteh.irc.client.library.event.channel.ChannelKickEvent;
import org.kitteh.irc.client.library.event.channel.UnexpectedChannelLeaveViaKickEvent;
import org.kitteh.irc.client.library.event.client.ClientReceiveCommandEvent;
import org.kitteh.irc.client.library.feature.filter.CommandFilter;

public class DefaultKickListener
extends AbstractDefaultListenerBase {
    public DefaultKickListener(@NonNull Client.WithManagement client) {
        super(client);
    }

    @CommandFilter(value="KICK")
    @Handler(priority=0x7FFFFFFE)
    public void kick(ClientReceiveCommandEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "KICK message too short");
            return;
        }
        Channel channel = this.getTracker().getChannel(event.getParameters().get(0)).orElse(null);
        if (channel == null) {
            this.trackException(event, "KICK message sent for invalid channel name");
            return;
        }
        User kickedUser = this.getTracker().getTrackedUser(event.getParameters().get(1)).orElse(null);
        if (kickedUser == null) {
            this.trackException(event, "KICK message sent for non-user");
            return;
        }
        boolean isSelf = event.getParameters().get(1).equals(this.getClient().getNick());
        String kickReason = event.getParameters().size() > 2 ? event.getParameters().get(2) : "";
        ChannelKickEvent kickEvent = isSelf && this.getClient().getIntendedChannels().contains(channel.getName()) ? new UnexpectedChannelLeaveViaKickEvent(this.getClient(), event.getSource(), channel, (Actor)event.getActor(), kickedUser, kickReason) : new ChannelKickEvent(this.getClient(), event.getSource(), channel, (Actor)event.getActor(), kickedUser, kickReason);
        this.fire(kickEvent);
        this.getTracker().trackUserPart(channel.getName(), event.getParameters().get(1));
        if (isSelf) {
            this.getTracker().unTrackChannel(channel.getName());
        }
    }
}

