/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.defaults.feature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.defaults.element.messagetag.DefaultMessageTagLabel;
import org.kitteh.irc.client.library.defaults.element.messagetag.DefaultMessageTagMsgId;
import org.kitteh.irc.client.library.defaults.element.messagetag.DefaultMessageTagTime;
import org.kitteh.irc.client.library.defaults.element.messagetag.DefaultMessageTagTyping;
import org.kitteh.irc.client.library.element.MessageTag;
import org.kitteh.irc.client.library.exception.KittehServerMessageTagException;
import org.kitteh.irc.client.library.feature.MessageTagManager;
import org.kitteh.irc.client.library.util.AbstractNameValueProcessor;
import org.kitteh.irc.client.library.util.ToStringer;
import org.kitteh.irc.client.library.util.TriFunction;

public class DefaultMessageTagManager
extends AbstractNameValueProcessor<MessageTag>
implements MessageTagManager {
    private static final Pattern TAG_ESCAPE = Pattern.compile("\\\\([\\\\s:])");

    public DefaultMessageTagManager(Client.WithManagement client) {
        super(client);
        this.registerTagCreator("server-time", "time", DefaultMessageTagTime.FUNCTION);
        this.registerTagCreator("message-tags", "msgid", DefaultMessageTagMsgId.FUNCTION);
        this.registerTagCreator("labeled-response", "label", DefaultMessageTagLabel.FUNCTION);
        this.registerTagCreator("message-tags", "typing", DefaultMessageTagTyping.FUNCTION);
    }

    @Override
    public @NonNull Map<String, TriFunction<Client, String, String, ? extends MessageTag>> getCapabilityTagCreators(@NonNull String capability) {
        return Collections.unmodifiableMap(this.getRegistrations().entrySet().stream().filter(e -> ((TagCreator)e.getValue()).getCapability().equals(capability)).collect(Collectors.toMap(Map.Entry::getKey, e -> ((AbstractNameValueProcessor.Creator)e.getValue()).getFunction())));
    }

    @Override
    public @NonNull Optional<TriFunction<Client, String, String, ? extends MessageTag>> getTagCreator(@NonNull String tagName) {
        return this.getCreatorByName(tagName);
    }

    @Override
    public @NonNull Optional<TriFunction<Client, String, String, ? extends MessageTag>> registerTagCreator(@NonNull String capability, @NonNull String tagName, @NonNull TriFunction<Client, String, String, ? extends MessageTag> function) {
        return this.registerCreator(tagName, new TagCreator(capability, function));
    }

    @Override
    public @NonNull Optional<TriFunction<Client, String, String, ? extends MessageTag>> unregisterTag(@NonNull String tagName) {
        return this.unregisterCreator(tagName);
    }

    @Override
    public @NonNull List<MessageTag> getCapabilityTags(@NonNull String tagList) {
        String[] tagSplit = tagList.split(";");
        LinkedHashMap<String, MessageTagManager.DefaultMessageTag> tags = new LinkedHashMap<String, MessageTagManager.DefaultMessageTag>();
        for (String tag : tagSplit) {
            String value;
            String tagName;
            int index = tag.indexOf(61);
            if (index > -1 && index < tag.length() - 1) {
                tagName = tag.substring(0, index);
                value = this.getTagValue(tag.substring(index + 1));
            } else {
                tagName = index < 0 ? tag : tag.substring(0, index);
                value = null;
            }
            MessageTag messageTag = null;
            TagCreator tagCreator = (TagCreator)this.getRegistrations().get(tagName);
            if (tagCreator != null) {
                try {
                    messageTag = (MessageTag)tagCreator.getFunction().apply(this.getClient(), tagName, value);
                }
                catch (Throwable thrown) {
                    this.getClient().getExceptionListener().queue(new KittehServerMessageTagException(tag, "Tag creator failed", thrown));
                }
            }
            if (messageTag == null) {
                messageTag = new MessageTagManager.DefaultMessageTag(tagName, value);
            }
            tags.put(tagName.toLowerCase(), (MessageTagManager.DefaultMessageTag)messageTag);
        }
        return Collections.unmodifiableList(new ArrayList(tags.values()));
    }

    private @NonNull String getTagValue(@NonNull String tag) {
        StringBuilder builder = new StringBuilder(tag.length());
        int currentIndex = 0;
        Matcher matcher = TAG_ESCAPE.matcher(tag);
        while (matcher.find()) {
            if (matcher.start() > currentIndex) {
                builder.append(tag, currentIndex, matcher.start());
            }
            switch (matcher.group(1)) {
                case ":": {
                    builder.append(';');
                    break;
                }
                case "s": {
                    builder.append(' ');
                    break;
                }
                case "\\": {
                    builder.append('\\');
                    break;
                }
                case "r": {
                    builder.append('\r');
                    break;
                }
                case "n": {
                    builder.append('\n');
                    break;
                }
            }
            currentIndex = matcher.end();
        }
        if (currentIndex < tag.length()) {
            builder.append(tag.substring(currentIndex));
        }
        return builder.toString();
    }

    protected static class TagCreator
    extends AbstractNameValueProcessor.Creator<MessageTag> {
        private final String capability;

        private TagCreator(@NonNull String capability, @NonNull TriFunction<Client, String, String, ? extends MessageTag> function) {
            super(function);
            this.capability = capability;
        }

        protected @NonNull String getCapability() {
            return this.capability;
        }

        public @NonNull String toString() {
            return new ToStringer(this).add("capability", this.capability).add("function", this.getFunction()).toString();
        }
    }
}

