/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.defaults.feature;

import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.defaults.element.DefaultISupportParameter;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportAwayLen;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportCaseMapping;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportChanLimit;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportChanModes;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportChanTypes;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportChannelLen;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportClientTagDeny;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportEList;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportExcepts;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportExtBan;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportHostLen;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportInvEx;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportKickLen;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportMaxList;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportMaxTargets;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportModes;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportNetwork;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportNickLen;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportPrefix;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportSilence;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportStatusMsg;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportTargMax;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportTopicLen;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportUserLen;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportWhoX;
import org.kitteh.irc.client.library.element.ISupportParameter;
import org.kitteh.irc.client.library.exception.KittehServerISupportException;
import org.kitteh.irc.client.library.feature.ISupportManager;
import org.kitteh.irc.client.library.util.AbstractNameValueProcessor;
import org.kitteh.irc.client.library.util.TriFunction;

public class DefaultISupportManager
extends AbstractNameValueProcessor<ISupportParameter>
implements ISupportManager {
    public DefaultISupportManager(Client.WithManagement client) {
        super(client);
        this.registerParameter("AWAYLEN", DefaultISupportAwayLen::new);
        this.registerParameter("CASEMAPPING", DefaultISupportCaseMapping::new);
        this.registerParameter("CHANNELLEN", DefaultISupportChannelLen::new);
        this.registerParameter("CHANLIMIT", DefaultISupportChanLimit::new);
        this.registerParameter("CHANMODES", DefaultISupportChanModes::new);
        this.registerParameter("CHANTYPES", DefaultISupportChanTypes::new);
        this.registerParameter("CLIENTTAGDENY", DefaultISupportClientTagDeny::new);
        this.registerParameter("ELIST", DefaultISupportEList::new);
        this.registerParameter("EXCEPTS", DefaultISupportExcepts::new);
        this.registerParameter("EXTBAN", DefaultISupportExtBan::new);
        this.registerParameter("HOSTLEN", DefaultISupportHostLen::new);
        this.registerParameter("INVEX", DefaultISupportInvEx::new);
        this.registerParameter("KICKLEN", DefaultISupportKickLen::new);
        this.registerParameter("MAXLIST", DefaultISupportMaxList::new);
        this.registerParameter("MAXTARGETS", DefaultISupportMaxTargets::new);
        this.registerParameter("MODES", DefaultISupportModes::new);
        this.registerParameter("NETWORK", DefaultISupportNetwork::new);
        this.registerParameter("NICKLEN", DefaultISupportNickLen::new);
        this.registerParameter("PREFIX", DefaultISupportPrefix::new);
        this.registerParameter("SILENCE", DefaultISupportSilence::new);
        this.registerParameter("STATUSMSG", DefaultISupportStatusMsg::new);
        this.registerParameter("TARGMAX", DefaultISupportTargMax::new);
        this.registerParameter("TOPICLEN", DefaultISupportTopicLen::new);
        this.registerParameter("USERLEN", DefaultISupportUserLen::new);
        this.registerParameter("WHOX", DefaultISupportWhoX::new);
    }

    @Override
    public @NonNull Optional<TriFunction<Client, String, String, ? extends ISupportParameter>> getCreator(@NonNull String tagName) {
        return this.getCreatorByName(tagName);
    }

    @Override
    public @NonNull Optional<TriFunction<Client, String, String, ? extends ISupportParameter>> registerParameter(@NonNull String tagName, @NonNull TriFunction<Client, String, String, ? extends ISupportParameter> function) {
        return this.registerCreator(tagName, new AbstractNameValueProcessor.Creator<ISupportParameter>(function));
    }

    @Override
    public @NonNull Optional<TriFunction<Client, String, String, ? extends ISupportParameter>> unregisterParameter(@NonNull String tagName) {
        return this.unregisterCreator(tagName);
    }

    @Override
    public @NonNull ISupportParameter createParameter(@NonNull String tag) {
        String value;
        String tagName;
        int index = tag.indexOf(61);
        if (index > -1 && index < tag.length() - 1) {
            tagName = tag.substring(0, index);
            value = tag.substring(index + 1);
        } else {
            tagName = tag;
            value = null;
        }
        ISupportParameter iSupportParameter = null;
        AbstractNameValueProcessor.Creator creator = this.getRegistrations().get(tagName);
        if (creator != null) {
            try {
                iSupportParameter = (ISupportParameter)creator.getFunction().apply(this.getClient(), tagName, value);
            }
            catch (KittehServerISupportException thrown) {
                this.getClient().getExceptionListener().queue(new KittehServerISupportException(tag, "Creator failed: " + thrown.getMessage()));
            }
            catch (Exception thrown) {
                this.getClient().getExceptionListener().queue(new KittehServerISupportException(tag, "Creator failed", thrown));
            }
        }
        if (iSupportParameter == null) {
            iSupportParameter = new DefaultISupportParameter(this.getClient(), tagName, value);
        }
        return iSupportParameter;
    }
}

