/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.command;

import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.command.Command;
import org.kitteh.irc.client.library.defaults.element.mode.DefaultModeStatus;
import org.kitteh.irc.client.library.defaults.element.mode.DefaultModeStatusList;
import org.kitteh.irc.client.library.element.mode.ModeStatus;
import org.kitteh.irc.client.library.element.mode.UserMode;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class UserModeCommand
extends Command<UserModeCommand> {
    private final List<ModeStatus<UserMode>> changes = new ArrayList<ModeStatus<UserMode>>();

    public UserModeCommand(@NonNull Client client) {
        super(client);
    }

    public @NonNull UserModeCommand add(ModeStatus.Action action, @NonNull UserMode mode) {
        return this.addChange(action, mode, null);
    }

    public @NonNull UserModeCommand add(ModeStatus.Action action, @NonNull UserMode mode, @NonNull String parameter) {
        return this.addChange(action, mode, Sanity.nullCheck(parameter, "Parameter"));
    }

    private synchronized @NonNull UserModeCommand addChange(ModeStatus.Action action, @NonNull UserMode mode, @Nullable String parameter) {
        Sanity.nullCheck(mode, "Mode");
        Sanity.truthiness(mode.getClient() == this.getClient(), "Mode comes from a different Client");
        if (parameter != null) {
            Sanity.safeMessageCheck(parameter, "Parameter");
            this.changes.add(new DefaultModeStatus<UserMode>(action, mode, parameter));
        } else {
            this.changes.add(new DefaultModeStatus<UserMode>(action, mode));
        }
        return this;
    }

    @Override
    public synchronized void execute() {
        if (this.changes.isEmpty()) {
            this.sendCommandLine("MODE " + this.getClient().getNick());
            return;
        }
        this.sendCommandLine("MODE " + this.getClient().getNick() + ' ' + DefaultModeStatusList.of(new ArrayList(this.changes)).getAsString());
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("changes", this.changes);
    }
}

