/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.command;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.command.Command;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class AwayCommand
extends Command<AwayCommand> {
    private @Nullable String message;

    public AwayCommand(@NonNull Client client) {
        super(client);
    }

    public @NonNull AwayCommand away(@Nullable String message) {
        this.message = message == null ? null : Sanity.safeMessageCheck(message);
        return this;
    }

    public @NonNull AwayCommand notAway() {
        this.message = null;
        return this;
    }

    @Override
    public void execute() {
        String exec = "AWAY";
        if (this.message != null) {
            exec = exec + " :" + this.message;
        }
        this.sendCommandLine(exec);
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("message", this.message);
    }
}

