/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.conversion;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.javalite.activejdbc.conversion.Converter;

public class DateToStringConverter
implements Converter<Date, String> {
    private final DateFormat format;
    private final ThreadLocal<DateFormat> threadLocalFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return (DateFormat)DateToStringConverter.this.format.clone();
        }
    };

    public DateToStringConverter(String pattern) {
        this(new SimpleDateFormat(pattern));
    }

    public DateToStringConverter(DateFormat format) {
        this.format = format;
    }

    @Override
    public boolean canConvert(Class sourceClass, Class destinationClass) {
        return Date.class.isAssignableFrom(sourceClass) && String.class.equals((Object)destinationClass);
    }

    @Override
    public String convert(Date source) {
        return this.threadLocalFormat.get().format(source);
    }
}

