/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.connection_config.ConnectionJdbcSpec;
import org.javalite.activejdbc.connection_config.ConnectionJndiSpec;
import org.javalite.activejdbc.connection_config.ConnectionSpec;
import org.javalite.activejdbc.logging.ActiveJDBCLogger;
import org.javalite.activejdbc.logging.LogFilter;
import org.javalite.activejdbc.logging.LogLevel;
import org.javalite.common.Convert;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private Properties properties = new Properties();
    private static final Logger LOGGER = LoggerFactory.getLogger(Configuration.class);
    private static String ENV;
    private static ActiveJDBCLogger activeLogger;
    private Map<String, ConnectionSpec> connectionSpecMap = new HashMap<String, ConnectionSpec>();

    protected Configuration() {
        this.loadProjectProperties();
        this.loadOverridesFromSystemProperties();
        this.loadConnectionsSpecs();
        String loggerClass = this.properties.getProperty(PropertyName.ActiveJdbcLogger.name);
        if (loggerClass != null) {
            try {
                activeLogger = (ActiveJDBCLogger)Class.forName(loggerClass).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new InitException("Failed to initialize a ActiveJDBCLogger. Please, ensure that the property 'activejdbc.logger' points to correct class which extends '" + ActiveJDBCLogger.class.getName() + "' and provides a default constructor.", e);
            }
        }
    }

    private void loadOverridesFromSystemProperties() {
        PropertyName[] names;
        for (PropertyName propertyName : names = PropertyName.values()) {
            String sysProp = System.getProperty(propertyName.name);
            if (sysProp == null) continue;
            this.properties.put(propertyName.name, sysProp);
        }
    }

    private void loadProjectProperties() {
        try {
            InputStream in = this.getClass().getResourceAsStream("/activejdbc.properties");
            if (in != null) {
                this.properties.load(in);
            }
        }
        catch (IOException e) {
            throw new InitException(e);
        }
    }

    private void loadConnectionsSpecs() {
        try {
            String propertyFileName = this.properties == null ? "database.properties" : this.properties.getProperty(PropertyName.EnvConnectionsFile.name, "database.properties");
            Properties connectionProps = this.readPropertyFile(propertyFileName);
            for (String env : this.getEnvironments(connectionProps)) {
                String jndiName = env + ".jndi";
                if (connectionProps.containsKey(jndiName)) {
                    this.connectionSpecMap.put(env, new ConnectionJndiSpec(connectionProps.getProperty(jndiName)));
                    continue;
                }
                String driver = connectionProps.getProperty(env + ".driver");
                String userName = connectionProps.getProperty(env + ".username");
                String password = connectionProps.getProperty(env + ".password");
                String url = connectionProps.getProperty(env + ".url");
                if (driver == null || userName == null || password == null || url == null) {
                    throw new InitException("Four JDBC properties are expected: driver, username, password, url for environment: " + env);
                }
                this.connectionSpecMap.put(env, new ConnectionJdbcSpec(driver, url, userName, password));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.overrideFromEnvironmentVariables();
        this.overrideFromSystemProperties();
    }

    private void overrideFromEnvironmentVariables() {
        String jndi;
        String url = System.getenv("ACTIVEJDBC.URL");
        String user = System.getenv("ACTIVEJDBC.USER");
        String password = System.getenv("ACTIVEJDBC.PASSWORD");
        String driver = System.getenv("ACTIVEJDBC.DRIVER");
        if (!(Util.blank((Object)url) || Util.blank((Object)user) || Util.blank((Object)password) || Util.blank((Object)driver))) {
            this.connectionSpecMap.put(this.getEnvironment(), new ConnectionJdbcSpec(driver, url, user, password));
        }
        if (!Util.blank((Object)(jndi = System.getenv("ACTIVEJDBC.JNDI")))) {
            this.connectionSpecMap.put(this.getEnvironment(), new ConnectionJndiSpec(jndi));
        }
    }

    private void overrideFromSystemProperties() {
        String jndi;
        String url = System.getProperty("activejdbc.url");
        String user = System.getProperty("activejdbc.user");
        String password = System.getProperty("activejdbc.password");
        String driver = System.getProperty("activejdbc.driver");
        if (!(Util.blank((Object)url) || Util.blank((Object)user) || Util.blank((Object)driver))) {
            this.connectionSpecMap.put(this.getEnvironment(), new ConnectionJdbcSpec(driver, url, user, password));
        }
        if (!Util.blank((Object)(jndi = System.getProperty("activejdbc.jndi")))) {
            this.connectionSpecMap.put(this.getEnvironment(), new ConnectionJndiSpec(jndi));
        }
    }

    public ConnectionSpec getConnectionSpec(String environment) {
        return this.connectionSpecMap.get(environment);
    }

    public ConnectionSpec getCurrentConnectionSpec() {
        return this.getConnectionSpec(this.getEnvironment());
    }

    public String getEnvironment() {
        String env = "development";
        if (!Util.blank((Object)System.getenv("ACTIVE_ENV"))) {
            env = System.getenv("ACTIVE_ENV");
        }
        if (!Util.blank((Object)System.getProperty("active_env"))) {
            env = System.getProperty("active_env");
        }
        return env;
    }

    private Set<String> getEnvironments(Properties props) {
        HashSet<String> environments = new HashSet<String>();
        for (Object k : props.keySet()) {
            String environment = k.toString().split("\\.")[0];
            environments.add(environment);
        }
        return new TreeSet<String>(environments);
    }

    private Properties readPropertyFile(String file) throws IOException {
        String fileName = file.startsWith("/") ? file : "/" + file;
        LOGGER.info("Reading properties from: " + fileName + ". Will try classpath, then file system.");
        return Util.readProperties((String)fileName);
    }

    public boolean collectStatistics() {
        return Convert.toBoolean((Object)this.properties.getProperty(PropertyName.CollectStatistics.name, "false"));
    }

    public boolean collectStatisticsOnHold() {
        return Convert.toBoolean((Object)this.properties.getProperty(PropertyName.CollectStatisticsOnHold.name, "false"));
    }

    public String getCacheManager() {
        return this.properties.getProperty(PropertyName.CacheManager.name);
    }

    public static String getEnv() {
        if (ENV == null) {
            if (!Util.blank((Object)System.getenv("ACTIVE_ENV"))) {
                ENV = System.getenv("ACTIVE_ENV");
            }
            if (!Util.blank((Object)System.getProperty("ACTIVE_ENV"))) {
                ENV = System.getProperty("ACTIVE_ENV");
            }
            if (!Util.blank((Object)System.getProperty("active_env"))) {
                ENV = System.getProperty("active_env");
            }
            if (Util.blank((Object)ENV)) {
                ENV = "development";
                LogFilter.log(LOGGER, LogLevel.INFO, "Environment variable ACTIVE_ENV not provided, defaulting to '" + ENV + "'");
            }
        }
        return ENV;
    }

    public static void setEnv(String env) {
        ENV = env;
    }

    public static boolean hasActiveLogger() {
        return activeLogger != null;
    }

    public static ActiveJDBCLogger getActiveLogger() {
        return activeLogger;
    }

    public static enum PropertyName {
        CacheManager("cache.manager"),
        ActiveJdbcLogger("activejdbc.logger"),
        EnvConnectionsFile("env.connections.file"),
        CollectStatistics("collectStatistics"),
        CollectStatisticsOnHold("collectStatisticsOnHold");

        private String name;

        private PropertyName(String name) {
            this.name = name;
        }
    }
}

