/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.info;

import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.internal.util.DateUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class MigrationInfoDumper {
    private static final int MINIMUM_CONSOLE_WIDTH = 80;

    private MigrationInfoDumper() {
    }

    public static String dumpToAsciiTable(MigrationInfo[] migrationInfos) {
        return MigrationInfoDumper.dumpToAsciiTable(migrationInfos, 80);
    }

    public static String dumpToAsciiTable(MigrationInfo[] migrationInfos, int consoleWidth) {
        int descriptionWidth = Math.max(consoleWidth, 80) - 54;
        StringBuilder table = new StringBuilder();
        table.append("+----------------+-").append(StringUtils.trimOrPad("", descriptionWidth, '-')).append("-+---------------------+---------+\n");
        table.append("| Version        | ").append(StringUtils.trimOrPad("Description", descriptionWidth)).append(" | Installed on        | State   |\n");
        table.append("+----------------+-").append(StringUtils.trimOrPad("", descriptionWidth, '-')).append("-+---------------------+---------+\n");
        if (migrationInfos.length == 0) {
            table.append("| No migrations found                                                         |\n");
        } else {
            for (MigrationInfo migrationInfo : migrationInfos) {
                table.append("| ").append(StringUtils.trimOrPad(migrationInfo.getVersion().toString(), 14));
                table.append(" | ").append(StringUtils.trimOrPad(migrationInfo.getDescription(), descriptionWidth));
                table.append(" | ").append(StringUtils.trimOrPad(DateUtils.formatDateAsIsoString(migrationInfo.getInstalledOn()), 19));
                table.append(" | ").append(StringUtils.trimOrPad(migrationInfo.getState().getDisplayName(), 7));
                table.append(" |\n");
            }
        }
        table.append("+----------------+-").append(StringUtils.trimOrPad("", descriptionWidth, '-')).append("-+---------------------+---------+");
        return table.toString();
    }
}

